/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorkloadName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/workloads/{workload}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String workload;

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkload() {
        return this.workload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private WorkloadName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workload = (String)Preconditions.checkNotNull((Object)builder.getWorkload());
    }

    public static WorkloadName of(String organization, String location, String workload) {
        return WorkloadName.newBuilder().setOrganization(organization).setLocation(location).setWorkload(workload).build();
    }

    public static String format(String organization, String location, String workload) {
        return WorkloadName.newBuilder().setOrganization(organization).setLocation(location).setWorkload(workload).build().toString();
    }

    public static WorkloadName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "WorkloadName.parse: formattedString not in valid format");
        return WorkloadName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("workload"));
    }

    public static List<WorkloadName> parseList(List<String> formattedStrings) {
        ArrayList<WorkloadName> list = new ArrayList<WorkloadName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkloadName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkloadName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkloadName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkloadName workloadName = this;
            synchronized (workloadName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"workload", (Object)this.workload);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "location", this.location, "workload", this.workload});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WorkloadName) {
            WorkloadName that = (WorkloadName)o;
            return this.organization.equals(that.organization) && this.location.equals(that.location) && this.workload.equals(that.workload);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.workload.hashCode();
    }

    public static class Builder {
        private String organization;
        private String location;
        private String workload;

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkload() {
            return this.workload;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        private Builder() {
        }

        private Builder(WorkloadName workloadName) {
            this.organization = workloadName.organization;
            this.location = workloadName.location;
            this.workload = workloadName.workload;
        }

        public WorkloadName build() {
            return new WorkloadName(this);
        }
    }
}

