/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeedName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/feeds/{feed}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String feed;

    public String getProject() {
        return this.project;
    }

    public String getFeed() {
        return this.feed;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FeedName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.feed = (String)Preconditions.checkNotNull((Object)builder.getFeed());
    }

    public static FeedName of(String project, String feed) {
        return FeedName.newBuilder().setProject(project).setFeed(feed).build();
    }

    public static String format(String project, String feed) {
        return FeedName.newBuilder().setProject(project).setFeed(feed).build().toString();
    }

    public static FeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FeedName.parse: formattedString not in valid format");
        return FeedName.of((String)matchMap.get("project"), (String)matchMap.get("feed"));
    }

    public static List<FeedName> parseList(List<String> formattedStrings) {
        ArrayList<FeedName> list = new ArrayList<FeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedName feedName = this;
            synchronized (feedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"feed", (Object)this.feed);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "feed", this.feed});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FeedName) {
            FeedName that = (FeedName)o;
            return this.project.equals(that.project) && this.feed.equals(that.feed);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.feed.hashCode();
    }

    public static class Builder {
        private String project;
        private String feed;

        public String getProject() {
            return this.project;
        }

        public String getFeed() {
            return this.feed;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setFeed(String feed) {
            this.feed = feed;
            return this;
        }

        private Builder() {
        }

        private Builder(FeedName feedName) {
            this.project = feedName.project;
            this.feed = feedName.feed;
        }

        public FeedName build() {
            return new FeedName(this);
        }
    }
}

