/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SavedQueryName
implements ResourceName {
    private static final PathTemplate PROJECT_SAVED_QUERY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/savedQueries/{saved_query}");
    private static final PathTemplate FOLDER_SAVED_QUERY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/savedQueries/{saved_query}");
    private static final PathTemplate ORGANIZATION_SAVED_QUERY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/savedQueries/{saved_query}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String savedQuery;
    private final String folder;
    private final String organization;

    @Deprecated
    protected SavedQueryName() {
        this.project = null;
        this.savedQuery = null;
        this.folder = null;
        this.organization = null;
    }

    private SavedQueryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.savedQuery = (String)Preconditions.checkNotNull((Object)builder.getSavedQuery());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_SAVED_QUERY;
    }

    private SavedQueryName(FolderSavedQueryBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.savedQuery = (String)Preconditions.checkNotNull((Object)builder.getSavedQuery());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_SAVED_QUERY;
    }

    private SavedQueryName(OrganizationSavedQueryBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.savedQuery = (String)Preconditions.checkNotNull((Object)builder.getSavedQuery());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_SAVED_QUERY;
    }

    public String getProject() {
        return this.project;
    }

    public String getSavedQuery() {
        return this.savedQuery;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectSavedQueryBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderSavedQueryBuilder newFolderSavedQueryBuilder() {
        return new FolderSavedQueryBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationSavedQueryBuilder newOrganizationSavedQueryBuilder() {
        return new OrganizationSavedQueryBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SavedQueryName of(String project, String savedQuery) {
        return SavedQueryName.newBuilder().setProject(project).setSavedQuery(savedQuery).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SavedQueryName ofProjectSavedQueryName(String project, String savedQuery) {
        return SavedQueryName.newBuilder().setProject(project).setSavedQuery(savedQuery).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SavedQueryName ofFolderSavedQueryName(String folder, String savedQuery) {
        return SavedQueryName.newFolderSavedQueryBuilder().setFolder(folder).setSavedQuery(savedQuery).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SavedQueryName ofOrganizationSavedQueryName(String organization, String savedQuery) {
        return SavedQueryName.newOrganizationSavedQueryBuilder().setOrganization(organization).setSavedQuery(savedQuery).build();
    }

    public static String format(String project, String savedQuery) {
        return SavedQueryName.newBuilder().setProject(project).setSavedQuery(savedQuery).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSavedQueryName(String project, String savedQuery) {
        return SavedQueryName.newBuilder().setProject(project).setSavedQuery(savedQuery).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderSavedQueryName(String folder, String savedQuery) {
        return SavedQueryName.newFolderSavedQueryBuilder().setFolder(folder).setSavedQuery(savedQuery).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSavedQueryName(String organization, String savedQuery) {
        return SavedQueryName.newOrganizationSavedQueryBuilder().setOrganization(organization).setSavedQuery(savedQuery).build().toString();
    }

    public static SavedQueryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SAVED_QUERY.matches(formattedString)) {
            Map matchMap = PROJECT_SAVED_QUERY.match(formattedString);
            return SavedQueryName.ofProjectSavedQueryName((String)matchMap.get("project"), (String)matchMap.get("saved_query"));
        }
        if (FOLDER_SAVED_QUERY.matches(formattedString)) {
            Map matchMap = FOLDER_SAVED_QUERY.match(formattedString);
            return SavedQueryName.ofFolderSavedQueryName((String)matchMap.get("folder"), (String)matchMap.get("saved_query"));
        }
        if (ORGANIZATION_SAVED_QUERY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SAVED_QUERY.match(formattedString);
            return SavedQueryName.ofOrganizationSavedQueryName((String)matchMap.get("organization"), (String)matchMap.get("saved_query"));
        }
        throw new ValidationException("SavedQueryName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SavedQueryName> parseList(List<String> formattedStrings) {
        ArrayList<SavedQueryName> list = new ArrayList<SavedQueryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SavedQueryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SavedQueryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SavedQueryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SAVED_QUERY.matches(formattedString) || FOLDER_SAVED_QUERY.matches(formattedString) || ORGANIZATION_SAVED_QUERY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SavedQueryName savedQueryName = this;
            synchronized (savedQueryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.savedQuery != null) {
                        fieldMapBuilder.put((Object)"saved_query", (Object)this.savedQuery);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SavedQueryName that = (SavedQueryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.savedQuery, that.savedQuery) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.savedQuery);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationSavedQueryBuilder {
        private String organization;
        private String savedQuery;

        protected OrganizationSavedQueryBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSavedQuery() {
            return this.savedQuery;
        }

        public OrganizationSavedQueryBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSavedQueryBuilder setSavedQuery(String savedQuery) {
            this.savedQuery = savedQuery;
            return this;
        }

        public SavedQueryName build() {
            return new SavedQueryName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderSavedQueryBuilder {
        private String folder;
        private String savedQuery;

        protected FolderSavedQueryBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSavedQuery() {
            return this.savedQuery;
        }

        public FolderSavedQueryBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSavedQueryBuilder setSavedQuery(String savedQuery) {
            this.savedQuery = savedQuery;
            return this;
        }

        public SavedQueryName build() {
            return new SavedQueryName(this);
        }
    }

    public static class Builder {
        private String project;
        private String savedQuery;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSavedQuery() {
            return this.savedQuery;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSavedQuery(String savedQuery) {
            this.savedQuery = savedQuery;
            return this;
        }

        private Builder(SavedQueryName savedQueryName) {
            Preconditions.checkArgument((boolean)Objects.equals(savedQueryName.pathTemplate, PROJECT_SAVED_QUERY), (Object)"toBuilder is only supported when SavedQueryName has the pattern of projects/{project}/savedQueries/{saved_query}");
            this.project = savedQueryName.project;
            this.savedQuery = savedQueryName.savedQuery;
        }

        public SavedQueryName build() {
            return new SavedQueryName(this);
        }
    }
}

