/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeedName
implements ResourceName {
    private static final PathTemplate PROJECT_FEED = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/feeds/{feed}");
    private static final PathTemplate FOLDER_FEED = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/feeds/{feed}");
    private static final PathTemplate ORGANIZATION_FEED = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/feeds/{feed}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String feed;
    private final String folder;
    private final String organization;

    @Deprecated
    protected FeedName() {
        this.project = null;
        this.feed = null;
        this.folder = null;
        this.organization = null;
    }

    private FeedName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.feed = (String)Preconditions.checkNotNull((Object)builder.getFeed());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_FEED;
    }

    private FeedName(FolderFeedBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.feed = (String)Preconditions.checkNotNull((Object)builder.getFeed());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_FEED;
    }

    private FeedName(OrganizationFeedBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.feed = (String)Preconditions.checkNotNull((Object)builder.getFeed());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_FEED;
    }

    public String getProject() {
        return this.project;
    }

    public String getFeed() {
        return this.feed;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectFeedBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderFeedBuilder newFolderFeedBuilder() {
        return new FolderFeedBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationFeedBuilder newOrganizationFeedBuilder() {
        return new OrganizationFeedBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeedName of(String project, String feed) {
        return FeedName.newBuilder().setProject(project).setFeed(feed).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static FeedName ofProjectFeedName(String project, String feed) {
        return FeedName.newBuilder().setProject(project).setFeed(feed).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static FeedName ofFolderFeedName(String folder, String feed) {
        return FeedName.newFolderFeedBuilder().setFolder(folder).setFeed(feed).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static FeedName ofOrganizationFeedName(String organization, String feed) {
        return FeedName.newOrganizationFeedBuilder().setOrganization(organization).setFeed(feed).build();
    }

    public static String format(String project, String feed) {
        return FeedName.newBuilder().setProject(project).setFeed(feed).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectFeedName(String project, String feed) {
        return FeedName.newBuilder().setProject(project).setFeed(feed).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderFeedName(String folder, String feed) {
        return FeedName.newFolderFeedBuilder().setFolder(folder).setFeed(feed).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationFeedName(String organization, String feed) {
        return FeedName.newOrganizationFeedBuilder().setOrganization(organization).setFeed(feed).build().toString();
    }

    public static FeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_FEED.matches(formattedString)) {
            Map matchMap = PROJECT_FEED.match(formattedString);
            return FeedName.ofProjectFeedName((String)matchMap.get("project"), (String)matchMap.get("feed"));
        }
        if (FOLDER_FEED.matches(formattedString)) {
            Map matchMap = FOLDER_FEED.match(formattedString);
            return FeedName.ofFolderFeedName((String)matchMap.get("folder"), (String)matchMap.get("feed"));
        }
        if (ORGANIZATION_FEED.matches(formattedString)) {
            Map matchMap = ORGANIZATION_FEED.match(formattedString);
            return FeedName.ofOrganizationFeedName((String)matchMap.get("organization"), (String)matchMap.get("feed"));
        }
        throw new ValidationException("FeedName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FeedName> parseList(List<String> formattedStrings) {
        ArrayList<FeedName> list = new ArrayList<FeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_FEED.matches(formattedString) || FOLDER_FEED.matches(formattedString) || ORGANIZATION_FEED.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedName feedName = this;
            synchronized (feedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.feed != null) {
                        fieldMapBuilder.put((Object)"feed", (Object)this.feed);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeedName that = (FeedName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.feed, that.feed) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.feed);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationFeedBuilder {
        private String organization;
        private String feed;

        protected OrganizationFeedBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getFeed() {
            return this.feed;
        }

        public OrganizationFeedBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationFeedBuilder setFeed(String feed) {
            this.feed = feed;
            return this;
        }

        public FeedName build() {
            return new FeedName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderFeedBuilder {
        private String folder;
        private String feed;

        protected FolderFeedBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getFeed() {
            return this.feed;
        }

        public FolderFeedBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderFeedBuilder setFeed(String feed) {
            this.feed = feed;
            return this;
        }

        public FeedName build() {
            return new FeedName(this);
        }
    }

    public static class Builder {
        private String project;
        private String feed;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getFeed() {
            return this.feed;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setFeed(String feed) {
            this.feed = feed;
            return this;
        }

        private Builder(FeedName feedName) {
            Preconditions.checkArgument((boolean)Objects.equals(feedName.pathTemplate, PROJECT_FEED), (Object)"toBuilder is only supported when FeedName has the pattern of projects/{project}/feeds/{feed}");
            this.project = feedName.project;
            this.feed = feedName.feed;
        }

        public FeedName build() {
            return new FeedName(this);
        }
    }
}

