/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PythonPackageName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_PYTHON_PACKAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/pythonPackages/{python_package}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String pythonPackage;

    @Deprecated
    protected PythonPackageName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.pythonPackage = null;
    }

    private PythonPackageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.pythonPackage = (String)Preconditions.checkNotNull((Object)builder.getPythonPackage());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPythonPackage() {
        return this.pythonPackage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PythonPackageName of(String project, String location, String repository, String pythonPackage) {
        return PythonPackageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPythonPackage(pythonPackage).build();
    }

    public static String format(String project, String location, String repository, String pythonPackage) {
        return PythonPackageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPythonPackage(pythonPackage).build().toString();
    }

    public static PythonPackageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_PYTHON_PACKAGE.validatedMatch(formattedString, "PythonPackageName.parse: formattedString not in valid format");
        return PythonPackageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("python_package"));
    }

    public static List<PythonPackageName> parseList(List<String> formattedStrings) {
        ArrayList<PythonPackageName> list = new ArrayList<PythonPackageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PythonPackageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PythonPackageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PythonPackageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_PYTHON_PACKAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PythonPackageName pythonPackageName = this;
            synchronized (pythonPackageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.pythonPackage != null) {
                        fieldMapBuilder.put((Object)"python_package", (Object)this.pythonPackage);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_PYTHON_PACKAGE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "python_package", this.pythonPackage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PythonPackageName that = (PythonPackageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.pythonPackage, that.pythonPackage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.pythonPackage);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String pythonPackage;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getPythonPackage() {
            return this.pythonPackage;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setPythonPackage(String pythonPackage) {
            this.pythonPackage = pythonPackage;
            return this;
        }

        private Builder(PythonPackageName pythonPackageName) {
            this.project = pythonPackageName.project;
            this.location = pythonPackageName.location;
            this.repository = pythonPackageName.repository;
            this.pythonPackage = pythonPackageName.pythonPackage;
        }

        public PythonPackageName build() {
            return new PythonPackageName(this);
        }
    }
}

