/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PackageName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_PACKAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/packages/{package}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String package_;

    @Deprecated
    protected PackageName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.package_ = null;
    }

    private PackageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.package_ = (String)Preconditions.checkNotNull((Object)builder.getPackage());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPackage() {
        return this.package_;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PackageName of(String project, String location, String repository, String package_) {
        return PackageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPackage(package_).build();
    }

    public static String format(String project, String location, String repository, String package_) {
        return PackageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPackage(package_).build().toString();
    }

    public static PackageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_PACKAGE.validatedMatch(formattedString, "PackageName.parse: formattedString not in valid format");
        return PackageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("package"));
    }

    public static List<PackageName> parseList(List<String> formattedStrings) {
        ArrayList<PackageName> list = new ArrayList<PackageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PackageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PackageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PackageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_PACKAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PackageName packageName = this;
            synchronized (packageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.package_ != null) {
                        fieldMapBuilder.put((Object)"package", (Object)this.package_);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_PACKAGE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "package", this.package_});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PackageName that = (PackageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.package_, that.package_);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.package_);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String package_;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getPackage() {
            return this.package_;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setPackage(String package_) {
            this.package_ = package_;
            return this;
        }

        private Builder(PackageName packageName) {
            this.project = packageName.project;
            this.location = packageName.location;
            this.repository = packageName.repository;
            this.package_ = packageName.package_;
        }

        public PackageName build() {
            return new PackageName(this);
        }
    }
}

