/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apphub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiscoveredServiceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DISCOVERED_SERVICE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/discoveredServices/{discovered_service}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String discoveredService;

    @Deprecated
    protected DiscoveredServiceName() {
        this.project = null;
        this.location = null;
        this.discoveredService = null;
    }

    private DiscoveredServiceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.discoveredService = (String)Preconditions.checkNotNull((Object)builder.getDiscoveredService());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDiscoveredService() {
        return this.discoveredService;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DiscoveredServiceName of(String project, String location, String discoveredService) {
        return DiscoveredServiceName.newBuilder().setProject(project).setLocation(location).setDiscoveredService(discoveredService).build();
    }

    public static String format(String project, String location, String discoveredService) {
        return DiscoveredServiceName.newBuilder().setProject(project).setLocation(location).setDiscoveredService(discoveredService).build().toString();
    }

    public static DiscoveredServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DISCOVERED_SERVICE.validatedMatch(formattedString, "DiscoveredServiceName.parse: formattedString not in valid format");
        return DiscoveredServiceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("discovered_service"));
    }

    public static List<DiscoveredServiceName> parseList(List<String> formattedStrings) {
        ArrayList<DiscoveredServiceName> list = new ArrayList<DiscoveredServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DiscoveredServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DiscoveredServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DiscoveredServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DISCOVERED_SERVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DiscoveredServiceName discoveredServiceName = this;
            synchronized (discoveredServiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.discoveredService != null) {
                        fieldMapBuilder.put((Object)"discovered_service", (Object)this.discoveredService);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DISCOVERED_SERVICE.instantiate(new String[]{"project", this.project, "location", this.location, "discovered_service", this.discoveredService});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DiscoveredServiceName that = (DiscoveredServiceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.discoveredService, that.discoveredService);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.discoveredService);
    }

    public static class Builder {
        private String project;
        private String location;
        private String discoveredService;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDiscoveredService() {
            return this.discoveredService;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDiscoveredService(String discoveredService) {
            this.discoveredService = discoveredService;
            return this;
        }

        private Builder(DiscoveredServiceName discoveredServiceName) {
            this.project = discoveredServiceName.project;
            this.location = discoveredServiceName.location;
            this.discoveredService = discoveredServiceName.discoveredService;
        }

        public DiscoveredServiceName build() {
            return new DiscoveredServiceName(this);
        }
    }
}

