/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceName
implements ResourceName {
    private static final PathTemplate APP_SERVICE_VERSION_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"apps/{app}/services/{service}/versions/{version}/instances/{instance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String app;
    private final String service;
    private final String version;
    private final String instance;

    @Deprecated
    protected InstanceName() {
        this.app = null;
        this.service = null;
        this.version = null;
        this.instance = null;
    }

    private InstanceName(Builder builder) {
        this.app = (String)Preconditions.checkNotNull((Object)builder.getApp());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
    }

    public String getApp() {
        return this.app;
    }

    public String getService() {
        return this.service;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceName of(String app, String service, String version, String instance) {
        return InstanceName.newBuilder().setApp(app).setService(service).setVersion(version).setInstance(instance).build();
    }

    public static String format(String app, String service, String version, String instance) {
        return InstanceName.newBuilder().setApp(app).setService(service).setVersion(version).setInstance(instance).build().toString();
    }

    public static InstanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = APP_SERVICE_VERSION_INSTANCE.validatedMatch(formattedString, "InstanceName.parse: formattedString not in valid format");
        return InstanceName.of((String)matchMap.get("app"), (String)matchMap.get("service"), (String)matchMap.get("version"), (String)matchMap.get("instance"));
    }

    public static List<InstanceName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceName> list = new ArrayList<InstanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return APP_SERVICE_VERSION_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceName instanceName = this;
            synchronized (instanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.app != null) {
                        fieldMapBuilder.put((Object)"app", (Object)this.app);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return APP_SERVICE_VERSION_INSTANCE.instantiate(new String[]{"app", this.app, "service", this.service, "version", this.version, "instance", this.instance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InstanceName that = (InstanceName)o;
            return Objects.equals(this.app, that.app) && Objects.equals(this.service, that.service) && Objects.equals(this.version, that.version) && Objects.equals(this.instance, that.instance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.app);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        h ^= Objects.hashCode(this.version);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instance);
    }

    public static class Builder {
        private String app;
        private String service;
        private String version;
        private String instance;

        protected Builder() {
        }

        public String getApp() {
            return this.app;
        }

        public String getService() {
            return this.service;
        }

        public String getVersion() {
            return this.version;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setApp(String app) {
            this.app = app;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder(InstanceName instanceName) {
            this.app = instanceName.app;
            this.service = instanceName.service;
            this.version = instanceName.version;
            this.instance = instanceName.instance;
        }

        public InstanceName build() {
            return new InstanceName(this);
        }
    }
}

