/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiscoveredApiOperationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DISCOVERED_API_OBSERVATION_DISCOVERED_API_OPERATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/discoveredApiObservations/{discovered_api_observation}/discoveredApiOperations/{discovered_api_operation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String discoveredApiObservation;
    private final String discoveredApiOperation;

    @Deprecated
    protected DiscoveredApiOperationName() {
        this.project = null;
        this.location = null;
        this.discoveredApiObservation = null;
        this.discoveredApiOperation = null;
    }

    private DiscoveredApiOperationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.discoveredApiObservation = (String)Preconditions.checkNotNull((Object)builder.getDiscoveredApiObservation());
        this.discoveredApiOperation = (String)Preconditions.checkNotNull((Object)builder.getDiscoveredApiOperation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDiscoveredApiObservation() {
        return this.discoveredApiObservation;
    }

    public String getDiscoveredApiOperation() {
        return this.discoveredApiOperation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DiscoveredApiOperationName of(String project, String location, String discoveredApiObservation, String discoveredApiOperation) {
        return DiscoveredApiOperationName.newBuilder().setProject(project).setLocation(location).setDiscoveredApiObservation(discoveredApiObservation).setDiscoveredApiOperation(discoveredApiOperation).build();
    }

    public static String format(String project, String location, String discoveredApiObservation, String discoveredApiOperation) {
        return DiscoveredApiOperationName.newBuilder().setProject(project).setLocation(location).setDiscoveredApiObservation(discoveredApiObservation).setDiscoveredApiOperation(discoveredApiOperation).build().toString();
    }

    public static DiscoveredApiOperationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DISCOVERED_API_OBSERVATION_DISCOVERED_API_OPERATION.validatedMatch(formattedString, "DiscoveredApiOperationName.parse: formattedString not in valid format");
        return DiscoveredApiOperationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("discovered_api_observation"), (String)matchMap.get("discovered_api_operation"));
    }

    public static List<DiscoveredApiOperationName> parseList(List<String> formattedStrings) {
        ArrayList<DiscoveredApiOperationName> list = new ArrayList<DiscoveredApiOperationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DiscoveredApiOperationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DiscoveredApiOperationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DiscoveredApiOperationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DISCOVERED_API_OBSERVATION_DISCOVERED_API_OPERATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DiscoveredApiOperationName discoveredApiOperationName = this;
            synchronized (discoveredApiOperationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.discoveredApiObservation != null) {
                        fieldMapBuilder.put((Object)"discovered_api_observation", (Object)this.discoveredApiObservation);
                    }
                    if (this.discoveredApiOperation != null) {
                        fieldMapBuilder.put((Object)"discovered_api_operation", (Object)this.discoveredApiOperation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DISCOVERED_API_OBSERVATION_DISCOVERED_API_OPERATION.instantiate(new String[]{"project", this.project, "location", this.location, "discovered_api_observation", this.discoveredApiObservation, "discovered_api_operation", this.discoveredApiOperation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DiscoveredApiOperationName that = (DiscoveredApiOperationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.discoveredApiObservation, that.discoveredApiObservation) && Objects.equals(this.discoveredApiOperation, that.discoveredApiOperation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.discoveredApiObservation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.discoveredApiOperation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String discoveredApiObservation;
        private String discoveredApiOperation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDiscoveredApiObservation() {
            return this.discoveredApiObservation;
        }

        public String getDiscoveredApiOperation() {
            return this.discoveredApiOperation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDiscoveredApiObservation(String discoveredApiObservation) {
            this.discoveredApiObservation = discoveredApiObservation;
            return this;
        }

        public Builder setDiscoveredApiOperation(String discoveredApiOperation) {
            this.discoveredApiOperation = discoveredApiOperation;
            return this;
        }

        private Builder(DiscoveredApiOperationName discoveredApiOperationName) {
            this.project = discoveredApiOperationName.project;
            this.location = discoveredApiOperationName.location;
            this.discoveredApiObservation = discoveredApiOperationName.discoveredApiObservation;
            this.discoveredApiOperation = discoveredApiOperationName.discoveredApiOperation;
        }

        public DiscoveredApiOperationName build() {
            return new DiscoveredApiOperationName(this);
        }
    }
}

