/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PluginInstanceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PLUGIN_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String plugin;
    private final String instance;

    @Deprecated
    protected PluginInstanceName() {
        this.project = null;
        this.location = null;
        this.plugin = null;
        this.instance = null;
    }

    private PluginInstanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.plugin = (String)Preconditions.checkNotNull((Object)builder.getPlugin());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PluginInstanceName of(String project, String location, String plugin, String instance) {
        return PluginInstanceName.newBuilder().setProject(project).setLocation(location).setPlugin(plugin).setInstance(instance).build();
    }

    public static String format(String project, String location, String plugin, String instance) {
        return PluginInstanceName.newBuilder().setProject(project).setLocation(location).setPlugin(plugin).setInstance(instance).build().toString();
    }

    public static PluginInstanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PLUGIN_INSTANCE.validatedMatch(formattedString, "PluginInstanceName.parse: formattedString not in valid format");
        return PluginInstanceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("plugin"), (String)matchMap.get("instance"));
    }

    public static List<PluginInstanceName> parseList(List<String> formattedStrings) {
        ArrayList<PluginInstanceName> list = new ArrayList<PluginInstanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PluginInstanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PluginInstanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PluginInstanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PLUGIN_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PluginInstanceName pluginInstanceName = this;
            synchronized (pluginInstanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.plugin != null) {
                        fieldMapBuilder.put((Object)"plugin", (Object)this.plugin);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PLUGIN_INSTANCE.instantiate(new String[]{"project", this.project, "location", this.location, "plugin", this.plugin, "instance", this.instance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PluginInstanceName that = (PluginInstanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.plugin, that.plugin) && Objects.equals(this.instance, that.instance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.plugin);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instance);
    }

    public static class Builder {
        private String project;
        private String location;
        private String plugin;
        private String instance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPlugin(String plugin) {
            this.plugin = plugin;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder(PluginInstanceName pluginInstanceName) {
            this.project = pluginInstanceName.project;
            this.location = pluginInstanceName.location;
            this.plugin = pluginInstanceName.plugin;
            this.instance = pluginInstanceName.instance;
        }

        public PluginInstanceName build() {
            return new PluginInstanceName(this);
        }
    }
}

