/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiscoveredApiObservationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DISCOVERED_API_OBSERVATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/discoveredApiObservations/{discovered_api_observation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String discoveredApiObservation;

    @Deprecated
    protected DiscoveredApiObservationName() {
        this.project = null;
        this.location = null;
        this.discoveredApiObservation = null;
    }

    private DiscoveredApiObservationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.discoveredApiObservation = (String)Preconditions.checkNotNull((Object)builder.getDiscoveredApiObservation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDiscoveredApiObservation() {
        return this.discoveredApiObservation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DiscoveredApiObservationName of(String project, String location, String discoveredApiObservation) {
        return DiscoveredApiObservationName.newBuilder().setProject(project).setLocation(location).setDiscoveredApiObservation(discoveredApiObservation).build();
    }

    public static String format(String project, String location, String discoveredApiObservation) {
        return DiscoveredApiObservationName.newBuilder().setProject(project).setLocation(location).setDiscoveredApiObservation(discoveredApiObservation).build().toString();
    }

    public static DiscoveredApiObservationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DISCOVERED_API_OBSERVATION.validatedMatch(formattedString, "DiscoveredApiObservationName.parse: formattedString not in valid format");
        return DiscoveredApiObservationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("discovered_api_observation"));
    }

    public static List<DiscoveredApiObservationName> parseList(List<String> formattedStrings) {
        ArrayList<DiscoveredApiObservationName> list = new ArrayList<DiscoveredApiObservationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DiscoveredApiObservationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DiscoveredApiObservationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DiscoveredApiObservationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DISCOVERED_API_OBSERVATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DiscoveredApiObservationName discoveredApiObservationName = this;
            synchronized (discoveredApiObservationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.discoveredApiObservation != null) {
                        fieldMapBuilder.put((Object)"discovered_api_observation", (Object)this.discoveredApiObservation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DISCOVERED_API_OBSERVATION.instantiate(new String[]{"project", this.project, "location", this.location, "discovered_api_observation", this.discoveredApiObservation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DiscoveredApiObservationName that = (DiscoveredApiObservationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.discoveredApiObservation, that.discoveredApiObservation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.discoveredApiObservation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String discoveredApiObservation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDiscoveredApiObservation() {
            return this.discoveredApiObservation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDiscoveredApiObservation(String discoveredApiObservation) {
            this.discoveredApiObservation = discoveredApiObservation;
            return this;
        }

        private Builder(DiscoveredApiObservationName discoveredApiObservationName) {
            this.project = discoveredApiObservationName.project;
            this.location = discoveredApiObservationName.location;
            this.discoveredApiObservation = discoveredApiObservationName.discoveredApiObservation;
        }

        public DiscoveredApiObservationName build() {
            return new DiscoveredApiObservationName(this);
        }
    }
}

