/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.cloud.apihub.v1.CommonFieldsProto;
import com.google.cloud.apihub.v1.DiscoveredApiObservationOrBuilder;
import com.google.cloud.apihub.v1.SourceMetadata;
import com.google.cloud.apihub.v1.SourceMetadataOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DiscoveredApiObservation
extends GeneratedMessageV3
implements DiscoveredApiObservationOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int STYLE_FIELD_NUMBER = 2;
    private int style_ = 0;
    public static final int SERVER_IPS_FIELD_NUMBER = 3;
    private LazyStringArrayList serverIps_ = LazyStringArrayList.emptyList();
    public static final int HOSTNAME_FIELD_NUMBER = 4;
    private volatile Object hostname_ = "";
    public static final int LAST_EVENT_DETECTED_TIME_FIELD_NUMBER = 5;
    private Timestamp lastEventDetectedTime_;
    public static final int SOURCE_LOCATIONS_FIELD_NUMBER = 6;
    private LazyStringArrayList sourceLocations_ = LazyStringArrayList.emptyList();
    public static final int API_OPERATION_COUNT_FIELD_NUMBER = 7;
    private long apiOperationCount_ = 0L;
    public static final int ORIGIN_FIELD_NUMBER = 8;
    private volatile Object origin_ = "";
    public static final int SOURCE_TYPES_FIELD_NUMBER = 9;
    private List<Integer> sourceTypes_;
    private static final Internal.ListAdapter.Converter<Integer, SourceType> sourceTypes_converter_ = new Internal.ListAdapter.Converter<Integer, SourceType>(){

        public SourceType convert(Integer from) {
            SourceType result = SourceType.forNumber(from);
            return result == null ? SourceType.UNRECOGNIZED : result;
        }
    };
    private int sourceTypesMemoizedSerializedSize;
    public static final int KNOWN_OPERATIONS_COUNT_FIELD_NUMBER = 10;
    private long knownOperationsCount_ = 0L;
    public static final int UNKNOWN_OPERATIONS_COUNT_FIELD_NUMBER = 11;
    private long unknownOperationsCount_ = 0L;
    public static final int CREATE_TIME_FIELD_NUMBER = 12;
    private Timestamp createTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 13;
    private Timestamp updateTime_;
    public static final int SOURCE_METADATA_FIELD_NUMBER = 14;
    private SourceMetadata sourceMetadata_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final DiscoveredApiObservation DEFAULT_INSTANCE = new DiscoveredApiObservation();
    private static final Parser<DiscoveredApiObservation> PARSER = new AbstractParser<DiscoveredApiObservation>(){

        public DiscoveredApiObservation parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DiscoveredApiObservation.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DiscoveredApiObservation(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DiscoveredApiObservation() {
        this.name_ = "";
        this.style_ = 0;
        this.serverIps_ = LazyStringArrayList.emptyList();
        this.hostname_ = "";
        this.sourceLocations_ = LazyStringArrayList.emptyList();
        this.origin_ = "";
        this.sourceTypes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DiscoveredApiObservation();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonFieldsProto.internal_static_google_cloud_apihub_v1_DiscoveredApiObservation_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonFieldsProto.internal_static_google_cloud_apihub_v1_DiscoveredApiObservation_fieldAccessorTable.ensureFieldAccessorsInitialized(DiscoveredApiObservation.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStyleValue() {
        return this.style_;
    }

    @Override
    public Style getStyle() {
        Style result = Style.forNumber(this.style_);
        return result == null ? Style.UNRECOGNIZED : result;
    }

    public ProtocolStringList getServerIpsList() {
        return this.serverIps_;
    }

    @Override
    public int getServerIpsCount() {
        return this.serverIps_.size();
    }

    @Override
    public String getServerIps(int index) {
        return this.serverIps_.get(index);
    }

    @Override
    public ByteString getServerIpsBytes(int index) {
        return this.serverIps_.getByteString(index);
    }

    @Override
    public String getHostname() {
        Object ref = this.hostname_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.hostname_ = s;
        return s;
    }

    @Override
    public ByteString getHostnameBytes() {
        Object ref = this.hostname_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.hostname_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasLastEventDetectedTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getLastEventDetectedTime() {
        return this.lastEventDetectedTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventDetectedTime_;
    }

    @Override
    public TimestampOrBuilder getLastEventDetectedTimeOrBuilder() {
        return this.lastEventDetectedTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventDetectedTime_;
    }

    public ProtocolStringList getSourceLocationsList() {
        return this.sourceLocations_;
    }

    @Override
    public int getSourceLocationsCount() {
        return this.sourceLocations_.size();
    }

    @Override
    public String getSourceLocations(int index) {
        return this.sourceLocations_.get(index);
    }

    @Override
    public ByteString getSourceLocationsBytes(int index) {
        return this.sourceLocations_.getByteString(index);
    }

    @Override
    public long getApiOperationCount() {
        return this.apiOperationCount_;
    }

    @Override
    public String getOrigin() {
        Object ref = this.origin_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.origin_ = s;
        return s;
    }

    @Override
    public ByteString getOriginBytes() {
        Object ref = this.origin_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.origin_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<SourceType> getSourceTypesList() {
        return new Internal.ListAdapter(this.sourceTypes_, sourceTypes_converter_);
    }

    @Override
    public int getSourceTypesCount() {
        return this.sourceTypes_.size();
    }

    @Override
    public SourceType getSourceTypes(int index) {
        return (SourceType)((Object)sourceTypes_converter_.convert((Object)this.sourceTypes_.get(index)));
    }

    @Override
    public List<Integer> getSourceTypesValueList() {
        return this.sourceTypes_;
    }

    @Override
    public int getSourceTypesValue(int index) {
        return this.sourceTypes_.get(index);
    }

    @Override
    public long getKnownOperationsCount() {
        return this.knownOperationsCount_;
    }

    @Override
    public long getUnknownOperationsCount() {
        return this.unknownOperationsCount_;
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public boolean hasSourceMetadata() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public SourceMetadata getSourceMetadata() {
        return this.sourceMetadata_ == null ? SourceMetadata.getDefaultInstance() : this.sourceMetadata_;
    }

    @Override
    public SourceMetadataOrBuilder getSourceMetadataOrBuilder() {
        return this.sourceMetadata_ == null ? SourceMetadata.getDefaultInstance() : this.sourceMetadata_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.style_ != Style.STYLE_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.style_);
        }
        for (i = 0; i < this.serverIps_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.serverIps_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.hostname_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.hostname_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(5, (MessageLite)this.getLastEventDetectedTime());
        }
        for (i = 0; i < this.sourceLocations_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.sourceLocations_.getRaw(i));
        }
        if (this.apiOperationCount_ != 0L) {
            output.writeInt64(7, this.apiOperationCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.origin_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.origin_);
        }
        if (this.getSourceTypesList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.sourceTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.sourceTypes_.size(); ++i) {
            output.writeEnumNoTag(this.sourceTypes_.get(i).intValue());
        }
        if (this.knownOperationsCount_ != 0L) {
            output.writeInt64(10, this.knownOperationsCount_);
        }
        if (this.unknownOperationsCount_ != 0L) {
            output.writeInt64(11, this.unknownOperationsCount_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(12, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(13, (MessageLite)this.getUpdateTime());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(14, (MessageLite)this.getSourceMetadata());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (this.style_ != Style.STYLE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.style_);
        }
        int dataSize = 0;
        for (i = 0; i < this.serverIps_.size(); ++i) {
            dataSize += DiscoveredApiObservation.computeStringSizeNoTag((Object)this.serverIps_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getServerIpsList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.hostname_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.hostname_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getLastEventDetectedTime());
        }
        dataSize = 0;
        for (i = 0; i < this.sourceLocations_.size(); ++i) {
            dataSize += DiscoveredApiObservation.computeStringSizeNoTag((Object)this.sourceLocations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getSourceLocationsList().size();
        if (this.apiOperationCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)7, (long)this.apiOperationCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.origin_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.origin_);
        }
        dataSize = 0;
        for (i = 0; i < this.sourceTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.sourceTypes_.get(i));
        }
        size += dataSize;
        if (!this.getSourceTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.sourceTypesMemoizedSerializedSize = dataSize;
        if (this.knownOperationsCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)10, (long)this.knownOperationsCount_);
        }
        if (this.unknownOperationsCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)11, (long)this.unknownOperationsCount_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getUpdateTime());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getSourceMetadata());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiscoveredApiObservation)) {
            return super.equals(obj);
        }
        DiscoveredApiObservation other = (DiscoveredApiObservation)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.style_ != other.style_) {
            return false;
        }
        if (!this.getServerIpsList().equals(other.getServerIpsList())) {
            return false;
        }
        if (!this.getHostname().equals(other.getHostname())) {
            return false;
        }
        if (this.hasLastEventDetectedTime() != other.hasLastEventDetectedTime()) {
            return false;
        }
        if (this.hasLastEventDetectedTime() && !this.getLastEventDetectedTime().equals((Object)other.getLastEventDetectedTime())) {
            return false;
        }
        if (!this.getSourceLocationsList().equals(other.getSourceLocationsList())) {
            return false;
        }
        if (this.getApiOperationCount() != other.getApiOperationCount()) {
            return false;
        }
        if (!this.getOrigin().equals(other.getOrigin())) {
            return false;
        }
        if (!this.sourceTypes_.equals(other.sourceTypes_)) {
            return false;
        }
        if (this.getKnownOperationsCount() != other.getKnownOperationsCount()) {
            return false;
        }
        if (this.getUnknownOperationsCount() != other.getUnknownOperationsCount()) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (this.hasSourceMetadata() != other.hasSourceMetadata()) {
            return false;
        }
        if (this.hasSourceMetadata() && !this.getSourceMetadata().equals(other.getSourceMetadata())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DiscoveredApiObservation.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.style_;
        if (this.getServerIpsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getServerIpsList().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getHostname().hashCode();
        if (this.hasLastEventDetectedTime()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getLastEventDetectedTime().hashCode();
        }
        if (this.getSourceLocationsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getSourceLocationsList().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong((long)this.getApiOperationCount());
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getOrigin().hashCode();
        if (this.getSourceTypesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.sourceTypes_.hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashLong((long)this.getKnownOperationsCount());
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashLong((long)this.getUnknownOperationsCount());
        if (this.hasCreateTime()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        if (this.hasSourceMetadata()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getSourceMetadata().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static DiscoveredApiObservation parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DiscoveredApiObservation)PARSER.parseFrom(data);
    }

    public static DiscoveredApiObservation parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DiscoveredApiObservation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DiscoveredApiObservation parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DiscoveredApiObservation)PARSER.parseFrom(data);
    }

    public static DiscoveredApiObservation parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DiscoveredApiObservation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DiscoveredApiObservation parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DiscoveredApiObservation)PARSER.parseFrom(data);
    }

    public static DiscoveredApiObservation parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DiscoveredApiObservation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DiscoveredApiObservation parseFrom(InputStream input) throws IOException {
        return (DiscoveredApiObservation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DiscoveredApiObservation parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DiscoveredApiObservation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DiscoveredApiObservation parseDelimitedFrom(InputStream input) throws IOException {
        return (DiscoveredApiObservation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DiscoveredApiObservation parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DiscoveredApiObservation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DiscoveredApiObservation parseFrom(CodedInputStream input) throws IOException {
        return (DiscoveredApiObservation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DiscoveredApiObservation parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DiscoveredApiObservation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DiscoveredApiObservation.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DiscoveredApiObservation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DiscoveredApiObservation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DiscoveredApiObservation> parser() {
        return PARSER;
    }

    public Parser<DiscoveredApiObservation> getParserForType() {
        return PARSER;
    }

    public DiscoveredApiObservation getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DiscoveredApiObservationOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private int style_ = 0;
        private LazyStringArrayList serverIps_ = LazyStringArrayList.emptyList();
        private Object hostname_ = "";
        private Timestamp lastEventDetectedTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastEventDetectedTimeBuilder_;
        private LazyStringArrayList sourceLocations_ = LazyStringArrayList.emptyList();
        private long apiOperationCount_;
        private Object origin_ = "";
        private List<Integer> sourceTypes_ = Collections.emptyList();
        private long knownOperationsCount_;
        private long unknownOperationsCount_;
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private SourceMetadata sourceMetadata_;
        private SingleFieldBuilderV3<SourceMetadata, SourceMetadata.Builder, SourceMetadataOrBuilder> sourceMetadataBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonFieldsProto.internal_static_google_cloud_apihub_v1_DiscoveredApiObservation_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonFieldsProto.internal_static_google_cloud_apihub_v1_DiscoveredApiObservation_fieldAccessorTable.ensureFieldAccessorsInitialized(DiscoveredApiObservation.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getLastEventDetectedTimeFieldBuilder();
                this.getCreateTimeFieldBuilder();
                this.getUpdateTimeFieldBuilder();
                this.getSourceMetadataFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.style_ = 0;
            this.serverIps_ = LazyStringArrayList.emptyList();
            this.hostname_ = "";
            this.lastEventDetectedTime_ = null;
            if (this.lastEventDetectedTimeBuilder_ != null) {
                this.lastEventDetectedTimeBuilder_.dispose();
                this.lastEventDetectedTimeBuilder_ = null;
            }
            this.sourceLocations_ = LazyStringArrayList.emptyList();
            this.apiOperationCount_ = 0L;
            this.origin_ = "";
            this.sourceTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.knownOperationsCount_ = 0L;
            this.unknownOperationsCount_ = 0L;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.sourceMetadata_ = null;
            if (this.sourceMetadataBuilder_ != null) {
                this.sourceMetadataBuilder_.dispose();
                this.sourceMetadataBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CommonFieldsProto.internal_static_google_cloud_apihub_v1_DiscoveredApiObservation_descriptor;
        }

        public DiscoveredApiObservation getDefaultInstanceForType() {
            return DiscoveredApiObservation.getDefaultInstance();
        }

        public DiscoveredApiObservation build() {
            DiscoveredApiObservation result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DiscoveredApiObservation buildPartial() {
            DiscoveredApiObservation result = new DiscoveredApiObservation(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(DiscoveredApiObservation result) {
            if ((this.bitField0_ & 0x100) != 0) {
                this.sourceTypes_ = Collections.unmodifiableList(this.sourceTypes_);
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.sourceTypes_ = this.sourceTypes_;
        }

        private void buildPartial0(DiscoveredApiObservation result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.style_ = this.style_;
            }
            if ((from_bitField0_ & 4) != 0) {
                this.serverIps_.makeImmutable();
                result.serverIps_ = this.serverIps_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.hostname_ = this.hostname_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x10) != 0) {
                result.lastEventDetectedTime_ = this.lastEventDetectedTimeBuilder_ == null ? this.lastEventDetectedTime_ : (Timestamp)this.lastEventDetectedTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                this.sourceLocations_.makeImmutable();
                result.sourceLocations_ = this.sourceLocations_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.apiOperationCount_ = this.apiOperationCount_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.origin_ = this.origin_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.knownOperationsCount_ = this.knownOperationsCount_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.unknownOperationsCount_ = this.unknownOperationsCount_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.sourceMetadata_ = this.sourceMetadataBuilder_ == null ? this.sourceMetadata_ : (SourceMetadata)this.sourceMetadataBuilder_.build();
                to_bitField0_ |= 8;
            }
            DiscoveredApiObservation discoveredApiObservation = result;
            discoveredApiObservation.bitField0_ = discoveredApiObservation.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DiscoveredApiObservation) {
                return this.mergeFrom((DiscoveredApiObservation)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DiscoveredApiObservation other) {
            if (other == DiscoveredApiObservation.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.style_ != 0) {
                this.setStyleValue(other.getStyleValue());
            }
            if (!other.serverIps_.isEmpty()) {
                if (this.serverIps_.isEmpty()) {
                    this.serverIps_ = other.serverIps_;
                    this.bitField0_ |= 4;
                } else {
                    this.ensureServerIpsIsMutable();
                    this.serverIps_.addAll((Collection)other.serverIps_);
                }
                this.onChanged();
            }
            if (!other.getHostname().isEmpty()) {
                this.hostname_ = other.hostname_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasLastEventDetectedTime()) {
                this.mergeLastEventDetectedTime(other.getLastEventDetectedTime());
            }
            if (!other.sourceLocations_.isEmpty()) {
                if (this.sourceLocations_.isEmpty()) {
                    this.sourceLocations_ = other.sourceLocations_;
                    this.bitField0_ |= 0x20;
                } else {
                    this.ensureSourceLocationsIsMutable();
                    this.sourceLocations_.addAll((Collection)other.sourceLocations_);
                }
                this.onChanged();
            }
            if (other.getApiOperationCount() != 0L) {
                this.setApiOperationCount(other.getApiOperationCount());
            }
            if (!other.getOrigin().isEmpty()) {
                this.origin_ = other.origin_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (!other.sourceTypes_.isEmpty()) {
                if (this.sourceTypes_.isEmpty()) {
                    this.sourceTypes_ = other.sourceTypes_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensureSourceTypesIsMutable();
                    this.sourceTypes_.addAll(other.sourceTypes_);
                }
                this.onChanged();
            }
            if (other.getKnownOperationsCount() != 0L) {
                this.setKnownOperationsCount(other.getKnownOperationsCount());
            }
            if (other.getUnknownOperationsCount() != 0L) {
                this.setUnknownOperationsCount(other.getUnknownOperationsCount());
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            if (other.hasSourceMetadata()) {
                this.mergeSourceMetadata(other.getSourceMetadata());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block23: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block23;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block23;
                        }
                        case 16: {
                            this.style_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block23;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.ensureServerIpsIsMutable();
                            this.serverIps_.add((Object)s);
                            continue block23;
                        }
                        case 34: {
                            this.hostname_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block23;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getLastEventDetectedTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block23;
                        }
                        case 50: {
                            String s = input.readStringRequireUtf8();
                            this.ensureSourceLocationsIsMutable();
                            this.sourceLocations_.add((Object)s);
                            continue block23;
                        }
                        case 56: {
                            this.apiOperationCount_ = input.readInt64();
                            this.bitField0_ |= 0x40;
                            continue block23;
                        }
                        case 66: {
                            this.origin_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block23;
                        }
                        case 72: {
                            int tmpRaw = input.readEnum();
                            this.ensureSourceTypesIsMutable();
                            this.sourceTypes_.add(tmpRaw);
                            continue block23;
                        }
                        case 74: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureSourceTypesIsMutable();
                                this.sourceTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block23;
                        }
                        case 80: {
                            this.knownOperationsCount_ = input.readInt64();
                            this.bitField0_ |= 0x200;
                            continue block23;
                        }
                        case 88: {
                            this.unknownOperationsCount_ = input.readInt64();
                            this.bitField0_ |= 0x400;
                            continue block23;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block23;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block23;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getSourceMetadataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block23;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = DiscoveredApiObservation.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiscoveredApiObservation.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getStyleValue() {
            return this.style_;
        }

        public Builder setStyleValue(int value) {
            this.style_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public Style getStyle() {
            Style result = Style.forNumber(this.style_);
            return result == null ? Style.UNRECOGNIZED : result;
        }

        public Builder setStyle(Style value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.style_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStyle() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.style_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureServerIpsIsMutable() {
            if (!this.serverIps_.isModifiable()) {
                this.serverIps_ = new LazyStringArrayList((LazyStringList)this.serverIps_);
            }
            this.bitField0_ |= 4;
        }

        public ProtocolStringList getServerIpsList() {
            this.serverIps_.makeImmutable();
            return this.serverIps_;
        }

        @Override
        public int getServerIpsCount() {
            return this.serverIps_.size();
        }

        @Override
        public String getServerIps(int index) {
            return this.serverIps_.get(index);
        }

        @Override
        public ByteString getServerIpsBytes(int index) {
            return this.serverIps_.getByteString(index);
        }

        public Builder setServerIps(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureServerIpsIsMutable();
            this.serverIps_.set(index, value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addServerIps(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureServerIpsIsMutable();
            this.serverIps_.add((Object)value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addAllServerIps(Iterable<String> values) {
            this.ensureServerIpsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.serverIps_);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearServerIps() {
            this.serverIps_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addServerIpsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiscoveredApiObservation.checkByteStringIsUtf8((ByteString)value);
            this.ensureServerIpsIsMutable();
            this.serverIps_.add(value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getHostname() {
            Object ref = this.hostname_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.hostname_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getHostnameBytes() {
            Object ref = this.hostname_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.hostname_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setHostname(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.hostname_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearHostname() {
            this.hostname_ = DiscoveredApiObservation.getDefaultInstance().getHostname();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setHostnameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiscoveredApiObservation.checkByteStringIsUtf8((ByteString)value);
            this.hostname_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLastEventDetectedTime() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Timestamp getLastEventDetectedTime() {
            if (this.lastEventDetectedTimeBuilder_ == null) {
                return this.lastEventDetectedTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventDetectedTime_;
            }
            return (Timestamp)this.lastEventDetectedTimeBuilder_.getMessage();
        }

        public Builder setLastEventDetectedTime(Timestamp value) {
            if (this.lastEventDetectedTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastEventDetectedTime_ = value;
            } else {
                this.lastEventDetectedTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setLastEventDetectedTime(Timestamp.Builder builderForValue) {
            if (this.lastEventDetectedTimeBuilder_ == null) {
                this.lastEventDetectedTime_ = builderForValue.build();
            } else {
                this.lastEventDetectedTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeLastEventDetectedTime(Timestamp value) {
            if (this.lastEventDetectedTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.lastEventDetectedTime_ != null && this.lastEventDetectedTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastEventDetectedTimeBuilder().mergeFrom(value);
                } else {
                    this.lastEventDetectedTime_ = value;
                }
            } else {
                this.lastEventDetectedTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.lastEventDetectedTime_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLastEventDetectedTime() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.lastEventDetectedTime_ = null;
            if (this.lastEventDetectedTimeBuilder_ != null) {
                this.lastEventDetectedTimeBuilder_.dispose();
                this.lastEventDetectedTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastEventDetectedTimeBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Timestamp.Builder)this.getLastEventDetectedTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastEventDetectedTimeOrBuilder() {
            if (this.lastEventDetectedTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastEventDetectedTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastEventDetectedTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventDetectedTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastEventDetectedTimeFieldBuilder() {
            if (this.lastEventDetectedTimeBuilder_ == null) {
                this.lastEventDetectedTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastEventDetectedTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastEventDetectedTime_ = null;
            }
            return this.lastEventDetectedTimeBuilder_;
        }

        private void ensureSourceLocationsIsMutable() {
            if (!this.sourceLocations_.isModifiable()) {
                this.sourceLocations_ = new LazyStringArrayList((LazyStringList)this.sourceLocations_);
            }
            this.bitField0_ |= 0x20;
        }

        public ProtocolStringList getSourceLocationsList() {
            this.sourceLocations_.makeImmutable();
            return this.sourceLocations_;
        }

        @Override
        public int getSourceLocationsCount() {
            return this.sourceLocations_.size();
        }

        @Override
        public String getSourceLocations(int index) {
            return this.sourceLocations_.get(index);
        }

        @Override
        public ByteString getSourceLocationsBytes(int index) {
            return this.sourceLocations_.getByteString(index);
        }

        public Builder setSourceLocations(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSourceLocationsIsMutable();
            this.sourceLocations_.set(index, value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addSourceLocations(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSourceLocationsIsMutable();
            this.sourceLocations_.add((Object)value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addAllSourceLocations(Iterable<String> values) {
            this.ensureSourceLocationsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.sourceLocations_);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearSourceLocations() {
            this.sourceLocations_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder addSourceLocationsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiscoveredApiObservation.checkByteStringIsUtf8((ByteString)value);
            this.ensureSourceLocationsIsMutable();
            this.sourceLocations_.add(value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public long getApiOperationCount() {
            return this.apiOperationCount_;
        }

        public Builder setApiOperationCount(long value) {
            this.apiOperationCount_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearApiOperationCount() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.apiOperationCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getOrigin() {
            Object ref = this.origin_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.origin_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOriginBytes() {
            Object ref = this.origin_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.origin_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrigin(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.origin_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearOrigin() {
            this.origin_ = DiscoveredApiObservation.getDefaultInstance().getOrigin();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setOriginBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiscoveredApiObservation.checkByteStringIsUtf8((ByteString)value);
            this.origin_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        private void ensureSourceTypesIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.sourceTypes_ = new ArrayList<Integer>(this.sourceTypes_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<SourceType> getSourceTypesList() {
            return new Internal.ListAdapter(this.sourceTypes_, sourceTypes_converter_);
        }

        @Override
        public int getSourceTypesCount() {
            return this.sourceTypes_.size();
        }

        @Override
        public SourceType getSourceTypes(int index) {
            return (SourceType)((Object)sourceTypes_converter_.convert((Object)this.sourceTypes_.get(index)));
        }

        public Builder setSourceTypes(int index, SourceType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSourceTypesIsMutable();
            this.sourceTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addSourceTypes(SourceType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSourceTypesIsMutable();
            this.sourceTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllSourceTypes(Iterable<? extends SourceType> values) {
            this.ensureSourceTypesIsMutable();
            for (SourceType sourceType : values) {
                this.sourceTypes_.add(sourceType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearSourceTypes() {
            this.sourceTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getSourceTypesValueList() {
            return Collections.unmodifiableList(this.sourceTypes_);
        }

        @Override
        public int getSourceTypesValue(int index) {
            return this.sourceTypes_.get(index);
        }

        public Builder setSourceTypesValue(int index, int value) {
            this.ensureSourceTypesIsMutable();
            this.sourceTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addSourceTypesValue(int value) {
            this.ensureSourceTypesIsMutable();
            this.sourceTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllSourceTypesValue(Iterable<Integer> values) {
            this.ensureSourceTypesIsMutable();
            for (int value : values) {
                this.sourceTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public long getKnownOperationsCount() {
            return this.knownOperationsCount_;
        }

        public Builder setKnownOperationsCount(long value) {
            this.knownOperationsCount_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearKnownOperationsCount() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.knownOperationsCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getUnknownOperationsCount() {
            return this.unknownOperationsCount_;
        }

        public Builder setUnknownOperationsCount(long value) {
            this.unknownOperationsCount_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearUnknownOperationsCount() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.unknownOperationsCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.updateTime_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        @Override
        public boolean hasSourceMetadata() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public SourceMetadata getSourceMetadata() {
            if (this.sourceMetadataBuilder_ == null) {
                return this.sourceMetadata_ == null ? SourceMetadata.getDefaultInstance() : this.sourceMetadata_;
            }
            return (SourceMetadata)this.sourceMetadataBuilder_.getMessage();
        }

        public Builder setSourceMetadata(SourceMetadata value) {
            if (this.sourceMetadataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.sourceMetadata_ = value;
            } else {
                this.sourceMetadataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setSourceMetadata(SourceMetadata.Builder builderForValue) {
            if (this.sourceMetadataBuilder_ == null) {
                this.sourceMetadata_ = builderForValue.build();
            } else {
                this.sourceMetadataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeSourceMetadata(SourceMetadata value) {
            if (this.sourceMetadataBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.sourceMetadata_ != null && this.sourceMetadata_ != SourceMetadata.getDefaultInstance()) {
                    this.getSourceMetadataBuilder().mergeFrom(value);
                } else {
                    this.sourceMetadata_ = value;
                }
            } else {
                this.sourceMetadataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.sourceMetadata_ != null) {
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSourceMetadata() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.sourceMetadata_ = null;
            if (this.sourceMetadataBuilder_ != null) {
                this.sourceMetadataBuilder_.dispose();
                this.sourceMetadataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public SourceMetadata.Builder getSourceMetadataBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (SourceMetadata.Builder)this.getSourceMetadataFieldBuilder().getBuilder();
        }

        @Override
        public SourceMetadataOrBuilder getSourceMetadataOrBuilder() {
            if (this.sourceMetadataBuilder_ != null) {
                return (SourceMetadataOrBuilder)this.sourceMetadataBuilder_.getMessageOrBuilder();
            }
            return this.sourceMetadata_ == null ? SourceMetadata.getDefaultInstance() : this.sourceMetadata_;
        }

        private SingleFieldBuilderV3<SourceMetadata, SourceMetadata.Builder, SourceMetadataOrBuilder> getSourceMetadataFieldBuilder() {
            if (this.sourceMetadataBuilder_ == null) {
                this.sourceMetadataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSourceMetadata(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.sourceMetadata_ = null;
            }
            return this.sourceMetadataBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SourceType implements ProtocolMessageEnum
    {
        SOURCE_TYPE_UNSPECIFIED(0),
        GCP_XLB(1),
        GCP_ILB(2),
        UNRECOGNIZED(-1);

        public static final int SOURCE_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int GCP_XLB_VALUE = 1;
        public static final int GCP_ILB_VALUE = 2;
        private static final Internal.EnumLiteMap<SourceType> internalValueMap;
        private static final SourceType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SourceType valueOf(int value) {
            return SourceType.forNumber(value);
        }

        public static SourceType forNumber(int value) {
            switch (value) {
                case 0: {
                    return SOURCE_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return GCP_XLB;
                }
                case 2: {
                    return GCP_ILB;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SourceType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SourceType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SourceType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)DiscoveredApiObservation.getDescriptor().getEnumTypes().get(1);
        }

        public static SourceType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SourceType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SourceType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SourceType>(){

                public SourceType findValueByNumber(int number) {
                    return SourceType.forNumber(number);
                }
            };
            VALUES = SourceType.values();
        }
    }

    public static enum Style implements ProtocolMessageEnum
    {
        STYLE_UNSPECIFIED(0),
        REST(1),
        GRPC(2),
        GRAPHQL(3),
        UNRECOGNIZED(-1);

        public static final int STYLE_UNSPECIFIED_VALUE = 0;
        public static final int REST_VALUE = 1;
        public static final int GRPC_VALUE = 2;
        public static final int GRAPHQL_VALUE = 3;
        private static final Internal.EnumLiteMap<Style> internalValueMap;
        private static final Style[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Style valueOf(int value) {
            return Style.forNumber(value);
        }

        public static Style forNumber(int value) {
            switch (value) {
                case 0: {
                    return STYLE_UNSPECIFIED;
                }
                case 1: {
                    return REST;
                }
                case 2: {
                    return GRPC;
                }
                case 3: {
                    return GRAPHQL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Style> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Style.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Style.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)DiscoveredApiObservation.getDescriptor().getEnumTypes().get(0);
        }

        public static Style valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Style.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Style(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Style>(){

                public Style findValueByNumber(int number) {
                    return Style.forNumber(number);
                }
            };
            VALUES = Style.values();
        }
    }
}

