/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CurationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CURATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/curations/{curation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String curation;

    @Deprecated
    protected CurationName() {
        this.project = null;
        this.location = null;
        this.curation = null;
    }

    private CurationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.curation = (String)Preconditions.checkNotNull((Object)builder.getCuration());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCuration() {
        return this.curation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CurationName of(String project, String location, String curation) {
        return CurationName.newBuilder().setProject(project).setLocation(location).setCuration(curation).build();
    }

    public static String format(String project, String location, String curation) {
        return CurationName.newBuilder().setProject(project).setLocation(location).setCuration(curation).build().toString();
    }

    public static CurationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CURATION.validatedMatch(formattedString, "CurationName.parse: formattedString not in valid format");
        return CurationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("curation"));
    }

    public static List<CurationName> parseList(List<String> formattedStrings) {
        ArrayList<CurationName> list = new ArrayList<CurationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CurationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CurationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CurationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CURATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CurationName curationName = this;
            synchronized (curationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.curation != null) {
                        fieldMapBuilder.put((Object)"curation", (Object)this.curation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CURATION.instantiate(new String[]{"project", this.project, "location", this.location, "curation", this.curation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CurationName that = (CurationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.curation, that.curation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.curation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String curation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCuration() {
            return this.curation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCuration(String curation) {
            this.curation = curation;
            return this;
        }

        private Builder(CurationName curationName) {
            this.project = curationName.project;
            this.location = curationName.location;
            this.curation = curationName.curation;
        }

        public CurationName build() {
            return new CurationName(this);
        }
    }
}

