/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PluginName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PLUGIN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/plugins/{plugin}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String plugin;

    @Deprecated
    protected PluginName() {
        this.project = null;
        this.location = null;
        this.plugin = null;
    }

    private PluginName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.plugin = (String)Preconditions.checkNotNull((Object)builder.getPlugin());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PluginName of(String project, String location, String plugin) {
        return PluginName.newBuilder().setProject(project).setLocation(location).setPlugin(plugin).build();
    }

    public static String format(String project, String location, String plugin) {
        return PluginName.newBuilder().setProject(project).setLocation(location).setPlugin(plugin).build().toString();
    }

    public static PluginName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PLUGIN.validatedMatch(formattedString, "PluginName.parse: formattedString not in valid format");
        return PluginName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("plugin"));
    }

    public static List<PluginName> parseList(List<String> formattedStrings) {
        ArrayList<PluginName> list = new ArrayList<PluginName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PluginName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PluginName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PluginName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PLUGIN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PluginName pluginName = this;
            synchronized (pluginName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.plugin != null) {
                        fieldMapBuilder.put((Object)"plugin", (Object)this.plugin);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PLUGIN.instantiate(new String[]{"project", this.project, "location", this.location, "plugin", this.plugin});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PluginName that = (PluginName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.plugin, that.plugin);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.plugin);
    }

    public static class Builder {
        private String project;
        private String location;
        private String plugin;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPlugin(String plugin) {
            this.plugin = plugin;
            return this;
        }

        private Builder(PluginName pluginName) {
            this.project = pluginName.project;
            this.location = pluginName.location;
            this.plugin = pluginName.plugin;
        }

        public PluginName build() {
            return new PluginName(this);
        }
    }
}

