/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DependencyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEPENDENCY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dependencies/{dependency}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dependency;

    @Deprecated
    protected DependencyName() {
        this.project = null;
        this.location = null;
        this.dependency = null;
    }

    private DependencyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dependency = (String)Preconditions.checkNotNull((Object)builder.getDependency());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDependency() {
        return this.dependency;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DependencyName of(String project, String location, String dependency) {
        return DependencyName.newBuilder().setProject(project).setLocation(location).setDependency(dependency).build();
    }

    public static String format(String project, String location, String dependency) {
        return DependencyName.newBuilder().setProject(project).setLocation(location).setDependency(dependency).build().toString();
    }

    public static DependencyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEPENDENCY.validatedMatch(formattedString, "DependencyName.parse: formattedString not in valid format");
        return DependencyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dependency"));
    }

    public static List<DependencyName> parseList(List<String> formattedStrings) {
        ArrayList<DependencyName> list = new ArrayList<DependencyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DependencyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DependencyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DependencyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEPENDENCY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DependencyName dependencyName = this;
            synchronized (dependencyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dependency != null) {
                        fieldMapBuilder.put((Object)"dependency", (Object)this.dependency);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEPENDENCY.instantiate(new String[]{"project", this.project, "location", this.location, "dependency", this.dependency});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DependencyName that = (DependencyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dependency, that.dependency);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dependency);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dependency;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDependency() {
            return this.dependency;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDependency(String dependency) {
            this.dependency = dependency;
            return this;
        }

        private Builder(DependencyName dependencyName) {
            this.project = dependencyName.project;
            this.location = dependencyName.location;
            this.dependency = dependencyName.dependency;
        }

        public DependencyName build() {
            return new DependencyName(this);
        }
    }
}

