/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttributeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ATTRIBUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/attributes/{attribute}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String attribute;

    @Deprecated
    protected AttributeName() {
        this.project = null;
        this.location = null;
        this.attribute = null;
    }

    private AttributeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.attribute = (String)Preconditions.checkNotNull((Object)builder.getAttribute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttributeName of(String project, String location, String attribute) {
        return AttributeName.newBuilder().setProject(project).setLocation(location).setAttribute(attribute).build();
    }

    public static String format(String project, String location, String attribute) {
        return AttributeName.newBuilder().setProject(project).setLocation(location).setAttribute(attribute).build().toString();
    }

    public static AttributeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ATTRIBUTE.validatedMatch(formattedString, "AttributeName.parse: formattedString not in valid format");
        return AttributeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("attribute"));
    }

    public static List<AttributeName> parseList(List<String> formattedStrings) {
        ArrayList<AttributeName> list = new ArrayList<AttributeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttributeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttributeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttributeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ATTRIBUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttributeName attributeName = this;
            synchronized (attributeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.attribute != null) {
                        fieldMapBuilder.put((Object)"attribute", (Object)this.attribute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ATTRIBUTE.instantiate(new String[]{"project", this.project, "location", this.location, "attribute", this.attribute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttributeName that = (AttributeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.attribute, that.attribute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.attribute);
    }

    public static class Builder {
        private String project;
        private String location;
        private String attribute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAttribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        private Builder(AttributeName attributeName) {
            this.project = attributeName.project;
            this.location = attributeName.location;
            this.attribute = attributeName.attribute;
        }

        public AttributeName build() {
            return new AttributeName(this);
        }
    }
}

