/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExternalApiName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_EXTERNAL_API = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/externalApis/{external_api}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String externalApi;

    @Deprecated
    protected ExternalApiName() {
        this.project = null;
        this.location = null;
        this.externalApi = null;
    }

    private ExternalApiName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.externalApi = (String)Preconditions.checkNotNull((Object)builder.getExternalApi());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExternalApi() {
        return this.externalApi;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExternalApiName of(String project, String location, String externalApi) {
        return ExternalApiName.newBuilder().setProject(project).setLocation(location).setExternalApi(externalApi).build();
    }

    public static String format(String project, String location, String externalApi) {
        return ExternalApiName.newBuilder().setProject(project).setLocation(location).setExternalApi(externalApi).build().toString();
    }

    public static ExternalApiName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_EXTERNAL_API.validatedMatch(formattedString, "ExternalApiName.parse: formattedString not in valid format");
        return ExternalApiName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("external_api"));
    }

    public static List<ExternalApiName> parseList(List<String> formattedStrings) {
        ArrayList<ExternalApiName> list = new ArrayList<ExternalApiName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExternalApiName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExternalApiName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExternalApiName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_EXTERNAL_API.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExternalApiName externalApiName = this;
            synchronized (externalApiName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.externalApi != null) {
                        fieldMapBuilder.put((Object)"external_api", (Object)this.externalApi);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_EXTERNAL_API.instantiate(new String[]{"project", this.project, "location", this.location, "external_api", this.externalApi});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExternalApiName that = (ExternalApiName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.externalApi, that.externalApi);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.externalApi);
    }

    public static class Builder {
        private String project;
        private String location;
        private String externalApi;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExternalApi() {
            return this.externalApi;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setExternalApi(String externalApi) {
            this.externalApi = externalApi;
            return this;
        }

        private Builder(ExternalApiName externalApiName) {
            this.project = externalApiName.project;
            this.location = externalApiName.location;
            this.externalApi = externalApiName.externalApi;
        }

        public ExternalApiName build() {
            return new ExternalApiName(this);
        }
    }
}

