/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefinitionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_API_VERSION_DEFINITION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String api;
    private final String version;
    private final String definition;

    @Deprecated
    protected DefinitionName() {
        this.project = null;
        this.location = null;
        this.api = null;
        this.version = null;
        this.definition = null;
    }

    private DefinitionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
        this.definition = (String)Preconditions.checkNotNull((Object)builder.getDefinition());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApi() {
        return this.api;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefinition() {
        return this.definition;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DefinitionName of(String project, String location, String api, String version, String definition) {
        return DefinitionName.newBuilder().setProject(project).setLocation(location).setApi(api).setVersion(version).setDefinition(definition).build();
    }

    public static String format(String project, String location, String api, String version, String definition) {
        return DefinitionName.newBuilder().setProject(project).setLocation(location).setApi(api).setVersion(version).setDefinition(definition).build().toString();
    }

    public static DefinitionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_API_VERSION_DEFINITION.validatedMatch(formattedString, "DefinitionName.parse: formattedString not in valid format");
        return DefinitionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api"), (String)matchMap.get("version"), (String)matchMap.get("definition"));
    }

    public static List<DefinitionName> parseList(List<String> formattedStrings) {
        ArrayList<DefinitionName> list = new ArrayList<DefinitionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DefinitionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DefinitionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DefinitionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_API_VERSION_DEFINITION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DefinitionName definitionName = this;
            synchronized (definitionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.api != null) {
                        fieldMapBuilder.put((Object)"api", (Object)this.api);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    if (this.definition != null) {
                        fieldMapBuilder.put((Object)"definition", (Object)this.definition);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_API_VERSION_DEFINITION.instantiate(new String[]{"project", this.project, "location", this.location, "api", this.api, "version", this.version, "definition", this.definition});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DefinitionName that = (DefinitionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.api, that.api) && Objects.equals(this.version, that.version) && Objects.equals(this.definition, that.definition);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.api);
        h *= 1000003;
        h ^= Objects.hashCode(this.version);
        h *= 1000003;
        return h ^= Objects.hashCode(this.definition);
    }

    public static class Builder {
        private String project;
        private String location;
        private String api;
        private String version;
        private String definition;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApi() {
            return this.api;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDefinition() {
            return this.definition;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApi(String api) {
            this.api = api;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setDefinition(String definition) {
            this.definition = definition;
            return this;
        }

        private Builder(DefinitionName definitionName) {
            this.project = definitionName.project;
            this.location = definitionName.location;
            this.api = definitionName.api;
            this.version = definitionName.version;
            this.definition = definitionName.definition;
        }

        public DefinitionName build() {
            return new DefinitionName(this);
        }
    }
}

