/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiHubInstanceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_API_HUB_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apiHubInstances/{api_hub_instance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String apiHubInstance;

    @Deprecated
    protected ApiHubInstanceName() {
        this.project = null;
        this.location = null;
        this.apiHubInstance = null;
    }

    private ApiHubInstanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.apiHubInstance = (String)Preconditions.checkNotNull((Object)builder.getApiHubInstance());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApiHubInstance() {
        return this.apiHubInstance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApiHubInstanceName of(String project, String location, String apiHubInstance) {
        return ApiHubInstanceName.newBuilder().setProject(project).setLocation(location).setApiHubInstance(apiHubInstance).build();
    }

    public static String format(String project, String location, String apiHubInstance) {
        return ApiHubInstanceName.newBuilder().setProject(project).setLocation(location).setApiHubInstance(apiHubInstance).build().toString();
    }

    public static ApiHubInstanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_API_HUB_INSTANCE.validatedMatch(formattedString, "ApiHubInstanceName.parse: formattedString not in valid format");
        return ApiHubInstanceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api_hub_instance"));
    }

    public static List<ApiHubInstanceName> parseList(List<String> formattedStrings) {
        ArrayList<ApiHubInstanceName> list = new ArrayList<ApiHubInstanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApiHubInstanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApiHubInstanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApiHubInstanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_API_HUB_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApiHubInstanceName apiHubInstanceName = this;
            synchronized (apiHubInstanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.apiHubInstance != null) {
                        fieldMapBuilder.put((Object)"api_hub_instance", (Object)this.apiHubInstance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_API_HUB_INSTANCE.instantiate(new String[]{"project", this.project, "location", this.location, "api_hub_instance", this.apiHubInstance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ApiHubInstanceName that = (ApiHubInstanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.apiHubInstance, that.apiHubInstance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.apiHubInstance);
    }

    public static class Builder {
        private String project;
        private String location;
        private String apiHubInstance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApiHubInstance() {
            return this.apiHubInstance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApiHubInstance(String apiHubInstance) {
            this.apiHubInstance = apiHubInstance;
            return this;
        }

        private Builder(ApiHubInstanceName apiHubInstanceName) {
            this.project = apiHubInstanceName.project;
            this.location = apiHubInstanceName.location;
            this.apiHubInstance = apiHubInstanceName.apiHubInstance;
        }

        public ApiHubInstanceName build() {
            return new ApiHubInstanceName(this);
        }
    }
}

