/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HostProjectRegistrationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_HOST_PROJECT_REGISTRATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String hostProjectRegistration;

    @Deprecated
    protected HostProjectRegistrationName() {
        this.project = null;
        this.location = null;
        this.hostProjectRegistration = null;
    }

    private HostProjectRegistrationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.hostProjectRegistration = (String)Preconditions.checkNotNull((Object)builder.getHostProjectRegistration());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHostProjectRegistration() {
        return this.hostProjectRegistration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HostProjectRegistrationName of(String project, String location, String hostProjectRegistration) {
        return HostProjectRegistrationName.newBuilder().setProject(project).setLocation(location).setHostProjectRegistration(hostProjectRegistration).build();
    }

    public static String format(String project, String location, String hostProjectRegistration) {
        return HostProjectRegistrationName.newBuilder().setProject(project).setLocation(location).setHostProjectRegistration(hostProjectRegistration).build().toString();
    }

    public static HostProjectRegistrationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_HOST_PROJECT_REGISTRATION.validatedMatch(formattedString, "HostProjectRegistrationName.parse: formattedString not in valid format");
        return HostProjectRegistrationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("host_project_registration"));
    }

    public static List<HostProjectRegistrationName> parseList(List<String> formattedStrings) {
        ArrayList<HostProjectRegistrationName> list = new ArrayList<HostProjectRegistrationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HostProjectRegistrationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HostProjectRegistrationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HostProjectRegistrationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_HOST_PROJECT_REGISTRATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HostProjectRegistrationName hostProjectRegistrationName = this;
            synchronized (hostProjectRegistrationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.hostProjectRegistration != null) {
                        fieldMapBuilder.put((Object)"host_project_registration", (Object)this.hostProjectRegistration);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_HOST_PROJECT_REGISTRATION.instantiate(new String[]{"project", this.project, "location", this.location, "host_project_registration", this.hostProjectRegistration});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HostProjectRegistrationName that = (HostProjectRegistrationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.hostProjectRegistration, that.hostProjectRegistration);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hostProjectRegistration);
    }

    public static class Builder {
        private String project;
        private String location;
        private String hostProjectRegistration;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getHostProjectRegistration() {
            return this.hostProjectRegistration;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setHostProjectRegistration(String hostProjectRegistration) {
            this.hostProjectRegistration = hostProjectRegistration;
            return this;
        }

        private Builder(HostProjectRegistrationName hostProjectRegistrationName) {
            this.project = hostProjectRegistrationName.project;
            this.location = hostProjectRegistrationName.location;
            this.hostProjectRegistration = hostProjectRegistrationName.hostProjectRegistration;
        }

        public HostProjectRegistrationName build() {
            return new HostProjectRegistrationName(this);
        }
    }
}

