/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RuntimeProjectAttachmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RUNTIME_PROJECT_ATTACHMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String runtimeProjectAttachment;

    @Deprecated
    protected RuntimeProjectAttachmentName() {
        this.project = null;
        this.location = null;
        this.runtimeProjectAttachment = null;
    }

    private RuntimeProjectAttachmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.runtimeProjectAttachment = (String)Preconditions.checkNotNull((Object)builder.getRuntimeProjectAttachment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRuntimeProjectAttachment() {
        return this.runtimeProjectAttachment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RuntimeProjectAttachmentName of(String project, String location, String runtimeProjectAttachment) {
        return RuntimeProjectAttachmentName.newBuilder().setProject(project).setLocation(location).setRuntimeProjectAttachment(runtimeProjectAttachment).build();
    }

    public static String format(String project, String location, String runtimeProjectAttachment) {
        return RuntimeProjectAttachmentName.newBuilder().setProject(project).setLocation(location).setRuntimeProjectAttachment(runtimeProjectAttachment).build().toString();
    }

    public static RuntimeProjectAttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RUNTIME_PROJECT_ATTACHMENT.validatedMatch(formattedString, "RuntimeProjectAttachmentName.parse: formattedString not in valid format");
        return RuntimeProjectAttachmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("runtime_project_attachment"));
    }

    public static List<RuntimeProjectAttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<RuntimeProjectAttachmentName> list = new ArrayList<RuntimeProjectAttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RuntimeProjectAttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RuntimeProjectAttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RuntimeProjectAttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RUNTIME_PROJECT_ATTACHMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RuntimeProjectAttachmentName runtimeProjectAttachmentName = this;
            synchronized (runtimeProjectAttachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.runtimeProjectAttachment != null) {
                        fieldMapBuilder.put((Object)"runtime_project_attachment", (Object)this.runtimeProjectAttachment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RUNTIME_PROJECT_ATTACHMENT.instantiate(new String[]{"project", this.project, "location", this.location, "runtime_project_attachment", this.runtimeProjectAttachment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RuntimeProjectAttachmentName that = (RuntimeProjectAttachmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.runtimeProjectAttachment, that.runtimeProjectAttachment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.runtimeProjectAttachment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String runtimeProjectAttachment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRuntimeProjectAttachment() {
            return this.runtimeProjectAttachment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRuntimeProjectAttachment(String runtimeProjectAttachment) {
            this.runtimeProjectAttachment = runtimeProjectAttachment;
            return this;
        }

        private Builder(RuntimeProjectAttachmentName runtimeProjectAttachmentName) {
            this.project = runtimeProjectAttachmentName.project;
            this.location = runtimeProjectAttachmentName.location;
            this.runtimeProjectAttachment = runtimeProjectAttachmentName.runtimeProjectAttachment;
        }

        public RuntimeProjectAttachmentName build() {
            return new RuntimeProjectAttachmentName(this);
        }
    }
}

