/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiDeploymentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_API_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String api;
    private final String deployment;

    @Deprecated
    protected ApiDeploymentName() {
        this.project = null;
        this.location = null;
        this.api = null;
        this.deployment = null;
    }

    private ApiDeploymentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApi() {
        return this.api;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApiDeploymentName of(String project, String location, String api, String deployment) {
        return ApiDeploymentName.newBuilder().setProject(project).setLocation(location).setApi(api).setDeployment(deployment).build();
    }

    public static String format(String project, String location, String api, String deployment) {
        return ApiDeploymentName.newBuilder().setProject(project).setLocation(location).setApi(api).setDeployment(deployment).build().toString();
    }

    public static ApiDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_API_DEPLOYMENT.validatedMatch(formattedString, "ApiDeploymentName.parse: formattedString not in valid format");
        return ApiDeploymentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api"), (String)matchMap.get("deployment"));
    }

    public static List<ApiDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<ApiDeploymentName> list = new ArrayList<ApiDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApiDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApiDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApiDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_API_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApiDeploymentName apiDeploymentName = this;
            synchronized (apiDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.api != null) {
                        fieldMapBuilder.put((Object)"api", (Object)this.api);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_API_DEPLOYMENT.instantiate(new String[]{"project", this.project, "location", this.location, "api", this.api, "deployment", this.deployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ApiDeploymentName that = (ApiDeploymentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.api, that.api) && Objects.equals(this.deployment, that.deployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.api);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deployment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String api;
        private String deployment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApi() {
            return this.api;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApi(String api) {
            this.api = api;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        private Builder(ApiDeploymentName apiDeploymentName) {
            this.project = apiDeploymentName.project;
            this.location = apiDeploymentName.location;
            this.api = apiDeploymentName.api;
            this.deployment = apiDeploymentName.deployment;
        }

        public ApiDeploymentName build() {
            return new ApiDeploymentName(this);
        }
    }
}

