/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceName
implements ResourceName {
    private static final PathTemplate SERVICE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"services/{service}/configs/{config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String service;
    private final String config;

    @Deprecated
    protected ServiceName() {
        this.service = null;
        this.config = null;
    }

    private ServiceName(Builder builder) {
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.config = (String)Preconditions.checkNotNull((Object)builder.getConfig());
    }

    public String getService() {
        return this.service;
    }

    public String getConfig() {
        return this.config;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceName of(String service, String config) {
        return ServiceName.newBuilder().setService(service).setConfig(config).build();
    }

    public static String format(String service, String config) {
        return ServiceName.newBuilder().setService(service).setConfig(config).build().toString();
    }

    public static ServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SERVICE_CONFIG.validatedMatch(formattedString, "ServiceName.parse: formattedString not in valid format");
        return ServiceName.of((String)matchMap.get("service"), (String)matchMap.get("config"));
    }

    public static List<ServiceName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceName> list = new ArrayList<ServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SERVICE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceName serviceName = this;
            synchronized (serviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.config != null) {
                        fieldMapBuilder.put((Object)"config", (Object)this.config);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SERVICE_CONFIG.instantiate(new String[]{"service", this.service, "config", this.config});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ServiceName that = (ServiceName)o;
            return Objects.equals(this.service, that.service) && Objects.equals(this.config, that.config);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        return h ^= Objects.hashCode(this.config);
    }

    public static class Builder {
        private String service;
        private String config;

        protected Builder() {
        }

        public String getService() {
            return this.service;
        }

        public String getConfig() {
            return this.config;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setConfig(String config) {
            this.config = config;
            return this;
        }

        private Builder(ServiceName serviceName) {
            this.service = serviceName.service;
            this.config = serviceName.config;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }
}

