/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.analyticshub.v1;

import com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto;
import com.google.cloud.bigquery.analyticshub.v1.DataProvider;
import com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder;
import com.google.cloud.bigquery.analyticshub.v1.DiscoveryType;
import com.google.cloud.bigquery.analyticshub.v1.ListingOrBuilder;
import com.google.cloud.bigquery.analyticshub.v1.Publisher;
import com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder;
import com.google.cloud.bigquery.analyticshub.v1.SharedResourceType;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BoolValueOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Listing
extends GeneratedMessageV3
implements ListingOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int sourceCase_ = 0;
    private Object source_;
    public static final int BIGQUERY_DATASET_FIELD_NUMBER = 6;
    public static final int PUBSUB_TOPIC_FIELD_NUMBER = 16;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile Object displayName_ = "";
    public static final int DESCRIPTION_FIELD_NUMBER = 3;
    private volatile Object description_ = "";
    public static final int PRIMARY_CONTACT_FIELD_NUMBER = 4;
    private volatile Object primaryContact_ = "";
    public static final int DOCUMENTATION_FIELD_NUMBER = 5;
    private volatile Object documentation_ = "";
    public static final int STATE_FIELD_NUMBER = 7;
    private int state_ = 0;
    public static final int ICON_FIELD_NUMBER = 8;
    private ByteString icon_ = ByteString.EMPTY;
    public static final int DATA_PROVIDER_FIELD_NUMBER = 9;
    private DataProvider dataProvider_;
    public static final int CATEGORIES_FIELD_NUMBER = 10;
    private List<Integer> categories_;
    private static final Internal.ListAdapter.Converter<Integer, Category> categories_converter_ = new Internal.ListAdapter.Converter<Integer, Category>(){

        public Category convert(Integer from) {
            Category result = Category.forNumber(from);
            return result == null ? Category.UNRECOGNIZED : result;
        }
    };
    private int categoriesMemoizedSerializedSize;
    public static final int PUBLISHER_FIELD_NUMBER = 11;
    private Publisher publisher_;
    public static final int REQUEST_ACCESS_FIELD_NUMBER = 12;
    private volatile Object requestAccess_ = "";
    public static final int RESTRICTED_EXPORT_CONFIG_FIELD_NUMBER = 13;
    private RestrictedExportConfig restrictedExportConfig_;
    public static final int DISCOVERY_TYPE_FIELD_NUMBER = 14;
    private int discoveryType_ = 0;
    public static final int RESOURCE_TYPE_FIELD_NUMBER = 15;
    private int resourceType_ = 0;
    public static final int COMMERCIAL_INFO_FIELD_NUMBER = 17;
    private CommercialInfo commercialInfo_;
    public static final int LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER = 18;
    private boolean logLinkedDatasetQueryUserEmail_ = false;
    public static final int ALLOW_ONLY_METADATA_SHARING_FIELD_NUMBER = 19;
    private boolean allowOnlyMetadataSharing_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Listing DEFAULT_INSTANCE = new Listing();
    private static final Parser<Listing> PARSER = new AbstractParser<Listing>(){

        public Listing parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Listing.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Listing(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Listing() {
        this.name_ = "";
        this.displayName_ = "";
        this.description_ = "";
        this.primaryContact_ = "";
        this.documentation_ = "";
        this.state_ = 0;
        this.icon_ = ByteString.EMPTY;
        this.categories_ = Collections.emptyList();
        this.requestAccess_ = "";
        this.discoveryType_ = 0;
        this.resourceType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Listing();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_fieldAccessorTable.ensureFieldAccessorsInitialized(Listing.class, Builder.class);
    }

    @Override
    public SourceCase getSourceCase() {
        return SourceCase.forNumber(this.sourceCase_);
    }

    @Override
    public boolean hasBigqueryDataset() {
        return this.sourceCase_ == 6;
    }

    @Override
    public BigQueryDatasetSource getBigqueryDataset() {
        if (this.sourceCase_ == 6) {
            return (BigQueryDatasetSource)this.source_;
        }
        return BigQueryDatasetSource.getDefaultInstance();
    }

    @Override
    public BigQueryDatasetSourceOrBuilder getBigqueryDatasetOrBuilder() {
        if (this.sourceCase_ == 6) {
            return (BigQueryDatasetSource)this.source_;
        }
        return BigQueryDatasetSource.getDefaultInstance();
    }

    @Override
    public boolean hasPubsubTopic() {
        return this.sourceCase_ == 16;
    }

    @Override
    public PubSubTopicSource getPubsubTopic() {
        if (this.sourceCase_ == 16) {
            return (PubSubTopicSource)this.source_;
        }
        return PubSubTopicSource.getDefaultInstance();
    }

    @Override
    public PubSubTopicSourceOrBuilder getPubsubTopicOrBuilder() {
        if (this.sourceCase_ == 16) {
            return (PubSubTopicSource)this.source_;
        }
        return PubSubTopicSource.getDefaultInstance();
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPrimaryContact() {
        Object ref = this.primaryContact_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.primaryContact_ = s;
        return s;
    }

    @Override
    public ByteString getPrimaryContactBytes() {
        Object ref = this.primaryContact_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.primaryContact_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDocumentation() {
        Object ref = this.documentation_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.documentation_ = s;
        return s;
    }

    @Override
    public ByteString getDocumentationBytes() {
        Object ref = this.documentation_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.documentation_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public ByteString getIcon() {
        return this.icon_;
    }

    @Override
    public boolean hasDataProvider() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.dataProvider_ == null ? DataProvider.getDefaultInstance() : this.dataProvider_;
    }

    @Override
    public DataProviderOrBuilder getDataProviderOrBuilder() {
        return this.dataProvider_ == null ? DataProvider.getDefaultInstance() : this.dataProvider_;
    }

    @Override
    public List<Category> getCategoriesList() {
        return new Internal.ListAdapter(this.categories_, categories_converter_);
    }

    @Override
    public int getCategoriesCount() {
        return this.categories_.size();
    }

    @Override
    public Category getCategories(int index) {
        return (Category)((Object)categories_converter_.convert((Object)this.categories_.get(index)));
    }

    @Override
    public List<Integer> getCategoriesValueList() {
        return this.categories_;
    }

    @Override
    public int getCategoriesValue(int index) {
        return this.categories_.get(index);
    }

    @Override
    public boolean hasPublisher() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Publisher getPublisher() {
        return this.publisher_ == null ? Publisher.getDefaultInstance() : this.publisher_;
    }

    @Override
    public PublisherOrBuilder getPublisherOrBuilder() {
        return this.publisher_ == null ? Publisher.getDefaultInstance() : this.publisher_;
    }

    @Override
    public String getRequestAccess() {
        Object ref = this.requestAccess_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.requestAccess_ = s;
        return s;
    }

    @Override
    public ByteString getRequestAccessBytes() {
        Object ref = this.requestAccess_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.requestAccess_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasRestrictedExportConfig() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public RestrictedExportConfig getRestrictedExportConfig() {
        return this.restrictedExportConfig_ == null ? RestrictedExportConfig.getDefaultInstance() : this.restrictedExportConfig_;
    }

    @Override
    public RestrictedExportConfigOrBuilder getRestrictedExportConfigOrBuilder() {
        return this.restrictedExportConfig_ == null ? RestrictedExportConfig.getDefaultInstance() : this.restrictedExportConfig_;
    }

    @Override
    public boolean hasDiscoveryType() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public int getDiscoveryTypeValue() {
        return this.discoveryType_;
    }

    @Override
    public DiscoveryType getDiscoveryType() {
        DiscoveryType result = DiscoveryType.forNumber(this.discoveryType_);
        return result == null ? DiscoveryType.UNRECOGNIZED : result;
    }

    @Override
    public int getResourceTypeValue() {
        return this.resourceType_;
    }

    @Override
    public SharedResourceType getResourceType() {
        SharedResourceType result = SharedResourceType.forNumber(this.resourceType_);
        return result == null ? SharedResourceType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasCommercialInfo() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public CommercialInfo getCommercialInfo() {
        return this.commercialInfo_ == null ? CommercialInfo.getDefaultInstance() : this.commercialInfo_;
    }

    @Override
    public CommercialInfoOrBuilder getCommercialInfoOrBuilder() {
        return this.commercialInfo_ == null ? CommercialInfo.getDefaultInstance() : this.commercialInfo_;
    }

    @Override
    public boolean hasLogLinkedDatasetQueryUserEmail() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public boolean getLogLinkedDatasetQueryUserEmail() {
        return this.logLinkedDatasetQueryUserEmail_;
    }

    @Override
    public boolean hasAllowOnlyMetadataSharing() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public boolean getAllowOnlyMetadataSharing() {
        return this.allowOnlyMetadataSharing_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.displayName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.description_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.primaryContact_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.primaryContact_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.documentation_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.documentation_);
        }
        if (this.sourceCase_ == 6) {
            output.writeMessage(6, (MessageLite)((BigQueryDatasetSource)this.source_));
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.state_);
        }
        if (!this.icon_.isEmpty()) {
            output.writeBytes(8, this.icon_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(9, (MessageLite)this.getDataProvider());
        }
        if (this.getCategoriesList().size() > 0) {
            output.writeUInt32NoTag(82);
            output.writeUInt32NoTag(this.categoriesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.categories_.size(); ++i) {
            output.writeEnumNoTag(this.categories_.get(i).intValue());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(11, (MessageLite)this.getPublisher());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.requestAccess_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.requestAccess_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(13, (MessageLite)this.getRestrictedExportConfig());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeEnum(14, this.discoveryType_);
        }
        if (this.resourceType_ != SharedResourceType.SHARED_RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(15, this.resourceType_);
        }
        if (this.sourceCase_ == 16) {
            output.writeMessage(16, (MessageLite)((PubSubTopicSource)this.source_));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(17, (MessageLite)this.getCommercialInfo());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeBool(18, this.logLinkedDatasetQueryUserEmail_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeBool(19, this.allowOnlyMetadataSharing_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.displayName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.description_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.primaryContact_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.primaryContact_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.documentation_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.documentation_);
        }
        if (this.sourceCase_ == 6) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((BigQueryDatasetSource)this.source_));
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.state_);
        }
        if (!this.icon_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)8, (ByteString)this.icon_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getDataProvider());
        }
        int dataSize = 0;
        for (int i = 0; i < this.categories_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.categories_.get(i));
        }
        size += dataSize;
        if (!this.getCategoriesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.categoriesMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getPublisher());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.requestAccess_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.requestAccess_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getRestrictedExportConfig());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeEnumSize((int)14, (int)this.discoveryType_);
        }
        if (this.resourceType_ != SharedResourceType.SHARED_RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)15, (int)this.resourceType_);
        }
        if (this.sourceCase_ == 16) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)((PubSubTopicSource)this.source_));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)this.getCommercialInfo());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeBoolSize((int)18, (boolean)this.logLinkedDatasetQueryUserEmail_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeBoolSize((int)19, (boolean)this.allowOnlyMetadataSharing_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Listing)) {
            return super.equals(obj);
        }
        Listing other = (Listing)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getPrimaryContact().equals(other.getPrimaryContact())) {
            return false;
        }
        if (!this.getDocumentation().equals(other.getDocumentation())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (!this.getIcon().equals((Object)other.getIcon())) {
            return false;
        }
        if (this.hasDataProvider() != other.hasDataProvider()) {
            return false;
        }
        if (this.hasDataProvider() && !this.getDataProvider().equals(other.getDataProvider())) {
            return false;
        }
        if (!this.categories_.equals(other.categories_)) {
            return false;
        }
        if (this.hasPublisher() != other.hasPublisher()) {
            return false;
        }
        if (this.hasPublisher() && !this.getPublisher().equals(other.getPublisher())) {
            return false;
        }
        if (!this.getRequestAccess().equals(other.getRequestAccess())) {
            return false;
        }
        if (this.hasRestrictedExportConfig() != other.hasRestrictedExportConfig()) {
            return false;
        }
        if (this.hasRestrictedExportConfig() && !this.getRestrictedExportConfig().equals(other.getRestrictedExportConfig())) {
            return false;
        }
        if (this.hasDiscoveryType() != other.hasDiscoveryType()) {
            return false;
        }
        if (this.hasDiscoveryType() && this.discoveryType_ != other.discoveryType_) {
            return false;
        }
        if (this.resourceType_ != other.resourceType_) {
            return false;
        }
        if (this.hasCommercialInfo() != other.hasCommercialInfo()) {
            return false;
        }
        if (this.hasCommercialInfo() && !this.getCommercialInfo().equals(other.getCommercialInfo())) {
            return false;
        }
        if (this.hasLogLinkedDatasetQueryUserEmail() != other.hasLogLinkedDatasetQueryUserEmail()) {
            return false;
        }
        if (this.hasLogLinkedDatasetQueryUserEmail() && this.getLogLinkedDatasetQueryUserEmail() != other.getLogLinkedDatasetQueryUserEmail()) {
            return false;
        }
        if (this.hasAllowOnlyMetadataSharing() != other.hasAllowOnlyMetadataSharing()) {
            return false;
        }
        if (this.hasAllowOnlyMetadataSharing() && this.getAllowOnlyMetadataSharing() != other.getAllowOnlyMetadataSharing()) {
            return false;
        }
        if (!this.getSourceCase().equals((Object)other.getSourceCase())) {
            return false;
        }
        switch (this.sourceCase_) {
            case 6: {
                if (this.getBigqueryDataset().equals(other.getBigqueryDataset())) break;
                return false;
            }
            case 16: {
                if (this.getPubsubTopic().equals(other.getPubsubTopic())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Listing.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDisplayName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getPrimaryContact().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getDocumentation().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getIcon().hashCode();
        if (this.hasDataProvider()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getDataProvider().hashCode();
        }
        if (this.getCategoriesCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.categories_.hashCode();
        }
        if (this.hasPublisher()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getPublisher().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getRequestAccess().hashCode();
        if (this.hasRestrictedExportConfig()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getRestrictedExportConfig().hashCode();
        }
        if (this.hasDiscoveryType()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.discoveryType_;
        }
        hash = 37 * hash + 15;
        hash = 53 * hash + this.resourceType_;
        if (this.hasCommercialInfo()) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getCommercialInfo().hashCode();
        }
        if (this.hasLogLinkedDatasetQueryUserEmail()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getLogLinkedDatasetQueryUserEmail());
        }
        if (this.hasAllowOnlyMetadataSharing()) {
            hash = 37 * hash + 19;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getAllowOnlyMetadataSharing());
        }
        switch (this.sourceCase_) {
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getBigqueryDataset().hashCode();
                break;
            }
            case 16: {
                hash = 37 * hash + 16;
                hash = 53 * hash + this.getPubsubTopic().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Listing parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Listing)PARSER.parseFrom(data);
    }

    public static Listing parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Listing)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Listing parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Listing)PARSER.parseFrom(data);
    }

    public static Listing parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Listing)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Listing parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Listing)PARSER.parseFrom(data);
    }

    public static Listing parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Listing)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Listing parseFrom(InputStream input) throws IOException {
        return (Listing)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Listing parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Listing)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Listing parseDelimitedFrom(InputStream input) throws IOException {
        return (Listing)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Listing parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Listing)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Listing parseFrom(CodedInputStream input) throws IOException {
        return (Listing)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Listing parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Listing)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Listing.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Listing prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Listing getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Listing> parser() {
        return PARSER;
    }

    public Parser<Listing> getParserForType() {
        return PARSER;
    }

    public Listing getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ListingOrBuilder {
        private int sourceCase_ = 0;
        private Object source_;
        private int bitField0_;
        private SingleFieldBuilderV3<BigQueryDatasetSource, BigQueryDatasetSource.Builder, BigQueryDatasetSourceOrBuilder> bigqueryDatasetBuilder_;
        private SingleFieldBuilderV3<PubSubTopicSource, PubSubTopicSource.Builder, PubSubTopicSourceOrBuilder> pubsubTopicBuilder_;
        private Object name_ = "";
        private Object displayName_ = "";
        private Object description_ = "";
        private Object primaryContact_ = "";
        private Object documentation_ = "";
        private int state_ = 0;
        private ByteString icon_ = ByteString.EMPTY;
        private DataProvider dataProvider_;
        private SingleFieldBuilderV3<DataProvider, DataProvider.Builder, DataProviderOrBuilder> dataProviderBuilder_;
        private List<Integer> categories_ = Collections.emptyList();
        private Publisher publisher_;
        private SingleFieldBuilderV3<Publisher, Publisher.Builder, PublisherOrBuilder> publisherBuilder_;
        private Object requestAccess_ = "";
        private RestrictedExportConfig restrictedExportConfig_;
        private SingleFieldBuilderV3<RestrictedExportConfig, RestrictedExportConfig.Builder, RestrictedExportConfigOrBuilder> restrictedExportConfigBuilder_;
        private int discoveryType_ = 0;
        private int resourceType_ = 0;
        private CommercialInfo commercialInfo_;
        private SingleFieldBuilderV3<CommercialInfo, CommercialInfo.Builder, CommercialInfoOrBuilder> commercialInfoBuilder_;
        private boolean logLinkedDatasetQueryUserEmail_;
        private boolean allowOnlyMetadataSharing_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_fieldAccessorTable.ensureFieldAccessorsInitialized(Listing.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getDataProviderFieldBuilder();
                this.getPublisherFieldBuilder();
                this.getRestrictedExportConfigFieldBuilder();
                this.getCommercialInfoFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.bigqueryDatasetBuilder_ != null) {
                this.bigqueryDatasetBuilder_.clear();
            }
            if (this.pubsubTopicBuilder_ != null) {
                this.pubsubTopicBuilder_.clear();
            }
            this.name_ = "";
            this.displayName_ = "";
            this.description_ = "";
            this.primaryContact_ = "";
            this.documentation_ = "";
            this.state_ = 0;
            this.icon_ = ByteString.EMPTY;
            this.dataProvider_ = null;
            if (this.dataProviderBuilder_ != null) {
                this.dataProviderBuilder_.dispose();
                this.dataProviderBuilder_ = null;
            }
            this.categories_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.publisher_ = null;
            if (this.publisherBuilder_ != null) {
                this.publisherBuilder_.dispose();
                this.publisherBuilder_ = null;
            }
            this.requestAccess_ = "";
            this.restrictedExportConfig_ = null;
            if (this.restrictedExportConfigBuilder_ != null) {
                this.restrictedExportConfigBuilder_.dispose();
                this.restrictedExportConfigBuilder_ = null;
            }
            this.discoveryType_ = 0;
            this.resourceType_ = 0;
            this.commercialInfo_ = null;
            if (this.commercialInfoBuilder_ != null) {
                this.commercialInfoBuilder_.dispose();
                this.commercialInfoBuilder_ = null;
            }
            this.logLinkedDatasetQueryUserEmail_ = false;
            this.allowOnlyMetadataSharing_ = false;
            this.sourceCase_ = 0;
            this.source_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_descriptor;
        }

        public Listing getDefaultInstanceForType() {
            return Listing.getDefaultInstance();
        }

        public Listing build() {
            Listing result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Listing buildPartial() {
            Listing result = new Listing(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Listing result) {
            if ((this.bitField0_ & 0x400) != 0) {
                this.categories_ = Collections.unmodifiableList(this.categories_);
                this.bitField0_ &= 0xFFFFFBFF;
            }
            result.categories_ = this.categories_;
        }

        private void buildPartial0(Listing result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 4) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.primaryContact_ = this.primaryContact_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.documentation_ = this.documentation_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.icon_ = this.icon_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x200) != 0) {
                result.dataProvider_ = this.dataProviderBuilder_ == null ? this.dataProvider_ : (DataProvider)this.dataProviderBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.publisher_ = this.publisherBuilder_ == null ? this.publisher_ : (Publisher)this.publisherBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.requestAccess_ = this.requestAccess_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.restrictedExportConfig_ = this.restrictedExportConfigBuilder_ == null ? this.restrictedExportConfig_ : (RestrictedExportConfig)this.restrictedExportConfigBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.discoveryType_ = this.discoveryType_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.resourceType_ = this.resourceType_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.commercialInfo_ = this.commercialInfoBuilder_ == null ? this.commercialInfo_ : (CommercialInfo)this.commercialInfoBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.logLinkedDatasetQueryUserEmail_ = this.logLinkedDatasetQueryUserEmail_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.allowOnlyMetadataSharing_ = this.allowOnlyMetadataSharing_;
                to_bitField0_ |= 0x40;
            }
            Listing listing = result;
            listing.bitField0_ = listing.bitField0_ | to_bitField0_;
        }

        private void buildPartialOneofs(Listing result) {
            result.sourceCase_ = this.sourceCase_;
            result.source_ = this.source_;
            if (this.sourceCase_ == 6 && this.bigqueryDatasetBuilder_ != null) {
                result.source_ = this.bigqueryDatasetBuilder_.build();
            }
            if (this.sourceCase_ == 16 && this.pubsubTopicBuilder_ != null) {
                result.source_ = this.pubsubTopicBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Listing) {
                return this.mergeFrom((Listing)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Listing other) {
            if (other == Listing.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (!other.getPrimaryContact().isEmpty()) {
                this.primaryContact_ = other.primaryContact_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (!other.getDocumentation().isEmpty()) {
                this.documentation_ = other.documentation_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (other.getIcon() != ByteString.EMPTY) {
                this.setIcon(other.getIcon());
            }
            if (other.hasDataProvider()) {
                this.mergeDataProvider(other.getDataProvider());
            }
            if (!other.categories_.isEmpty()) {
                if (this.categories_.isEmpty()) {
                    this.categories_ = other.categories_;
                    this.bitField0_ &= 0xFFFFFBFF;
                } else {
                    this.ensureCategoriesIsMutable();
                    this.categories_.addAll(other.categories_);
                }
                this.onChanged();
            }
            if (other.hasPublisher()) {
                this.mergePublisher(other.getPublisher());
            }
            if (!other.getRequestAccess().isEmpty()) {
                this.requestAccess_ = other.requestAccess_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            if (other.hasRestrictedExportConfig()) {
                this.mergeRestrictedExportConfig(other.getRestrictedExportConfig());
            }
            if (other.hasDiscoveryType()) {
                this.setDiscoveryType(other.getDiscoveryType());
            }
            if (other.resourceType_ != 0) {
                this.setResourceTypeValue(other.getResourceTypeValue());
            }
            if (other.hasCommercialInfo()) {
                this.mergeCommercialInfo(other.getCommercialInfo());
            }
            if (other.hasLogLinkedDatasetQueryUserEmail()) {
                this.setLogLinkedDatasetQueryUserEmail(other.getLogLinkedDatasetQueryUserEmail());
            }
            if (other.hasAllowOnlyMetadataSharing()) {
                this.setAllowOnlyMetadataSharing(other.getAllowOnlyMetadataSharing());
            }
            switch (other.getSourceCase()) {
                case BIGQUERY_DATASET: {
                    this.mergeBigqueryDataset(other.getBigqueryDataset());
                    break;
                }
                case PUBSUB_TOPIC: {
                    this.mergePubsubTopic(other.getPubsubTopic());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block28: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block28;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block28;
                        }
                        case 18: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block28;
                        }
                        case 26: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block28;
                        }
                        case 34: {
                            this.primaryContact_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block28;
                        }
                        case 42: {
                            this.documentation_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block28;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getBigqueryDatasetFieldBuilder().getBuilder(), extensionRegistry);
                            this.sourceCase_ = 6;
                            continue block28;
                        }
                        case 56: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block28;
                        }
                        case 66: {
                            this.icon_ = input.readBytes();
                            this.bitField0_ |= 0x100;
                            continue block28;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getDataProviderFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block28;
                        }
                        case 80: {
                            int tmpRaw = input.readEnum();
                            this.ensureCategoriesIsMutable();
                            this.categories_.add(tmpRaw);
                            continue block28;
                        }
                        case 82: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureCategoriesIsMutable();
                                this.categories_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block28;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getPublisherFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block28;
                        }
                        case 98: {
                            this.requestAccess_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block28;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getRestrictedExportConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block28;
                        }
                        case 112: {
                            this.discoveryType_ = input.readEnum();
                            this.bitField0_ |= 0x4000;
                            continue block28;
                        }
                        case 120: {
                            this.resourceType_ = input.readEnum();
                            this.bitField0_ |= 0x8000;
                            continue block28;
                        }
                        case 130: {
                            input.readMessage((MessageLite.Builder)this.getPubsubTopicFieldBuilder().getBuilder(), extensionRegistry);
                            this.sourceCase_ = 16;
                            continue block28;
                        }
                        case 138: {
                            input.readMessage((MessageLite.Builder)this.getCommercialInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block28;
                        }
                        case 144: {
                            this.logLinkedDatasetQueryUserEmail_ = input.readBool();
                            this.bitField0_ |= 0x20000;
                            continue block28;
                        }
                        case 152: {
                            this.allowOnlyMetadataSharing_ = input.readBool();
                            this.bitField0_ |= 0x40000;
                            continue block28;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public SourceCase getSourceCase() {
            return SourceCase.forNumber(this.sourceCase_);
        }

        public Builder clearSource() {
            this.sourceCase_ = 0;
            this.source_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBigqueryDataset() {
            return this.sourceCase_ == 6;
        }

        @Override
        public BigQueryDatasetSource getBigqueryDataset() {
            if (this.bigqueryDatasetBuilder_ == null) {
                if (this.sourceCase_ == 6) {
                    return (BigQueryDatasetSource)this.source_;
                }
                return BigQueryDatasetSource.getDefaultInstance();
            }
            if (this.sourceCase_ == 6) {
                return (BigQueryDatasetSource)this.bigqueryDatasetBuilder_.getMessage();
            }
            return BigQueryDatasetSource.getDefaultInstance();
        }

        public Builder setBigqueryDataset(BigQueryDatasetSource value) {
            if (this.bigqueryDatasetBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.source_ = value;
                this.onChanged();
            } else {
                this.bigqueryDatasetBuilder_.setMessage((AbstractMessage)value);
            }
            this.sourceCase_ = 6;
            return this;
        }

        public Builder setBigqueryDataset(BigQueryDatasetSource.Builder builderForValue) {
            if (this.bigqueryDatasetBuilder_ == null) {
                this.source_ = builderForValue.build();
                this.onChanged();
            } else {
                this.bigqueryDatasetBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.sourceCase_ = 6;
            return this;
        }

        public Builder mergeBigqueryDataset(BigQueryDatasetSource value) {
            if (this.bigqueryDatasetBuilder_ == null) {
                this.source_ = this.sourceCase_ == 6 && this.source_ != BigQueryDatasetSource.getDefaultInstance() ? BigQueryDatasetSource.newBuilder((BigQueryDatasetSource)this.source_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.sourceCase_ == 6) {
                this.bigqueryDatasetBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.bigqueryDatasetBuilder_.setMessage((AbstractMessage)value);
            }
            this.sourceCase_ = 6;
            return this;
        }

        public Builder clearBigqueryDataset() {
            if (this.bigqueryDatasetBuilder_ == null) {
                if (this.sourceCase_ == 6) {
                    this.sourceCase_ = 0;
                    this.source_ = null;
                    this.onChanged();
                }
            } else {
                if (this.sourceCase_ == 6) {
                    this.sourceCase_ = 0;
                    this.source_ = null;
                }
                this.bigqueryDatasetBuilder_.clear();
            }
            return this;
        }

        public BigQueryDatasetSource.Builder getBigqueryDatasetBuilder() {
            return (BigQueryDatasetSource.Builder)this.getBigqueryDatasetFieldBuilder().getBuilder();
        }

        @Override
        public BigQueryDatasetSourceOrBuilder getBigqueryDatasetOrBuilder() {
            if (this.sourceCase_ == 6 && this.bigqueryDatasetBuilder_ != null) {
                return (BigQueryDatasetSourceOrBuilder)this.bigqueryDatasetBuilder_.getMessageOrBuilder();
            }
            if (this.sourceCase_ == 6) {
                return (BigQueryDatasetSource)this.source_;
            }
            return BigQueryDatasetSource.getDefaultInstance();
        }

        private SingleFieldBuilderV3<BigQueryDatasetSource, BigQueryDatasetSource.Builder, BigQueryDatasetSourceOrBuilder> getBigqueryDatasetFieldBuilder() {
            if (this.bigqueryDatasetBuilder_ == null) {
                if (this.sourceCase_ != 6) {
                    this.source_ = BigQueryDatasetSource.getDefaultInstance();
                }
                this.bigqueryDatasetBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((BigQueryDatasetSource)this.source_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.source_ = null;
            }
            this.sourceCase_ = 6;
            this.onChanged();
            return this.bigqueryDatasetBuilder_;
        }

        @Override
        public boolean hasPubsubTopic() {
            return this.sourceCase_ == 16;
        }

        @Override
        public PubSubTopicSource getPubsubTopic() {
            if (this.pubsubTopicBuilder_ == null) {
                if (this.sourceCase_ == 16) {
                    return (PubSubTopicSource)this.source_;
                }
                return PubSubTopicSource.getDefaultInstance();
            }
            if (this.sourceCase_ == 16) {
                return (PubSubTopicSource)this.pubsubTopicBuilder_.getMessage();
            }
            return PubSubTopicSource.getDefaultInstance();
        }

        public Builder setPubsubTopic(PubSubTopicSource value) {
            if (this.pubsubTopicBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.source_ = value;
                this.onChanged();
            } else {
                this.pubsubTopicBuilder_.setMessage((AbstractMessage)value);
            }
            this.sourceCase_ = 16;
            return this;
        }

        public Builder setPubsubTopic(PubSubTopicSource.Builder builderForValue) {
            if (this.pubsubTopicBuilder_ == null) {
                this.source_ = builderForValue.build();
                this.onChanged();
            } else {
                this.pubsubTopicBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.sourceCase_ = 16;
            return this;
        }

        public Builder mergePubsubTopic(PubSubTopicSource value) {
            if (this.pubsubTopicBuilder_ == null) {
                this.source_ = this.sourceCase_ == 16 && this.source_ != PubSubTopicSource.getDefaultInstance() ? PubSubTopicSource.newBuilder((PubSubTopicSource)this.source_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.sourceCase_ == 16) {
                this.pubsubTopicBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.pubsubTopicBuilder_.setMessage((AbstractMessage)value);
            }
            this.sourceCase_ = 16;
            return this;
        }

        public Builder clearPubsubTopic() {
            if (this.pubsubTopicBuilder_ == null) {
                if (this.sourceCase_ == 16) {
                    this.sourceCase_ = 0;
                    this.source_ = null;
                    this.onChanged();
                }
            } else {
                if (this.sourceCase_ == 16) {
                    this.sourceCase_ = 0;
                    this.source_ = null;
                }
                this.pubsubTopicBuilder_.clear();
            }
            return this;
        }

        public PubSubTopicSource.Builder getPubsubTopicBuilder() {
            return (PubSubTopicSource.Builder)this.getPubsubTopicFieldBuilder().getBuilder();
        }

        @Override
        public PubSubTopicSourceOrBuilder getPubsubTopicOrBuilder() {
            if (this.sourceCase_ == 16 && this.pubsubTopicBuilder_ != null) {
                return (PubSubTopicSourceOrBuilder)this.pubsubTopicBuilder_.getMessageOrBuilder();
            }
            if (this.sourceCase_ == 16) {
                return (PubSubTopicSource)this.source_;
            }
            return PubSubTopicSource.getDefaultInstance();
        }

        private SingleFieldBuilderV3<PubSubTopicSource, PubSubTopicSource.Builder, PubSubTopicSourceOrBuilder> getPubsubTopicFieldBuilder() {
            if (this.pubsubTopicBuilder_ == null) {
                if (this.sourceCase_ != 16) {
                    this.source_ = PubSubTopicSource.getDefaultInstance();
                }
                this.pubsubTopicBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((PubSubTopicSource)this.source_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.source_ = null;
            }
            this.sourceCase_ = 16;
            this.onChanged();
            return this.pubsubTopicBuilder_;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Listing.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Listing.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = Listing.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Listing.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Listing.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Listing.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public String getPrimaryContact() {
            Object ref = this.primaryContact_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.primaryContact_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPrimaryContactBytes() {
            Object ref = this.primaryContact_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.primaryContact_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPrimaryContact(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.primaryContact_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryContact() {
            this.primaryContact_ = Listing.getDefaultInstance().getPrimaryContact();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setPrimaryContactBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Listing.checkByteStringIsUtf8((ByteString)value);
            this.primaryContact_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public String getDocumentation() {
            Object ref = this.documentation_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.documentation_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDocumentationBytes() {
            Object ref = this.documentation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.documentation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDocumentation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.documentation_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearDocumentation() {
            this.documentation_ = Listing.getDefaultInstance().getDocumentation();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setDocumentationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Listing.checkByteStringIsUtf8((ByteString)value);
            this.documentation_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getIcon() {
            return this.icon_;
        }

        public Builder setIcon(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.icon_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearIcon() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.icon_ = Listing.getDefaultInstance().getIcon();
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDataProvider() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public DataProvider getDataProvider() {
            if (this.dataProviderBuilder_ == null) {
                return this.dataProvider_ == null ? DataProvider.getDefaultInstance() : this.dataProvider_;
            }
            return (DataProvider)this.dataProviderBuilder_.getMessage();
        }

        public Builder setDataProvider(DataProvider value) {
            if (this.dataProviderBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.dataProvider_ = value;
            } else {
                this.dataProviderBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setDataProvider(DataProvider.Builder builderForValue) {
            if (this.dataProviderBuilder_ == null) {
                this.dataProvider_ = builderForValue.build();
            } else {
                this.dataProviderBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeDataProvider(DataProvider value) {
            if (this.dataProviderBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.dataProvider_ != null && this.dataProvider_ != DataProvider.getDefaultInstance()) {
                    this.getDataProviderBuilder().mergeFrom(value);
                } else {
                    this.dataProvider_ = value;
                }
            } else {
                this.dataProviderBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.dataProvider_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDataProvider() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.dataProvider_ = null;
            if (this.dataProviderBuilder_ != null) {
                this.dataProviderBuilder_.dispose();
                this.dataProviderBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DataProvider.Builder getDataProviderBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (DataProvider.Builder)this.getDataProviderFieldBuilder().getBuilder();
        }

        @Override
        public DataProviderOrBuilder getDataProviderOrBuilder() {
            if (this.dataProviderBuilder_ != null) {
                return (DataProviderOrBuilder)this.dataProviderBuilder_.getMessageOrBuilder();
            }
            return this.dataProvider_ == null ? DataProvider.getDefaultInstance() : this.dataProvider_;
        }

        private SingleFieldBuilderV3<DataProvider, DataProvider.Builder, DataProviderOrBuilder> getDataProviderFieldBuilder() {
            if (this.dataProviderBuilder_ == null) {
                this.dataProviderBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDataProvider(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dataProvider_ = null;
            }
            return this.dataProviderBuilder_;
        }

        private void ensureCategoriesIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.categories_ = new ArrayList<Integer>(this.categories_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<Category> getCategoriesList() {
            return new Internal.ListAdapter(this.categories_, categories_converter_);
        }

        @Override
        public int getCategoriesCount() {
            return this.categories_.size();
        }

        @Override
        public Category getCategories(int index) {
            return (Category)((Object)categories_converter_.convert((Object)this.categories_.get(index)));
        }

        public Builder setCategories(int index, Category value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCategoriesIsMutable();
            this.categories_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addCategories(Category value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCategoriesIsMutable();
            this.categories_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllCategories(Iterable<? extends Category> values) {
            this.ensureCategoriesIsMutable();
            for (Category category : values) {
                this.categories_.add(category.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearCategories() {
            this.categories_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getCategoriesValueList() {
            return Collections.unmodifiableList(this.categories_);
        }

        @Override
        public int getCategoriesValue(int index) {
            return this.categories_.get(index);
        }

        public Builder setCategoriesValue(int index, int value) {
            this.ensureCategoriesIsMutable();
            this.categories_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addCategoriesValue(int value) {
            this.ensureCategoriesIsMutable();
            this.categories_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllCategoriesValue(Iterable<Integer> values) {
            this.ensureCategoriesIsMutable();
            for (int value : values) {
                this.categories_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPublisher() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public Publisher getPublisher() {
            if (this.publisherBuilder_ == null) {
                return this.publisher_ == null ? Publisher.getDefaultInstance() : this.publisher_;
            }
            return (Publisher)this.publisherBuilder_.getMessage();
        }

        public Builder setPublisher(Publisher value) {
            if (this.publisherBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.publisher_ = value;
            } else {
                this.publisherBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setPublisher(Publisher.Builder builderForValue) {
            if (this.publisherBuilder_ == null) {
                this.publisher_ = builderForValue.build();
            } else {
                this.publisherBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergePublisher(Publisher value) {
            if (this.publisherBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.publisher_ != null && this.publisher_ != Publisher.getDefaultInstance()) {
                    this.getPublisherBuilder().mergeFrom(value);
                } else {
                    this.publisher_ = value;
                }
            } else {
                this.publisherBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.publisher_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPublisher() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.publisher_ = null;
            if (this.publisherBuilder_ != null) {
                this.publisherBuilder_.dispose();
                this.publisherBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Publisher.Builder getPublisherBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (Publisher.Builder)this.getPublisherFieldBuilder().getBuilder();
        }

        @Override
        public PublisherOrBuilder getPublisherOrBuilder() {
            if (this.publisherBuilder_ != null) {
                return (PublisherOrBuilder)this.publisherBuilder_.getMessageOrBuilder();
            }
            return this.publisher_ == null ? Publisher.getDefaultInstance() : this.publisher_;
        }

        private SingleFieldBuilderV3<Publisher, Publisher.Builder, PublisherOrBuilder> getPublisherFieldBuilder() {
            if (this.publisherBuilder_ == null) {
                this.publisherBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPublisher(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.publisher_ = null;
            }
            return this.publisherBuilder_;
        }

        @Override
        public String getRequestAccess() {
            Object ref = this.requestAccess_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.requestAccess_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRequestAccessBytes() {
            Object ref = this.requestAccess_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.requestAccess_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRequestAccess(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.requestAccess_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearRequestAccess() {
            this.requestAccess_ = Listing.getDefaultInstance().getRequestAccess();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setRequestAccessBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Listing.checkByteStringIsUtf8((ByteString)value);
            this.requestAccess_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRestrictedExportConfig() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public RestrictedExportConfig getRestrictedExportConfig() {
            if (this.restrictedExportConfigBuilder_ == null) {
                return this.restrictedExportConfig_ == null ? RestrictedExportConfig.getDefaultInstance() : this.restrictedExportConfig_;
            }
            return (RestrictedExportConfig)this.restrictedExportConfigBuilder_.getMessage();
        }

        public Builder setRestrictedExportConfig(RestrictedExportConfig value) {
            if (this.restrictedExportConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.restrictedExportConfig_ = value;
            } else {
                this.restrictedExportConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setRestrictedExportConfig(RestrictedExportConfig.Builder builderForValue) {
            if (this.restrictedExportConfigBuilder_ == null) {
                this.restrictedExportConfig_ = builderForValue.build();
            } else {
                this.restrictedExportConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeRestrictedExportConfig(RestrictedExportConfig value) {
            if (this.restrictedExportConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.restrictedExportConfig_ != null && this.restrictedExportConfig_ != RestrictedExportConfig.getDefaultInstance()) {
                    this.getRestrictedExportConfigBuilder().mergeFrom(value);
                } else {
                    this.restrictedExportConfig_ = value;
                }
            } else {
                this.restrictedExportConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.restrictedExportConfig_ != null) {
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRestrictedExportConfig() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.restrictedExportConfig_ = null;
            if (this.restrictedExportConfigBuilder_ != null) {
                this.restrictedExportConfigBuilder_.dispose();
                this.restrictedExportConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RestrictedExportConfig.Builder getRestrictedExportConfigBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (RestrictedExportConfig.Builder)this.getRestrictedExportConfigFieldBuilder().getBuilder();
        }

        @Override
        public RestrictedExportConfigOrBuilder getRestrictedExportConfigOrBuilder() {
            if (this.restrictedExportConfigBuilder_ != null) {
                return (RestrictedExportConfigOrBuilder)this.restrictedExportConfigBuilder_.getMessageOrBuilder();
            }
            return this.restrictedExportConfig_ == null ? RestrictedExportConfig.getDefaultInstance() : this.restrictedExportConfig_;
        }

        private SingleFieldBuilderV3<RestrictedExportConfig, RestrictedExportConfig.Builder, RestrictedExportConfigOrBuilder> getRestrictedExportConfigFieldBuilder() {
            if (this.restrictedExportConfigBuilder_ == null) {
                this.restrictedExportConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRestrictedExportConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.restrictedExportConfig_ = null;
            }
            return this.restrictedExportConfigBuilder_;
        }

        @Override
        public boolean hasDiscoveryType() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public int getDiscoveryTypeValue() {
            return this.discoveryType_;
        }

        public Builder setDiscoveryTypeValue(int value) {
            this.discoveryType_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        @Override
        public DiscoveryType getDiscoveryType() {
            DiscoveryType result = DiscoveryType.forNumber(this.discoveryType_);
            return result == null ? DiscoveryType.UNRECOGNIZED : result;
        }

        public Builder setDiscoveryType(DiscoveryType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x4000;
            this.discoveryType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDiscoveryType() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.discoveryType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getResourceTypeValue() {
            return this.resourceType_;
        }

        public Builder setResourceTypeValue(int value) {
            this.resourceType_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public SharedResourceType getResourceType() {
            SharedResourceType result = SharedResourceType.forNumber(this.resourceType_);
            return result == null ? SharedResourceType.UNRECOGNIZED : result;
        }

        public Builder setResourceType(SharedResourceType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x8000;
            this.resourceType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearResourceType() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.resourceType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCommercialInfo() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public CommercialInfo getCommercialInfo() {
            if (this.commercialInfoBuilder_ == null) {
                return this.commercialInfo_ == null ? CommercialInfo.getDefaultInstance() : this.commercialInfo_;
            }
            return (CommercialInfo)this.commercialInfoBuilder_.getMessage();
        }

        public Builder setCommercialInfo(CommercialInfo value) {
            if (this.commercialInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.commercialInfo_ = value;
            } else {
                this.commercialInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setCommercialInfo(CommercialInfo.Builder builderForValue) {
            if (this.commercialInfoBuilder_ == null) {
                this.commercialInfo_ = builderForValue.build();
            } else {
                this.commercialInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeCommercialInfo(CommercialInfo value) {
            if (this.commercialInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.commercialInfo_ != null && this.commercialInfo_ != CommercialInfo.getDefaultInstance()) {
                    this.getCommercialInfoBuilder().mergeFrom(value);
                } else {
                    this.commercialInfo_ = value;
                }
            } else {
                this.commercialInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.commercialInfo_ != null) {
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCommercialInfo() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.commercialInfo_ = null;
            if (this.commercialInfoBuilder_ != null) {
                this.commercialInfoBuilder_.dispose();
                this.commercialInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public CommercialInfo.Builder getCommercialInfoBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (CommercialInfo.Builder)this.getCommercialInfoFieldBuilder().getBuilder();
        }

        @Override
        public CommercialInfoOrBuilder getCommercialInfoOrBuilder() {
            if (this.commercialInfoBuilder_ != null) {
                return (CommercialInfoOrBuilder)this.commercialInfoBuilder_.getMessageOrBuilder();
            }
            return this.commercialInfo_ == null ? CommercialInfo.getDefaultInstance() : this.commercialInfo_;
        }

        private SingleFieldBuilderV3<CommercialInfo, CommercialInfo.Builder, CommercialInfoOrBuilder> getCommercialInfoFieldBuilder() {
            if (this.commercialInfoBuilder_ == null) {
                this.commercialInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCommercialInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.commercialInfo_ = null;
            }
            return this.commercialInfoBuilder_;
        }

        @Override
        public boolean hasLogLinkedDatasetQueryUserEmail() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public boolean getLogLinkedDatasetQueryUserEmail() {
            return this.logLinkedDatasetQueryUserEmail_;
        }

        public Builder setLogLinkedDatasetQueryUserEmail(boolean value) {
            this.logLinkedDatasetQueryUserEmail_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearLogLinkedDatasetQueryUserEmail() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.logLinkedDatasetQueryUserEmail_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAllowOnlyMetadataSharing() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public boolean getAllowOnlyMetadataSharing() {
            return this.allowOnlyMetadataSharing_;
        }

        public Builder setAllowOnlyMetadataSharing(boolean value) {
            this.allowOnlyMetadataSharing_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearAllowOnlyMetadataSharing() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.allowOnlyMetadataSharing_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SourceCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        BIGQUERY_DATASET(6),
        PUBSUB_TOPIC(16),
        SOURCE_NOT_SET(0);

        private final int value;

        private SourceCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static SourceCase valueOf(int value) {
            return SourceCase.forNumber(value);
        }

        public static SourceCase forNumber(int value) {
            switch (value) {
                case 6: {
                    return BIGQUERY_DATASET;
                }
                case 16: {
                    return PUBSUB_TOPIC;
                }
                case 0: {
                    return SOURCE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static final class CommercialInfo
    extends GeneratedMessageV3
    implements CommercialInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int CLOUD_MARKETPLACE_FIELD_NUMBER = 1;
        private GoogleCloudMarketplaceInfo cloudMarketplace_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final CommercialInfo DEFAULT_INSTANCE = new CommercialInfo();
        private static final Parser<CommercialInfo> PARSER = new AbstractParser<CommercialInfo>(){

            public CommercialInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = CommercialInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private CommercialInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private CommercialInfo() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new CommercialInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(CommercialInfo.class, Builder.class);
        }

        @Override
        public boolean hasCloudMarketplace() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public GoogleCloudMarketplaceInfo getCloudMarketplace() {
            return this.cloudMarketplace_ == null ? GoogleCloudMarketplaceInfo.getDefaultInstance() : this.cloudMarketplace_;
        }

        @Override
        public GoogleCloudMarketplaceInfoOrBuilder getCloudMarketplaceOrBuilder() {
            return this.cloudMarketplace_ == null ? GoogleCloudMarketplaceInfo.getDefaultInstance() : this.cloudMarketplace_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(1, (MessageLite)this.getCloudMarketplace());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getCloudMarketplace());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CommercialInfo)) {
                return super.equals(obj);
            }
            CommercialInfo other = (CommercialInfo)obj;
            if (this.hasCloudMarketplace() != other.hasCloudMarketplace()) {
                return false;
            }
            if (this.hasCloudMarketplace() && !this.getCloudMarketplace().equals(other.getCloudMarketplace())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + CommercialInfo.getDescriptor().hashCode();
            if (this.hasCloudMarketplace()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getCloudMarketplace().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static CommercialInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (CommercialInfo)PARSER.parseFrom(data);
        }

        public static CommercialInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CommercialInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CommercialInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (CommercialInfo)PARSER.parseFrom(data);
        }

        public static CommercialInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CommercialInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CommercialInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (CommercialInfo)PARSER.parseFrom(data);
        }

        public static CommercialInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CommercialInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CommercialInfo parseFrom(InputStream input) throws IOException {
            return (CommercialInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static CommercialInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CommercialInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static CommercialInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (CommercialInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static CommercialInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CommercialInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static CommercialInfo parseFrom(CodedInputStream input) throws IOException {
            return (CommercialInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static CommercialInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CommercialInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return CommercialInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(CommercialInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static CommercialInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<CommercialInfo> parser() {
            return PARSER;
        }

        public Parser<CommercialInfo> getParserForType() {
            return PARSER;
        }

        public CommercialInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements CommercialInfoOrBuilder {
            private int bitField0_;
            private GoogleCloudMarketplaceInfo cloudMarketplace_;
            private SingleFieldBuilderV3<GoogleCloudMarketplaceInfo, GoogleCloudMarketplaceInfo.Builder, GoogleCloudMarketplaceInfoOrBuilder> cloudMarketplaceBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(CommercialInfo.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getCloudMarketplaceFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.cloudMarketplace_ = null;
                if (this.cloudMarketplaceBuilder_ != null) {
                    this.cloudMarketplaceBuilder_.dispose();
                    this.cloudMarketplaceBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_descriptor;
            }

            public CommercialInfo getDefaultInstanceForType() {
                return CommercialInfo.getDefaultInstance();
            }

            public CommercialInfo build() {
                CommercialInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public CommercialInfo buildPartial() {
                CommercialInfo result = new CommercialInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(CommercialInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.cloudMarketplace_ = this.cloudMarketplaceBuilder_ == null ? this.cloudMarketplace_ : (GoogleCloudMarketplaceInfo)this.cloudMarketplaceBuilder_.build();
                    to_bitField0_ |= 1;
                }
                CommercialInfo commercialInfo = result;
                commercialInfo.bitField0_ = commercialInfo.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof CommercialInfo) {
                    return this.mergeFrom((CommercialInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(CommercialInfo other) {
                if (other == CommercialInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasCloudMarketplace()) {
                    this.mergeCloudMarketplace(other.getCloudMarketplace());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getCloudMarketplaceFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasCloudMarketplace() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public GoogleCloudMarketplaceInfo getCloudMarketplace() {
                if (this.cloudMarketplaceBuilder_ == null) {
                    return this.cloudMarketplace_ == null ? GoogleCloudMarketplaceInfo.getDefaultInstance() : this.cloudMarketplace_;
                }
                return (GoogleCloudMarketplaceInfo)this.cloudMarketplaceBuilder_.getMessage();
            }

            public Builder setCloudMarketplace(GoogleCloudMarketplaceInfo value) {
                if (this.cloudMarketplaceBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.cloudMarketplace_ = value;
                } else {
                    this.cloudMarketplaceBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setCloudMarketplace(GoogleCloudMarketplaceInfo.Builder builderForValue) {
                if (this.cloudMarketplaceBuilder_ == null) {
                    this.cloudMarketplace_ = builderForValue.build();
                } else {
                    this.cloudMarketplaceBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeCloudMarketplace(GoogleCloudMarketplaceInfo value) {
                if (this.cloudMarketplaceBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.cloudMarketplace_ != null && this.cloudMarketplace_ != GoogleCloudMarketplaceInfo.getDefaultInstance()) {
                        this.getCloudMarketplaceBuilder().mergeFrom(value);
                    } else {
                        this.cloudMarketplace_ = value;
                    }
                } else {
                    this.cloudMarketplaceBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.cloudMarketplace_ != null) {
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearCloudMarketplace() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.cloudMarketplace_ = null;
                if (this.cloudMarketplaceBuilder_ != null) {
                    this.cloudMarketplaceBuilder_.dispose();
                    this.cloudMarketplaceBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public GoogleCloudMarketplaceInfo.Builder getCloudMarketplaceBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return (GoogleCloudMarketplaceInfo.Builder)this.getCloudMarketplaceFieldBuilder().getBuilder();
            }

            @Override
            public GoogleCloudMarketplaceInfoOrBuilder getCloudMarketplaceOrBuilder() {
                if (this.cloudMarketplaceBuilder_ != null) {
                    return (GoogleCloudMarketplaceInfoOrBuilder)this.cloudMarketplaceBuilder_.getMessageOrBuilder();
                }
                return this.cloudMarketplace_ == null ? GoogleCloudMarketplaceInfo.getDefaultInstance() : this.cloudMarketplace_;
            }

            private SingleFieldBuilderV3<GoogleCloudMarketplaceInfo, GoogleCloudMarketplaceInfo.Builder, GoogleCloudMarketplaceInfoOrBuilder> getCloudMarketplaceFieldBuilder() {
                if (this.cloudMarketplaceBuilder_ == null) {
                    this.cloudMarketplaceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCloudMarketplace(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.cloudMarketplace_ = null;
                }
                return this.cloudMarketplaceBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class GoogleCloudMarketplaceInfo
        extends GeneratedMessageV3
        implements GoogleCloudMarketplaceInfoOrBuilder {
            private static final long serialVersionUID = 0L;
            private int bitField0_;
            public static final int SERVICE_FIELD_NUMBER = 1;
            private volatile Object service_ = "";
            public static final int COMMERCIAL_STATE_FIELD_NUMBER = 3;
            private int commercialState_ = 0;
            private byte memoizedIsInitialized = (byte)-1;
            private static final GoogleCloudMarketplaceInfo DEFAULT_INSTANCE = new GoogleCloudMarketplaceInfo();
            private static final Parser<GoogleCloudMarketplaceInfo> PARSER = new AbstractParser<GoogleCloudMarketplaceInfo>(){

                public GoogleCloudMarketplaceInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = GoogleCloudMarketplaceInfo.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private GoogleCloudMarketplaceInfo(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private GoogleCloudMarketplaceInfo() {
                this.service_ = "";
                this.commercialState_ = 0;
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new GoogleCloudMarketplaceInfo();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(GoogleCloudMarketplaceInfo.class, Builder.class);
            }

            @Override
            public boolean hasService() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getService() {
                Object ref = this.service_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.service_ = s;
                return s;
            }

            @Override
            public ByteString getServiceBytes() {
                Object ref = this.service_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.service_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public boolean hasCommercialState() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public int getCommercialStateValue() {
                return this.commercialState_;
            }

            @Override
            public CommercialState getCommercialState() {
                CommercialState result = CommercialState.forNumber(this.commercialState_);
                return result == null ? CommercialState.UNRECOGNIZED : result;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if ((this.bitField0_ & 1) != 0) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.service_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    output.writeEnum(3, this.commercialState_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if ((this.bitField0_ & 1) != 0) {
                    size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.service_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    size += CodedOutputStream.computeEnumSize((int)3, (int)this.commercialState_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof GoogleCloudMarketplaceInfo)) {
                    return super.equals(obj);
                }
                GoogleCloudMarketplaceInfo other = (GoogleCloudMarketplaceInfo)obj;
                if (this.hasService() != other.hasService()) {
                    return false;
                }
                if (this.hasService() && !this.getService().equals(other.getService())) {
                    return false;
                }
                if (this.hasCommercialState() != other.hasCommercialState()) {
                    return false;
                }
                if (this.hasCommercialState() && this.commercialState_ != other.commercialState_) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + GoogleCloudMarketplaceInfo.getDescriptor().hashCode();
                if (this.hasService()) {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getService().hashCode();
                }
                if (this.hasCommercialState()) {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + this.commercialState_;
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static GoogleCloudMarketplaceInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (GoogleCloudMarketplaceInfo)PARSER.parseFrom(data);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (GoogleCloudMarketplaceInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (GoogleCloudMarketplaceInfo)PARSER.parseFrom(data);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (GoogleCloudMarketplaceInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (GoogleCloudMarketplaceInfo)PARSER.parseFrom(data);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (GoogleCloudMarketplaceInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(InputStream input) throws IOException {
                return (GoogleCloudMarketplaceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (GoogleCloudMarketplaceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static GoogleCloudMarketplaceInfo parseDelimitedFrom(InputStream input) throws IOException {
                return (GoogleCloudMarketplaceInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static GoogleCloudMarketplaceInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (GoogleCloudMarketplaceInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(CodedInputStream input) throws IOException {
                return (GoogleCloudMarketplaceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static GoogleCloudMarketplaceInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (GoogleCloudMarketplaceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return GoogleCloudMarketplaceInfo.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(GoogleCloudMarketplaceInfo prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static GoogleCloudMarketplaceInfo getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<GoogleCloudMarketplaceInfo> parser() {
                return PARSER;
            }

            public Parser<GoogleCloudMarketplaceInfo> getParserForType() {
                return PARSER;
            }

            public GoogleCloudMarketplaceInfo getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements GoogleCloudMarketplaceInfoOrBuilder {
                private int bitField0_;
                private Object service_ = "";
                private int commercialState_ = 0;

                public static final Descriptors.Descriptor getDescriptor() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(GoogleCloudMarketplaceInfo.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.service_ = "";
                    this.commercialState_ = 0;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
                }

                public GoogleCloudMarketplaceInfo getDefaultInstanceForType() {
                    return GoogleCloudMarketplaceInfo.getDefaultInstance();
                }

                public GoogleCloudMarketplaceInfo build() {
                    GoogleCloudMarketplaceInfo result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public GoogleCloudMarketplaceInfo buildPartial() {
                    GoogleCloudMarketplaceInfo result = new GoogleCloudMarketplaceInfo(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(GoogleCloudMarketplaceInfo result) {
                    int from_bitField0_ = this.bitField0_;
                    int to_bitField0_ = 0;
                    if ((from_bitField0_ & 1) != 0) {
                        result.service_ = this.service_;
                        to_bitField0_ |= 1;
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.commercialState_ = this.commercialState_;
                        to_bitField0_ |= 2;
                    }
                    GoogleCloudMarketplaceInfo googleCloudMarketplaceInfo = result;
                    googleCloudMarketplaceInfo.bitField0_ = googleCloudMarketplaceInfo.bitField0_ | to_bitField0_;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof GoogleCloudMarketplaceInfo) {
                        return this.mergeFrom((GoogleCloudMarketplaceInfo)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(GoogleCloudMarketplaceInfo other) {
                    if (other == GoogleCloudMarketplaceInfo.getDefaultInstance()) {
                        return this;
                    }
                    if (other.hasService()) {
                        this.service_ = other.service_;
                        this.bitField0_ |= 1;
                        this.onChanged();
                    }
                    if (other.hasCommercialState()) {
                        this.setCommercialState(other.getCommercialState());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 10: {
                                    this.service_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 1;
                                    continue block10;
                                }
                                case 24: {
                                    this.commercialState_ = input.readEnum();
                                    this.bitField0_ |= 2;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasService() {
                    return (this.bitField0_ & 1) != 0;
                }

                @Override
                public String getService() {
                    Object ref = this.service_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        this.service_ = s;
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getServiceBytes() {
                    Object ref = this.service_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        this.service_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setService(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.service_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearService() {
                    this.service_ = GoogleCloudMarketplaceInfo.getDefaultInstance().getService();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                    return this;
                }

                public Builder setServiceBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    GoogleCloudMarketplaceInfo.checkByteStringIsUtf8((ByteString)value);
                    this.service_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasCommercialState() {
                    return (this.bitField0_ & 2) != 0;
                }

                @Override
                public int getCommercialStateValue() {
                    return this.commercialState_;
                }

                public Builder setCommercialStateValue(int value) {
                    this.commercialState_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                @Override
                public CommercialState getCommercialState() {
                    CommercialState result = CommercialState.forNumber(this.commercialState_);
                    return result == null ? CommercialState.UNRECOGNIZED : result;
                }

                public Builder setCommercialState(CommercialState value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 2;
                    this.commercialState_ = value.getNumber();
                    this.onChanged();
                    return this;
                }

                public Builder clearCommercialState() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.commercialState_ = 0;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static enum CommercialState implements ProtocolMessageEnum
            {
                COMMERCIAL_STATE_UNSPECIFIED(0),
                ONBOARDING(1),
                ACTIVE(2),
                UNRECOGNIZED(-1);

                public static final int COMMERCIAL_STATE_UNSPECIFIED_VALUE = 0;
                public static final int ONBOARDING_VALUE = 1;
                public static final int ACTIVE_VALUE = 2;
                private static final Internal.EnumLiteMap<CommercialState> internalValueMap;
                private static final CommercialState[] VALUES;
                private final int value;

                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                    }
                    return this.value;
                }

                @Deprecated
                public static CommercialState valueOf(int value) {
                    return CommercialState.forNumber(value);
                }

                public static CommercialState forNumber(int value) {
                    switch (value) {
                        case 0: {
                            return COMMERCIAL_STATE_UNSPECIFIED;
                        }
                        case 1: {
                            return ONBOARDING;
                        }
                        case 2: {
                            return ACTIVE;
                        }
                    }
                    return null;
                }

                public static Internal.EnumLiteMap<CommercialState> internalGetValueMap() {
                    return internalValueMap;
                }

                public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                    }
                    return (Descriptors.EnumValueDescriptor)CommercialState.getDescriptor().getValues().get(this.ordinal());
                }

                public final Descriptors.EnumDescriptor getDescriptorForType() {
                    return CommercialState.getDescriptor();
                }

                public static final Descriptors.EnumDescriptor getDescriptor() {
                    return (Descriptors.EnumDescriptor)GoogleCloudMarketplaceInfo.getDescriptor().getEnumTypes().get(0);
                }

                public static CommercialState valueOf(Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != CommercialState.getDescriptor()) {
                        throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private CommercialState(int value) {
                    this.value = value;
                }

                static {
                    internalValueMap = new Internal.EnumLiteMap<CommercialState>(){

                        public CommercialState findValueByNumber(int number) {
                            return CommercialState.forNumber(number);
                        }
                    };
                    VALUES = CommercialState.values();
                }
            }
        }

        public static interface GoogleCloudMarketplaceInfoOrBuilder
        extends MessageOrBuilder {
            public boolean hasService();

            public String getService();

            public ByteString getServiceBytes();

            public boolean hasCommercialState();

            public int getCommercialStateValue();

            public GoogleCloudMarketplaceInfo.CommercialState getCommercialState();
        }
    }

    public static interface CommercialInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasCloudMarketplace();

        public CommercialInfo.GoogleCloudMarketplaceInfo getCloudMarketplace();

        public CommercialInfo.GoogleCloudMarketplaceInfoOrBuilder getCloudMarketplaceOrBuilder();
    }

    public static final class RestrictedExportConfig
    extends GeneratedMessageV3
    implements RestrictedExportConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int ENABLED_FIELD_NUMBER = 3;
        private boolean enabled_ = false;
        public static final int RESTRICT_DIRECT_TABLE_ACCESS_FIELD_NUMBER = 1;
        private boolean restrictDirectTableAccess_ = false;
        public static final int RESTRICT_QUERY_RESULT_FIELD_NUMBER = 2;
        private boolean restrictQueryResult_ = false;
        private byte memoizedIsInitialized = (byte)-1;
        private static final RestrictedExportConfig DEFAULT_INSTANCE = new RestrictedExportConfig();
        private static final Parser<RestrictedExportConfig> PARSER = new AbstractParser<RestrictedExportConfig>(){

            public RestrictedExportConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = RestrictedExportConfig.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private RestrictedExportConfig(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private RestrictedExportConfig() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new RestrictedExportConfig();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(RestrictedExportConfig.class, Builder.class);
        }

        @Override
        public boolean getEnabled() {
            return this.enabled_;
        }

        @Override
        public boolean getRestrictDirectTableAccess() {
            return this.restrictDirectTableAccess_;
        }

        @Override
        public boolean getRestrictQueryResult() {
            return this.restrictQueryResult_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.restrictDirectTableAccess_) {
                output.writeBool(1, this.restrictDirectTableAccess_);
            }
            if (this.restrictQueryResult_) {
                output.writeBool(2, this.restrictQueryResult_);
            }
            if (this.enabled_) {
                output.writeBool(3, this.enabled_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.restrictDirectTableAccess_) {
                size += CodedOutputStream.computeBoolSize((int)1, (boolean)this.restrictDirectTableAccess_);
            }
            if (this.restrictQueryResult_) {
                size += CodedOutputStream.computeBoolSize((int)2, (boolean)this.restrictQueryResult_);
            }
            if (this.enabled_) {
                size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.enabled_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RestrictedExportConfig)) {
                return super.equals(obj);
            }
            RestrictedExportConfig other = (RestrictedExportConfig)obj;
            if (this.getEnabled() != other.getEnabled()) {
                return false;
            }
            if (this.getRestrictDirectTableAccess() != other.getRestrictDirectTableAccess()) {
                return false;
            }
            if (this.getRestrictQueryResult() != other.getRestrictQueryResult()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + RestrictedExportConfig.getDescriptor().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getEnabled());
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getRestrictDirectTableAccess());
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getRestrictQueryResult());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static RestrictedExportConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (RestrictedExportConfig)PARSER.parseFrom(data);
        }

        public static RestrictedExportConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (RestrictedExportConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static RestrictedExportConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (RestrictedExportConfig)PARSER.parseFrom(data);
        }

        public static RestrictedExportConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (RestrictedExportConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static RestrictedExportConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (RestrictedExportConfig)PARSER.parseFrom(data);
        }

        public static RestrictedExportConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (RestrictedExportConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static RestrictedExportConfig parseFrom(InputStream input) throws IOException {
            return (RestrictedExportConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static RestrictedExportConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (RestrictedExportConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static RestrictedExportConfig parseDelimitedFrom(InputStream input) throws IOException {
            return (RestrictedExportConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static RestrictedExportConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (RestrictedExportConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static RestrictedExportConfig parseFrom(CodedInputStream input) throws IOException {
            return (RestrictedExportConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static RestrictedExportConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (RestrictedExportConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return RestrictedExportConfig.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(RestrictedExportConfig prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static RestrictedExportConfig getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<RestrictedExportConfig> parser() {
            return PARSER;
        }

        public Parser<RestrictedExportConfig> getParserForType() {
            return PARSER;
        }

        public RestrictedExportConfig getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements RestrictedExportConfigOrBuilder {
            private int bitField0_;
            private boolean enabled_;
            private boolean restrictDirectTableAccess_;
            private boolean restrictQueryResult_;

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(RestrictedExportConfig.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.enabled_ = false;
                this.restrictDirectTableAccess_ = false;
                this.restrictQueryResult_ = false;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_descriptor;
            }

            public RestrictedExportConfig getDefaultInstanceForType() {
                return RestrictedExportConfig.getDefaultInstance();
            }

            public RestrictedExportConfig build() {
                RestrictedExportConfig result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public RestrictedExportConfig buildPartial() {
                RestrictedExportConfig result = new RestrictedExportConfig(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(RestrictedExportConfig result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.enabled_ = this.enabled_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.restrictDirectTableAccess_ = this.restrictDirectTableAccess_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.restrictQueryResult_ = this.restrictQueryResult_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof RestrictedExportConfig) {
                    return this.mergeFrom((RestrictedExportConfig)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(RestrictedExportConfig other) {
                if (other == RestrictedExportConfig.getDefaultInstance()) {
                    return this;
                }
                if (other.getEnabled()) {
                    this.setEnabled(other.getEnabled());
                }
                if (other.getRestrictDirectTableAccess()) {
                    this.setRestrictDirectTableAccess(other.getRestrictDirectTableAccess());
                }
                if (other.getRestrictQueryResult()) {
                    this.setRestrictQueryResult(other.getRestrictQueryResult());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 8: {
                                this.restrictDirectTableAccess_ = input.readBool();
                                this.bitField0_ |= 2;
                                continue block11;
                            }
                            case 16: {
                                this.restrictQueryResult_ = input.readBool();
                                this.bitField0_ |= 4;
                                continue block11;
                            }
                            case 24: {
                                this.enabled_ = input.readBool();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean getEnabled() {
                return this.enabled_;
            }

            public Builder setEnabled(boolean value) {
                this.enabled_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearEnabled() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.enabled_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getRestrictDirectTableAccess() {
                return this.restrictDirectTableAccess_;
            }

            public Builder setRestrictDirectTableAccess(boolean value) {
                this.restrictDirectTableAccess_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearRestrictDirectTableAccess() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.restrictDirectTableAccess_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getRestrictQueryResult() {
                return this.restrictQueryResult_;
            }

            public Builder setRestrictQueryResult(boolean value) {
                this.restrictQueryResult_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearRestrictQueryResult() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.restrictQueryResult_ = false;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface RestrictedExportConfigOrBuilder
    extends MessageOrBuilder {
        public boolean getEnabled();

        public boolean getRestrictDirectTableAccess();

        public boolean getRestrictQueryResult();
    }

    public static final class PubSubTopicSource
    extends GeneratedMessageV3
    implements PubSubTopicSourceOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TOPIC_FIELD_NUMBER = 1;
        private volatile Object topic_ = "";
        public static final int DATA_AFFINITY_REGIONS_FIELD_NUMBER = 2;
        private LazyStringArrayList dataAffinityRegions_ = LazyStringArrayList.emptyList();
        private byte memoizedIsInitialized = (byte)-1;
        private static final PubSubTopicSource DEFAULT_INSTANCE = new PubSubTopicSource();
        private static final Parser<PubSubTopicSource> PARSER = new AbstractParser<PubSubTopicSource>(){

            public PubSubTopicSource parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = PubSubTopicSource.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private PubSubTopicSource(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private PubSubTopicSource() {
            this.topic_ = "";
            this.dataAffinityRegions_ = LazyStringArrayList.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new PubSubTopicSource();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_fieldAccessorTable.ensureFieldAccessorsInitialized(PubSubTopicSource.class, Builder.class);
        }

        @Override
        public String getTopic() {
            Object ref = this.topic_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.topic_ = s;
            return s;
        }

        @Override
        public ByteString getTopicBytes() {
            Object ref = this.topic_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.topic_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public ProtocolStringList getDataAffinityRegionsList() {
            return this.dataAffinityRegions_;
        }

        @Override
        public int getDataAffinityRegionsCount() {
            return this.dataAffinityRegions_.size();
        }

        @Override
        public String getDataAffinityRegions(int index) {
            return this.dataAffinityRegions_.get(index);
        }

        @Override
        public ByteString getDataAffinityRegionsBytes(int index) {
            return this.dataAffinityRegions_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.topic_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.topic_);
            }
            for (int i = 0; i < this.dataAffinityRegions_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.dataAffinityRegions_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.topic_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.topic_);
            }
            int dataSize = 0;
            for (int i = 0; i < this.dataAffinityRegions_.size(); ++i) {
                dataSize += PubSubTopicSource.computeStringSizeNoTag((Object)this.dataAffinityRegions_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getDataAffinityRegionsList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PubSubTopicSource)) {
                return super.equals(obj);
            }
            PubSubTopicSource other = (PubSubTopicSource)obj;
            if (!this.getTopic().equals(other.getTopic())) {
                return false;
            }
            if (!this.getDataAffinityRegionsList().equals(other.getDataAffinityRegionsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + PubSubTopicSource.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getTopic().hashCode();
            if (this.getDataAffinityRegionsCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getDataAffinityRegionsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static PubSubTopicSource parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (PubSubTopicSource)PARSER.parseFrom(data);
        }

        public static PubSubTopicSource parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PubSubTopicSource)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PubSubTopicSource parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (PubSubTopicSource)PARSER.parseFrom(data);
        }

        public static PubSubTopicSource parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PubSubTopicSource)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PubSubTopicSource parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (PubSubTopicSource)PARSER.parseFrom(data);
        }

        public static PubSubTopicSource parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PubSubTopicSource)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PubSubTopicSource parseFrom(InputStream input) throws IOException {
            return (PubSubTopicSource)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static PubSubTopicSource parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PubSubTopicSource)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PubSubTopicSource parseDelimitedFrom(InputStream input) throws IOException {
            return (PubSubTopicSource)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static PubSubTopicSource parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PubSubTopicSource)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PubSubTopicSource parseFrom(CodedInputStream input) throws IOException {
            return (PubSubTopicSource)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static PubSubTopicSource parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PubSubTopicSource)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return PubSubTopicSource.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PubSubTopicSource prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static PubSubTopicSource getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<PubSubTopicSource> parser() {
            return PARSER;
        }

        public Parser<PubSubTopicSource> getParserForType() {
            return PARSER;
        }

        public PubSubTopicSource getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements PubSubTopicSourceOrBuilder {
            private int bitField0_;
            private Object topic_ = "";
            private LazyStringArrayList dataAffinityRegions_ = LazyStringArrayList.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_fieldAccessorTable.ensureFieldAccessorsInitialized(PubSubTopicSource.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.topic_ = "";
                this.dataAffinityRegions_ = LazyStringArrayList.emptyList();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_descriptor;
            }

            public PubSubTopicSource getDefaultInstanceForType() {
                return PubSubTopicSource.getDefaultInstance();
            }

            public PubSubTopicSource build() {
                PubSubTopicSource result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public PubSubTopicSource buildPartial() {
                PubSubTopicSource result = new PubSubTopicSource(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(PubSubTopicSource result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.topic_ = this.topic_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    this.dataAffinityRegions_.makeImmutable();
                    result.dataAffinityRegions_ = this.dataAffinityRegions_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof PubSubTopicSource) {
                    return this.mergeFrom((PubSubTopicSource)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(PubSubTopicSource other) {
                if (other == PubSubTopicSource.getDefaultInstance()) {
                    return this;
                }
                if (!other.getTopic().isEmpty()) {
                    this.topic_ = other.topic_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.dataAffinityRegions_.isEmpty()) {
                    if (this.dataAffinityRegions_.isEmpty()) {
                        this.dataAffinityRegions_ = other.dataAffinityRegions_;
                        this.bitField0_ |= 2;
                    } else {
                        this.ensureDataAffinityRegionsIsMutable();
                        this.dataAffinityRegions_.addAll((Collection)other.dataAffinityRegions_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                this.topic_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                String s = input.readStringRequireUtf8();
                                this.ensureDataAffinityRegionsIsMutable();
                                this.dataAffinityRegions_.add((Object)s);
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getTopic() {
                Object ref = this.topic_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.topic_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getTopicBytes() {
                Object ref = this.topic_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.topic_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setTopic(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.topic_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearTopic() {
                this.topic_ = PubSubTopicSource.getDefaultInstance().getTopic();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setTopicBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PubSubTopicSource.checkByteStringIsUtf8((ByteString)value);
                this.topic_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureDataAffinityRegionsIsMutable() {
                if (!this.dataAffinityRegions_.isModifiable()) {
                    this.dataAffinityRegions_ = new LazyStringArrayList((LazyStringList)this.dataAffinityRegions_);
                }
                this.bitField0_ |= 2;
            }

            public ProtocolStringList getDataAffinityRegionsList() {
                this.dataAffinityRegions_.makeImmutable();
                return this.dataAffinityRegions_;
            }

            @Override
            public int getDataAffinityRegionsCount() {
                return this.dataAffinityRegions_.size();
            }

            @Override
            public String getDataAffinityRegions(int index) {
                return this.dataAffinityRegions_.get(index);
            }

            @Override
            public ByteString getDataAffinityRegionsBytes(int index) {
                return this.dataAffinityRegions_.getByteString(index);
            }

            public Builder setDataAffinityRegions(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDataAffinityRegionsIsMutable();
                this.dataAffinityRegions_.set(index, value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addDataAffinityRegions(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDataAffinityRegionsIsMutable();
                this.dataAffinityRegions_.add((Object)value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllDataAffinityRegions(Iterable<String> values) {
                this.ensureDataAffinityRegionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.dataAffinityRegions_);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearDataAffinityRegions() {
                this.dataAffinityRegions_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder addDataAffinityRegionsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PubSubTopicSource.checkByteStringIsUtf8((ByteString)value);
                this.ensureDataAffinityRegionsIsMutable();
                this.dataAffinityRegions_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface PubSubTopicSourceOrBuilder
    extends MessageOrBuilder {
        public String getTopic();

        public ByteString getTopicBytes();

        public List<String> getDataAffinityRegionsList();

        public int getDataAffinityRegionsCount();

        public String getDataAffinityRegions(int var1);

        public ByteString getDataAffinityRegionsBytes(int var1);
    }

    public static final class BigQueryDatasetSource
    extends GeneratedMessageV3
    implements BigQueryDatasetSourceOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int DATASET_FIELD_NUMBER = 1;
        private volatile Object dataset_ = "";
        public static final int SELECTED_RESOURCES_FIELD_NUMBER = 2;
        private List<SelectedResource> selectedResources_;
        public static final int RESTRICTED_EXPORT_POLICY_FIELD_NUMBER = 3;
        private RestrictedExportPolicy restrictedExportPolicy_;
        public static final int REPLICA_LOCATIONS_FIELD_NUMBER = 5;
        private LazyStringArrayList replicaLocations_ = LazyStringArrayList.emptyList();
        public static final int EFFECTIVE_REPLICAS_FIELD_NUMBER = 6;
        private List<Replica> effectiveReplicas_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final BigQueryDatasetSource DEFAULT_INSTANCE = new BigQueryDatasetSource();
        private static final Parser<BigQueryDatasetSource> PARSER = new AbstractParser<BigQueryDatasetSource>(){

            public BigQueryDatasetSource parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = BigQueryDatasetSource.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private BigQueryDatasetSource(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BigQueryDatasetSource() {
            this.dataset_ = "";
            this.selectedResources_ = Collections.emptyList();
            this.replicaLocations_ = LazyStringArrayList.emptyList();
            this.effectiveReplicas_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new BigQueryDatasetSource();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_fieldAccessorTable.ensureFieldAccessorsInitialized(BigQueryDatasetSource.class, Builder.class);
        }

        @Override
        public String getDataset() {
            Object ref = this.dataset_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.dataset_ = s;
            return s;
        }

        @Override
        public ByteString getDatasetBytes() {
            Object ref = this.dataset_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dataset_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<SelectedResource> getSelectedResourcesList() {
            return this.selectedResources_;
        }

        @Override
        public List<? extends SelectedResourceOrBuilder> getSelectedResourcesOrBuilderList() {
            return this.selectedResources_;
        }

        @Override
        public int getSelectedResourcesCount() {
            return this.selectedResources_.size();
        }

        @Override
        public SelectedResource getSelectedResources(int index) {
            return this.selectedResources_.get(index);
        }

        @Override
        public SelectedResourceOrBuilder getSelectedResourcesOrBuilder(int index) {
            return this.selectedResources_.get(index);
        }

        @Override
        public boolean hasRestrictedExportPolicy() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public RestrictedExportPolicy getRestrictedExportPolicy() {
            return this.restrictedExportPolicy_ == null ? RestrictedExportPolicy.getDefaultInstance() : this.restrictedExportPolicy_;
        }

        @Override
        public RestrictedExportPolicyOrBuilder getRestrictedExportPolicyOrBuilder() {
            return this.restrictedExportPolicy_ == null ? RestrictedExportPolicy.getDefaultInstance() : this.restrictedExportPolicy_;
        }

        public ProtocolStringList getReplicaLocationsList() {
            return this.replicaLocations_;
        }

        @Override
        public int getReplicaLocationsCount() {
            return this.replicaLocations_.size();
        }

        @Override
        public String getReplicaLocations(int index) {
            return this.replicaLocations_.get(index);
        }

        @Override
        public ByteString getReplicaLocationsBytes(int index) {
            return this.replicaLocations_.getByteString(index);
        }

        @Override
        public List<Replica> getEffectiveReplicasList() {
            return this.effectiveReplicas_;
        }

        @Override
        public List<? extends ReplicaOrBuilder> getEffectiveReplicasOrBuilderList() {
            return this.effectiveReplicas_;
        }

        @Override
        public int getEffectiveReplicasCount() {
            return this.effectiveReplicas_.size();
        }

        @Override
        public Replica getEffectiveReplicas(int index) {
            return this.effectiveReplicas_.get(index);
        }

        @Override
        public ReplicaOrBuilder getEffectiveReplicasOrBuilder(int index) {
            return this.effectiveReplicas_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            int i;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.dataset_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.dataset_);
            }
            for (i = 0; i < this.selectedResources_.size(); ++i) {
                output.writeMessage(2, (MessageLite)this.selectedResources_.get(i));
            }
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(3, (MessageLite)this.getRestrictedExportPolicy());
            }
            for (i = 0; i < this.replicaLocations_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.replicaLocations_.getRaw(i));
            }
            for (i = 0; i < this.effectiveReplicas_.size(); ++i) {
                output.writeMessage(6, (MessageLite)this.effectiveReplicas_.get(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int i;
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.dataset_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.dataset_);
            }
            for (i = 0; i < this.selectedResources_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.selectedResources_.get(i)));
            }
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getRestrictedExportPolicy());
            }
            int dataSize = 0;
            for (int i2 = 0; i2 < this.replicaLocations_.size(); ++i2) {
                dataSize += BigQueryDatasetSource.computeStringSizeNoTag((Object)this.replicaLocations_.getRaw(i2));
            }
            size += dataSize;
            size += 1 * this.getReplicaLocationsList().size();
            for (i = 0; i < this.effectiveReplicas_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.effectiveReplicas_.get(i)));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BigQueryDatasetSource)) {
                return super.equals(obj);
            }
            BigQueryDatasetSource other = (BigQueryDatasetSource)obj;
            if (!this.getDataset().equals(other.getDataset())) {
                return false;
            }
            if (!this.getSelectedResourcesList().equals(other.getSelectedResourcesList())) {
                return false;
            }
            if (this.hasRestrictedExportPolicy() != other.hasRestrictedExportPolicy()) {
                return false;
            }
            if (this.hasRestrictedExportPolicy() && !this.getRestrictedExportPolicy().equals(other.getRestrictedExportPolicy())) {
                return false;
            }
            if (!this.getReplicaLocationsList().equals(other.getReplicaLocationsList())) {
                return false;
            }
            if (!this.getEffectiveReplicasList().equals(other.getEffectiveReplicasList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + BigQueryDatasetSource.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getDataset().hashCode();
            if (this.getSelectedResourcesCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getSelectedResourcesList().hashCode();
            }
            if (this.hasRestrictedExportPolicy()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getRestrictedExportPolicy().hashCode();
            }
            if (this.getReplicaLocationsCount() > 0) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getReplicaLocationsList().hashCode();
            }
            if (this.getEffectiveReplicasCount() > 0) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getEffectiveReplicasList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static BigQueryDatasetSource parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (BigQueryDatasetSource)PARSER.parseFrom(data);
        }

        public static BigQueryDatasetSource parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BigQueryDatasetSource)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BigQueryDatasetSource parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BigQueryDatasetSource)PARSER.parseFrom(data);
        }

        public static BigQueryDatasetSource parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BigQueryDatasetSource)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BigQueryDatasetSource parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BigQueryDatasetSource)PARSER.parseFrom(data);
        }

        public static BigQueryDatasetSource parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BigQueryDatasetSource)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BigQueryDatasetSource parseFrom(InputStream input) throws IOException {
            return (BigQueryDatasetSource)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static BigQueryDatasetSource parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BigQueryDatasetSource)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BigQueryDatasetSource parseDelimitedFrom(InputStream input) throws IOException {
            return (BigQueryDatasetSource)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static BigQueryDatasetSource parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BigQueryDatasetSource)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BigQueryDatasetSource parseFrom(CodedInputStream input) throws IOException {
            return (BigQueryDatasetSource)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static BigQueryDatasetSource parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BigQueryDatasetSource)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return BigQueryDatasetSource.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(BigQueryDatasetSource prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static BigQueryDatasetSource getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<BigQueryDatasetSource> parser() {
            return PARSER;
        }

        public Parser<BigQueryDatasetSource> getParserForType() {
            return PARSER;
        }

        public BigQueryDatasetSource getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements BigQueryDatasetSourceOrBuilder {
            private int bitField0_;
            private Object dataset_ = "";
            private List<SelectedResource> selectedResources_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<SelectedResource, SelectedResource.Builder, SelectedResourceOrBuilder> selectedResourcesBuilder_;
            private RestrictedExportPolicy restrictedExportPolicy_;
            private SingleFieldBuilderV3<RestrictedExportPolicy, RestrictedExportPolicy.Builder, RestrictedExportPolicyOrBuilder> restrictedExportPolicyBuilder_;
            private LazyStringArrayList replicaLocations_ = LazyStringArrayList.emptyList();
            private List<Replica> effectiveReplicas_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<Replica, Replica.Builder, ReplicaOrBuilder> effectiveReplicasBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_fieldAccessorTable.ensureFieldAccessorsInitialized(BigQueryDatasetSource.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getSelectedResourcesFieldBuilder();
                    this.getRestrictedExportPolicyFieldBuilder();
                    this.getEffectiveReplicasFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.dataset_ = "";
                if (this.selectedResourcesBuilder_ == null) {
                    this.selectedResources_ = Collections.emptyList();
                } else {
                    this.selectedResources_ = null;
                    this.selectedResourcesBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFD;
                this.restrictedExportPolicy_ = null;
                if (this.restrictedExportPolicyBuilder_ != null) {
                    this.restrictedExportPolicyBuilder_.dispose();
                    this.restrictedExportPolicyBuilder_ = null;
                }
                this.replicaLocations_ = LazyStringArrayList.emptyList();
                if (this.effectiveReplicasBuilder_ == null) {
                    this.effectiveReplicas_ = Collections.emptyList();
                } else {
                    this.effectiveReplicas_ = null;
                    this.effectiveReplicasBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFEF;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_descriptor;
            }

            public BigQueryDatasetSource getDefaultInstanceForType() {
                return BigQueryDatasetSource.getDefaultInstance();
            }

            public BigQueryDatasetSource build() {
                BigQueryDatasetSource result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public BigQueryDatasetSource buildPartial() {
                BigQueryDatasetSource result = new BigQueryDatasetSource(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(BigQueryDatasetSource result) {
                if (this.selectedResourcesBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0) {
                        this.selectedResources_ = Collections.unmodifiableList(this.selectedResources_);
                        this.bitField0_ &= 0xFFFFFFFD;
                    }
                    result.selectedResources_ = this.selectedResources_;
                } else {
                    result.selectedResources_ = this.selectedResourcesBuilder_.build();
                }
                if (this.effectiveReplicasBuilder_ == null) {
                    if ((this.bitField0_ & 0x10) != 0) {
                        this.effectiveReplicas_ = Collections.unmodifiableList(this.effectiveReplicas_);
                        this.bitField0_ &= 0xFFFFFFEF;
                    }
                    result.effectiveReplicas_ = this.effectiveReplicas_;
                } else {
                    result.effectiveReplicas_ = this.effectiveReplicasBuilder_.build();
                }
            }

            private void buildPartial0(BigQueryDatasetSource result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.dataset_ = this.dataset_;
                }
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 4) != 0) {
                    result.restrictedExportPolicy_ = this.restrictedExportPolicyBuilder_ == null ? this.restrictedExportPolicy_ : (RestrictedExportPolicy)this.restrictedExportPolicyBuilder_.build();
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 8) != 0) {
                    this.replicaLocations_.makeImmutable();
                    result.replicaLocations_ = this.replicaLocations_;
                }
                BigQueryDatasetSource bigQueryDatasetSource = result;
                bigQueryDatasetSource.bitField0_ = bigQueryDatasetSource.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof BigQueryDatasetSource) {
                    return this.mergeFrom((BigQueryDatasetSource)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(BigQueryDatasetSource other) {
                if (other == BigQueryDatasetSource.getDefaultInstance()) {
                    return this;
                }
                if (!other.getDataset().isEmpty()) {
                    this.dataset_ = other.dataset_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (this.selectedResourcesBuilder_ == null) {
                    if (!other.selectedResources_.isEmpty()) {
                        if (this.selectedResources_.isEmpty()) {
                            this.selectedResources_ = other.selectedResources_;
                            this.bitField0_ &= 0xFFFFFFFD;
                        } else {
                            this.ensureSelectedResourcesIsMutable();
                            this.selectedResources_.addAll(other.selectedResources_);
                        }
                        this.onChanged();
                    }
                } else if (!other.selectedResources_.isEmpty()) {
                    if (this.selectedResourcesBuilder_.isEmpty()) {
                        this.selectedResourcesBuilder_.dispose();
                        this.selectedResourcesBuilder_ = null;
                        this.selectedResources_ = other.selectedResources_;
                        this.bitField0_ &= 0xFFFFFFFD;
                        this.selectedResourcesBuilder_ = alwaysUseFieldBuilders ? this.getSelectedResourcesFieldBuilder() : null;
                    } else {
                        this.selectedResourcesBuilder_.addAllMessages((Iterable)other.selectedResources_);
                    }
                }
                if (other.hasRestrictedExportPolicy()) {
                    this.mergeRestrictedExportPolicy(other.getRestrictedExportPolicy());
                }
                if (!other.replicaLocations_.isEmpty()) {
                    if (this.replicaLocations_.isEmpty()) {
                        this.replicaLocations_ = other.replicaLocations_;
                        this.bitField0_ |= 8;
                    } else {
                        this.ensureReplicaLocationsIsMutable();
                        this.replicaLocations_.addAll((Collection)other.replicaLocations_);
                    }
                    this.onChanged();
                }
                if (this.effectiveReplicasBuilder_ == null) {
                    if (!other.effectiveReplicas_.isEmpty()) {
                        if (this.effectiveReplicas_.isEmpty()) {
                            this.effectiveReplicas_ = other.effectiveReplicas_;
                            this.bitField0_ &= 0xFFFFFFEF;
                        } else {
                            this.ensureEffectiveReplicasIsMutable();
                            this.effectiveReplicas_.addAll(other.effectiveReplicas_);
                        }
                        this.onChanged();
                    }
                } else if (!other.effectiveReplicas_.isEmpty()) {
                    if (this.effectiveReplicasBuilder_.isEmpty()) {
                        this.effectiveReplicasBuilder_.dispose();
                        this.effectiveReplicasBuilder_ = null;
                        this.effectiveReplicas_ = other.effectiveReplicas_;
                        this.bitField0_ &= 0xFFFFFFEF;
                        this.effectiveReplicasBuilder_ = alwaysUseFieldBuilders ? this.getEffectiveReplicasFieldBuilder() : null;
                    } else {
                        this.effectiveReplicasBuilder_.addAllMessages((Iterable)other.effectiveReplicas_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block13: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block13;
                            }
                            case 10: {
                                this.dataset_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block13;
                            }
                            case 18: {
                                GeneratedMessageV3 m = (SelectedResource)input.readMessage(SelectedResource.parser(), extensionRegistry);
                                if (this.selectedResourcesBuilder_ == null) {
                                    this.ensureSelectedResourcesIsMutable();
                                    this.selectedResources_.add((SelectedResource)m);
                                    continue block13;
                                }
                                this.selectedResourcesBuilder_.addMessage((AbstractMessage)m);
                                continue block13;
                            }
                            case 26: {
                                input.readMessage((MessageLite.Builder)this.getRestrictedExportPolicyFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 4;
                                continue block13;
                            }
                            case 42: {
                                String s = input.readStringRequireUtf8();
                                this.ensureReplicaLocationsIsMutable();
                                this.replicaLocations_.add((Object)s);
                                continue block13;
                            }
                            case 50: {
                                GeneratedMessageV3 m = (Replica)input.readMessage(Replica.parser(), extensionRegistry);
                                if (this.effectiveReplicasBuilder_ == null) {
                                    this.ensureEffectiveReplicasIsMutable();
                                    this.effectiveReplicas_.add((Replica)m);
                                    continue block13;
                                }
                                this.effectiveReplicasBuilder_.addMessage((AbstractMessage)m);
                                continue block13;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getDataset() {
                Object ref = this.dataset_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.dataset_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getDatasetBytes() {
                Object ref = this.dataset_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.dataset_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setDataset(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.dataset_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearDataset() {
                this.dataset_ = BigQueryDatasetSource.getDefaultInstance().getDataset();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setDatasetBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                BigQueryDatasetSource.checkByteStringIsUtf8((ByteString)value);
                this.dataset_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureSelectedResourcesIsMutable() {
                if ((this.bitField0_ & 2) == 0) {
                    this.selectedResources_ = new ArrayList<SelectedResource>(this.selectedResources_);
                    this.bitField0_ |= 2;
                }
            }

            @Override
            public List<SelectedResource> getSelectedResourcesList() {
                if (this.selectedResourcesBuilder_ == null) {
                    return Collections.unmodifiableList(this.selectedResources_);
                }
                return this.selectedResourcesBuilder_.getMessageList();
            }

            @Override
            public int getSelectedResourcesCount() {
                if (this.selectedResourcesBuilder_ == null) {
                    return this.selectedResources_.size();
                }
                return this.selectedResourcesBuilder_.getCount();
            }

            @Override
            public SelectedResource getSelectedResources(int index) {
                if (this.selectedResourcesBuilder_ == null) {
                    return this.selectedResources_.get(index);
                }
                return (SelectedResource)this.selectedResourcesBuilder_.getMessage(index);
            }

            public Builder setSelectedResources(int index, SelectedResource value) {
                if (this.selectedResourcesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.set(index, value);
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setSelectedResources(int index, SelectedResource.Builder builderForValue) {
                if (this.selectedResourcesBuilder_ == null) {
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addSelectedResources(SelectedResource value) {
                if (this.selectedResourcesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.add(value);
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addSelectedResources(int index, SelectedResource value) {
                if (this.selectedResourcesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.add(index, value);
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addSelectedResources(SelectedResource.Builder builderForValue) {
                if (this.selectedResourcesBuilder_ == null) {
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addSelectedResources(int index, SelectedResource.Builder builderForValue) {
                if (this.selectedResourcesBuilder_ == null) {
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllSelectedResources(Iterable<? extends SelectedResource> values) {
                if (this.selectedResourcesBuilder_ == null) {
                    this.ensureSelectedResourcesIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.selectedResources_);
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearSelectedResources() {
                if (this.selectedResourcesBuilder_ == null) {
                    this.selectedResources_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.clear();
                }
                return this;
            }

            public Builder removeSelectedResources(int index) {
                if (this.selectedResourcesBuilder_ == null) {
                    this.ensureSelectedResourcesIsMutable();
                    this.selectedResources_.remove(index);
                    this.onChanged();
                } else {
                    this.selectedResourcesBuilder_.remove(index);
                }
                return this;
            }

            public SelectedResource.Builder getSelectedResourcesBuilder(int index) {
                return (SelectedResource.Builder)this.getSelectedResourcesFieldBuilder().getBuilder(index);
            }

            @Override
            public SelectedResourceOrBuilder getSelectedResourcesOrBuilder(int index) {
                if (this.selectedResourcesBuilder_ == null) {
                    return this.selectedResources_.get(index);
                }
                return (SelectedResourceOrBuilder)this.selectedResourcesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends SelectedResourceOrBuilder> getSelectedResourcesOrBuilderList() {
                if (this.selectedResourcesBuilder_ != null) {
                    return this.selectedResourcesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.selectedResources_);
            }

            public SelectedResource.Builder addSelectedResourcesBuilder() {
                return (SelectedResource.Builder)this.getSelectedResourcesFieldBuilder().addBuilder((AbstractMessage)SelectedResource.getDefaultInstance());
            }

            public SelectedResource.Builder addSelectedResourcesBuilder(int index) {
                return (SelectedResource.Builder)this.getSelectedResourcesFieldBuilder().addBuilder(index, (AbstractMessage)SelectedResource.getDefaultInstance());
            }

            public List<SelectedResource.Builder> getSelectedResourcesBuilderList() {
                return this.getSelectedResourcesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<SelectedResource, SelectedResource.Builder, SelectedResourceOrBuilder> getSelectedResourcesFieldBuilder() {
                if (this.selectedResourcesBuilder_ == null) {
                    this.selectedResourcesBuilder_ = new RepeatedFieldBuilderV3(this.selectedResources_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.selectedResources_ = null;
                }
                return this.selectedResourcesBuilder_;
            }

            @Override
            public boolean hasRestrictedExportPolicy() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public RestrictedExportPolicy getRestrictedExportPolicy() {
                if (this.restrictedExportPolicyBuilder_ == null) {
                    return this.restrictedExportPolicy_ == null ? RestrictedExportPolicy.getDefaultInstance() : this.restrictedExportPolicy_;
                }
                return (RestrictedExportPolicy)this.restrictedExportPolicyBuilder_.getMessage();
            }

            public Builder setRestrictedExportPolicy(RestrictedExportPolicy value) {
                if (this.restrictedExportPolicyBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.restrictedExportPolicy_ = value;
                } else {
                    this.restrictedExportPolicyBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder setRestrictedExportPolicy(RestrictedExportPolicy.Builder builderForValue) {
                if (this.restrictedExportPolicyBuilder_ == null) {
                    this.restrictedExportPolicy_ = builderForValue.build();
                } else {
                    this.restrictedExportPolicyBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder mergeRestrictedExportPolicy(RestrictedExportPolicy value) {
                if (this.restrictedExportPolicyBuilder_ == null) {
                    if ((this.bitField0_ & 4) != 0 && this.restrictedExportPolicy_ != null && this.restrictedExportPolicy_ != RestrictedExportPolicy.getDefaultInstance()) {
                        this.getRestrictedExportPolicyBuilder().mergeFrom(value);
                    } else {
                        this.restrictedExportPolicy_ = value;
                    }
                } else {
                    this.restrictedExportPolicyBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.restrictedExportPolicy_ != null) {
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearRestrictedExportPolicy() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.restrictedExportPolicy_ = null;
                if (this.restrictedExportPolicyBuilder_ != null) {
                    this.restrictedExportPolicyBuilder_.dispose();
                    this.restrictedExportPolicyBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public RestrictedExportPolicy.Builder getRestrictedExportPolicyBuilder() {
                this.bitField0_ |= 4;
                this.onChanged();
                return (RestrictedExportPolicy.Builder)this.getRestrictedExportPolicyFieldBuilder().getBuilder();
            }

            @Override
            public RestrictedExportPolicyOrBuilder getRestrictedExportPolicyOrBuilder() {
                if (this.restrictedExportPolicyBuilder_ != null) {
                    return (RestrictedExportPolicyOrBuilder)this.restrictedExportPolicyBuilder_.getMessageOrBuilder();
                }
                return this.restrictedExportPolicy_ == null ? RestrictedExportPolicy.getDefaultInstance() : this.restrictedExportPolicy_;
            }

            private SingleFieldBuilderV3<RestrictedExportPolicy, RestrictedExportPolicy.Builder, RestrictedExportPolicyOrBuilder> getRestrictedExportPolicyFieldBuilder() {
                if (this.restrictedExportPolicyBuilder_ == null) {
                    this.restrictedExportPolicyBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRestrictedExportPolicy(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.restrictedExportPolicy_ = null;
                }
                return this.restrictedExportPolicyBuilder_;
            }

            private void ensureReplicaLocationsIsMutable() {
                if (!this.replicaLocations_.isModifiable()) {
                    this.replicaLocations_ = new LazyStringArrayList((LazyStringList)this.replicaLocations_);
                }
                this.bitField0_ |= 8;
            }

            public ProtocolStringList getReplicaLocationsList() {
                this.replicaLocations_.makeImmutable();
                return this.replicaLocations_;
            }

            @Override
            public int getReplicaLocationsCount() {
                return this.replicaLocations_.size();
            }

            @Override
            public String getReplicaLocations(int index) {
                return this.replicaLocations_.get(index);
            }

            @Override
            public ByteString getReplicaLocationsBytes(int index) {
                return this.replicaLocations_.getByteString(index);
            }

            public Builder setReplicaLocations(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureReplicaLocationsIsMutable();
                this.replicaLocations_.set(index, value);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder addReplicaLocations(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureReplicaLocationsIsMutable();
                this.replicaLocations_.add((Object)value);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder addAllReplicaLocations(Iterable<String> values) {
                this.ensureReplicaLocationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.replicaLocations_);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearReplicaLocations() {
                this.replicaLocations_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder addReplicaLocationsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                BigQueryDatasetSource.checkByteStringIsUtf8((ByteString)value);
                this.ensureReplicaLocationsIsMutable();
                this.replicaLocations_.add(value);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            private void ensureEffectiveReplicasIsMutable() {
                if ((this.bitField0_ & 0x10) == 0) {
                    this.effectiveReplicas_ = new ArrayList<Replica>(this.effectiveReplicas_);
                    this.bitField0_ |= 0x10;
                }
            }

            @Override
            public List<Replica> getEffectiveReplicasList() {
                if (this.effectiveReplicasBuilder_ == null) {
                    return Collections.unmodifiableList(this.effectiveReplicas_);
                }
                return this.effectiveReplicasBuilder_.getMessageList();
            }

            @Override
            public int getEffectiveReplicasCount() {
                if (this.effectiveReplicasBuilder_ == null) {
                    return this.effectiveReplicas_.size();
                }
                return this.effectiveReplicasBuilder_.getCount();
            }

            @Override
            public Replica getEffectiveReplicas(int index) {
                if (this.effectiveReplicasBuilder_ == null) {
                    return this.effectiveReplicas_.get(index);
                }
                return (Replica)this.effectiveReplicasBuilder_.getMessage(index);
            }

            public Builder setEffectiveReplicas(int index, Replica value) {
                if (this.effectiveReplicasBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.set(index, value);
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setEffectiveReplicas(int index, Replica.Builder builderForValue) {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addEffectiveReplicas(Replica value) {
                if (this.effectiveReplicasBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.add(value);
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addEffectiveReplicas(int index, Replica value) {
                if (this.effectiveReplicasBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.add(index, value);
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addEffectiveReplicas(Replica.Builder builderForValue) {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addEffectiveReplicas(int index, Replica.Builder builderForValue) {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllEffectiveReplicas(Iterable<? extends Replica> values) {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.ensureEffectiveReplicasIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.effectiveReplicas_);
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearEffectiveReplicas() {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.effectiveReplicas_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.clear();
                }
                return this;
            }

            public Builder removeEffectiveReplicas(int index) {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.ensureEffectiveReplicasIsMutable();
                    this.effectiveReplicas_.remove(index);
                    this.onChanged();
                } else {
                    this.effectiveReplicasBuilder_.remove(index);
                }
                return this;
            }

            public Replica.Builder getEffectiveReplicasBuilder(int index) {
                return (Replica.Builder)this.getEffectiveReplicasFieldBuilder().getBuilder(index);
            }

            @Override
            public ReplicaOrBuilder getEffectiveReplicasOrBuilder(int index) {
                if (this.effectiveReplicasBuilder_ == null) {
                    return this.effectiveReplicas_.get(index);
                }
                return (ReplicaOrBuilder)this.effectiveReplicasBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends ReplicaOrBuilder> getEffectiveReplicasOrBuilderList() {
                if (this.effectiveReplicasBuilder_ != null) {
                    return this.effectiveReplicasBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.effectiveReplicas_);
            }

            public Replica.Builder addEffectiveReplicasBuilder() {
                return (Replica.Builder)this.getEffectiveReplicasFieldBuilder().addBuilder((AbstractMessage)Replica.getDefaultInstance());
            }

            public Replica.Builder addEffectiveReplicasBuilder(int index) {
                return (Replica.Builder)this.getEffectiveReplicasFieldBuilder().addBuilder(index, (AbstractMessage)Replica.getDefaultInstance());
            }

            public List<Replica.Builder> getEffectiveReplicasBuilderList() {
                return this.getEffectiveReplicasFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<Replica, Replica.Builder, ReplicaOrBuilder> getEffectiveReplicasFieldBuilder() {
                if (this.effectiveReplicasBuilder_ == null) {
                    this.effectiveReplicasBuilder_ = new RepeatedFieldBuilderV3(this.effectiveReplicas_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.effectiveReplicas_ = null;
                }
                return this.effectiveReplicasBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class Replica
        extends GeneratedMessageV3
        implements ReplicaOrBuilder {
            private static final long serialVersionUID = 0L;
            private int bitField0_;
            public static final int LOCATION_FIELD_NUMBER = 1;
            private volatile Object location_ = "";
            public static final int REPLICA_STATE_FIELD_NUMBER = 2;
            private int replicaState_ = 0;
            public static final int PRIMARY_STATE_FIELD_NUMBER = 3;
            private int primaryState_ = 0;
            private byte memoizedIsInitialized = (byte)-1;
            private static final Replica DEFAULT_INSTANCE = new Replica();
            private static final Parser<Replica> PARSER = new AbstractParser<Replica>(){

                public Replica parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = Replica.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private Replica(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private Replica() {
                this.location_ = "";
                this.replicaState_ = 0;
                this.primaryState_ = 0;
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new Replica();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_Replica_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_Replica_fieldAccessorTable.ensureFieldAccessorsInitialized(Replica.class, Builder.class);
            }

            @Override
            public String getLocation() {
                Object ref = this.location_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.location_ = s;
                return s;
            }

            @Override
            public ByteString getLocationBytes() {
                Object ref = this.location_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.location_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public int getReplicaStateValue() {
                return this.replicaState_;
            }

            @Override
            public ReplicaState getReplicaState() {
                ReplicaState result = ReplicaState.forNumber(this.replicaState_);
                return result == null ? ReplicaState.UNRECOGNIZED : result;
            }

            @Override
            public boolean hasPrimaryState() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getPrimaryStateValue() {
                return this.primaryState_;
            }

            @Override
            public PrimaryState getPrimaryState() {
                PrimaryState result = PrimaryState.forNumber(this.primaryState_);
                return result == null ? PrimaryState.UNRECOGNIZED : result;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if (!GeneratedMessageV3.isStringEmpty((Object)this.location_)) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.location_);
                }
                if (this.replicaState_ != ReplicaState.REPLICA_STATE_UNSPECIFIED.getNumber()) {
                    output.writeEnum(2, this.replicaState_);
                }
                if ((this.bitField0_ & 1) != 0) {
                    output.writeEnum(3, this.primaryState_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (!GeneratedMessageV3.isStringEmpty((Object)this.location_)) {
                    size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.location_);
                }
                if (this.replicaState_ != ReplicaState.REPLICA_STATE_UNSPECIFIED.getNumber()) {
                    size += CodedOutputStream.computeEnumSize((int)2, (int)this.replicaState_);
                }
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputStream.computeEnumSize((int)3, (int)this.primaryState_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Replica)) {
                    return super.equals(obj);
                }
                Replica other = (Replica)obj;
                if (!this.getLocation().equals(other.getLocation())) {
                    return false;
                }
                if (this.replicaState_ != other.replicaState_) {
                    return false;
                }
                if (this.hasPrimaryState() != other.hasPrimaryState()) {
                    return false;
                }
                if (this.hasPrimaryState() && this.primaryState_ != other.primaryState_) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + Replica.getDescriptor().hashCode();
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getLocation().hashCode();
                hash = 37 * hash + 2;
                hash = 53 * hash + this.replicaState_;
                if (this.hasPrimaryState()) {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + this.primaryState_;
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static Replica parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (Replica)PARSER.parseFrom(data);
            }

            public static Replica parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Replica)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Replica parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (Replica)PARSER.parseFrom(data);
            }

            public static Replica parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Replica)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Replica parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (Replica)PARSER.parseFrom(data);
            }

            public static Replica parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Replica)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Replica parseFrom(InputStream input) throws IOException {
                return (Replica)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static Replica parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Replica)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Replica parseDelimitedFrom(InputStream input) throws IOException {
                return (Replica)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static Replica parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Replica)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Replica parseFrom(CodedInputStream input) throws IOException {
                return (Replica)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static Replica parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Replica)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return Replica.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(Replica prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static Replica getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<Replica> parser() {
                return PARSER;
            }

            public Parser<Replica> getParserForType() {
                return PARSER;
            }

            public Replica getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements ReplicaOrBuilder {
                private int bitField0_;
                private Object location_ = "";
                private int replicaState_ = 0;
                private int primaryState_ = 0;

                public static final Descriptors.Descriptor getDescriptor() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_Replica_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_Replica_fieldAccessorTable.ensureFieldAccessorsInitialized(Replica.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.location_ = "";
                    this.replicaState_ = 0;
                    this.primaryState_ = 0;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_Replica_descriptor;
                }

                public Replica getDefaultInstanceForType() {
                    return Replica.getDefaultInstance();
                }

                public Replica build() {
                    Replica result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public Replica buildPartial() {
                    Replica result = new Replica(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(Replica result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 1) != 0) {
                        result.location_ = this.location_;
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.replicaState_ = this.replicaState_;
                    }
                    int to_bitField0_ = 0;
                    if ((from_bitField0_ & 4) != 0) {
                        result.primaryState_ = this.primaryState_;
                        to_bitField0_ |= 1;
                    }
                    Replica replica = result;
                    replica.bitField0_ = replica.bitField0_ | to_bitField0_;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof Replica) {
                        return this.mergeFrom((Replica)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(Replica other) {
                    if (other == Replica.getDefaultInstance()) {
                        return this;
                    }
                    if (!other.getLocation().isEmpty()) {
                        this.location_ = other.location_;
                        this.bitField0_ |= 1;
                        this.onChanged();
                    }
                    if (other.replicaState_ != 0) {
                        this.setReplicaStateValue(other.getReplicaStateValue());
                    }
                    if (other.hasPrimaryState()) {
                        this.setPrimaryState(other.getPrimaryState());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block11: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block11;
                                }
                                case 10: {
                                    this.location_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 1;
                                    continue block11;
                                }
                                case 16: {
                                    this.replicaState_ = input.readEnum();
                                    this.bitField0_ |= 2;
                                    continue block11;
                                }
                                case 24: {
                                    this.primaryState_ = input.readEnum();
                                    this.bitField0_ |= 4;
                                    continue block11;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public String getLocation() {
                    Object ref = this.location_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        this.location_ = s;
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getLocationBytes() {
                    Object ref = this.location_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        this.location_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setLocation(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.location_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearLocation() {
                    this.location_ = Replica.getDefaultInstance().getLocation();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                    return this;
                }

                public Builder setLocationBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    Replica.checkByteStringIsUtf8((ByteString)value);
                    this.location_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                @Override
                public int getReplicaStateValue() {
                    return this.replicaState_;
                }

                public Builder setReplicaStateValue(int value) {
                    this.replicaState_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                @Override
                public ReplicaState getReplicaState() {
                    ReplicaState result = ReplicaState.forNumber(this.replicaState_);
                    return result == null ? ReplicaState.UNRECOGNIZED : result;
                }

                public Builder setReplicaState(ReplicaState value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 2;
                    this.replicaState_ = value.getNumber();
                    this.onChanged();
                    return this;
                }

                public Builder clearReplicaState() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.replicaState_ = 0;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasPrimaryState() {
                    return (this.bitField0_ & 4) != 0;
                }

                @Override
                public int getPrimaryStateValue() {
                    return this.primaryState_;
                }

                public Builder setPrimaryStateValue(int value) {
                    this.primaryState_ = value;
                    this.bitField0_ |= 4;
                    this.onChanged();
                    return this;
                }

                @Override
                public PrimaryState getPrimaryState() {
                    PrimaryState result = PrimaryState.forNumber(this.primaryState_);
                    return result == null ? PrimaryState.UNRECOGNIZED : result;
                }

                public Builder setPrimaryState(PrimaryState value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 4;
                    this.primaryState_ = value.getNumber();
                    this.onChanged();
                    return this;
                }

                public Builder clearPrimaryState() {
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.primaryState_ = 0;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static enum PrimaryState implements ProtocolMessageEnum
            {
                PRIMARY_STATE_UNSPECIFIED(0),
                PRIMARY_REPLICA(1),
                UNRECOGNIZED(-1);

                public static final int PRIMARY_STATE_UNSPECIFIED_VALUE = 0;
                public static final int PRIMARY_REPLICA_VALUE = 1;
                private static final Internal.EnumLiteMap<PrimaryState> internalValueMap;
                private static final PrimaryState[] VALUES;
                private final int value;

                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                    }
                    return this.value;
                }

                @Deprecated
                public static PrimaryState valueOf(int value) {
                    return PrimaryState.forNumber(value);
                }

                public static PrimaryState forNumber(int value) {
                    switch (value) {
                        case 0: {
                            return PRIMARY_STATE_UNSPECIFIED;
                        }
                        case 1: {
                            return PRIMARY_REPLICA;
                        }
                    }
                    return null;
                }

                public static Internal.EnumLiteMap<PrimaryState> internalGetValueMap() {
                    return internalValueMap;
                }

                public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                    }
                    return (Descriptors.EnumValueDescriptor)PrimaryState.getDescriptor().getValues().get(this.ordinal());
                }

                public final Descriptors.EnumDescriptor getDescriptorForType() {
                    return PrimaryState.getDescriptor();
                }

                public static final Descriptors.EnumDescriptor getDescriptor() {
                    return (Descriptors.EnumDescriptor)Replica.getDescriptor().getEnumTypes().get(1);
                }

                public static PrimaryState valueOf(Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != PrimaryState.getDescriptor()) {
                        throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private PrimaryState(int value) {
                    this.value = value;
                }

                static {
                    internalValueMap = new Internal.EnumLiteMap<PrimaryState>(){

                        public PrimaryState findValueByNumber(int number) {
                            return PrimaryState.forNumber(number);
                        }
                    };
                    VALUES = PrimaryState.values();
                }
            }

            public static enum ReplicaState implements ProtocolMessageEnum
            {
                REPLICA_STATE_UNSPECIFIED(0),
                READY_TO_USE(1),
                UNAVAILABLE(2),
                UNRECOGNIZED(-1);

                public static final int REPLICA_STATE_UNSPECIFIED_VALUE = 0;
                public static final int READY_TO_USE_VALUE = 1;
                public static final int UNAVAILABLE_VALUE = 2;
                private static final Internal.EnumLiteMap<ReplicaState> internalValueMap;
                private static final ReplicaState[] VALUES;
                private final int value;

                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                    }
                    return this.value;
                }

                @Deprecated
                public static ReplicaState valueOf(int value) {
                    return ReplicaState.forNumber(value);
                }

                public static ReplicaState forNumber(int value) {
                    switch (value) {
                        case 0: {
                            return REPLICA_STATE_UNSPECIFIED;
                        }
                        case 1: {
                            return READY_TO_USE;
                        }
                        case 2: {
                            return UNAVAILABLE;
                        }
                    }
                    return null;
                }

                public static Internal.EnumLiteMap<ReplicaState> internalGetValueMap() {
                    return internalValueMap;
                }

                public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                    }
                    return (Descriptors.EnumValueDescriptor)ReplicaState.getDescriptor().getValues().get(this.ordinal());
                }

                public final Descriptors.EnumDescriptor getDescriptorForType() {
                    return ReplicaState.getDescriptor();
                }

                public static final Descriptors.EnumDescriptor getDescriptor() {
                    return (Descriptors.EnumDescriptor)Replica.getDescriptor().getEnumTypes().get(0);
                }

                public static ReplicaState valueOf(Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != ReplicaState.getDescriptor()) {
                        throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private ReplicaState(int value) {
                    this.value = value;
                }

                static {
                    internalValueMap = new Internal.EnumLiteMap<ReplicaState>(){

                        public ReplicaState findValueByNumber(int number) {
                            return ReplicaState.forNumber(number);
                        }
                    };
                    VALUES = ReplicaState.values();
                }
            }
        }

        public static interface ReplicaOrBuilder
        extends MessageOrBuilder {
            public String getLocation();

            public ByteString getLocationBytes();

            public int getReplicaStateValue();

            public Replica.ReplicaState getReplicaState();

            public boolean hasPrimaryState();

            public int getPrimaryStateValue();

            public Replica.PrimaryState getPrimaryState();
        }

        public static final class RestrictedExportPolicy
        extends GeneratedMessageV3
        implements RestrictedExportPolicyOrBuilder {
            private static final long serialVersionUID = 0L;
            private int bitField0_;
            public static final int ENABLED_FIELD_NUMBER = 1;
            private BoolValue enabled_;
            public static final int RESTRICT_DIRECT_TABLE_ACCESS_FIELD_NUMBER = 2;
            private BoolValue restrictDirectTableAccess_;
            public static final int RESTRICT_QUERY_RESULT_FIELD_NUMBER = 3;
            private BoolValue restrictQueryResult_;
            private byte memoizedIsInitialized = (byte)-1;
            private static final RestrictedExportPolicy DEFAULT_INSTANCE = new RestrictedExportPolicy();
            private static final Parser<RestrictedExportPolicy> PARSER = new AbstractParser<RestrictedExportPolicy>(){

                public RestrictedExportPolicy parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = RestrictedExportPolicy.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private RestrictedExportPolicy(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private RestrictedExportPolicy() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new RestrictedExportPolicy();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_fieldAccessorTable.ensureFieldAccessorsInitialized(RestrictedExportPolicy.class, Builder.class);
            }

            @Override
            public boolean hasEnabled() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public BoolValue getEnabled() {
                return this.enabled_ == null ? BoolValue.getDefaultInstance() : this.enabled_;
            }

            @Override
            public BoolValueOrBuilder getEnabledOrBuilder() {
                return this.enabled_ == null ? BoolValue.getDefaultInstance() : this.enabled_;
            }

            @Override
            public boolean hasRestrictDirectTableAccess() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public BoolValue getRestrictDirectTableAccess() {
                return this.restrictDirectTableAccess_ == null ? BoolValue.getDefaultInstance() : this.restrictDirectTableAccess_;
            }

            @Override
            public BoolValueOrBuilder getRestrictDirectTableAccessOrBuilder() {
                return this.restrictDirectTableAccess_ == null ? BoolValue.getDefaultInstance() : this.restrictDirectTableAccess_;
            }

            @Override
            public boolean hasRestrictQueryResult() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public BoolValue getRestrictQueryResult() {
                return this.restrictQueryResult_ == null ? BoolValue.getDefaultInstance() : this.restrictQueryResult_;
            }

            @Override
            public BoolValueOrBuilder getRestrictQueryResultOrBuilder() {
                return this.restrictQueryResult_ == null ? BoolValue.getDefaultInstance() : this.restrictQueryResult_;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if ((this.bitField0_ & 1) != 0) {
                    output.writeMessage(1, (MessageLite)this.getEnabled());
                }
                if ((this.bitField0_ & 2) != 0) {
                    output.writeMessage(2, (MessageLite)this.getRestrictDirectTableAccess());
                }
                if ((this.bitField0_ & 4) != 0) {
                    output.writeMessage(3, (MessageLite)this.getRestrictQueryResult());
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getEnabled());
                }
                if ((this.bitField0_ & 2) != 0) {
                    size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getRestrictDirectTableAccess());
                }
                if ((this.bitField0_ & 4) != 0) {
                    size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getRestrictQueryResult());
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof RestrictedExportPolicy)) {
                    return super.equals(obj);
                }
                RestrictedExportPolicy other = (RestrictedExportPolicy)obj;
                if (this.hasEnabled() != other.hasEnabled()) {
                    return false;
                }
                if (this.hasEnabled() && !this.getEnabled().equals((Object)other.getEnabled())) {
                    return false;
                }
                if (this.hasRestrictDirectTableAccess() != other.hasRestrictDirectTableAccess()) {
                    return false;
                }
                if (this.hasRestrictDirectTableAccess() && !this.getRestrictDirectTableAccess().equals((Object)other.getRestrictDirectTableAccess())) {
                    return false;
                }
                if (this.hasRestrictQueryResult() != other.hasRestrictQueryResult()) {
                    return false;
                }
                if (this.hasRestrictQueryResult() && !this.getRestrictQueryResult().equals((Object)other.getRestrictQueryResult())) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + RestrictedExportPolicy.getDescriptor().hashCode();
                if (this.hasEnabled()) {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getEnabled().hashCode();
                }
                if (this.hasRestrictDirectTableAccess()) {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getRestrictDirectTableAccess().hashCode();
                }
                if (this.hasRestrictQueryResult()) {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + this.getRestrictQueryResult().hashCode();
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static RestrictedExportPolicy parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (RestrictedExportPolicy)PARSER.parseFrom(data);
            }

            public static RestrictedExportPolicy parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (RestrictedExportPolicy)PARSER.parseFrom(data, extensionRegistry);
            }

            public static RestrictedExportPolicy parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (RestrictedExportPolicy)PARSER.parseFrom(data);
            }

            public static RestrictedExportPolicy parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (RestrictedExportPolicy)PARSER.parseFrom(data, extensionRegistry);
            }

            public static RestrictedExportPolicy parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (RestrictedExportPolicy)PARSER.parseFrom(data);
            }

            public static RestrictedExportPolicy parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (RestrictedExportPolicy)PARSER.parseFrom(data, extensionRegistry);
            }

            public static RestrictedExportPolicy parseFrom(InputStream input) throws IOException {
                return (RestrictedExportPolicy)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static RestrictedExportPolicy parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (RestrictedExportPolicy)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static RestrictedExportPolicy parseDelimitedFrom(InputStream input) throws IOException {
                return (RestrictedExportPolicy)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static RestrictedExportPolicy parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (RestrictedExportPolicy)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static RestrictedExportPolicy parseFrom(CodedInputStream input) throws IOException {
                return (RestrictedExportPolicy)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static RestrictedExportPolicy parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (RestrictedExportPolicy)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return RestrictedExportPolicy.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(RestrictedExportPolicy prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static RestrictedExportPolicy getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<RestrictedExportPolicy> parser() {
                return PARSER;
            }

            public Parser<RestrictedExportPolicy> getParserForType() {
                return PARSER;
            }

            public RestrictedExportPolicy getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements RestrictedExportPolicyOrBuilder {
                private int bitField0_;
                private BoolValue enabled_;
                private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> enabledBuilder_;
                private BoolValue restrictDirectTableAccess_;
                private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> restrictDirectTableAccessBuilder_;
                private BoolValue restrictQueryResult_;
                private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> restrictQueryResultBuilder_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_fieldAccessorTable.ensureFieldAccessorsInitialized(RestrictedExportPolicy.class, Builder.class);
                }

                private Builder() {
                    this.maybeForceBuilderInitialization();
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                    this.maybeForceBuilderInitialization();
                }

                private void maybeForceBuilderInitialization() {
                    if (alwaysUseFieldBuilders) {
                        this.getEnabledFieldBuilder();
                        this.getRestrictDirectTableAccessFieldBuilder();
                        this.getRestrictQueryResultFieldBuilder();
                    }
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.enabled_ = null;
                    if (this.enabledBuilder_ != null) {
                        this.enabledBuilder_.dispose();
                        this.enabledBuilder_ = null;
                    }
                    this.restrictDirectTableAccess_ = null;
                    if (this.restrictDirectTableAccessBuilder_ != null) {
                        this.restrictDirectTableAccessBuilder_.dispose();
                        this.restrictDirectTableAccessBuilder_ = null;
                    }
                    this.restrictQueryResult_ = null;
                    if (this.restrictQueryResultBuilder_ != null) {
                        this.restrictQueryResultBuilder_.dispose();
                        this.restrictQueryResultBuilder_ = null;
                    }
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_descriptor;
                }

                public RestrictedExportPolicy getDefaultInstanceForType() {
                    return RestrictedExportPolicy.getDefaultInstance();
                }

                public RestrictedExportPolicy build() {
                    RestrictedExportPolicy result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public RestrictedExportPolicy buildPartial() {
                    RestrictedExportPolicy result = new RestrictedExportPolicy(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(RestrictedExportPolicy result) {
                    int from_bitField0_ = this.bitField0_;
                    int to_bitField0_ = 0;
                    if ((from_bitField0_ & 1) != 0) {
                        result.enabled_ = this.enabledBuilder_ == null ? this.enabled_ : (BoolValue)this.enabledBuilder_.build();
                        to_bitField0_ |= 1;
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.restrictDirectTableAccess_ = this.restrictDirectTableAccessBuilder_ == null ? this.restrictDirectTableAccess_ : (BoolValue)this.restrictDirectTableAccessBuilder_.build();
                        to_bitField0_ |= 2;
                    }
                    if ((from_bitField0_ & 4) != 0) {
                        result.restrictQueryResult_ = this.restrictQueryResultBuilder_ == null ? this.restrictQueryResult_ : (BoolValue)this.restrictQueryResultBuilder_.build();
                        to_bitField0_ |= 4;
                    }
                    RestrictedExportPolicy restrictedExportPolicy = result;
                    restrictedExportPolicy.bitField0_ = restrictedExportPolicy.bitField0_ | to_bitField0_;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof RestrictedExportPolicy) {
                        return this.mergeFrom((RestrictedExportPolicy)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(RestrictedExportPolicy other) {
                    if (other == RestrictedExportPolicy.getDefaultInstance()) {
                        return this;
                    }
                    if (other.hasEnabled()) {
                        this.mergeEnabled(other.getEnabled());
                    }
                    if (other.hasRestrictDirectTableAccess()) {
                        this.mergeRestrictDirectTableAccess(other.getRestrictDirectTableAccess());
                    }
                    if (other.hasRestrictQueryResult()) {
                        this.mergeRestrictQueryResult(other.getRestrictQueryResult());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block11: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block11;
                                }
                                case 10: {
                                    input.readMessage((MessageLite.Builder)this.getEnabledFieldBuilder().getBuilder(), extensionRegistry);
                                    this.bitField0_ |= 1;
                                    continue block11;
                                }
                                case 18: {
                                    input.readMessage((MessageLite.Builder)this.getRestrictDirectTableAccessFieldBuilder().getBuilder(), extensionRegistry);
                                    this.bitField0_ |= 2;
                                    continue block11;
                                }
                                case 26: {
                                    input.readMessage((MessageLite.Builder)this.getRestrictQueryResultFieldBuilder().getBuilder(), extensionRegistry);
                                    this.bitField0_ |= 4;
                                    continue block11;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasEnabled() {
                    return (this.bitField0_ & 1) != 0;
                }

                @Override
                public BoolValue getEnabled() {
                    if (this.enabledBuilder_ == null) {
                        return this.enabled_ == null ? BoolValue.getDefaultInstance() : this.enabled_;
                    }
                    return (BoolValue)this.enabledBuilder_.getMessage();
                }

                public Builder setEnabled(BoolValue value) {
                    if (this.enabledBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.enabled_ = value;
                    } else {
                        this.enabledBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder setEnabled(BoolValue.Builder builderForValue) {
                    if (this.enabledBuilder_ == null) {
                        this.enabled_ = builderForValue.build();
                    } else {
                        this.enabledBuilder_.setMessage((AbstractMessage)builderForValue.build());
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder mergeEnabled(BoolValue value) {
                    if (this.enabledBuilder_ == null) {
                        if ((this.bitField0_ & 1) != 0 && this.enabled_ != null && this.enabled_ != BoolValue.getDefaultInstance()) {
                            this.getEnabledBuilder().mergeFrom(value);
                        } else {
                            this.enabled_ = value;
                        }
                    } else {
                        this.enabledBuilder_.mergeFrom((AbstractMessage)value);
                    }
                    if (this.enabled_ != null) {
                        this.bitField0_ |= 1;
                        this.onChanged();
                    }
                    return this;
                }

                public Builder clearEnabled() {
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.enabled_ = null;
                    if (this.enabledBuilder_ != null) {
                        this.enabledBuilder_.dispose();
                        this.enabledBuilder_ = null;
                    }
                    this.onChanged();
                    return this;
                }

                public BoolValue.Builder getEnabledBuilder() {
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return (BoolValue.Builder)this.getEnabledFieldBuilder().getBuilder();
                }

                @Override
                public BoolValueOrBuilder getEnabledOrBuilder() {
                    if (this.enabledBuilder_ != null) {
                        return (BoolValueOrBuilder)this.enabledBuilder_.getMessageOrBuilder();
                    }
                    return this.enabled_ == null ? BoolValue.getDefaultInstance() : this.enabled_;
                }

                private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> getEnabledFieldBuilder() {
                    if (this.enabledBuilder_ == null) {
                        this.enabledBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEnabled(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.enabled_ = null;
                    }
                    return this.enabledBuilder_;
                }

                @Override
                public boolean hasRestrictDirectTableAccess() {
                    return (this.bitField0_ & 2) != 0;
                }

                @Override
                public BoolValue getRestrictDirectTableAccess() {
                    if (this.restrictDirectTableAccessBuilder_ == null) {
                        return this.restrictDirectTableAccess_ == null ? BoolValue.getDefaultInstance() : this.restrictDirectTableAccess_;
                    }
                    return (BoolValue)this.restrictDirectTableAccessBuilder_.getMessage();
                }

                public Builder setRestrictDirectTableAccess(BoolValue value) {
                    if (this.restrictDirectTableAccessBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.restrictDirectTableAccess_ = value;
                    } else {
                        this.restrictDirectTableAccessBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder setRestrictDirectTableAccess(BoolValue.Builder builderForValue) {
                    if (this.restrictDirectTableAccessBuilder_ == null) {
                        this.restrictDirectTableAccess_ = builderForValue.build();
                    } else {
                        this.restrictDirectTableAccessBuilder_.setMessage((AbstractMessage)builderForValue.build());
                    }
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder mergeRestrictDirectTableAccess(BoolValue value) {
                    if (this.restrictDirectTableAccessBuilder_ == null) {
                        if ((this.bitField0_ & 2) != 0 && this.restrictDirectTableAccess_ != null && this.restrictDirectTableAccess_ != BoolValue.getDefaultInstance()) {
                            this.getRestrictDirectTableAccessBuilder().mergeFrom(value);
                        } else {
                            this.restrictDirectTableAccess_ = value;
                        }
                    } else {
                        this.restrictDirectTableAccessBuilder_.mergeFrom((AbstractMessage)value);
                    }
                    if (this.restrictDirectTableAccess_ != null) {
                        this.bitField0_ |= 2;
                        this.onChanged();
                    }
                    return this;
                }

                public Builder clearRestrictDirectTableAccess() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.restrictDirectTableAccess_ = null;
                    if (this.restrictDirectTableAccessBuilder_ != null) {
                        this.restrictDirectTableAccessBuilder_.dispose();
                        this.restrictDirectTableAccessBuilder_ = null;
                    }
                    this.onChanged();
                    return this;
                }

                public BoolValue.Builder getRestrictDirectTableAccessBuilder() {
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return (BoolValue.Builder)this.getRestrictDirectTableAccessFieldBuilder().getBuilder();
                }

                @Override
                public BoolValueOrBuilder getRestrictDirectTableAccessOrBuilder() {
                    if (this.restrictDirectTableAccessBuilder_ != null) {
                        return (BoolValueOrBuilder)this.restrictDirectTableAccessBuilder_.getMessageOrBuilder();
                    }
                    return this.restrictDirectTableAccess_ == null ? BoolValue.getDefaultInstance() : this.restrictDirectTableAccess_;
                }

                private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> getRestrictDirectTableAccessFieldBuilder() {
                    if (this.restrictDirectTableAccessBuilder_ == null) {
                        this.restrictDirectTableAccessBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRestrictDirectTableAccess(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.restrictDirectTableAccess_ = null;
                    }
                    return this.restrictDirectTableAccessBuilder_;
                }

                @Override
                public boolean hasRestrictQueryResult() {
                    return (this.bitField0_ & 4) != 0;
                }

                @Override
                public BoolValue getRestrictQueryResult() {
                    if (this.restrictQueryResultBuilder_ == null) {
                        return this.restrictQueryResult_ == null ? BoolValue.getDefaultInstance() : this.restrictQueryResult_;
                    }
                    return (BoolValue)this.restrictQueryResultBuilder_.getMessage();
                }

                public Builder setRestrictQueryResult(BoolValue value) {
                    if (this.restrictQueryResultBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.restrictQueryResult_ = value;
                    } else {
                        this.restrictQueryResultBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.bitField0_ |= 4;
                    this.onChanged();
                    return this;
                }

                public Builder setRestrictQueryResult(BoolValue.Builder builderForValue) {
                    if (this.restrictQueryResultBuilder_ == null) {
                        this.restrictQueryResult_ = builderForValue.build();
                    } else {
                        this.restrictQueryResultBuilder_.setMessage((AbstractMessage)builderForValue.build());
                    }
                    this.bitField0_ |= 4;
                    this.onChanged();
                    return this;
                }

                public Builder mergeRestrictQueryResult(BoolValue value) {
                    if (this.restrictQueryResultBuilder_ == null) {
                        if ((this.bitField0_ & 4) != 0 && this.restrictQueryResult_ != null && this.restrictQueryResult_ != BoolValue.getDefaultInstance()) {
                            this.getRestrictQueryResultBuilder().mergeFrom(value);
                        } else {
                            this.restrictQueryResult_ = value;
                        }
                    } else {
                        this.restrictQueryResultBuilder_.mergeFrom((AbstractMessage)value);
                    }
                    if (this.restrictQueryResult_ != null) {
                        this.bitField0_ |= 4;
                        this.onChanged();
                    }
                    return this;
                }

                public Builder clearRestrictQueryResult() {
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.restrictQueryResult_ = null;
                    if (this.restrictQueryResultBuilder_ != null) {
                        this.restrictQueryResultBuilder_.dispose();
                        this.restrictQueryResultBuilder_ = null;
                    }
                    this.onChanged();
                    return this;
                }

                public BoolValue.Builder getRestrictQueryResultBuilder() {
                    this.bitField0_ |= 4;
                    this.onChanged();
                    return (BoolValue.Builder)this.getRestrictQueryResultFieldBuilder().getBuilder();
                }

                @Override
                public BoolValueOrBuilder getRestrictQueryResultOrBuilder() {
                    if (this.restrictQueryResultBuilder_ != null) {
                        return (BoolValueOrBuilder)this.restrictQueryResultBuilder_.getMessageOrBuilder();
                    }
                    return this.restrictQueryResult_ == null ? BoolValue.getDefaultInstance() : this.restrictQueryResult_;
                }

                private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> getRestrictQueryResultFieldBuilder() {
                    if (this.restrictQueryResultBuilder_ == null) {
                        this.restrictQueryResultBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRestrictQueryResult(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.restrictQueryResult_ = null;
                    }
                    return this.restrictQueryResultBuilder_;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface RestrictedExportPolicyOrBuilder
        extends MessageOrBuilder {
            public boolean hasEnabled();

            public BoolValue getEnabled();

            public BoolValueOrBuilder getEnabledOrBuilder();

            public boolean hasRestrictDirectTableAccess();

            public BoolValue getRestrictDirectTableAccess();

            public BoolValueOrBuilder getRestrictDirectTableAccessOrBuilder();

            public boolean hasRestrictQueryResult();

            public BoolValue getRestrictQueryResult();

            public BoolValueOrBuilder getRestrictQueryResultOrBuilder();
        }

        public static final class SelectedResource
        extends GeneratedMessageV3
        implements SelectedResourceOrBuilder {
            private static final long serialVersionUID = 0L;
            private int resourceCase_ = 0;
            private Object resource_;
            public static final int TABLE_FIELD_NUMBER = 1;
            public static final int ROUTINE_FIELD_NUMBER = 2;
            private byte memoizedIsInitialized = (byte)-1;
            private static final SelectedResource DEFAULT_INSTANCE = new SelectedResource();
            private static final Parser<SelectedResource> PARSER = new AbstractParser<SelectedResource>(){

                public SelectedResource parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = SelectedResource.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private SelectedResource(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private SelectedResource() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new SelectedResource();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_fieldAccessorTable.ensureFieldAccessorsInitialized(SelectedResource.class, Builder.class);
            }

            @Override
            public ResourceCase getResourceCase() {
                return ResourceCase.forNumber(this.resourceCase_);
            }

            @Override
            public boolean hasTable() {
                return this.resourceCase_ == 1;
            }

            @Override
            public String getTable() {
                Object ref = "";
                if (this.resourceCase_ == 1) {
                    ref = this.resource_;
                }
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.resourceCase_ == 1) {
                    this.resource_ = s;
                }
                return s;
            }

            @Override
            public ByteString getTableBytes() {
                Object ref = "";
                if (this.resourceCase_ == 1) {
                    ref = this.resource_;
                }
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    if (this.resourceCase_ == 1) {
                        this.resource_ = b;
                    }
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public boolean hasRoutine() {
                return this.resourceCase_ == 2;
            }

            @Override
            public String getRoutine() {
                Object ref = "";
                if (this.resourceCase_ == 2) {
                    ref = this.resource_;
                }
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.resourceCase_ == 2) {
                    this.resource_ = s;
                }
                return s;
            }

            @Override
            public ByteString getRoutineBytes() {
                Object ref = "";
                if (this.resourceCase_ == 2) {
                    ref = this.resource_;
                }
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    if (this.resourceCase_ == 2) {
                        this.resource_ = b;
                    }
                    return b;
                }
                return (ByteString)ref;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if (this.resourceCase_ == 1) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resource_);
                }
                if (this.resourceCase_ == 2) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.resource_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (this.resourceCase_ == 1) {
                    size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resource_);
                }
                if (this.resourceCase_ == 2) {
                    size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.resource_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof SelectedResource)) {
                    return super.equals(obj);
                }
                SelectedResource other = (SelectedResource)obj;
                if (!this.getResourceCase().equals((Object)other.getResourceCase())) {
                    return false;
                }
                switch (this.resourceCase_) {
                    case 1: {
                        if (this.getTable().equals(other.getTable())) break;
                        return false;
                    }
                    case 2: {
                        if (this.getRoutine().equals(other.getRoutine())) break;
                        return false;
                    }
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + SelectedResource.getDescriptor().hashCode();
                switch (this.resourceCase_) {
                    case 1: {
                        hash = 37 * hash + 1;
                        hash = 53 * hash + this.getTable().hashCode();
                        break;
                    }
                    case 2: {
                        hash = 37 * hash + 2;
                        hash = 53 * hash + this.getRoutine().hashCode();
                        break;
                    }
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static SelectedResource parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (SelectedResource)PARSER.parseFrom(data);
            }

            public static SelectedResource parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (SelectedResource)PARSER.parseFrom(data, extensionRegistry);
            }

            public static SelectedResource parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (SelectedResource)PARSER.parseFrom(data);
            }

            public static SelectedResource parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (SelectedResource)PARSER.parseFrom(data, extensionRegistry);
            }

            public static SelectedResource parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (SelectedResource)PARSER.parseFrom(data);
            }

            public static SelectedResource parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (SelectedResource)PARSER.parseFrom(data, extensionRegistry);
            }

            public static SelectedResource parseFrom(InputStream input) throws IOException {
                return (SelectedResource)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static SelectedResource parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (SelectedResource)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static SelectedResource parseDelimitedFrom(InputStream input) throws IOException {
                return (SelectedResource)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static SelectedResource parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (SelectedResource)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static SelectedResource parseFrom(CodedInputStream input) throws IOException {
                return (SelectedResource)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static SelectedResource parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (SelectedResource)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return SelectedResource.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(SelectedResource prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static SelectedResource getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<SelectedResource> parser() {
                return PARSER;
            }

            public Parser<SelectedResource> getParserForType() {
                return PARSER;
            }

            public SelectedResource getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements SelectedResourceOrBuilder {
                private int resourceCase_ = 0;
                private Object resource_;
                private int bitField0_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_fieldAccessorTable.ensureFieldAccessorsInitialized(SelectedResource.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.resourceCase_ = 0;
                    this.resource_ = null;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return AnalyticsHubProto.internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_descriptor;
                }

                public SelectedResource getDefaultInstanceForType() {
                    return SelectedResource.getDefaultInstance();
                }

                public SelectedResource build() {
                    SelectedResource result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public SelectedResource buildPartial() {
                    SelectedResource result = new SelectedResource(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.buildPartialOneofs(result);
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(SelectedResource result) {
                    int from_bitField0_ = this.bitField0_;
                }

                private void buildPartialOneofs(SelectedResource result) {
                    result.resourceCase_ = this.resourceCase_;
                    result.resource_ = this.resource_;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof SelectedResource) {
                        return this.mergeFrom((SelectedResource)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(SelectedResource other) {
                    if (other == SelectedResource.getDefaultInstance()) {
                        return this;
                    }
                    switch (other.getResourceCase()) {
                        case TABLE: {
                            this.resourceCase_ = 1;
                            this.resource_ = other.resource_;
                            this.onChanged();
                            break;
                        }
                        case ROUTINE: {
                            this.resourceCase_ = 2;
                            this.resource_ = other.resource_;
                            this.onChanged();
                            break;
                        }
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 10: {
                                    String s = input.readStringRequireUtf8();
                                    this.resourceCase_ = 1;
                                    this.resource_ = s;
                                    continue block10;
                                }
                                case 18: {
                                    String s = input.readStringRequireUtf8();
                                    this.resourceCase_ = 2;
                                    this.resource_ = s;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public ResourceCase getResourceCase() {
                    return ResourceCase.forNumber(this.resourceCase_);
                }

                public Builder clearResource() {
                    this.resourceCase_ = 0;
                    this.resource_ = null;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasTable() {
                    return this.resourceCase_ == 1;
                }

                @Override
                public String getTable() {
                    Object ref = "";
                    if (this.resourceCase_ == 1) {
                        ref = this.resource_;
                    }
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        if (this.resourceCase_ == 1) {
                            this.resource_ = s;
                        }
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getTableBytes() {
                    Object ref = "";
                    if (this.resourceCase_ == 1) {
                        ref = this.resource_;
                    }
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        if (this.resourceCase_ == 1) {
                            this.resource_ = b;
                        }
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setTable(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.resourceCase_ = 1;
                    this.resource_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearTable() {
                    if (this.resourceCase_ == 1) {
                        this.resourceCase_ = 0;
                        this.resource_ = null;
                        this.onChanged();
                    }
                    return this;
                }

                public Builder setTableBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    SelectedResource.checkByteStringIsUtf8((ByteString)value);
                    this.resourceCase_ = 1;
                    this.resource_ = value;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasRoutine() {
                    return this.resourceCase_ == 2;
                }

                @Override
                public String getRoutine() {
                    Object ref = "";
                    if (this.resourceCase_ == 2) {
                        ref = this.resource_;
                    }
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        if (this.resourceCase_ == 2) {
                            this.resource_ = s;
                        }
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getRoutineBytes() {
                    Object ref = "";
                    if (this.resourceCase_ == 2) {
                        ref = this.resource_;
                    }
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        if (this.resourceCase_ == 2) {
                            this.resource_ = b;
                        }
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setRoutine(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.resourceCase_ = 2;
                    this.resource_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearRoutine() {
                    if (this.resourceCase_ == 2) {
                        this.resourceCase_ = 0;
                        this.resource_ = null;
                        this.onChanged();
                    }
                    return this;
                }

                public Builder setRoutineBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    SelectedResource.checkByteStringIsUtf8((ByteString)value);
                    this.resourceCase_ = 2;
                    this.resource_ = value;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static enum ResourceCase implements Internal.EnumLite,
            AbstractMessageLite.InternalOneOfEnum
            {
                TABLE(1),
                ROUTINE(2),
                RESOURCE_NOT_SET(0);

                private final int value;

                private ResourceCase(int value) {
                    this.value = value;
                }

                @Deprecated
                public static ResourceCase valueOf(int value) {
                    return ResourceCase.forNumber(value);
                }

                public static ResourceCase forNumber(int value) {
                    switch (value) {
                        case 1: {
                            return TABLE;
                        }
                        case 2: {
                            return ROUTINE;
                        }
                        case 0: {
                            return RESOURCE_NOT_SET;
                        }
                    }
                    return null;
                }

                public int getNumber() {
                    return this.value;
                }
            }
        }

        public static interface SelectedResourceOrBuilder
        extends MessageOrBuilder {
            public boolean hasTable();

            public String getTable();

            public ByteString getTableBytes();

            public boolean hasRoutine();

            public String getRoutine();

            public ByteString getRoutineBytes();

            public SelectedResource.ResourceCase getResourceCase();
        }
    }

    public static interface BigQueryDatasetSourceOrBuilder
    extends MessageOrBuilder {
        public String getDataset();

        public ByteString getDatasetBytes();

        public List<BigQueryDatasetSource.SelectedResource> getSelectedResourcesList();

        public BigQueryDatasetSource.SelectedResource getSelectedResources(int var1);

        public int getSelectedResourcesCount();

        public List<? extends BigQueryDatasetSource.SelectedResourceOrBuilder> getSelectedResourcesOrBuilderList();

        public BigQueryDatasetSource.SelectedResourceOrBuilder getSelectedResourcesOrBuilder(int var1);

        public boolean hasRestrictedExportPolicy();

        public BigQueryDatasetSource.RestrictedExportPolicy getRestrictedExportPolicy();

        public BigQueryDatasetSource.RestrictedExportPolicyOrBuilder getRestrictedExportPolicyOrBuilder();

        public List<String> getReplicaLocationsList();

        public int getReplicaLocationsCount();

        public String getReplicaLocations(int var1);

        public ByteString getReplicaLocationsBytes(int var1);

        public List<BigQueryDatasetSource.Replica> getEffectiveReplicasList();

        public BigQueryDatasetSource.Replica getEffectiveReplicas(int var1);

        public int getEffectiveReplicasCount();

        public List<? extends BigQueryDatasetSource.ReplicaOrBuilder> getEffectiveReplicasOrBuilderList();

        public BigQueryDatasetSource.ReplicaOrBuilder getEffectiveReplicasOrBuilder(int var1);
    }

    public static enum Category implements ProtocolMessageEnum
    {
        CATEGORY_UNSPECIFIED(0),
        CATEGORY_OTHERS(1),
        CATEGORY_ADVERTISING_AND_MARKETING(2),
        CATEGORY_COMMERCE(3),
        CATEGORY_CLIMATE_AND_ENVIRONMENT(4),
        CATEGORY_DEMOGRAPHICS(5),
        CATEGORY_ECONOMICS(6),
        CATEGORY_EDUCATION(7),
        CATEGORY_ENERGY(8),
        CATEGORY_FINANCIAL(9),
        CATEGORY_GAMING(10),
        CATEGORY_GEOSPATIAL(11),
        CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE(12),
        CATEGORY_MEDIA(13),
        CATEGORY_PUBLIC_SECTOR(14),
        CATEGORY_RETAIL(15),
        CATEGORY_SPORTS(16),
        CATEGORY_SCIENCE_AND_RESEARCH(17),
        CATEGORY_TRANSPORTATION_AND_LOGISTICS(18),
        CATEGORY_TRAVEL_AND_TOURISM(19),
        CATEGORY_GOOGLE_EARTH_ENGINE(20),
        UNRECOGNIZED(-1);

        public static final int CATEGORY_UNSPECIFIED_VALUE = 0;
        public static final int CATEGORY_OTHERS_VALUE = 1;
        public static final int CATEGORY_ADVERTISING_AND_MARKETING_VALUE = 2;
        public static final int CATEGORY_COMMERCE_VALUE = 3;
        public static final int CATEGORY_CLIMATE_AND_ENVIRONMENT_VALUE = 4;
        public static final int CATEGORY_DEMOGRAPHICS_VALUE = 5;
        public static final int CATEGORY_ECONOMICS_VALUE = 6;
        public static final int CATEGORY_EDUCATION_VALUE = 7;
        public static final int CATEGORY_ENERGY_VALUE = 8;
        public static final int CATEGORY_FINANCIAL_VALUE = 9;
        public static final int CATEGORY_GAMING_VALUE = 10;
        public static final int CATEGORY_GEOSPATIAL_VALUE = 11;
        public static final int CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE_VALUE = 12;
        public static final int CATEGORY_MEDIA_VALUE = 13;
        public static final int CATEGORY_PUBLIC_SECTOR_VALUE = 14;
        public static final int CATEGORY_RETAIL_VALUE = 15;
        public static final int CATEGORY_SPORTS_VALUE = 16;
        public static final int CATEGORY_SCIENCE_AND_RESEARCH_VALUE = 17;
        public static final int CATEGORY_TRANSPORTATION_AND_LOGISTICS_VALUE = 18;
        public static final int CATEGORY_TRAVEL_AND_TOURISM_VALUE = 19;
        public static final int CATEGORY_GOOGLE_EARTH_ENGINE_VALUE = 20;
        private static final Internal.EnumLiteMap<Category> internalValueMap;
        private static final Category[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Category valueOf(int value) {
            return Category.forNumber(value);
        }

        public static Category forNumber(int value) {
            switch (value) {
                case 0: {
                    return CATEGORY_UNSPECIFIED;
                }
                case 1: {
                    return CATEGORY_OTHERS;
                }
                case 2: {
                    return CATEGORY_ADVERTISING_AND_MARKETING;
                }
                case 3: {
                    return CATEGORY_COMMERCE;
                }
                case 4: {
                    return CATEGORY_CLIMATE_AND_ENVIRONMENT;
                }
                case 5: {
                    return CATEGORY_DEMOGRAPHICS;
                }
                case 6: {
                    return CATEGORY_ECONOMICS;
                }
                case 7: {
                    return CATEGORY_EDUCATION;
                }
                case 8: {
                    return CATEGORY_ENERGY;
                }
                case 9: {
                    return CATEGORY_FINANCIAL;
                }
                case 10: {
                    return CATEGORY_GAMING;
                }
                case 11: {
                    return CATEGORY_GEOSPATIAL;
                }
                case 12: {
                    return CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE;
                }
                case 13: {
                    return CATEGORY_MEDIA;
                }
                case 14: {
                    return CATEGORY_PUBLIC_SECTOR;
                }
                case 15: {
                    return CATEGORY_RETAIL;
                }
                case 16: {
                    return CATEGORY_SPORTS;
                }
                case 17: {
                    return CATEGORY_SCIENCE_AND_RESEARCH;
                }
                case 18: {
                    return CATEGORY_TRANSPORTATION_AND_LOGISTICS;
                }
                case 19: {
                    return CATEGORY_TRAVEL_AND_TOURISM;
                }
                case 20: {
                    return CATEGORY_GOOGLE_EARTH_ENGINE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Category> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Category.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Category.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Listing.getDescriptor().getEnumTypes().get(1);
        }

        public static Category valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Category.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Category(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Category>(){

                public Category findValueByNumber(int number) {
                    return Category.forNumber(number);
                }
            };
            VALUES = Category.values();
        }
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        ACTIVE(1),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int ACTIVE_VALUE = 1;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return ACTIVE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Listing.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

