/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

/**
 *
 *
 * <pre>
 * A subscription represents a subscribers' access to a particular set of
 * published data. It contains references to associated listings,
 * data exchanges, and linked datasets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Subscription}
 */
public final class Subscription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Subscription)
    SubscriptionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Subscription.newBuilder() to construct.
  private Subscription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Subscription() {
    name_ = "";
    organizationId_ = "";
    organizationDisplayName_ = "";
    state_ = 0;
    subscriberContact_ = "";
    linkedResources_ = java.util.Collections.emptyList();
    resourceType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Subscription();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetLinkedDatasetMap();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.analyticshub.v1.Subscription.class,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the subscription.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.analyticshub.v1.Subscription.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This subscription is active and the data is accessible.
     * </pre>
     *
     * <code>STATE_ACTIVE = 1;</code>
     */
    STATE_ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The data referenced by this subscription is out of date and should be
     * refreshed. This can happen when a data provider adds or removes datasets.
     * </pre>
     *
     * <code>STATE_STALE = 2;</code>
     */
    STATE_STALE(2),
    /**
     *
     *
     * <pre>
     * This subscription has been cancelled or revoked and the data is no longer
     * accessible.
     * </pre>
     *
     * <code>STATE_INACTIVE = 3;</code>
     */
    STATE_INACTIVE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * This subscription is active and the data is accessible.
     * </pre>
     *
     * <code>STATE_ACTIVE = 1;</code>
     */
    public static final int STATE_ACTIVE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The data referenced by this subscription is out of date and should be
     * refreshed. This can happen when a data provider adds or removes datasets.
     * </pre>
     *
     * <code>STATE_STALE = 2;</code>
     */
    public static final int STATE_STALE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * This subscription has been cancelled or revoked and the data is no longer
     * accessible.
     * </pre>
     *
     * <code>STATE_INACTIVE = 3;</code>
     */
    public static final int STATE_INACTIVE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STATE_ACTIVE;
        case 2:
          return STATE_STALE;
        case 3:
          return STATE_INACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.Subscription.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.analyticshub.v1.Subscription.State)
  }

  public interface LinkedResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Name of the linked dataset, e.g.
     * projects/subscriberproject/datasets/linked_dataset
     * </pre>
     *
     * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the linkedDataset field is set.
     */
    boolean hasLinkedDataset();

    /**
     *
     *
     * <pre>
     * Output only. Name of the linked dataset, e.g.
     * projects/subscriberproject/datasets/linked_dataset
     * </pre>
     *
     * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The linkedDataset.
     */
    java.lang.String getLinkedDataset();

    /**
     *
     *
     * <pre>
     * Output only. Name of the linked dataset, e.g.
     * projects/subscriberproject/datasets/linked_dataset
     * </pre>
     *
     * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for linkedDataset.
     */
    com.google.protobuf.ByteString getLinkedDatasetBytes();

    /**
     *
     *
     * <pre>
     * Output only. Name of the Pub/Sub subscription, e.g.
     * projects/subscriberproject/subscriptions/subscriptions/sub_id
     * </pre>
     *
     * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the linkedPubsubSubscription field is set.
     */
    boolean hasLinkedPubsubSubscription();

    /**
     *
     *
     * <pre>
     * Output only. Name of the Pub/Sub subscription, e.g.
     * projects/subscriberproject/subscriptions/subscriptions/sub_id
     * </pre>
     *
     * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The linkedPubsubSubscription.
     */
    java.lang.String getLinkedPubsubSubscription();

    /**
     *
     *
     * <pre>
     * Output only. Name of the Pub/Sub subscription, e.g.
     * projects/subscriberproject/subscriptions/subscriptions/sub_id
     * </pre>
     *
     * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for linkedPubsubSubscription.
     */
    com.google.protobuf.ByteString getLinkedPubsubSubscriptionBytes();

    /**
     *
     *
     * <pre>
     * Output only. Listing for which linked resource is created.
     * </pre>
     *
     * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The listing.
     */
    java.lang.String getListing();

    /**
     *
     *
     * <pre>
     * Output only. Listing for which linked resource is created.
     * </pre>
     *
     * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for listing.
     */
    com.google.protobuf.ByteString getListingBytes();

    com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.ReferenceCase
        getReferenceCase();
  }

  /**
   *
   *
   * <pre>
   * Reference to a linked resource tracked by this Subscription.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource}
   */
  public static final class LinkedResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource)
      LinkedResourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use LinkedResource.newBuilder() to construct.
    private LinkedResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LinkedResource() {
      listing_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LinkedResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_LinkedResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_LinkedResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.class,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder.class);
    }

    private int referenceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object reference_;

    public enum ReferenceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      LINKED_DATASET(1),
      LINKED_PUBSUB_SUBSCRIPTION(3),
      REFERENCE_NOT_SET(0);
      private final int value;

      private ReferenceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ReferenceCase valueOf(int value) {
        return forNumber(value);
      }

      public static ReferenceCase forNumber(int value) {
        switch (value) {
          case 1:
            return LINKED_DATASET;
          case 3:
            return LINKED_PUBSUB_SUBSCRIPTION;
          case 0:
            return REFERENCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ReferenceCase getReferenceCase() {
      return ReferenceCase.forNumber(referenceCase_);
    }

    public static final int LINKED_DATASET_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Output only. Name of the linked dataset, e.g.
     * projects/subscriberproject/datasets/linked_dataset
     * </pre>
     *
     * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the linkedDataset field is set.
     */
    public boolean hasLinkedDataset() {
      return referenceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the linked dataset, e.g.
     * projects/subscriberproject/datasets/linked_dataset
     * </pre>
     *
     * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The linkedDataset.
     */
    public java.lang.String getLinkedDataset() {
      java.lang.Object ref = "";
      if (referenceCase_ == 1) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 1) {
          reference_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the linked dataset, e.g.
     * projects/subscriberproject/datasets/linked_dataset
     * </pre>
     *
     * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for linkedDataset.
     */
    public com.google.protobuf.ByteString getLinkedDatasetBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 1) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 1) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LINKED_PUBSUB_SUBSCRIPTION_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Output only. Name of the Pub/Sub subscription, e.g.
     * projects/subscriberproject/subscriptions/subscriptions/sub_id
     * </pre>
     *
     * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the linkedPubsubSubscription field is set.
     */
    public boolean hasLinkedPubsubSubscription() {
      return referenceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the Pub/Sub subscription, e.g.
     * projects/subscriberproject/subscriptions/subscriptions/sub_id
     * </pre>
     *
     * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The linkedPubsubSubscription.
     */
    public java.lang.String getLinkedPubsubSubscription() {
      java.lang.Object ref = "";
      if (referenceCase_ == 3) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 3) {
          reference_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the Pub/Sub subscription, e.g.
     * projects/subscriberproject/subscriptions/subscriptions/sub_id
     * </pre>
     *
     * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for linkedPubsubSubscription.
     */
    public com.google.protobuf.ByteString getLinkedPubsubSubscriptionBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 3) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 3) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LISTING_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object listing_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Listing for which linked resource is created.
     * </pre>
     *
     * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The listing.
     */
    @java.lang.Override
    public java.lang.String getListing() {
      java.lang.Object ref = listing_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        listing_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing for which linked resource is created.
     * </pre>
     *
     * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for listing.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getListingBytes() {
      java.lang.Object ref = listing_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        listing_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (referenceCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, reference_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(listing_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, listing_);
      }
      if (referenceCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, reference_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (referenceCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, reference_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(listing_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, listing_);
      }
      if (referenceCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, reference_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource other =
          (com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) obj;

      if (!getListing().equals(other.getListing())) return false;
      if (!getReferenceCase().equals(other.getReferenceCase())) return false;
      switch (referenceCase_) {
        case 1:
          if (!getLinkedDataset().equals(other.getLinkedDataset())) return false;
          break;
        case 3:
          if (!getLinkedPubsubSubscription().equals(other.getLinkedPubsubSubscription()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LISTING_FIELD_NUMBER;
      hash = (53 * hash) + getListing().hashCode();
      switch (referenceCase_) {
        case 1:
          hash = (37 * hash) + LINKED_DATASET_FIELD_NUMBER;
          hash = (53 * hash) + getLinkedDataset().hashCode();
          break;
        case 3:
          hash = (37 * hash) + LINKED_PUBSUB_SUBSCRIPTION_FIELD_NUMBER;
          hash = (53 * hash) + getLinkedPubsubSubscription().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Reference to a linked resource tracked by this Subscription.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource)
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_LinkedResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_LinkedResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.class,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        listing_ = "";
        referenceCase_ = 0;
        reference_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_LinkedResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource build() {
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource buildPartial() {
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource result =
            new com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.listing_ = listing_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource result) {
        result.referenceCase_ = referenceCase_;
        result.reference_ = this.reference_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) {
          return mergeFrom(
              (com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource other) {
        if (other
            == com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
                .getDefaultInstance()) return this;
        if (!other.getListing().isEmpty()) {
          listing_ = other.listing_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getReferenceCase()) {
          case LINKED_DATASET:
            {
              referenceCase_ = 1;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case LINKED_PUBSUB_SUBSCRIPTION:
            {
              referenceCase_ = 3;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case REFERENCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 1;
                  reference_ = s;
                  break;
                } // case 10
              case 18:
                {
                  listing_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 3;
                  reference_ = s;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int referenceCase_ = 0;
      private java.lang.Object reference_;

      public ReferenceCase getReferenceCase() {
        return ReferenceCase.forNumber(referenceCase_);
      }

      public Builder clearReference() {
        referenceCase_ = 0;
        reference_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Output only. Name of the linked dataset, e.g.
       * projects/subscriberproject/datasets/linked_dataset
       * </pre>
       *
       * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the linkedDataset field is set.
       */
      @java.lang.Override
      public boolean hasLinkedDataset() {
        return referenceCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the linked dataset, e.g.
       * projects/subscriberproject/datasets/linked_dataset
       * </pre>
       *
       * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The linkedDataset.
       */
      @java.lang.Override
      public java.lang.String getLinkedDataset() {
        java.lang.Object ref = "";
        if (referenceCase_ == 1) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 1) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the linked dataset, e.g.
       * projects/subscriberproject/datasets/linked_dataset
       * </pre>
       *
       * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for linkedDataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLinkedDatasetBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 1) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 1) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the linked dataset, e.g.
       * projects/subscriberproject/datasets/linked_dataset
       * </pre>
       *
       * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The linkedDataset to set.
       * @return This builder for chaining.
       */
      public Builder setLinkedDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 1;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the linked dataset, e.g.
       * projects/subscriberproject/datasets/linked_dataset
       * </pre>
       *
       * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLinkedDataset() {
        if (referenceCase_ == 1) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the linked dataset, e.g.
       * projects/subscriberproject/datasets/linked_dataset
       * </pre>
       *
       * <code>string linked_dataset = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for linkedDataset to set.
       * @return This builder for chaining.
       */
      public Builder setLinkedDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 1;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the Pub/Sub subscription, e.g.
       * projects/subscriberproject/subscriptions/subscriptions/sub_id
       * </pre>
       *
       * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the linkedPubsubSubscription field is set.
       */
      @java.lang.Override
      public boolean hasLinkedPubsubSubscription() {
        return referenceCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the Pub/Sub subscription, e.g.
       * projects/subscriberproject/subscriptions/subscriptions/sub_id
       * </pre>
       *
       * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The linkedPubsubSubscription.
       */
      @java.lang.Override
      public java.lang.String getLinkedPubsubSubscription() {
        java.lang.Object ref = "";
        if (referenceCase_ == 3) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 3) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the Pub/Sub subscription, e.g.
       * projects/subscriberproject/subscriptions/subscriptions/sub_id
       * </pre>
       *
       * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for linkedPubsubSubscription.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLinkedPubsubSubscriptionBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 3) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 3) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the Pub/Sub subscription, e.g.
       * projects/subscriberproject/subscriptions/subscriptions/sub_id
       * </pre>
       *
       * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The linkedPubsubSubscription to set.
       * @return This builder for chaining.
       */
      public Builder setLinkedPubsubSubscription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 3;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the Pub/Sub subscription, e.g.
       * projects/subscriberproject/subscriptions/subscriptions/sub_id
       * </pre>
       *
       * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLinkedPubsubSubscription() {
        if (referenceCase_ == 3) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Name of the Pub/Sub subscription, e.g.
       * projects/subscriberproject/subscriptions/subscriptions/sub_id
       * </pre>
       *
       * <code>string linked_pubsub_subscription = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for linkedPubsubSubscription to set.
       * @return This builder for chaining.
       */
      public Builder setLinkedPubsubSubscriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 3;
        reference_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object listing_ = "";

      /**
       *
       *
       * <pre>
       * Output only. Listing for which linked resource is created.
       * </pre>
       *
       * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The listing.
       */
      public java.lang.String getListing() {
        java.lang.Object ref = listing_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          listing_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Listing for which linked resource is created.
       * </pre>
       *
       * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for listing.
       */
      public com.google.protobuf.ByteString getListingBytes() {
        java.lang.Object ref = listing_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          listing_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Listing for which linked resource is created.
       * </pre>
       *
       * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The listing to set.
       * @return This builder for chaining.
       */
      public Builder setListing(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        listing_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Listing for which linked resource is created.
       * </pre>
       *
       * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearListing() {
        listing_ = getDefaultInstance().getListing();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Listing for which linked resource is created.
       * </pre>
       *
       * <code>string listing = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for listing to set.
       * @return This builder for chaining.
       */
      public Builder setListingBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        listing_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource)
    private static final com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource();
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LinkedResource> PARSER =
        new com.google.protobuf.AbstractParser<LinkedResource>() {
          @java.lang.Override
          public LinkedResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LinkedResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LinkedResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CommercialInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. This is set when the subscription is commercialised via
     * Cloud Marketplace.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudMarketplace field is set.
     */
    boolean hasCloudMarketplace();

    /**
     *
     *
     * <pre>
     * Output only. This is set when the subscription is commercialised via
     * Cloud Marketplace.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudMarketplace.
     */
    com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo
        getCloudMarketplace();

    /**
     *
     *
     * <pre>
     * Output only. This is set when the subscription is commercialised via
     * Cloud Marketplace.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
            .GoogleCloudMarketplaceInfoOrBuilder
        getCloudMarketplaceOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Commercial info metadata for this subscription.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo}
   */
  public static final class CommercialInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo)
      CommercialInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CommercialInfo.newBuilder() to construct.
    private CommercialInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CommercialInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CommercialInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.class,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder.class);
    }

    public interface GoogleCloudMarketplaceInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Resource name of the Marketplace Order.
       * </pre>
       *
       * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The order.
       */
      java.lang.String getOrder();

      /**
       *
       *
       * <pre>
       * Resource name of the Marketplace Order.
       * </pre>
       *
       * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for order.
       */
      com.google.protobuf.ByteString getOrderBytes();
    }

    /**
     *
     *
     * <pre>
     * Cloud Marketplace commercial metadata for this subscription.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo}
     */
    public static final class GoogleCloudMarketplaceInfo
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo)
        GoogleCloudMarketplaceInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use GoogleCloudMarketplaceInfo.newBuilder() to construct.
      private GoogleCloudMarketplaceInfo(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GoogleCloudMarketplaceInfo() {
        order_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GoogleCloudMarketplaceInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_GoogleCloudMarketplaceInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                    .GoogleCloudMarketplaceInfo.class,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                    .GoogleCloudMarketplaceInfo.Builder.class);
      }

      public static final int ORDER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object order_ = "";

      /**
       *
       *
       * <pre>
       * Resource name of the Marketplace Order.
       * </pre>
       *
       * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The order.
       */
      @java.lang.Override
      public java.lang.String getOrder() {
        java.lang.Object ref = order_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          order_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Resource name of the Marketplace Order.
       * </pre>
       *
       * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for order.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOrderBytes() {
        java.lang.Object ref = order_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          order_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(order_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, order_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(order_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, order_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .GoogleCloudMarketplaceInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .GoogleCloudMarketplaceInfo
            other =
                (com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                        .GoogleCloudMarketplaceInfo)
                    obj;

        if (!getOrder().equals(other.getOrder())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ORDER_FIELD_NUMBER;
        hash = (53 * hash) + getOrder().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Cloud Marketplace commercial metadata for this subscription.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo)
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_GoogleCloudMarketplaceInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfo.class,
                  com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfo.Builder.class);
        }

        // Construct using
        // com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          order_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .GoogleCloudMarketplaceInfo
            getDefaultInstanceForType() {
          return com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .GoogleCloudMarketplaceInfo
            build() {
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .GoogleCloudMarketplaceInfo
            buildPartial() {
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              result =
                  new com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                    .GoogleCloudMarketplaceInfo
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.order_ = order_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo) {
            return mergeFrom(
                (com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                        .GoogleCloudMarketplaceInfo)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                    .GoogleCloudMarketplaceInfo
                other) {
          if (other
              == com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo.getDefaultInstance()) return this;
          if (!other.getOrder().isEmpty()) {
            order_ = other.order_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    order_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object order_ = "";

        /**
         *
         *
         * <pre>
         * Resource name of the Marketplace Order.
         * </pre>
         *
         * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The order.
         */
        public java.lang.String getOrder() {
          java.lang.Object ref = order_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            order_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Resource name of the Marketplace Order.
         * </pre>
         *
         * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for order.
         */
        public com.google.protobuf.ByteString getOrderBytes() {
          java.lang.Object ref = order_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            order_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Resource name of the Marketplace Order.
         * </pre>
         *
         * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The order to set.
         * @return This builder for chaining.
         */
        public Builder setOrder(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          order_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Resource name of the Marketplace Order.
         * </pre>
         *
         * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrder() {
          order_ = getDefaultInstance().getOrder();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Resource name of the Marketplace Order.
         * </pre>
         *
         * <code>string order = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for order to set.
         * @return This builder for chaining.
         */
        public Builder setOrderBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          order_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo)
      private static final com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .GoogleCloudMarketplaceInfo();
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GoogleCloudMarketplaceInfo> PARSER =
          new com.google.protobuf.AbstractParser<GoogleCloudMarketplaceInfo>() {
            @java.lang.Override
            public GoogleCloudMarketplaceInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GoogleCloudMarketplaceInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GoogleCloudMarketplaceInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CLOUD_MARKETPLACE_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
            .GoogleCloudMarketplaceInfo
        cloudMarketplace_;

    /**
     *
     *
     * <pre>
     * Output only. This is set when the subscription is commercialised via
     * Cloud Marketplace.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudMarketplace field is set.
     */
    @java.lang.Override
    public boolean hasCloudMarketplace() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set when the subscription is commercialised via
     * Cloud Marketplace.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudMarketplace.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
            .GoogleCloudMarketplaceInfo
        getCloudMarketplace() {
      return cloudMarketplace_ == null
          ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDefaultInstance()
          : cloudMarketplace_;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set when the subscription is commercialised via
     * Cloud Marketplace.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
            .GoogleCloudMarketplaceInfoOrBuilder
        getCloudMarketplaceOrBuilder() {
      return cloudMarketplace_ == null
          ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDefaultInstance()
          : cloudMarketplace_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCloudMarketplace());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCloudMarketplace());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo other =
          (com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo) obj;

      if (hasCloudMarketplace() != other.hasCloudMarketplace()) return false;
      if (hasCloudMarketplace()) {
        if (!getCloudMarketplace().equals(other.getCloudMarketplace())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCloudMarketplace()) {
        hash = (37 * hash) + CLOUD_MARKETPLACE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudMarketplace().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Commercial info metadata for this subscription.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo)
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.class,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getCloudMarketplaceFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cloudMarketplace_ = null;
        if (cloudMarketplaceBuilder_ != null) {
          cloudMarketplaceBuilder_.dispose();
          cloudMarketplaceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_CommercialInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo build() {
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo buildPartial() {
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo result =
            new com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cloudMarketplace_ =
              cloudMarketplaceBuilder_ == null
                  ? cloudMarketplace_
                  : cloudMarketplaceBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo) {
          return mergeFrom(
              (com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo other) {
        if (other
            == com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .getDefaultInstance()) return this;
        if (other.hasCloudMarketplace()) {
          mergeCloudMarketplace(other.getCloudMarketplace());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCloudMarketplaceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          cloudMarketplace_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfoOrBuilder>
          cloudMarketplaceBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the cloudMarketplace field is set.
       */
      public boolean hasCloudMarketplace() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The cloudMarketplace.
       */
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo
          getCloudMarketplace() {
        if (cloudMarketplaceBuilder_ == null) {
          return cloudMarketplace_ == null
              ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo.getDefaultInstance()
              : cloudMarketplace_;
        } else {
          return cloudMarketplaceBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCloudMarketplace(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              value) {
        if (cloudMarketplaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudMarketplace_ = value;
        } else {
          cloudMarketplaceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCloudMarketplace(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo.Builder
              builderForValue) {
        if (cloudMarketplaceBuilder_ == null) {
          cloudMarketplace_ = builderForValue.build();
        } else {
          cloudMarketplaceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCloudMarketplace(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              value) {
        if (cloudMarketplaceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && cloudMarketplace_ != null
              && cloudMarketplace_
                  != com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfo.getDefaultInstance()) {
            getCloudMarketplaceBuilder().mergeFrom(value);
          } else {
            cloudMarketplace_ = value;
          }
        } else {
          cloudMarketplaceBuilder_.mergeFrom(value);
        }
        if (cloudMarketplace_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCloudMarketplace() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cloudMarketplace_ = null;
        if (cloudMarketplaceBuilder_ != null) {
          cloudMarketplaceBuilder_.dispose();
          cloudMarketplaceBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfo.Builder
          getCloudMarketplaceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCloudMarketplaceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
              .GoogleCloudMarketplaceInfoOrBuilder
          getCloudMarketplaceOrBuilder() {
        if (cloudMarketplaceBuilder_ != null) {
          return cloudMarketplaceBuilder_.getMessageOrBuilder();
        } else {
          return cloudMarketplace_ == null
              ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo.getDefaultInstance()
              : cloudMarketplace_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. This is set when the subscription is commercialised via
       * Cloud Marketplace.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfo.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                  .GoogleCloudMarketplaceInfoOrBuilder>
          getCloudMarketplaceFieldBuilder() {
        if (cloudMarketplaceBuilder_ == null) {
          cloudMarketplaceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfo,
                  com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfo.Builder,
                  com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                      .GoogleCloudMarketplaceInfoOrBuilder>(
                  getCloudMarketplace(), getParentForChildren(), isClean());
          cloudMarketplace_ = null;
        }
        return cloudMarketplaceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo)
    private static final com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo();
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CommercialInfo> PARSER =
        new com.google.protobuf.AbstractParser<CommercialInfo>() {
          @java.lang.Override
          public CommercialInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CommercialInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CommercialInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int resourceNameCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object resourceName_;

  public enum ResourceNameCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LISTING(5),
    DATA_EXCHANGE(6),
    RESOURCENAME_NOT_SET(0);
    private final int value;

    private ResourceNameCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResourceNameCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResourceNameCase forNumber(int value) {
      switch (value) {
        case 5:
          return LISTING;
        case 6:
          return DATA_EXCHANGE;
        case 0:
          return RESOURCENAME_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResourceNameCase getResourceNameCase() {
    return ResourceNameCase.forNumber(resourceNameCase_);
  }

  public static final int LISTING_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Output only. Resource name of the source Listing.
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * </pre>
   *
   * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the listing field is set.
   */
  public boolean hasListing() {
    return resourceNameCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Output only. Resource name of the source Listing.
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * </pre>
   *
   * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The listing.
   */
  public java.lang.String getListing() {
    java.lang.Object ref = "";
    if (resourceNameCase_ == 5) {
      ref = resourceName_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (resourceNameCase_ == 5) {
        resourceName_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Resource name of the source Listing.
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * </pre>
   *
   * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for listing.
   */
  public com.google.protobuf.ByteString getListingBytes() {
    java.lang.Object ref = "";
    if (resourceNameCase_ == 5) {
      ref = resourceName_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (resourceNameCase_ == 5) {
        resourceName_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_EXCHANGE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Output only. Resource name of the source Data Exchange.
   * e.g. projects/123/locations/us/dataExchanges/456
   * </pre>
   *
   * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the dataExchange field is set.
   */
  public boolean hasDataExchange() {
    return resourceNameCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Output only. Resource name of the source Data Exchange.
   * e.g. projects/123/locations/us/dataExchanges/456
   * </pre>
   *
   * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The dataExchange.
   */
  public java.lang.String getDataExchange() {
    java.lang.Object ref = "";
    if (resourceNameCase_ == 6) {
      ref = resourceName_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (resourceNameCase_ == 6) {
        resourceName_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Resource name of the source Data Exchange.
   * e.g. projects/123/locations/us/dataExchanges/456
   * </pre>
   *
   * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for dataExchange.
   */
  public com.google.protobuf.ByteString getDataExchangeBytes() {
    java.lang.Object ref = "";
    if (resourceNameCase_ == 6) {
      ref = resourceName_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (resourceNameCase_ == 6) {
        resourceName_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the subscription.
   * e.g. `projects/myproject/locations/us/subscriptions/123`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the subscription.
   * e.g. `projects/myproject/locations/us/subscriptions/123`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp creationTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the subscription was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the creationTime field is set.
   */
  @java.lang.Override
  public boolean hasCreationTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the subscription was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreationTime() {
    return creationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : creationTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the subscription was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder() {
    return creationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : creationTime_;
  }

  public static final int LAST_MODIFY_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp lastModifyTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the subscription was last modified.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastModifyTime field is set.
   */
  @java.lang.Override
  public boolean hasLastModifyTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the subscription was last modified.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastModifyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastModifyTime() {
    return lastModifyTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastModifyTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the subscription was last modified.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastModifyTimeOrBuilder() {
    return lastModifyTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastModifyTime_;
  }

  public static final int ORGANIZATION_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object organizationId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Organization of the project this subscription belongs to.
   * </pre>
   *
   * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The organizationId.
   */
  @java.lang.Override
  public java.lang.String getOrganizationId() {
    java.lang.Object ref = organizationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      organizationId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Organization of the project this subscription belongs to.
   * </pre>
   *
   * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for organizationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrganizationIdBytes() {
    java.lang.Object ref = organizationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      organizationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORGANIZATION_DISPLAY_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object organizationDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Display name of the project of this subscription.
   * </pre>
   *
   * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The organizationDisplayName.
   */
  @java.lang.Override
  public java.lang.String getOrganizationDisplayName() {
    java.lang.Object ref = organizationDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      organizationDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Display name of the project of this subscription.
   * </pre>
   *
   * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for organizationDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrganizationDisplayNameBytes() {
    java.lang.Object ref = organizationDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      organizationDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Current state of the subscription.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Current state of the subscription.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription.State getState() {
    com.google.cloud.bigquery.analyticshub.v1.Subscription.State result =
        com.google.cloud.bigquery.analyticshub.v1.Subscription.State.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.analyticshub.v1.Subscription.State.UNRECOGNIZED
        : result;
  }

  public static final int LINKED_DATASET_MAP_FIELD_NUMBER = 8;

  private static final class LinkedDatasetMapDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
                    newDefaultInstance(
                        com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
                            .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_LinkedDatasetMapEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
      linkedDatasetMap_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
      internalGetLinkedDatasetMap() {
    if (linkedDatasetMap_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          LinkedDatasetMapDefaultEntryHolder.defaultEntry);
    }
    return linkedDatasetMap_;
  }

  public int getLinkedDatasetMapCount() {
    return internalGetLinkedDatasetMap().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Map of listing resource names to associated linked resource,
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * -&gt;
   * projects/123/datasets/my_dataset
   *
   * For listing-level subscriptions, this is a map of size 1.
   * Only contains values if state == STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsLinkedDatasetMap(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLinkedDatasetMap().getMap().containsKey(key);
  }

  /** Use {@link #getLinkedDatasetMapMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
      getLinkedDatasetMap() {
    return getLinkedDatasetMapMap();
  }

  /**
   *
   *
   * <pre>
   * Output only. Map of listing resource names to associated linked resource,
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * -&gt;
   * projects/123/datasets/my_dataset
   *
   * For listing-level subscriptions, this is a map of size 1.
   * Only contains values if state == STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
      getLinkedDatasetMapMap() {
    return internalGetLinkedDatasetMap().getMap();
  }

  /**
   *
   *
   * <pre>
   * Output only. Map of listing resource names to associated linked resource,
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * -&gt;
   * projects/123/datasets/my_dataset
   *
   * For listing-level subscriptions, this is a map of size 1.
   * Only contains values if state == STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
      getLinkedDatasetMapOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        map = internalGetLinkedDatasetMap().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Output only. Map of listing resource names to associated linked resource,
   * e.g. projects/123/locations/us/dataExchanges/456/listings/789
   * -&gt;
   * projects/123/datasets/my_dataset
   *
   * For listing-level subscriptions, this is a map of size 1.
   * Only contains values if state == STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
      getLinkedDatasetMapOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        map = internalGetLinkedDatasetMap().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SUBSCRIBER_CONTACT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subscriberContact_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Email of the subscriber.
   * </pre>
   *
   * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The subscriberContact.
   */
  @java.lang.Override
  public java.lang.String getSubscriberContact() {
    java.lang.Object ref = subscriberContact_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subscriberContact_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Email of the subscriber.
   * </pre>
   *
   * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for subscriberContact.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubscriberContactBytes() {
    java.lang.Object ref = subscriberContact_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subscriberContact_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_RESOURCES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
      linkedResources_;

  /**
   *
   *
   * <pre>
   * Output only. Linked resources created in the subscription. Only contains
   * values if state = STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
      getLinkedResourcesList() {
    return linkedResources_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Linked resources created in the subscription. Only contains
   * values if state = STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
      getLinkedResourcesOrBuilderList() {
    return linkedResources_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Linked resources created in the subscription. Only contains
   * values if state = STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getLinkedResourcesCount() {
    return linkedResources_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Linked resources created in the subscription. Only contains
   * values if state = STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource getLinkedResources(
      int index) {
    return linkedResources_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Linked resources created in the subscription. Only contains
   * values if state = STATE_ACTIVE.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder
      getLinkedResourcesOrBuilder(int index) {
    return linkedResources_.get(index);
  }

  public static final int RESOURCE_TYPE_FIELD_NUMBER = 12;
  private int resourceType_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Listing shared asset type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  @java.lang.Override
  public int getResourceTypeValue() {
    return resourceType_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Listing shared asset type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.SharedResourceType getResourceType() {
    com.google.cloud.bigquery.analyticshub.v1.SharedResourceType result =
        com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.forNumber(resourceType_);
    return result == null
        ? com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.UNRECOGNIZED
        : result;
  }

  public static final int COMMERCIAL_INFO_FIELD_NUMBER = 13;
  private com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercialInfo_;

  /**
   *
   *
   * <pre>
   * Output only. This is set if this is a commercial subscription i.e. if this
   * subscription was created from subscribing to a commercial listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the commercialInfo field is set.
   */
  @java.lang.Override
  public boolean hasCommercialInfo() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. This is set if this is a commercial subscription i.e. if this
   * subscription was created from subscribing to a commercial listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The commercialInfo.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo getCommercialInfo() {
    return commercialInfo_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.getDefaultInstance()
        : commercialInfo_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This is set if this is a commercial subscription i.e. if this
   * subscription was created from subscribing to a commercial listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfoOrBuilder
      getCommercialInfoOrBuilder() {
    return commercialInfo_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.getDefaultInstance()
        : commercialInfo_;
  }

  public static final int LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER = 14;
  private boolean logLinkedDatasetQueryUserEmail_ = false;

  /**
   *
   *
   * <pre>
   * Output only. By default, false.
   * If true, the Subscriber agreed to the email sharing mandate
   * that is enabled for DataExchange/Listing.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the logLinkedDatasetQueryUserEmail field is set.
   */
  @java.lang.Override
  public boolean hasLogLinkedDatasetQueryUserEmail() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. By default, false.
   * If true, the Subscriber agreed to the email sharing mandate
   * that is enabled for DataExchange/Listing.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The logLinkedDatasetQueryUserEmail.
   */
  @java.lang.Override
  public boolean getLogLinkedDatasetQueryUserEmail() {
    return logLinkedDatasetQueryUserEmail_;
  }

  public static final int DESTINATION_DATASET_FIELD_NUMBER = 15;
  private com.google.cloud.bigquery.analyticshub.v1.DestinationDataset destinationDataset_;

  /**
   *
   *
   * <pre>
   * Optional. BigQuery destination dataset to create for the subscriber.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the destinationDataset field is set.
   */
  @java.lang.Override
  public boolean hasDestinationDataset() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. BigQuery destination dataset to create for the subscriber.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The destinationDataset.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset getDestinationDataset() {
    return destinationDataset_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.getDefaultInstance()
        : destinationDataset_;
  }

  /**
   *
   *
   * <pre>
   * Optional. BigQuery destination dataset to create for the subscriber.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetOrBuilder
      getDestinationDatasetOrBuilder() {
    return destinationDataset_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.getDefaultInstance()
        : destinationDataset_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreationTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getLastModifyTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(organizationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, organizationId_);
    }
    if (resourceNameCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, resourceName_);
    }
    if (resourceNameCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, resourceName_);
    }
    if (state_
        != com.google.cloud.bigquery.analyticshub.v1.Subscription.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, state_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLinkedDatasetMap(), LinkedDatasetMapDefaultEntryHolder.defaultEntry, 8);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscriberContact_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, subscriberContact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(organizationDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, organizationDisplayName_);
    }
    for (int i = 0; i < linkedResources_.size(); i++) {
      output.writeMessage(11, linkedResources_.get(i));
    }
    if (resourceType_
        != com.google.cloud.bigquery.analyticshub.v1.SharedResourceType
            .SHARED_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, resourceType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getCommercialInfo());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(14, logLinkedDatasetQueryUserEmail_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(15, getDestinationDataset());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreationTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLastModifyTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(organizationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, organizationId_);
    }
    if (resourceNameCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, resourceName_);
    }
    if (resourceNameCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, resourceName_);
    }
    if (state_
        != com.google.cloud.bigquery.analyticshub.v1.Subscription.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        entry : internalGetLinkedDatasetMap().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
          linkedDatasetMap__ =
              LinkedDatasetMapDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, linkedDatasetMap__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscriberContact_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, subscriberContact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(organizationDisplayName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(10, organizationDisplayName_);
    }
    for (int i = 0; i < linkedResources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, linkedResources_.get(i));
    }
    if (resourceType_
        != com.google.cloud.bigquery.analyticshub.v1.SharedResourceType
            .SHARED_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, resourceType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCommercialInfo());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              14, logLinkedDatasetQueryUserEmail_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getDestinationDataset());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.analyticshub.v1.Subscription other =
        (com.google.cloud.bigquery.analyticshub.v1.Subscription) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreationTime() != other.hasCreationTime()) return false;
    if (hasCreationTime()) {
      if (!getCreationTime().equals(other.getCreationTime())) return false;
    }
    if (hasLastModifyTime() != other.hasLastModifyTime()) return false;
    if (hasLastModifyTime()) {
      if (!getLastModifyTime().equals(other.getLastModifyTime())) return false;
    }
    if (!getOrganizationId().equals(other.getOrganizationId())) return false;
    if (!getOrganizationDisplayName().equals(other.getOrganizationDisplayName())) return false;
    if (state_ != other.state_) return false;
    if (!internalGetLinkedDatasetMap().equals(other.internalGetLinkedDatasetMap())) return false;
    if (!getSubscriberContact().equals(other.getSubscriberContact())) return false;
    if (!getLinkedResourcesList().equals(other.getLinkedResourcesList())) return false;
    if (resourceType_ != other.resourceType_) return false;
    if (hasCommercialInfo() != other.hasCommercialInfo()) return false;
    if (hasCommercialInfo()) {
      if (!getCommercialInfo().equals(other.getCommercialInfo())) return false;
    }
    if (hasLogLinkedDatasetQueryUserEmail() != other.hasLogLinkedDatasetQueryUserEmail())
      return false;
    if (hasLogLinkedDatasetQueryUserEmail()) {
      if (getLogLinkedDatasetQueryUserEmail() != other.getLogLinkedDatasetQueryUserEmail())
        return false;
    }
    if (hasDestinationDataset() != other.hasDestinationDataset()) return false;
    if (hasDestinationDataset()) {
      if (!getDestinationDataset().equals(other.getDestinationDataset())) return false;
    }
    if (!getResourceNameCase().equals(other.getResourceNameCase())) return false;
    switch (resourceNameCase_) {
      case 5:
        if (!getListing().equals(other.getListing())) return false;
        break;
      case 6:
        if (!getDataExchange().equals(other.getDataExchange())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreationTime()) {
      hash = (37 * hash) + CREATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTime().hashCode();
    }
    if (hasLastModifyTime()) {
      hash = (37 * hash) + LAST_MODIFY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastModifyTime().hashCode();
    }
    hash = (37 * hash) + ORGANIZATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOrganizationId().hashCode();
    hash = (37 * hash) + ORGANIZATION_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOrganizationDisplayName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (!internalGetLinkedDatasetMap().getMap().isEmpty()) {
      hash = (37 * hash) + LINKED_DATASET_MAP_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLinkedDatasetMap().hashCode();
    }
    hash = (37 * hash) + SUBSCRIBER_CONTACT_FIELD_NUMBER;
    hash = (53 * hash) + getSubscriberContact().hashCode();
    if (getLinkedResourcesCount() > 0) {
      hash = (37 * hash) + LINKED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedResourcesList().hashCode();
    }
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + resourceType_;
    if (hasCommercialInfo()) {
      hash = (37 * hash) + COMMERCIAL_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCommercialInfo().hashCode();
    }
    if (hasLogLinkedDatasetQueryUserEmail()) {
      hash = (37 * hash) + LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getLogLinkedDatasetQueryUserEmail());
    }
    if (hasDestinationDataset()) {
      hash = (37 * hash) + DESTINATION_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationDataset().hashCode();
    }
    switch (resourceNameCase_) {
      case 5:
        hash = (37 * hash) + LISTING_FIELD_NUMBER;
        hash = (53 * hash) + getListing().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DATA_EXCHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getDataExchange().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.analyticshub.v1.Subscription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A subscription represents a subscribers' access to a particular set of
   * published data. It contains references to associated listings,
   * data exchanges, and linked datasets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Subscription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Subscription)
      com.google.cloud.bigquery.analyticshub.v1.SubscriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetLinkedDatasetMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableLinkedDatasetMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Subscription.class,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.analyticshub.v1.Subscription.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreationTimeFieldBuilder();
        getLastModifyTimeFieldBuilder();
        getLinkedResourcesFieldBuilder();
        getCommercialInfoFieldBuilder();
        getDestinationDatasetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      creationTime_ = null;
      if (creationTimeBuilder_ != null) {
        creationTimeBuilder_.dispose();
        creationTimeBuilder_ = null;
      }
      lastModifyTime_ = null;
      if (lastModifyTimeBuilder_ != null) {
        lastModifyTimeBuilder_.dispose();
        lastModifyTimeBuilder_ = null;
      }
      organizationId_ = "";
      organizationDisplayName_ = "";
      state_ = 0;
      internalGetMutableLinkedDatasetMap().clear();
      subscriberContact_ = "";
      if (linkedResourcesBuilder_ == null) {
        linkedResources_ = java.util.Collections.emptyList();
      } else {
        linkedResources_ = null;
        linkedResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      resourceType_ = 0;
      commercialInfo_ = null;
      if (commercialInfoBuilder_ != null) {
        commercialInfoBuilder_.dispose();
        commercialInfoBuilder_ = null;
      }
      logLinkedDatasetQueryUserEmail_ = false;
      destinationDataset_ = null;
      if (destinationDatasetBuilder_ != null) {
        destinationDatasetBuilder_.dispose();
        destinationDatasetBuilder_ = null;
      }
      resourceNameCase_ = 0;
      resourceName_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Subscription_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription getDefaultInstanceForType() {
      return com.google.cloud.bigquery.analyticshub.v1.Subscription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription build() {
      com.google.cloud.bigquery.analyticshub.v1.Subscription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription buildPartial() {
      com.google.cloud.bigquery.analyticshub.v1.Subscription result =
          new com.google.cloud.bigquery.analyticshub.v1.Subscription(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.analyticshub.v1.Subscription result) {
      if (linkedResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          linkedResources_ = java.util.Collections.unmodifiableList(linkedResources_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.linkedResources_ = linkedResources_;
      } else {
        result.linkedResources_ = linkedResourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.analyticshub.v1.Subscription result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.creationTime_ =
            creationTimeBuilder_ == null ? creationTime_ : creationTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.lastModifyTime_ =
            lastModifyTimeBuilder_ == null ? lastModifyTime_ : lastModifyTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.organizationId_ = organizationId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.organizationDisplayName_ = organizationDisplayName_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.linkedDatasetMap_ =
            internalGetLinkedDatasetMap().build(LinkedDatasetMapDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.subscriberContact_ = subscriberContact_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.resourceType_ = resourceType_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.commercialInfo_ =
            commercialInfoBuilder_ == null ? commercialInfo_ : commercialInfoBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.logLinkedDatasetQueryUserEmail_ = logLinkedDatasetQueryUserEmail_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.destinationDataset_ =
            destinationDatasetBuilder_ == null
                ? destinationDataset_
                : destinationDatasetBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.analyticshub.v1.Subscription result) {
      result.resourceNameCase_ = resourceNameCase_;
      result.resourceName_ = this.resourceName_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription) {
        return mergeFrom((com.google.cloud.bigquery.analyticshub.v1.Subscription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.analyticshub.v1.Subscription other) {
      if (other == com.google.cloud.bigquery.analyticshub.v1.Subscription.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreationTime()) {
        mergeCreationTime(other.getCreationTime());
      }
      if (other.hasLastModifyTime()) {
        mergeLastModifyTime(other.getLastModifyTime());
      }
      if (!other.getOrganizationId().isEmpty()) {
        organizationId_ = other.organizationId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getOrganizationDisplayName().isEmpty()) {
        organizationDisplayName_ = other.organizationDisplayName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      internalGetMutableLinkedDatasetMap().mergeFrom(other.internalGetLinkedDatasetMap());
      bitField0_ |= 0x00000100;
      if (!other.getSubscriberContact().isEmpty()) {
        subscriberContact_ = other.subscriberContact_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (linkedResourcesBuilder_ == null) {
        if (!other.linkedResources_.isEmpty()) {
          if (linkedResources_.isEmpty()) {
            linkedResources_ = other.linkedResources_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureLinkedResourcesIsMutable();
            linkedResources_.addAll(other.linkedResources_);
          }
          onChanged();
        }
      } else {
        if (!other.linkedResources_.isEmpty()) {
          if (linkedResourcesBuilder_.isEmpty()) {
            linkedResourcesBuilder_.dispose();
            linkedResourcesBuilder_ = null;
            linkedResources_ = other.linkedResources_;
            bitField0_ = (bitField0_ & ~0x00000400);
            linkedResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLinkedResourcesFieldBuilder()
                    : null;
          } else {
            linkedResourcesBuilder_.addAllMessages(other.linkedResources_);
          }
        }
      }
      if (other.resourceType_ != 0) {
        setResourceTypeValue(other.getResourceTypeValue());
      }
      if (other.hasCommercialInfo()) {
        mergeCommercialInfo(other.getCommercialInfo());
      }
      if (other.hasLogLinkedDatasetQueryUserEmail()) {
        setLogLinkedDatasetQueryUserEmail(other.getLogLinkedDatasetQueryUserEmail());
      }
      if (other.hasDestinationDataset()) {
        mergeDestinationDataset(other.getDestinationDataset());
      }
      switch (other.getResourceNameCase()) {
        case LISTING:
          {
            resourceNameCase_ = 5;
            resourceName_ = other.resourceName_;
            onChanged();
            break;
          }
        case DATA_EXCHANGE:
          {
            resourceNameCase_ = 6;
            resourceName_ = other.resourceName_;
            onChanged();
            break;
          }
        case RESOURCENAME_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getLastModifyTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                organizationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                resourceNameCase_ = 5;
                resourceName_ = s;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                resourceNameCase_ = 6;
                resourceName_ = s;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
                    linkedDatasetMap__ =
                        input.readMessage(
                            LinkedDatasetMapDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableLinkedDatasetMap()
                    .ensureBuilderMap()
                    .put(linkedDatasetMap__.getKey(), linkedDatasetMap__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                subscriberContact_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                organizationDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource m =
                    input.readMessage(
                        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
                            .parser(),
                        extensionRegistry);
                if (linkedResourcesBuilder_ == null) {
                  ensureLinkedResourcesIsMutable();
                  linkedResources_.add(m);
                } else {
                  linkedResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 96:
              {
                resourceType_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getCommercialInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 112:
              {
                logLinkedDatasetQueryUserEmail_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 122:
              {
                input.readMessage(
                    getDestinationDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resourceNameCase_ = 0;
    private java.lang.Object resourceName_;

    public ResourceNameCase getResourceNameCase() {
      return ResourceNameCase.forNumber(resourceNameCase_);
    }

    public Builder clearResourceName() {
      resourceNameCase_ = 0;
      resourceName_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * </pre>
     *
     * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the listing field is set.
     */
    @java.lang.Override
    public boolean hasListing() {
      return resourceNameCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * </pre>
     *
     * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The listing.
     */
    @java.lang.Override
    public java.lang.String getListing() {
      java.lang.Object ref = "";
      if (resourceNameCase_ == 5) {
        ref = resourceName_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resourceNameCase_ == 5) {
          resourceName_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * </pre>
     *
     * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for listing.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getListingBytes() {
      java.lang.Object ref = "";
      if (resourceNameCase_ == 5) {
        ref = resourceName_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resourceNameCase_ == 5) {
          resourceName_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * </pre>
     *
     * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The listing to set.
     * @return This builder for chaining.
     */
    public Builder setListing(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceNameCase_ = 5;
      resourceName_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * </pre>
     *
     * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearListing() {
      if (resourceNameCase_ == 5) {
        resourceNameCase_ = 0;
        resourceName_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Listing.
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * </pre>
     *
     * <code>string listing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for listing to set.
     * @return This builder for chaining.
     */
    public Builder setListingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceNameCase_ = 5;
      resourceName_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/us/dataExchanges/456
     * </pre>
     *
     * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the dataExchange field is set.
     */
    @java.lang.Override
    public boolean hasDataExchange() {
      return resourceNameCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/us/dataExchanges/456
     * </pre>
     *
     * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dataExchange.
     */
    @java.lang.Override
    public java.lang.String getDataExchange() {
      java.lang.Object ref = "";
      if (resourceNameCase_ == 6) {
        ref = resourceName_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resourceNameCase_ == 6) {
          resourceName_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/us/dataExchanges/456
     * </pre>
     *
     * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dataExchange.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataExchangeBytes() {
      java.lang.Object ref = "";
      if (resourceNameCase_ == 6) {
        ref = resourceName_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resourceNameCase_ == 6) {
          resourceName_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/us/dataExchanges/456
     * </pre>
     *
     * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The dataExchange to set.
     * @return This builder for chaining.
     */
    public Builder setDataExchange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceNameCase_ = 6;
      resourceName_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/us/dataExchanges/456
     * </pre>
     *
     * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataExchange() {
      if (resourceNameCase_ == 6) {
        resourceNameCase_ = 0;
        resourceName_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Resource name of the source Data Exchange.
     * e.g. projects/123/locations/us/dataExchanges/456
     * </pre>
     *
     * <code>string data_exchange = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for dataExchange to set.
     * @return This builder for chaining.
     */
    public Builder setDataExchangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceNameCase_ = 6;
      resourceName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/us/subscriptions/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/us/subscriptions/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/us/subscriptions/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/us/subscriptions/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the subscription.
     * e.g. `projects/myproject/locations/us/subscriptions/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp creationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        creationTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the creationTime field is set.
     */
    public boolean hasCreationTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationTime.
     */
    public com.google.protobuf.Timestamp getCreationTime() {
      if (creationTimeBuilder_ == null) {
        return creationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : creationTime_;
      } else {
        return creationTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationTime(com.google.protobuf.Timestamp value) {
      if (creationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        creationTime_ = value;
      } else {
        creationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (creationTimeBuilder_ == null) {
        creationTime_ = builderForValue.build();
      } else {
        creationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreationTime(com.google.protobuf.Timestamp value) {
      if (creationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && creationTime_ != null
            && creationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreationTimeBuilder().mergeFrom(value);
        } else {
          creationTime_ = value;
        }
      } else {
        creationTimeBuilder_.mergeFrom(value);
      }
      if (creationTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreationTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      creationTime_ = null;
      if (creationTimeBuilder_ != null) {
        creationTimeBuilder_.dispose();
        creationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreationTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreationTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder() {
      if (creationTimeBuilder_ != null) {
        return creationTimeBuilder_.getMessageOrBuilder();
      } else {
        return creationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : creationTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreationTimeFieldBuilder() {
      if (creationTimeBuilder_ == null) {
        creationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreationTime(), getParentForChildren(), isClean());
        creationTime_ = null;
      }
      return creationTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastModifyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastModifyTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastModifyTime field is set.
     */
    public boolean hasLastModifyTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastModifyTime.
     */
    public com.google.protobuf.Timestamp getLastModifyTime() {
      if (lastModifyTimeBuilder_ == null) {
        return lastModifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastModifyTime_;
      } else {
        return lastModifyTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastModifyTime(com.google.protobuf.Timestamp value) {
      if (lastModifyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastModifyTime_ = value;
      } else {
        lastModifyTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastModifyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastModifyTimeBuilder_ == null) {
        lastModifyTime_ = builderForValue.build();
      } else {
        lastModifyTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastModifyTime(com.google.protobuf.Timestamp value) {
      if (lastModifyTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && lastModifyTime_ != null
            && lastModifyTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastModifyTimeBuilder().mergeFrom(value);
        } else {
          lastModifyTime_ = value;
        }
      } else {
        lastModifyTimeBuilder_.mergeFrom(value);
      }
      if (lastModifyTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastModifyTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      lastModifyTime_ = null;
      if (lastModifyTimeBuilder_ != null) {
        lastModifyTimeBuilder_.dispose();
        lastModifyTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastModifyTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getLastModifyTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastModifyTimeOrBuilder() {
      if (lastModifyTimeBuilder_ != null) {
        return lastModifyTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastModifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastModifyTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the subscription was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_modify_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastModifyTimeFieldBuilder() {
      if (lastModifyTimeBuilder_ == null) {
        lastModifyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastModifyTime(), getParentForChildren(), isClean());
        lastModifyTime_ = null;
      }
      return lastModifyTimeBuilder_;
    }

    private java.lang.Object organizationId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Organization of the project this subscription belongs to.
     * </pre>
     *
     * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The organizationId.
     */
    public java.lang.String getOrganizationId() {
      java.lang.Object ref = organizationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        organizationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Organization of the project this subscription belongs to.
     * </pre>
     *
     * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for organizationId.
     */
    public com.google.protobuf.ByteString getOrganizationIdBytes() {
      java.lang.Object ref = organizationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        organizationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Organization of the project this subscription belongs to.
     * </pre>
     *
     * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The organizationId to set.
     * @return This builder for chaining.
     */
    public Builder setOrganizationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      organizationId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Organization of the project this subscription belongs to.
     * </pre>
     *
     * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrganizationId() {
      organizationId_ = getDefaultInstance().getOrganizationId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Organization of the project this subscription belongs to.
     * </pre>
     *
     * <code>string organization_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for organizationId to set.
     * @return This builder for chaining.
     */
    public Builder setOrganizationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      organizationId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object organizationDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Display name of the project of this subscription.
     * </pre>
     *
     * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The organizationDisplayName.
     */
    public java.lang.String getOrganizationDisplayName() {
      java.lang.Object ref = organizationDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        organizationDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Display name of the project of this subscription.
     * </pre>
     *
     * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for organizationDisplayName.
     */
    public com.google.protobuf.ByteString getOrganizationDisplayNameBytes() {
      java.lang.Object ref = organizationDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        organizationDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Display name of the project of this subscription.
     * </pre>
     *
     * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The organizationDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setOrganizationDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      organizationDisplayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Display name of the project of this subscription.
     * </pre>
     *
     * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrganizationDisplayName() {
      organizationDisplayName_ = getDefaultInstance().getOrganizationDisplayName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Display name of the project of this subscription.
     * </pre>
     *
     * <code>string organization_display_name = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for organizationDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setOrganizationDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      organizationDisplayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Current state of the subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.State getState() {
      com.google.cloud.bigquery.analyticshub.v1.Subscription.State result =
          com.google.cloud.bigquery.analyticshub.v1.Subscription.State.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.analyticshub.v1.Subscription.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.analyticshub.v1.Subscription.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private static final class LinkedDatasetMapConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource> {
      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource build(
          com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder val) {
        if (val instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) {
          return (com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) val;
        }
        return ((com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
          defaultEntry() {
        return LinkedDatasetMapDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final LinkedDatasetMapConverter linkedDatasetMapConverter =
        new LinkedDatasetMapConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder>
        linkedDatasetMap_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder>
        internalGetLinkedDatasetMap() {
      if (linkedDatasetMap_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(linkedDatasetMapConverter);
      }
      return linkedDatasetMap_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder>
        internalGetMutableLinkedDatasetMap() {
      if (linkedDatasetMap_ == null) {
        linkedDatasetMap_ = new com.google.protobuf.MapFieldBuilder<>(linkedDatasetMapConverter);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return linkedDatasetMap_;
    }

    public int getLinkedDatasetMapCount() {
      return internalGetLinkedDatasetMap().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsLinkedDatasetMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLinkedDatasetMap().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getLinkedDatasetMapMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        getLinkedDatasetMap() {
      return getLinkedDatasetMapMap();
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        getLinkedDatasetMapMap() {
      return internalGetLinkedDatasetMap().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        getLinkedDatasetMapOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
          map = internalGetMutableLinkedDatasetMap().ensureBuilderMap();
      return map.containsKey(key) ? linkedDatasetMapConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
        getLinkedDatasetMapOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
          map = internalGetMutableLinkedDatasetMap().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return linkedDatasetMapConverter.build(map.get(key));
    }

    public Builder clearLinkedDatasetMap() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableLinkedDatasetMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLinkedDatasetMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLinkedDatasetMap().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        getMutableLinkedDatasetMap() {
      bitField0_ |= 0x00000100;
      return internalGetMutableLinkedDatasetMap().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putLinkedDatasetMap(
        java.lang.String key,
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLinkedDatasetMap().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllLinkedDatasetMap(
        java.util.Map<
                java.lang.String,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableLinkedDatasetMap().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Map of listing resource names to associated linked resource,
     * e.g. projects/123/locations/us/dataExchanges/456/listings/789
     * -&gt;
     * projects/123/datasets/my_dataset
     *
     * For listing-level subscriptions, this is a map of size 1.
     * Only contains values if state == STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource&gt; linked_dataset_map = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
        putLinkedDatasetMapBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
          builderMap = internalGetMutableLinkedDatasetMap().ensureBuilderMap();
      com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) {
        entry =
            ((com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder) entry;
    }

    private java.lang.Object subscriberContact_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Email of the subscriber.
     * </pre>
     *
     * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The subscriberContact.
     */
    public java.lang.String getSubscriberContact() {
      java.lang.Object ref = subscriberContact_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subscriberContact_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Email of the subscriber.
     * </pre>
     *
     * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for subscriberContact.
     */
    public com.google.protobuf.ByteString getSubscriberContactBytes() {
      java.lang.Object ref = subscriberContact_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subscriberContact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Email of the subscriber.
     * </pre>
     *
     * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The subscriberContact to set.
     * @return This builder for chaining.
     */
    public Builder setSubscriberContact(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subscriberContact_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Email of the subscriber.
     * </pre>
     *
     * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubscriberContact() {
      subscriberContact_ = getDefaultInstance().getSubscriberContact();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Email of the subscriber.
     * </pre>
     *
     * <code>string subscriber_contact = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for subscriberContact to set.
     * @return This builder for chaining.
     */
    public Builder setSubscriberContactBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subscriberContact_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        linkedResources_ = java.util.Collections.emptyList();

    private void ensureLinkedResourcesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        linkedResources_ =
            new java.util.ArrayList<
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>(
                linkedResources_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
        linkedResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
        getLinkedResourcesList() {
      if (linkedResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(linkedResources_);
      } else {
        return linkedResourcesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getLinkedResourcesCount() {
      if (linkedResourcesBuilder_ == null) {
        return linkedResources_.size();
      } else {
        return linkedResourcesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource getLinkedResources(
        int index) {
      if (linkedResourcesBuilder_ == null) {
        return linkedResources_.get(index);
      } else {
        return linkedResourcesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLinkedResources(
        int index, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource value) {
      if (linkedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinkedResourcesIsMutable();
        linkedResources_.set(index, value);
        onChanged();
      } else {
        linkedResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLinkedResources(
        int index,
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
            builderForValue) {
      if (linkedResourcesBuilder_ == null) {
        ensureLinkedResourcesIsMutable();
        linkedResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        linkedResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLinkedResources(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource value) {
      if (linkedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinkedResourcesIsMutable();
        linkedResources_.add(value);
        onChanged();
      } else {
        linkedResourcesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLinkedResources(
        int index, com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource value) {
      if (linkedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinkedResourcesIsMutable();
        linkedResources_.add(index, value);
        onChanged();
      } else {
        linkedResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLinkedResources(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
            builderForValue) {
      if (linkedResourcesBuilder_ == null) {
        ensureLinkedResourcesIsMutable();
        linkedResources_.add(builderForValue.build());
        onChanged();
      } else {
        linkedResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLinkedResources(
        int index,
        com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
            builderForValue) {
      if (linkedResourcesBuilder_ == null) {
        ensureLinkedResourcesIsMutable();
        linkedResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        linkedResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllLinkedResources(
        java.lang.Iterable<
                ? extends com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource>
            values) {
      if (linkedResourcesBuilder_ == null) {
        ensureLinkedResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, linkedResources_);
        onChanged();
      } else {
        linkedResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLinkedResources() {
      if (linkedResourcesBuilder_ == null) {
        linkedResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        linkedResourcesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLinkedResources(int index) {
      if (linkedResourcesBuilder_ == null) {
        ensureLinkedResourcesIsMutable();
        linkedResources_.remove(index);
        onChanged();
      } else {
        linkedResourcesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
        getLinkedResourcesBuilder(int index) {
      return getLinkedResourcesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder
        getLinkedResourcesOrBuilder(int index) {
      if (linkedResourcesBuilder_ == null) {
        return linkedResources_.get(index);
      } else {
        return linkedResourcesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
        getLinkedResourcesOrBuilderList() {
      if (linkedResourcesBuilder_ != null) {
        return linkedResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(linkedResources_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
        addLinkedResourcesBuilder() {
      return getLinkedResourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder
        addLinkedResourcesBuilder(int index) {
      return getLinkedResourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Linked resources created in the subscription. Only contains
     * values if state = STATE_ACTIVE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource linked_resources = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder>
        getLinkedResourcesBuilderList() {
      return getLinkedResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>
        getLinkedResourcesFieldBuilder() {
      if (linkedResourcesBuilder_ == null) {
        linkedResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource.Builder,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResourceOrBuilder>(
                linkedResources_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        linkedResources_ = null;
      }
      return linkedResourcesBuilder_;
    }

    private int resourceType_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeValue(int value) {
      resourceType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.SharedResourceType getResourceType() {
      com.google.cloud.bigquery.analyticshub.v1.SharedResourceType result =
          com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.forNumber(resourceType_);
      return result == null
          ? com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(
        com.google.cloud.bigquery.analyticshub.v1.SharedResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      resourceType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      bitField0_ = (bitField0_ & ~0x00000800);
      resourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercialInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfoOrBuilder>
        commercialInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commercialInfo field is set.
     */
    public boolean hasCommercialInfo() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commercialInfo.
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
        getCommercialInfo() {
      if (commercialInfoBuilder_ == null) {
        return commercialInfo_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .getDefaultInstance()
            : commercialInfo_;
      } else {
        return commercialInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommercialInfo(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo value) {
      if (commercialInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commercialInfo_ = value;
      } else {
        commercialInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommercialInfo(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder
            builderForValue) {
      if (commercialInfoBuilder_ == null) {
        commercialInfo_ = builderForValue.build();
      } else {
        commercialInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCommercialInfo(
        com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo value) {
      if (commercialInfoBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && commercialInfo_ != null
            && commercialInfo_
                != com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                    .getDefaultInstance()) {
          getCommercialInfoBuilder().mergeFrom(value);
        } else {
          commercialInfo_ = value;
        }
      } else {
        commercialInfoBuilder_.mergeFrom(value);
      }
      if (commercialInfo_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCommercialInfo() {
      bitField0_ = (bitField0_ & ~0x00001000);
      commercialInfo_ = null;
      if (commercialInfoBuilder_ != null) {
        commercialInfoBuilder_.dispose();
        commercialInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder
        getCommercialInfoBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getCommercialInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfoOrBuilder
        getCommercialInfoOrBuilder() {
      if (commercialInfoBuilder_ != null) {
        return commercialInfoBuilder_.getMessageOrBuilder();
      } else {
        return commercialInfo_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo
                .getDefaultInstance()
            : commercialInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This is set if this is a commercial subscription i.e. if this
     * subscription was created from subscribing to a commercial listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo commercial_info = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfoOrBuilder>
        getCommercialInfoFieldBuilder() {
      if (commercialInfoBuilder_ == null) {
        commercialInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfo.Builder,
                com.google.cloud.bigquery.analyticshub.v1.Subscription.CommercialInfoOrBuilder>(
                getCommercialInfo(), getParentForChildren(), isClean());
        commercialInfo_ = null;
      }
      return commercialInfoBuilder_;
    }

    private boolean logLinkedDatasetQueryUserEmail_;

    /**
     *
     *
     * <pre>
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the logLinkedDatasetQueryUserEmail field is set.
     */
    @java.lang.Override
    public boolean hasLogLinkedDatasetQueryUserEmail() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The logLinkedDatasetQueryUserEmail.
     */
    @java.lang.Override
    public boolean getLogLinkedDatasetQueryUserEmail() {
      return logLinkedDatasetQueryUserEmail_;
    }

    /**
     *
     *
     * <pre>
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The logLinkedDatasetQueryUserEmail to set.
     * @return This builder for chaining.
     */
    public Builder setLogLinkedDatasetQueryUserEmail(boolean value) {

      logLinkedDatasetQueryUserEmail_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. By default, false.
     * If true, the Subscriber agreed to the email sharing mandate
     * that is enabled for DataExchange/Listing.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogLinkedDatasetQueryUserEmail() {
      bitField0_ = (bitField0_ & ~0x00002000);
      logLinkedDatasetQueryUserEmail_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.DestinationDataset destinationDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DestinationDataset,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetOrBuilder>
        destinationDatasetBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the destinationDataset field is set.
     */
    public boolean hasDestinationDataset() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The destinationDataset.
     */
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset getDestinationDataset() {
      if (destinationDatasetBuilder_ == null) {
        return destinationDataset_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.getDefaultInstance()
            : destinationDataset_;
      } else {
        return destinationDatasetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDestinationDataset(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDataset value) {
      if (destinationDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationDataset_ = value;
      } else {
        destinationDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDestinationDataset(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder builderForValue) {
      if (destinationDatasetBuilder_ == null) {
        destinationDataset_ = builderForValue.build();
      } else {
        destinationDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDestinationDataset(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDataset value) {
      if (destinationDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && destinationDataset_ != null
            && destinationDataset_
                != com.google.cloud.bigquery.analyticshub.v1.DestinationDataset
                    .getDefaultInstance()) {
          getDestinationDatasetBuilder().mergeFrom(value);
        } else {
          destinationDataset_ = value;
        }
      } else {
        destinationDatasetBuilder_.mergeFrom(value);
      }
      if (destinationDataset_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDestinationDataset() {
      bitField0_ = (bitField0_ & ~0x00004000);
      destinationDataset_ = null;
      if (destinationDatasetBuilder_ != null) {
        destinationDatasetBuilder_.dispose();
        destinationDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder
        getDestinationDatasetBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getDestinationDatasetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetOrBuilder
        getDestinationDatasetOrBuilder() {
      if (destinationDatasetBuilder_ != null) {
        return destinationDatasetBuilder_.getMessageOrBuilder();
      } else {
        return destinationDataset_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.getDefaultInstance()
            : destinationDataset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. BigQuery destination dataset to create for the subscriber.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDataset destination_dataset = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DestinationDataset,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetOrBuilder>
        getDestinationDatasetFieldBuilder() {
      if (destinationDatasetBuilder_ == null) {
        destinationDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.DestinationDataset,
                com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder,
                com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetOrBuilder>(
                getDestinationDataset(), getParentForChildren(), isClean());
        destinationDataset_ = null;
      }
      return destinationDatasetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Subscription)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Subscription)
  private static final com.google.cloud.bigquery.analyticshub.v1.Subscription DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.Subscription();
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Subscription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Subscription> PARSER =
      new com.google.protobuf.AbstractParser<Subscription>() {
        @java.lang.Override
        public Subscription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Subscription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Subscription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Subscription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
