/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_USER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/users/{user}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String user;

    @Deprecated
    protected UserName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.user = null;
    }

    private UserName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getUser() {
        return this.user;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserName of(String project, String location, String cluster, String user) {
        return UserName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setUser(user).build();
    }

    public static String format(String project, String location, String cluster, String user) {
        return UserName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setUser(user).build().toString();
    }

    public static UserName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_USER.validatedMatch(formattedString, "UserName.parse: formattedString not in valid format");
        return UserName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("user"));
    }

    public static List<UserName> parseList(List<String> formattedStrings) {
        ArrayList<UserName> list = new ArrayList<UserName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_USER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserName userName = this;
            synchronized (userName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_USER.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "user", this.user});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserName that = (UserName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.user, that.user);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.user);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String user;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getUser() {
            return this.user;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        private Builder(UserName userName) {
            this.project = userName.project;
            this.location = userName.location;
            this.cluster = userName.cluster;
            this.user = userName.user;
        }

        public UserName build() {
            return new UserName(this);
        }
    }
}

