/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/types.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A tensor value type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Tensor}
 */
public final class Tensor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Tensor)
    TensorOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Tensor.newBuilder() to construct.
  private Tensor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Tensor() {
    dtype_ = 0;
    shape_ = emptyLongList();
    boolVal_ = emptyBooleanList();
    stringVal_ = com.google.protobuf.LazyStringArrayList.emptyList();
    bytesVal_ = emptyList(com.google.protobuf.ByteString.class);
    floatVal_ = emptyFloatList();
    doubleVal_ = emptyDoubleList();
    intVal_ = emptyIntList();
    int64Val_ = emptyLongList();
    uintVal_ = emptyIntList();
    uint64Val_ = emptyLongList();
    listVal_ = java.util.Collections.emptyList();
    tensorVal_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Tensor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TypesProto
        .internal_static_google_cloud_aiplatform_v1beta1_Tensor_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetStructVal();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TypesProto
        .internal_static_google_cloud_aiplatform_v1beta1_Tensor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Tensor.class,
            com.google.cloud.aiplatform.v1beta1.Tensor.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Data type of the tensor.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.Tensor.DataType}
   */
  public enum DataType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not a legal value for DataType. Used to indicate a DataType field has not
     * been set.
     * </pre>
     *
     * <code>DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    DATA_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Data types that all computation devices are expected to be
     * capable to support.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    BOOL(1),
    /** <code>STRING = 2;</code> */
    STRING(2),
    /** <code>FLOAT = 3;</code> */
    FLOAT(3),
    /** <code>DOUBLE = 4;</code> */
    DOUBLE(4),
    /** <code>INT8 = 5;</code> */
    INT8(5),
    /** <code>INT16 = 6;</code> */
    INT16(6),
    /** <code>INT32 = 7;</code> */
    INT32(7),
    /** <code>INT64 = 8;</code> */
    INT64(8),
    /** <code>UINT8 = 9;</code> */
    UINT8(9),
    /** <code>UINT16 = 10;</code> */
    UINT16(10),
    /** <code>UINT32 = 11;</code> */
    UINT32(11),
    /** <code>UINT64 = 12;</code> */
    UINT64(12),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not a legal value for DataType. Used to indicate a DataType field has not
     * been set.
     * </pre>
     *
     * <code>DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Data types that all computation devices are expected to be
     * capable to support.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    public static final int BOOL_VALUE = 1;

    /** <code>STRING = 2;</code> */
    public static final int STRING_VALUE = 2;

    /** <code>FLOAT = 3;</code> */
    public static final int FLOAT_VALUE = 3;

    /** <code>DOUBLE = 4;</code> */
    public static final int DOUBLE_VALUE = 4;

    /** <code>INT8 = 5;</code> */
    public static final int INT8_VALUE = 5;

    /** <code>INT16 = 6;</code> */
    public static final int INT16_VALUE = 6;

    /** <code>INT32 = 7;</code> */
    public static final int INT32_VALUE = 7;

    /** <code>INT64 = 8;</code> */
    public static final int INT64_VALUE = 8;

    /** <code>UINT8 = 9;</code> */
    public static final int UINT8_VALUE = 9;

    /** <code>UINT16 = 10;</code> */
    public static final int UINT16_VALUE = 10;

    /** <code>UINT32 = 11;</code> */
    public static final int UINT32_VALUE = 11;

    /** <code>UINT64 = 12;</code> */
    public static final int UINT64_VALUE = 12;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataType forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_TYPE_UNSPECIFIED;
        case 1:
          return BOOL;
        case 2:
          return STRING;
        case 3:
          return FLOAT;
        case 4:
          return DOUBLE;
        case 5:
          return INT8;
        case 6:
          return INT16;
        case 7:
          return INT32;
        case 8:
          return INT64;
        case 9:
          return UINT8;
        case 10:
          return UINT16;
        case 11:
          return UINT32;
        case 12:
          return UINT64;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataType>() {
          public DataType findValueByNumber(int number) {
            return DataType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Tensor.getDescriptor().getEnumTypes().get(0);
    }

    private static final DataType[] VALUES = values();

    public static DataType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.Tensor.DataType)
  }

  public static final int DTYPE_FIELD_NUMBER = 1;
  private int dtype_ = 0;

  /**
   *
   *
   * <pre>
   * The data type of tensor.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
   *
   * @return The enum numeric value on the wire for dtype.
   */
  @java.lang.Override
  public int getDtypeValue() {
    return dtype_;
  }

  /**
   *
   *
   * <pre>
   * The data type of tensor.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
   *
   * @return The dtype.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tensor.DataType getDtype() {
    com.google.cloud.aiplatform.v1beta1.Tensor.DataType result =
        com.google.cloud.aiplatform.v1beta1.Tensor.DataType.forNumber(dtype_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.Tensor.DataType.UNRECOGNIZED
        : result;
  }

  public static final int SHAPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList shape_ = emptyLongList();

  /**
   *
   *
   * <pre>
   * Shape of the tensor.
   * </pre>
   *
   * <code>repeated int64 shape = 2;</code>
   *
   * @return A list containing the shape.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getShapeList() {
    return shape_;
  }

  /**
   *
   *
   * <pre>
   * Shape of the tensor.
   * </pre>
   *
   * <code>repeated int64 shape = 2;</code>
   *
   * @return The count of shape.
   */
  public int getShapeCount() {
    return shape_.size();
  }

  /**
   *
   *
   * <pre>
   * Shape of the tensor.
   * </pre>
   *
   * <code>repeated int64 shape = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The shape at the given index.
   */
  public long getShape(int index) {
    return shape_.getLong(index);
  }

  private int shapeMemoizedSerializedSize = -1;

  public static final int BOOL_VAL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.BooleanList boolVal_ = emptyBooleanList();

  /**
   *
   *
   * <pre>
   * Type specific representations that make it easy to create tensor protos in
   * all languages.  Only the representation corresponding to "dtype" can
   * be set.  The values hold the flattened representation of the tensor in
   * row major order.
   *
   * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
   * </pre>
   *
   * <code>repeated bool bool_val = 3;</code>
   *
   * @return A list containing the boolVal.
   */
  @java.lang.Override
  public java.util.List<java.lang.Boolean> getBoolValList() {
    return boolVal_;
  }

  /**
   *
   *
   * <pre>
   * Type specific representations that make it easy to create tensor protos in
   * all languages.  Only the representation corresponding to "dtype" can
   * be set.  The values hold the flattened representation of the tensor in
   * row major order.
   *
   * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
   * </pre>
   *
   * <code>repeated bool bool_val = 3;</code>
   *
   * @return The count of boolVal.
   */
  public int getBoolValCount() {
    return boolVal_.size();
  }

  /**
   *
   *
   * <pre>
   * Type specific representations that make it easy to create tensor protos in
   * all languages.  Only the representation corresponding to "dtype" can
   * be set.  The values hold the flattened representation of the tensor in
   * row major order.
   *
   * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
   * </pre>
   *
   * <code>repeated bool bool_val = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The boolVal at the given index.
   */
  public boolean getBoolVal(int index) {
    return boolVal_.getBoolean(index);
  }

  private int boolValMemoizedSerializedSize = -1;

  public static final int STRING_VAL_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList stringVal_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated string string_val = 14;</code>
   *
   * @return A list containing the stringVal.
   */
  public com.google.protobuf.ProtocolStringList getStringValList() {
    return stringVal_;
  }

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated string string_val = 14;</code>
   *
   * @return The count of stringVal.
   */
  public int getStringValCount() {
    return stringVal_.size();
  }

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated string string_val = 14;</code>
   *
   * @param index The index of the element to return.
   * @return The stringVal at the given index.
   */
  public java.lang.String getStringVal(int index) {
    return stringVal_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated string string_val = 14;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the stringVal at the given index.
   */
  public com.google.protobuf.ByteString getStringValBytes(int index) {
    return stringVal_.getByteString(index);
  }

  public static final int BYTES_VAL_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> bytesVal_ =
      emptyList(com.google.protobuf.ByteString.class);

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated bytes bytes_val = 15;</code>
   *
   * @return A list containing the bytesVal.
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.ByteString> getBytesValList() {
    return bytesVal_;
  }

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated bytes bytes_val = 15;</code>
   *
   * @return The count of bytesVal.
   */
  public int getBytesValCount() {
    return bytesVal_.size();
  }

  /**
   *
   *
   * <pre>
   * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
   * </pre>
   *
   * <code>repeated bytes bytes_val = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The bytesVal at the given index.
   */
  public com.google.protobuf.ByteString getBytesVal(int index) {
    return bytesVal_.get(index);
  }

  public static final int FLOAT_VAL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.FloatList floatVal_ = emptyFloatList();

  /**
   *
   *
   * <pre>
   * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
   * </pre>
   *
   * <code>repeated float float_val = 5;</code>
   *
   * @return A list containing the floatVal.
   */
  @java.lang.Override
  public java.util.List<java.lang.Float> getFloatValList() {
    return floatVal_;
  }

  /**
   *
   *
   * <pre>
   * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
   * </pre>
   *
   * <code>repeated float float_val = 5;</code>
   *
   * @return The count of floatVal.
   */
  public int getFloatValCount() {
    return floatVal_.size();
  }

  /**
   *
   *
   * <pre>
   * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
   * </pre>
   *
   * <code>repeated float float_val = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The floatVal at the given index.
   */
  public float getFloatVal(int index) {
    return floatVal_.getFloat(index);
  }

  private int floatValMemoizedSerializedSize = -1;

  public static final int DOUBLE_VAL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList doubleVal_ = emptyDoubleList();

  /**
   *
   *
   * <pre>
   * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
   * </pre>
   *
   * <code>repeated double double_val = 6;</code>
   *
   * @return A list containing the doubleVal.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double> getDoubleValList() {
    return doubleVal_;
  }

  /**
   *
   *
   * <pre>
   * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
   * </pre>
   *
   * <code>repeated double double_val = 6;</code>
   *
   * @return The count of doubleVal.
   */
  public int getDoubleValCount() {
    return doubleVal_.size();
  }

  /**
   *
   *
   * <pre>
   * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
   * </pre>
   *
   * <code>repeated double double_val = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The doubleVal at the given index.
   */
  public double getDoubleVal(int index) {
    return doubleVal_.getDouble(index);
  }

  private int doubleValMemoizedSerializedSize = -1;

  public static final int INT_VAL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList intVal_ = emptyIntList();

  /**
   *
   *
   * <pre>
   * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
   * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
   * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
   * </pre>
   *
   * <code>repeated int32 int_val = 7;</code>
   *
   * @return A list containing the intVal.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getIntValList() {
    return intVal_;
  }

  /**
   *
   *
   * <pre>
   * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
   * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
   * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
   * </pre>
   *
   * <code>repeated int32 int_val = 7;</code>
   *
   * @return The count of intVal.
   */
  public int getIntValCount() {
    return intVal_.size();
  }

  /**
   *
   *
   * <pre>
   * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
   * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
   * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
   * </pre>
   *
   * <code>repeated int32 int_val = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The intVal at the given index.
   */
  public int getIntVal(int index) {
    return intVal_.getInt(index);
  }

  private int intValMemoizedSerializedSize = -1;

  public static final int INT64_VAL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList int64Val_ = emptyLongList();

  /**
   *
   *
   * <pre>
   * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
   * </pre>
   *
   * <code>repeated int64 int64_val = 8;</code>
   *
   * @return A list containing the int64Val.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getInt64ValList() {
    return int64Val_;
  }

  /**
   *
   *
   * <pre>
   * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
   * </pre>
   *
   * <code>repeated int64 int64_val = 8;</code>
   *
   * @return The count of int64Val.
   */
  public int getInt64ValCount() {
    return int64Val_.size();
  }

  /**
   *
   *
   * <pre>
   * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
   * </pre>
   *
   * <code>repeated int64 int64_val = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The int64Val at the given index.
   */
  public long getInt64Val(int index) {
    return int64Val_.getLong(index);
  }

  private int int64ValMemoizedSerializedSize = -1;

  public static final int UINT_VAL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList uintVal_ = emptyIntList();

  /**
   *
   *
   * <pre>
   * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
   * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
   * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
   * </pre>
   *
   * <code>repeated uint32 uint_val = 9;</code>
   *
   * @return A list containing the uintVal.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getUintValList() {
    return uintVal_;
  }

  /**
   *
   *
   * <pre>
   * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
   * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
   * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
   * </pre>
   *
   * <code>repeated uint32 uint_val = 9;</code>
   *
   * @return The count of uintVal.
   */
  public int getUintValCount() {
    return uintVal_.size();
  }

  /**
   *
   *
   * <pre>
   * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
   * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
   * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
   * </pre>
   *
   * <code>repeated uint32 uint_val = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The uintVal at the given index.
   */
  public int getUintVal(int index) {
    return uintVal_.getInt(index);
  }

  private int uintValMemoizedSerializedSize = -1;

  public static final int UINT64_VAL_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList uint64Val_ = emptyLongList();

  /**
   *
   *
   * <pre>
   * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
   * </pre>
   *
   * <code>repeated uint64 uint64_val = 10;</code>
   *
   * @return A list containing the uint64Val.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getUint64ValList() {
    return uint64Val_;
  }

  /**
   *
   *
   * <pre>
   * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
   * </pre>
   *
   * <code>repeated uint64 uint64_val = 10;</code>
   *
   * @return The count of uint64Val.
   */
  public int getUint64ValCount() {
    return uint64Val_.size();
  }

  /**
   *
   *
   * <pre>
   * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
   * </pre>
   *
   * <code>repeated uint64 uint64_val = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The uint64Val at the given index.
   */
  public long getUint64Val(int index) {
    return uint64Val_.getLong(index);
  }

  private int uint64ValMemoizedSerializedSize = -1;

  public static final int LIST_VAL_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Tensor> listVal_;

  /**
   *
   *
   * <pre>
   * A list of tensor values.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Tensor> getListValList() {
    return listVal_;
  }

  /**
   *
   *
   * <pre>
   * A list of tensor values.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TensorOrBuilder>
      getListValOrBuilderList() {
    return listVal_;
  }

  /**
   *
   *
   * <pre>
   * A list of tensor values.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
   */
  @java.lang.Override
  public int getListValCount() {
    return listVal_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of tensor values.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tensor getListVal(int index) {
    return listVal_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of tensor values.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TensorOrBuilder getListValOrBuilder(int index) {
    return listVal_.get(index);
  }

  public static final int STRUCT_VAL_FIELD_NUMBER = 12;

  private static final class StructValDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>newDefaultInstance(
                    com.google.cloud.aiplatform.v1beta1.TypesProto
                        .internal_static_google_cloud_aiplatform_v1beta1_Tensor_StructValEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.aiplatform.v1beta1.Tensor.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
      structVal_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
      internalGetStructVal() {
    if (structVal_ == null) {
      return com.google.protobuf.MapField.emptyMapField(StructValDefaultEntryHolder.defaultEntry);
    }
    return structVal_;
  }

  public int getStructValCount() {
    return internalGetStructVal().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * A map of string to tensor.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
   */
  @java.lang.Override
  public boolean containsStructVal(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetStructVal().getMap().containsKey(key);
  }

  /** Use {@link #getStructValMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
      getStructVal() {
    return getStructValMap();
  }

  /**
   *
   *
   * <pre>
   * A map of string to tensor.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
      getStructValMap() {
    return internalGetStructVal().getMap();
  }

  /**
   *
   *
   * <pre>
   * A map of string to tensor.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.aiplatform.v1beta1.Tensor getStructValOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.aiplatform.v1beta1.Tensor defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor> map =
        internalGetStructVal().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A map of string to tensor.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tensor getStructValOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor> map =
        internalGetStructVal().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TENSOR_VAL_FIELD_NUMBER = 13;
  private com.google.protobuf.ByteString tensorVal_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Serialized raw tensor content.
   * </pre>
   *
   * <code>bytes tensor_val = 13;</code>
   *
   * @return The tensorVal.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTensorVal() {
    return tensorVal_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (dtype_
        != com.google.cloud.aiplatform.v1beta1.Tensor.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, dtype_);
    }
    if (getShapeList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(shapeMemoizedSerializedSize);
    }
    for (int i = 0; i < shape_.size(); i++) {
      output.writeInt64NoTag(shape_.getLong(i));
    }
    if (getBoolValList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(boolValMemoizedSerializedSize);
    }
    for (int i = 0; i < boolVal_.size(); i++) {
      output.writeBoolNoTag(boolVal_.getBoolean(i));
    }
    if (getFloatValList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(floatValMemoizedSerializedSize);
    }
    for (int i = 0; i < floatVal_.size(); i++) {
      output.writeFloatNoTag(floatVal_.getFloat(i));
    }
    if (getDoubleValList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(doubleValMemoizedSerializedSize);
    }
    for (int i = 0; i < doubleVal_.size(); i++) {
      output.writeDoubleNoTag(doubleVal_.getDouble(i));
    }
    if (getIntValList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(intValMemoizedSerializedSize);
    }
    for (int i = 0; i < intVal_.size(); i++) {
      output.writeInt32NoTag(intVal_.getInt(i));
    }
    if (getInt64ValList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(int64ValMemoizedSerializedSize);
    }
    for (int i = 0; i < int64Val_.size(); i++) {
      output.writeInt64NoTag(int64Val_.getLong(i));
    }
    if (getUintValList().size() > 0) {
      output.writeUInt32NoTag(74);
      output.writeUInt32NoTag(uintValMemoizedSerializedSize);
    }
    for (int i = 0; i < uintVal_.size(); i++) {
      output.writeUInt32NoTag(uintVal_.getInt(i));
    }
    if (getUint64ValList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(uint64ValMemoizedSerializedSize);
    }
    for (int i = 0; i < uint64Val_.size(); i++) {
      output.writeUInt64NoTag(uint64Val_.getLong(i));
    }
    for (int i = 0; i < listVal_.size(); i++) {
      output.writeMessage(11, listVal_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetStructVal(), StructValDefaultEntryHolder.defaultEntry, 12);
    if (!tensorVal_.isEmpty()) {
      output.writeBytes(13, tensorVal_);
    }
    for (int i = 0; i < stringVal_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, stringVal_.getRaw(i));
    }
    for (int i = 0; i < bytesVal_.size(); i++) {
      output.writeBytes(15, bytesVal_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dtype_
        != com.google.cloud.aiplatform.v1beta1.Tensor.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, dtype_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < shape_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(shape_.getLong(i));
      }
      size += dataSize;
      if (!getShapeList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      shapeMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 1 * getBoolValList().size();
      size += dataSize;
      if (!getBoolValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      boolValMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 4 * getFloatValList().size();
      size += dataSize;
      if (!getFloatValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      floatValMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 8 * getDoubleValList().size();
      size += dataSize;
      if (!getDoubleValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      doubleValMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < intVal_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(intVal_.getInt(i));
      }
      size += dataSize;
      if (!getIntValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      intValMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < int64Val_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(int64Val_.getLong(i));
      }
      size += dataSize;
      if (!getInt64ValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      int64ValMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < uintVal_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(uintVal_.getInt(i));
      }
      size += dataSize;
      if (!getUintValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      uintValMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < uint64Val_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeUInt64SizeNoTag(uint64Val_.getLong(i));
      }
      size += dataSize;
      if (!getUint64ValList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      uint64ValMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < listVal_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, listVal_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor> entry :
        internalGetStructVal().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
          structVal__ =
              StructValDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, structVal__);
    }
    if (!tensorVal_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(13, tensorVal_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < stringVal_.size(); i++) {
        dataSize += computeStringSizeNoTag(stringVal_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStringValList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < bytesVal_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(bytesVal_.get(i));
      }
      size += dataSize;
      size += 1 * getBytesValList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Tensor)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Tensor other =
        (com.google.cloud.aiplatform.v1beta1.Tensor) obj;

    if (dtype_ != other.dtype_) return false;
    if (!getShapeList().equals(other.getShapeList())) return false;
    if (!getBoolValList().equals(other.getBoolValList())) return false;
    if (!getStringValList().equals(other.getStringValList())) return false;
    if (!getBytesValList().equals(other.getBytesValList())) return false;
    if (!getFloatValList().equals(other.getFloatValList())) return false;
    if (!getDoubleValList().equals(other.getDoubleValList())) return false;
    if (!getIntValList().equals(other.getIntValList())) return false;
    if (!getInt64ValList().equals(other.getInt64ValList())) return false;
    if (!getUintValList().equals(other.getUintValList())) return false;
    if (!getUint64ValList().equals(other.getUint64ValList())) return false;
    if (!getListValList().equals(other.getListValList())) return false;
    if (!internalGetStructVal().equals(other.internalGetStructVal())) return false;
    if (!getTensorVal().equals(other.getTensorVal())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DTYPE_FIELD_NUMBER;
    hash = (53 * hash) + dtype_;
    if (getShapeCount() > 0) {
      hash = (37 * hash) + SHAPE_FIELD_NUMBER;
      hash = (53 * hash) + getShapeList().hashCode();
    }
    if (getBoolValCount() > 0) {
      hash = (37 * hash) + BOOL_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getBoolValList().hashCode();
    }
    if (getStringValCount() > 0) {
      hash = (37 * hash) + STRING_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getStringValList().hashCode();
    }
    if (getBytesValCount() > 0) {
      hash = (37 * hash) + BYTES_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getBytesValList().hashCode();
    }
    if (getFloatValCount() > 0) {
      hash = (37 * hash) + FLOAT_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getFloatValList().hashCode();
    }
    if (getDoubleValCount() > 0) {
      hash = (37 * hash) + DOUBLE_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getDoubleValList().hashCode();
    }
    if (getIntValCount() > 0) {
      hash = (37 * hash) + INT_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getIntValList().hashCode();
    }
    if (getInt64ValCount() > 0) {
      hash = (37 * hash) + INT64_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getInt64ValList().hashCode();
    }
    if (getUintValCount() > 0) {
      hash = (37 * hash) + UINT_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getUintValList().hashCode();
    }
    if (getUint64ValCount() > 0) {
      hash = (37 * hash) + UINT64_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getUint64ValList().hashCode();
    }
    if (getListValCount() > 0) {
      hash = (37 * hash) + LIST_VAL_FIELD_NUMBER;
      hash = (53 * hash) + getListValList().hashCode();
    }
    if (!internalGetStructVal().getMap().isEmpty()) {
      hash = (37 * hash) + STRUCT_VAL_FIELD_NUMBER;
      hash = (53 * hash) + internalGetStructVal().hashCode();
    }
    hash = (37 * hash) + TENSOR_VAL_FIELD_NUMBER;
    hash = (53 * hash) + getTensorVal().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Tensor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A tensor value type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Tensor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Tensor)
      com.google.cloud.aiplatform.v1beta1.TensorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TypesProto
          .internal_static_google_cloud_aiplatform_v1beta1_Tensor_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetStructVal();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableStructVal();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TypesProto
          .internal_static_google_cloud_aiplatform_v1beta1_Tensor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Tensor.class,
              com.google.cloud.aiplatform.v1beta1.Tensor.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Tensor.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dtype_ = 0;
      shape_ = emptyLongList();
      boolVal_ = emptyBooleanList();
      stringVal_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bytesVal_ = emptyList(com.google.protobuf.ByteString.class);
      floatVal_ = emptyFloatList();
      doubleVal_ = emptyDoubleList();
      intVal_ = emptyIntList();
      int64Val_ = emptyLongList();
      uintVal_ = emptyIntList();
      uint64Val_ = emptyLongList();
      if (listValBuilder_ == null) {
        listVal_ = java.util.Collections.emptyList();
      } else {
        listVal_ = null;
        listValBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      internalGetMutableStructVal().clear();
      tensorVal_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TypesProto
          .internal_static_google_cloud_aiplatform_v1beta1_Tensor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tensor getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Tensor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tensor build() {
      com.google.cloud.aiplatform.v1beta1.Tensor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tensor buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Tensor result =
          new com.google.cloud.aiplatform.v1beta1.Tensor(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.Tensor result) {
      if (listValBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          listVal_ = java.util.Collections.unmodifiableList(listVal_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.listVal_ = listVal_;
      } else {
        result.listVal_ = listValBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Tensor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dtype_ = dtype_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        shape_.makeImmutable();
        result.shape_ = shape_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        boolVal_.makeImmutable();
        result.boolVal_ = boolVal_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        stringVal_.makeImmutable();
        result.stringVal_ = stringVal_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        bytesVal_.makeImmutable();
        result.bytesVal_ = bytesVal_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        floatVal_.makeImmutable();
        result.floatVal_ = floatVal_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        doubleVal_.makeImmutable();
        result.doubleVal_ = doubleVal_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        intVal_.makeImmutable();
        result.intVal_ = intVal_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        int64Val_.makeImmutable();
        result.int64Val_ = int64Val_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        uintVal_.makeImmutable();
        result.uintVal_ = uintVal_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        uint64Val_.makeImmutable();
        result.uint64Val_ = uint64Val_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.structVal_ = internalGetStructVal().build(StructValDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.tensorVal_ = tensorVal_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Tensor) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Tensor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Tensor other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Tensor.getDefaultInstance()) return this;
      if (other.dtype_ != 0) {
        setDtypeValue(other.getDtypeValue());
      }
      if (!other.shape_.isEmpty()) {
        if (shape_.isEmpty()) {
          shape_ = other.shape_;
          shape_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureShapeIsMutable();
          shape_.addAll(other.shape_);
        }
        onChanged();
      }
      if (!other.boolVal_.isEmpty()) {
        if (boolVal_.isEmpty()) {
          boolVal_ = other.boolVal_;
          boolVal_.makeImmutable();
          bitField0_ |= 0x00000004;
        } else {
          ensureBoolValIsMutable();
          boolVal_.addAll(other.boolVal_);
        }
        onChanged();
      }
      if (!other.stringVal_.isEmpty()) {
        if (stringVal_.isEmpty()) {
          stringVal_ = other.stringVal_;
          bitField0_ |= 0x00000008;
        } else {
          ensureStringValIsMutable();
          stringVal_.addAll(other.stringVal_);
        }
        onChanged();
      }
      if (!other.bytesVal_.isEmpty()) {
        if (bytesVal_.isEmpty()) {
          bytesVal_ = other.bytesVal_;
          bytesVal_.makeImmutable();
          bitField0_ |= 0x00000010;
        } else {
          ensureBytesValIsMutable();
          bytesVal_.addAll(other.bytesVal_);
        }
        onChanged();
      }
      if (!other.floatVal_.isEmpty()) {
        if (floatVal_.isEmpty()) {
          floatVal_ = other.floatVal_;
          floatVal_.makeImmutable();
          bitField0_ |= 0x00000020;
        } else {
          ensureFloatValIsMutable();
          floatVal_.addAll(other.floatVal_);
        }
        onChanged();
      }
      if (!other.doubleVal_.isEmpty()) {
        if (doubleVal_.isEmpty()) {
          doubleVal_ = other.doubleVal_;
          doubleVal_.makeImmutable();
          bitField0_ |= 0x00000040;
        } else {
          ensureDoubleValIsMutable();
          doubleVal_.addAll(other.doubleVal_);
        }
        onChanged();
      }
      if (!other.intVal_.isEmpty()) {
        if (intVal_.isEmpty()) {
          intVal_ = other.intVal_;
          intVal_.makeImmutable();
          bitField0_ |= 0x00000080;
        } else {
          ensureIntValIsMutable();
          intVal_.addAll(other.intVal_);
        }
        onChanged();
      }
      if (!other.int64Val_.isEmpty()) {
        if (int64Val_.isEmpty()) {
          int64Val_ = other.int64Val_;
          int64Val_.makeImmutable();
          bitField0_ |= 0x00000100;
        } else {
          ensureInt64ValIsMutable();
          int64Val_.addAll(other.int64Val_);
        }
        onChanged();
      }
      if (!other.uintVal_.isEmpty()) {
        if (uintVal_.isEmpty()) {
          uintVal_ = other.uintVal_;
          uintVal_.makeImmutable();
          bitField0_ |= 0x00000200;
        } else {
          ensureUintValIsMutable();
          uintVal_.addAll(other.uintVal_);
        }
        onChanged();
      }
      if (!other.uint64Val_.isEmpty()) {
        if (uint64Val_.isEmpty()) {
          uint64Val_ = other.uint64Val_;
          uint64Val_.makeImmutable();
          bitField0_ |= 0x00000400;
        } else {
          ensureUint64ValIsMutable();
          uint64Val_.addAll(other.uint64Val_);
        }
        onChanged();
      }
      if (listValBuilder_ == null) {
        if (!other.listVal_.isEmpty()) {
          if (listVal_.isEmpty()) {
            listVal_ = other.listVal_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureListValIsMutable();
            listVal_.addAll(other.listVal_);
          }
          onChanged();
        }
      } else {
        if (!other.listVal_.isEmpty()) {
          if (listValBuilder_.isEmpty()) {
            listValBuilder_.dispose();
            listValBuilder_ = null;
            listVal_ = other.listVal_;
            bitField0_ = (bitField0_ & ~0x00000800);
            listValBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListValFieldBuilder()
                    : null;
          } else {
            listValBuilder_.addAllMessages(other.listVal_);
          }
        }
      }
      internalGetMutableStructVal().mergeFrom(other.internalGetStructVal());
      bitField0_ |= 0x00001000;
      if (other.getTensorVal() != com.google.protobuf.ByteString.EMPTY) {
        setTensorVal(other.getTensorVal());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                dtype_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                long v = input.readInt64();
                ensureShapeIsMutable();
                shape_.addLong(v);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureShapeIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  shape_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 18
            case 24:
              {
                boolean v = input.readBool();
                ensureBoolValIsMutable();
                boolVal_.addBoolean(v);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureBoolValIsMutable(alloc / 1);
                while (input.getBytesUntilLimit() > 0) {
                  boolVal_.addBoolean(input.readBool());
                }
                input.popLimit(limit);
                break;
              } // case 26
            case 45:
              {
                float v = input.readFloat();
                ensureFloatValIsMutable();
                floatVal_.addFloat(v);
                break;
              } // case 45
            case 42:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureFloatValIsMutable(alloc / 4);
                while (input.getBytesUntilLimit() > 0) {
                  floatVal_.addFloat(input.readFloat());
                }
                input.popLimit(limit);
                break;
              } // case 42
            case 49:
              {
                double v = input.readDouble();
                ensureDoubleValIsMutable();
                doubleVal_.addDouble(v);
                break;
              } // case 49
            case 50:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureDoubleValIsMutable(alloc / 8);
                while (input.getBytesUntilLimit() > 0) {
                  doubleVal_.addDouble(input.readDouble());
                }
                input.popLimit(limit);
                break;
              } // case 50
            case 56:
              {
                int v = input.readInt32();
                ensureIntValIsMutable();
                intVal_.addInt(v);
                break;
              } // case 56
            case 58:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureIntValIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  intVal_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 58
            case 64:
              {
                long v = input.readInt64();
                ensureInt64ValIsMutable();
                int64Val_.addLong(v);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureInt64ValIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  int64Val_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 66
            case 72:
              {
                int v = input.readUInt32();
                ensureUintValIsMutable();
                uintVal_.addInt(v);
                break;
              } // case 72
            case 74:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureUintValIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  uintVal_.addInt(input.readUInt32());
                }
                input.popLimit(limit);
                break;
              } // case 74
            case 80:
              {
                long v = input.readUInt64();
                ensureUint64ValIsMutable();
                uint64Val_.addLong(v);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureUint64ValIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  uint64Val_.addLong(input.readUInt64());
                }
                input.popLimit(limit);
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.aiplatform.v1beta1.Tensor m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Tensor.parser(), extensionRegistry);
                if (listValBuilder_ == null) {
                  ensureListValIsMutable();
                  listVal_.add(m);
                } else {
                  listValBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
                    structVal__ =
                        input.readMessage(
                            StructValDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableStructVal()
                    .ensureBuilderMap()
                    .put(structVal__.getKey(), structVal__.getValue());
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                tensorVal_ = input.readBytes();
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStringValIsMutable();
                stringVal_.add(s);
                break;
              } // case 114
            case 122:
              {
                com.google.protobuf.ByteString v = input.readBytes();
                ensureBytesValIsMutable();
                bytesVal_.add(v);
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int dtype_ = 0;

    /**
     *
     *
     * <pre>
     * The data type of tensor.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
     *
     * @return The enum numeric value on the wire for dtype.
     */
    @java.lang.Override
    public int getDtypeValue() {
      return dtype_;
    }

    /**
     *
     *
     * <pre>
     * The data type of tensor.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
     *
     * @param value The enum numeric value on the wire for dtype to set.
     * @return This builder for chaining.
     */
    public Builder setDtypeValue(int value) {
      dtype_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data type of tensor.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
     *
     * @return The dtype.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tensor.DataType getDtype() {
      com.google.cloud.aiplatform.v1beta1.Tensor.DataType result =
          com.google.cloud.aiplatform.v1beta1.Tensor.DataType.forNumber(dtype_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.Tensor.DataType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The data type of tensor.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
     *
     * @param value The dtype to set.
     * @return This builder for chaining.
     */
    public Builder setDtype(com.google.cloud.aiplatform.v1beta1.Tensor.DataType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      dtype_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data type of tensor.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Tensor.DataType dtype = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDtype() {
      bitField0_ = (bitField0_ & ~0x00000001);
      dtype_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList shape_ = emptyLongList();

    private void ensureShapeIsMutable() {
      if (!shape_.isModifiable()) {
        shape_ = makeMutableCopy(shape_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @return A list containing the shape.
     */
    public java.util.List<java.lang.Long> getShapeList() {
      shape_.makeImmutable();
      return shape_;
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @return The count of shape.
     */
    public int getShapeCount() {
      return shape_.size();
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The shape at the given index.
     */
    public long getShape(int index) {
      return shape_.getLong(index);
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The shape to set.
     * @return This builder for chaining.
     */
    public Builder setShape(int index, long value) {

      ensureShapeIsMutable();
      shape_.setLong(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @param value The shape to add.
     * @return This builder for chaining.
     */
    public Builder addShape(long value) {

      ensureShapeIsMutable();
      shape_.addLong(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @param values The shape to add.
     * @return This builder for chaining.
     */
    public Builder addAllShape(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureShapeIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shape_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shape of the tensor.
     * </pre>
     *
     * <code>repeated int64 shape = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShape() {
      shape_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.BooleanList boolVal_ = emptyBooleanList();

    private void ensureBoolValIsMutable() {
      if (!boolVal_.isModifiable()) {
        boolVal_ = makeMutableCopy(boolVal_);
      }
      bitField0_ |= 0x00000004;
    }

    private void ensureBoolValIsMutable(int capacity) {
      if (!boolVal_.isModifiable()) {
        boolVal_ = makeMutableCopy(boolVal_, capacity);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @return A list containing the boolVal.
     */
    public java.util.List<java.lang.Boolean> getBoolValList() {
      boolVal_.makeImmutable();
      return boolVal_;
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @return The count of boolVal.
     */
    public int getBoolValCount() {
      return boolVal_.size();
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The boolVal at the given index.
     */
    public boolean getBoolVal(int index) {
      return boolVal_.getBoolean(index);
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The boolVal to set.
     * @return This builder for chaining.
     */
    public Builder setBoolVal(int index, boolean value) {

      ensureBoolValIsMutable();
      boolVal_.setBoolean(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @param value The boolVal to add.
     * @return This builder for chaining.
     */
    public Builder addBoolVal(boolean value) {

      ensureBoolValIsMutable();
      boolVal_.addBoolean(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @param values The boolVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllBoolVal(java.lang.Iterable<? extends java.lang.Boolean> values) {
      ensureBoolValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, boolVal_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type specific representations that make it easy to create tensor protos in
     * all languages.  Only the representation corresponding to "dtype" can
     * be set.  The values hold the flattened representation of the tensor in
     * row major order.
     *
     * [BOOL][google.aiplatform.master.Tensor.DataType.BOOL]
     * </pre>
     *
     * <code>repeated bool bool_val = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoolVal() {
      boolVal_ = emptyBooleanList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList stringVal_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStringValIsMutable() {
      if (!stringVal_.isModifiable()) {
        stringVal_ = new com.google.protobuf.LazyStringArrayList(stringVal_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @return A list containing the stringVal.
     */
    public com.google.protobuf.ProtocolStringList getStringValList() {
      stringVal_.makeImmutable();
      return stringVal_;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @return The count of stringVal.
     */
    public int getStringValCount() {
      return stringVal_.size();
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @param index The index of the element to return.
     * @return The stringVal at the given index.
     */
    public java.lang.String getStringVal(int index) {
      return stringVal_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the stringVal at the given index.
     */
    public com.google.protobuf.ByteString getStringValBytes(int index) {
      return stringVal_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @param index The index to set the value at.
     * @param value The stringVal to set.
     * @return This builder for chaining.
     */
    public Builder setStringVal(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStringValIsMutable();
      stringVal_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @param value The stringVal to add.
     * @return This builder for chaining.
     */
    public Builder addStringVal(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStringValIsMutable();
      stringVal_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @param values The stringVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllStringVal(java.lang.Iterable<java.lang.String> values) {
      ensureStringValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stringVal_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringVal() {
      stringVal_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated string string_val = 14;</code>
     *
     * @param value The bytes of the stringVal to add.
     * @return This builder for chaining.
     */
    public Builder addStringValBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStringValIsMutable();
      stringVal_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> bytesVal_ =
        emptyList(com.google.protobuf.ByteString.class);

    private void ensureBytesValIsMutable() {
      if (!bytesVal_.isModifiable()) {
        bytesVal_ = makeMutableCopy(bytesVal_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @return A list containing the bytesVal.
     */
    public java.util.List<com.google.protobuf.ByteString> getBytesValList() {
      bytesVal_.makeImmutable();
      return bytesVal_;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @return The count of bytesVal.
     */
    public int getBytesValCount() {
      return bytesVal_.size();
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The bytesVal at the given index.
     */
    public com.google.protobuf.ByteString getBytesVal(int index) {
      return bytesVal_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The bytesVal to set.
     * @return This builder for chaining.
     */
    public Builder setBytesVal(int index, com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBytesValIsMutable();
      bytesVal_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @param value The bytesVal to add.
     * @return This builder for chaining.
     */
    public Builder addBytesVal(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBytesValIsMutable();
      bytesVal_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @param values The bytesVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllBytesVal(
        java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
      ensureBytesValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bytesVal_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [STRING][google.aiplatform.master.Tensor.DataType.STRING]
     * </pre>
     *
     * <code>repeated bytes bytes_val = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBytesVal() {
      bytesVal_ = emptyList(com.google.protobuf.ByteString.class);
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.FloatList floatVal_ = emptyFloatList();

    private void ensureFloatValIsMutable() {
      if (!floatVal_.isModifiable()) {
        floatVal_ = makeMutableCopy(floatVal_);
      }
      bitField0_ |= 0x00000020;
    }

    private void ensureFloatValIsMutable(int capacity) {
      if (!floatVal_.isModifiable()) {
        floatVal_ = makeMutableCopy(floatVal_, capacity);
      }
      bitField0_ |= 0x00000020;
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @return A list containing the floatVal.
     */
    public java.util.List<java.lang.Float> getFloatValList() {
      floatVal_.makeImmutable();
      return floatVal_;
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @return The count of floatVal.
     */
    public int getFloatValCount() {
      return floatVal_.size();
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The floatVal at the given index.
     */
    public float getFloatVal(int index) {
      return floatVal_.getFloat(index);
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The floatVal to set.
     * @return This builder for chaining.
     */
    public Builder setFloatVal(int index, float value) {

      ensureFloatValIsMutable();
      floatVal_.setFloat(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @param value The floatVal to add.
     * @return This builder for chaining.
     */
    public Builder addFloatVal(float value) {

      ensureFloatValIsMutable();
      floatVal_.addFloat(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @param values The floatVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllFloatVal(java.lang.Iterable<? extends java.lang.Float> values) {
      ensureFloatValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, floatVal_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [FLOAT][google.aiplatform.master.Tensor.DataType.FLOAT]
     * </pre>
     *
     * <code>repeated float float_val = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFloatVal() {
      floatVal_ = emptyFloatList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList doubleVal_ = emptyDoubleList();

    private void ensureDoubleValIsMutable() {
      if (!doubleVal_.isModifiable()) {
        doubleVal_ = makeMutableCopy(doubleVal_);
      }
      bitField0_ |= 0x00000040;
    }

    private void ensureDoubleValIsMutable(int capacity) {
      if (!doubleVal_.isModifiable()) {
        doubleVal_ = makeMutableCopy(doubleVal_, capacity);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @return A list containing the doubleVal.
     */
    public java.util.List<java.lang.Double> getDoubleValList() {
      doubleVal_.makeImmutable();
      return doubleVal_;
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @return The count of doubleVal.
     */
    public int getDoubleValCount() {
      return doubleVal_.size();
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The doubleVal at the given index.
     */
    public double getDoubleVal(int index) {
      return doubleVal_.getDouble(index);
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The doubleVal to set.
     * @return This builder for chaining.
     */
    public Builder setDoubleVal(int index, double value) {

      ensureDoubleValIsMutable();
      doubleVal_.setDouble(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @param value The doubleVal to add.
     * @return This builder for chaining.
     */
    public Builder addDoubleVal(double value) {

      ensureDoubleValIsMutable();
      doubleVal_.addDouble(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @param values The doubleVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllDoubleVal(java.lang.Iterable<? extends java.lang.Double> values) {
      ensureDoubleValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, doubleVal_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [DOUBLE][google.aiplatform.master.Tensor.DataType.DOUBLE]
     * </pre>
     *
     * <code>repeated double double_val = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDoubleVal() {
      doubleVal_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList intVal_ = emptyIntList();

    private void ensureIntValIsMutable() {
      if (!intVal_.isModifiable()) {
        intVal_ = makeMutableCopy(intVal_);
      }
      bitField0_ |= 0x00000080;
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @return A list containing the intVal.
     */
    public java.util.List<java.lang.Integer> getIntValList() {
      intVal_.makeImmutable();
      return intVal_;
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @return The count of intVal.
     */
    public int getIntValCount() {
      return intVal_.size();
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The intVal at the given index.
     */
    public int getIntVal(int index) {
      return intVal_.getInt(index);
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The intVal to set.
     * @return This builder for chaining.
     */
    public Builder setIntVal(int index, int value) {

      ensureIntValIsMutable();
      intVal_.setInt(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @param value The intVal to add.
     * @return This builder for chaining.
     */
    public Builder addIntVal(int value) {

      ensureIntValIsMutable();
      intVal_.addInt(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @param values The intVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllIntVal(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureIntValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intVal_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [INT_8][google.aiplatform.master.Tensor.DataType.INT8]
     * [INT_16][google.aiplatform.master.Tensor.DataType.INT16]
     * [INT_32][google.aiplatform.master.Tensor.DataType.INT32]
     * </pre>
     *
     * <code>repeated int32 int_val = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntVal() {
      intVal_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList int64Val_ = emptyLongList();

    private void ensureInt64ValIsMutable() {
      if (!int64Val_.isModifiable()) {
        int64Val_ = makeMutableCopy(int64Val_);
      }
      bitField0_ |= 0x00000100;
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @return A list containing the int64Val.
     */
    public java.util.List<java.lang.Long> getInt64ValList() {
      int64Val_.makeImmutable();
      return int64Val_;
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @return The count of int64Val.
     */
    public int getInt64ValCount() {
      return int64Val_.size();
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The int64Val at the given index.
     */
    public long getInt64Val(int index) {
      return int64Val_.getLong(index);
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The int64Val to set.
     * @return This builder for chaining.
     */
    public Builder setInt64Val(int index, long value) {

      ensureInt64ValIsMutable();
      int64Val_.setLong(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @param value The int64Val to add.
     * @return This builder for chaining.
     */
    public Builder addInt64Val(long value) {

      ensureInt64ValIsMutable();
      int64Val_.addLong(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @param values The int64Val to add.
     * @return This builder for chaining.
     */
    public Builder addAllInt64Val(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureInt64ValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, int64Val_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [INT64][google.aiplatform.master.Tensor.DataType.INT64]
     * </pre>
     *
     * <code>repeated int64 int64_val = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInt64Val() {
      int64Val_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList uintVal_ = emptyIntList();

    private void ensureUintValIsMutable() {
      if (!uintVal_.isModifiable()) {
        uintVal_ = makeMutableCopy(uintVal_);
      }
      bitField0_ |= 0x00000200;
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @return A list containing the uintVal.
     */
    public java.util.List<java.lang.Integer> getUintValList() {
      uintVal_.makeImmutable();
      return uintVal_;
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @return The count of uintVal.
     */
    public int getUintValCount() {
      return uintVal_.size();
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The uintVal at the given index.
     */
    public int getUintVal(int index) {
      return uintVal_.getInt(index);
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The uintVal to set.
     * @return This builder for chaining.
     */
    public Builder setUintVal(int index, int value) {

      ensureUintValIsMutable();
      uintVal_.setInt(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @param value The uintVal to add.
     * @return This builder for chaining.
     */
    public Builder addUintVal(int value) {

      ensureUintValIsMutable();
      uintVal_.addInt(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @param values The uintVal to add.
     * @return This builder for chaining.
     */
    public Builder addAllUintVal(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureUintValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uintVal_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [UINT8][google.aiplatform.master.Tensor.DataType.UINT8]
     * [UINT16][google.aiplatform.master.Tensor.DataType.UINT16]
     * [UINT32][google.aiplatform.master.Tensor.DataType.UINT32]
     * </pre>
     *
     * <code>repeated uint32 uint_val = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUintVal() {
      uintVal_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList uint64Val_ = emptyLongList();

    private void ensureUint64ValIsMutable() {
      if (!uint64Val_.isModifiable()) {
        uint64Val_ = makeMutableCopy(uint64Val_);
      }
      bitField0_ |= 0x00000400;
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @return A list containing the uint64Val.
     */
    public java.util.List<java.lang.Long> getUint64ValList() {
      uint64Val_.makeImmutable();
      return uint64Val_;
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @return The count of uint64Val.
     */
    public int getUint64ValCount() {
      return uint64Val_.size();
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The uint64Val at the given index.
     */
    public long getUint64Val(int index) {
      return uint64Val_.getLong(index);
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The uint64Val to set.
     * @return This builder for chaining.
     */
    public Builder setUint64Val(int index, long value) {

      ensureUint64ValIsMutable();
      uint64Val_.setLong(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @param value The uint64Val to add.
     * @return This builder for chaining.
     */
    public Builder addUint64Val(long value) {

      ensureUint64ValIsMutable();
      uint64Val_.addLong(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @param values The uint64Val to add.
     * @return This builder for chaining.
     */
    public Builder addAllUint64Val(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureUint64ValIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uint64Val_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [UINT64][google.aiplatform.master.Tensor.DataType.UINT64]
     * </pre>
     *
     * <code>repeated uint64 uint64_val = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUint64Val() {
      uint64Val_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Tensor> listVal_ =
        java.util.Collections.emptyList();

    private void ensureListValIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        listVal_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Tensor>(listVal_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tensor,
            com.google.cloud.aiplatform.v1beta1.Tensor.Builder,
            com.google.cloud.aiplatform.v1beta1.TensorOrBuilder>
        listValBuilder_;

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tensor> getListValList() {
      if (listValBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listVal_);
      } else {
        return listValBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public int getListValCount() {
      if (listValBuilder_ == null) {
        return listVal_.size();
      } else {
        return listValBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tensor getListVal(int index) {
      if (listValBuilder_ == null) {
        return listVal_.get(index);
      } else {
        return listValBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder setListVal(int index, com.google.cloud.aiplatform.v1beta1.Tensor value) {
      if (listValBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListValIsMutable();
        listVal_.set(index, value);
        onChanged();
      } else {
        listValBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder setListVal(
        int index, com.google.cloud.aiplatform.v1beta1.Tensor.Builder builderForValue) {
      if (listValBuilder_ == null) {
        ensureListValIsMutable();
        listVal_.set(index, builderForValue.build());
        onChanged();
      } else {
        listValBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder addListVal(com.google.cloud.aiplatform.v1beta1.Tensor value) {
      if (listValBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListValIsMutable();
        listVal_.add(value);
        onChanged();
      } else {
        listValBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder addListVal(int index, com.google.cloud.aiplatform.v1beta1.Tensor value) {
      if (listValBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListValIsMutable();
        listVal_.add(index, value);
        onChanged();
      } else {
        listValBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder addListVal(com.google.cloud.aiplatform.v1beta1.Tensor.Builder builderForValue) {
      if (listValBuilder_ == null) {
        ensureListValIsMutable();
        listVal_.add(builderForValue.build());
        onChanged();
      } else {
        listValBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder addListVal(
        int index, com.google.cloud.aiplatform.v1beta1.Tensor.Builder builderForValue) {
      if (listValBuilder_ == null) {
        ensureListValIsMutable();
        listVal_.add(index, builderForValue.build());
        onChanged();
      } else {
        listValBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder addAllListVal(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Tensor> values) {
      if (listValBuilder_ == null) {
        ensureListValIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listVal_);
        onChanged();
      } else {
        listValBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder clearListVal() {
      if (listValBuilder_ == null) {
        listVal_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        listValBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public Builder removeListVal(int index) {
      if (listValBuilder_ == null) {
        ensureListValIsMutable();
        listVal_.remove(index);
        onChanged();
      } else {
        listValBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tensor.Builder getListValBuilder(int index) {
      return getListValFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.TensorOrBuilder getListValOrBuilder(int index) {
      if (listValBuilder_ == null) {
        return listVal_.get(index);
      } else {
        return listValBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TensorOrBuilder>
        getListValOrBuilderList() {
      if (listValBuilder_ != null) {
        return listValBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listVal_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tensor.Builder addListValBuilder() {
      return getListValFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Tensor.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tensor.Builder addListValBuilder(int index) {
      return getListValFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Tensor.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of tensor values.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.Tensor list_val = 11;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tensor.Builder>
        getListValBuilderList() {
      return getListValFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tensor,
            com.google.cloud.aiplatform.v1beta1.Tensor.Builder,
            com.google.cloud.aiplatform.v1beta1.TensorOrBuilder>
        getListValFieldBuilder() {
      if (listValBuilder_ == null) {
        listValBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Tensor,
                com.google.cloud.aiplatform.v1beta1.Tensor.Builder,
                com.google.cloud.aiplatform.v1beta1.TensorOrBuilder>(
                listVal_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        listVal_ = null;
      }
      return listValBuilder_;
    }

    private static final class StructValConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.TensorOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Tensor> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Tensor build(
          com.google.cloud.aiplatform.v1beta1.TensorOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1beta1.Tensor) {
          return (com.google.cloud.aiplatform.v1beta1.Tensor) val;
        }
        return ((com.google.cloud.aiplatform.v1beta1.Tensor.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
          defaultEntry() {
        return StructValDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final StructValConverter structValConverter = new StructValConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.TensorOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Tensor,
            com.google.cloud.aiplatform.v1beta1.Tensor.Builder>
        structVal_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.TensorOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Tensor,
            com.google.cloud.aiplatform.v1beta1.Tensor.Builder>
        internalGetStructVal() {
      if (structVal_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(structValConverter);
      }
      return structVal_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.TensorOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Tensor,
            com.google.cloud.aiplatform.v1beta1.Tensor.Builder>
        internalGetMutableStructVal() {
      if (structVal_ == null) {
        structVal_ = new com.google.protobuf.MapFieldBuilder<>(structValConverter);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return structVal_;
    }

    public int getStructValCount() {
      return internalGetStructVal().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    @java.lang.Override
    public boolean containsStructVal(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetStructVal().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getStructValMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
        getStructVal() {
      return getStructValMap();
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
        getStructValMap() {
      return internalGetStructVal().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.Tensor getStructValOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.Tensor defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.TensorOrBuilder> map =
          internalGetMutableStructVal().ensureBuilderMap();
      return map.containsKey(key) ? structValConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tensor getStructValOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.TensorOrBuilder> map =
          internalGetMutableStructVal().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return structValConverter.build(map.get(key));
    }

    public Builder clearStructVal() {
      bitField0_ = (bitField0_ & ~0x00001000);
      internalGetMutableStructVal().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    public Builder removeStructVal(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableStructVal().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor>
        getMutableStructVal() {
      bitField0_ |= 0x00001000;
      return internalGetMutableStructVal().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    public Builder putStructVal(
        java.lang.String key, com.google.cloud.aiplatform.v1beta1.Tensor value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableStructVal().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00001000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    public Builder putAllStructVal(
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Tensor> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableStructVal().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00001000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of string to tensor.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.aiplatform.v1beta1.Tensor&gt; struct_val = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tensor.Builder putStructValBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.TensorOrBuilder>
          builderMap = internalGetMutableStructVal().ensureBuilderMap();
      com.google.cloud.aiplatform.v1beta1.TensorOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1beta1.Tensor.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1beta1.Tensor) {
        entry = ((com.google.cloud.aiplatform.v1beta1.Tensor) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1beta1.Tensor.Builder) entry;
    }

    private com.google.protobuf.ByteString tensorVal_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Serialized raw tensor content.
     * </pre>
     *
     * <code>bytes tensor_val = 13;</code>
     *
     * @return The tensorVal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTensorVal() {
      return tensorVal_;
    }

    /**
     *
     *
     * <pre>
     * Serialized raw tensor content.
     * </pre>
     *
     * <code>bytes tensor_val = 13;</code>
     *
     * @param value The tensorVal to set.
     * @return This builder for chaining.
     */
    public Builder setTensorVal(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tensorVal_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Serialized raw tensor content.
     * </pre>
     *
     * <code>bytes tensor_val = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTensorVal() {
      bitField0_ = (bitField0_ & ~0x00002000);
      tensorVal_ = getDefaultInstance().getTensorVal();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Tensor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Tensor)
  private static final com.google.cloud.aiplatform.v1beta1.Tensor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Tensor();
  }

  public static com.google.cloud.aiplatform.v1beta1.Tensor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tensor> PARSER =
      new com.google.protobuf.AbstractParser<Tensor>() {
        @java.lang.Override
        public Tensor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Tensor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tensor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tensor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
