/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

public interface SupervisedTuningDataStatsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Number of examples in the tuning dataset.
   * </pre>
   *
   * <code>int64 tuning_dataset_example_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tuningDatasetExampleCount.
   */
  long getTuningDatasetExampleCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of tuning characters in the tuning dataset.
   * </pre>
   *
   * <code>int64 total_tuning_character_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The totalTuningCharacterCount.
   */
  long getTotalTuningCharacterCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of billable characters in the tuning dataset.
   * </pre>
   *
   * <code>
   * int64 total_billable_character_count = 3 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated
   *     google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.total_billable_character_count is
   *     deprecated. See google/cloud/aiplatform/v1beta1/tuning_job.proto;l=238
   * @return The totalBillableCharacterCount.
   */
  @java.lang.Deprecated
  long getTotalBillableCharacterCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of billable tokens in the tuning dataset.
   * </pre>
   *
   * <code>int64 total_billable_token_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The totalBillableTokenCount.
   */
  long getTotalBillableTokenCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of tuning steps for this Tuning Job.
   * </pre>
   *
   * <code>int64 tuning_step_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tuningStepCount.
   */
  long getTuningStepCount();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user input tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userInputTokenDistribution field is set.
   */
  boolean hasUserInputTokenDistribution();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user input tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userInputTokenDistribution.
   */
  com.google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
      getUserInputTokenDistribution();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user input tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistributionOrBuilder
      getUserInputTokenDistributionOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user output tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userOutputTokenDistribution field is set.
   */
  boolean hasUserOutputTokenDistribution();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user output tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userOutputTokenDistribution.
   */
  com.google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
      getUserOutputTokenDistribution();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user output tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistributionOrBuilder
      getUserOutputTokenDistributionOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the messages per example.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userMessagePerExampleDistribution field is set.
   */
  boolean hasUserMessagePerExampleDistribution();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the messages per example.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userMessagePerExampleDistribution.
   */
  com.google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
      getUserMessagePerExampleDistribution();

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the messages per example.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistributionOrBuilder
      getUserMessagePerExampleDistributionOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getUserDatasetExamplesList();

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.Content getUserDatasetExamples(int index);

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getUserDatasetExamplesCount();

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
      getUserDatasetExamplesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getUserDatasetExamplesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The number of examples in the dataset that have been truncated by any
   * amount.
   * </pre>
   *
   * <code>int64 total_truncated_example_count = 10;</code>
   *
   * @return The totalTruncatedExampleCount.
   */
  long getTotalTruncatedExampleCount();

  /**
   *
   *
   * <pre>
   * A partial sample of the indices (starting from 1) of the truncated
   * examples.
   * </pre>
   *
   * <code>repeated int64 truncated_example_indices = 11;</code>
   *
   * @return A list containing the truncatedExampleIndices.
   */
  java.util.List<java.lang.Long> getTruncatedExampleIndicesList();

  /**
   *
   *
   * <pre>
   * A partial sample of the indices (starting from 1) of the truncated
   * examples.
   * </pre>
   *
   * <code>repeated int64 truncated_example_indices = 11;</code>
   *
   * @return The count of truncatedExampleIndices.
   */
  int getTruncatedExampleIndicesCount();

  /**
   *
   *
   * <pre>
   * A partial sample of the indices (starting from 1) of the truncated
   * examples.
   * </pre>
   *
   * <code>repeated int64 truncated_example_indices = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The truncatedExampleIndices at the given index.
   */
  long getTruncatedExampleIndices(int index);
}
