/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/example_store_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ExampleStoreService.RemoveExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.RemoveExamples].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RemoveExamplesRequest}
 */
public final class RemoveExamplesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RemoveExamplesRequest)
    RemoveExamplesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RemoveExamplesRequest.newBuilder() to construct.
  private RemoveExamplesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RemoveExamplesRequest() {
    exampleStore_ = "";
    exampleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RemoveExamplesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RemoveExamplesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RemoveExamplesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.class,
            com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.Builder.class);
  }

  private int metadataFilterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadataFilter_;

  public enum MetadataFilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STORED_CONTENTS_EXAMPLE_FILTER(8),
    METADATAFILTER_NOT_SET(0);
    private final int value;

    private MetadataFilterCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataFilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataFilterCase forNumber(int value) {
      switch (value) {
        case 8:
          return STORED_CONTENTS_EXAMPLE_FILTER;
        case 0:
          return METADATAFILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataFilterCase getMetadataFilterCase() {
    return MetadataFilterCase.forNumber(metadataFilterCase_);
  }

  public static final int STORED_CONTENTS_EXAMPLE_FILTER_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * The metadata filters for StoredContentsExamples.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
   * </code>
   *
   * @return Whether the storedContentsExampleFilter field is set.
   */
  @java.lang.Override
  public boolean hasStoredContentsExampleFilter() {
    return metadataFilterCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * The metadata filters for StoredContentsExamples.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
   * </code>
   *
   * @return The storedContentsExampleFilter.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter
      getStoredContentsExampleFilter() {
    if (metadataFilterCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_;
    }
    return com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The metadata filters for StoredContentsExamples.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilterOrBuilder
      getStoredContentsExampleFilterOrBuilder() {
    if (metadataFilterCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_;
    }
    return com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.getDefaultInstance();
  }

  public static final int EXAMPLE_STORE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object exampleStore_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the ExampleStore resource that the examples should be
   * removed from. Format:
   * `projects/{project}/locations/{location}/exampleStores/{example_store}`
   * </pre>
   *
   * <code>
   * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The exampleStore.
   */
  @java.lang.Override
  public java.lang.String getExampleStore() {
    java.lang.Object ref = exampleStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      exampleStore_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the ExampleStore resource that the examples should be
   * removed from. Format:
   * `projects/{project}/locations/{location}/exampleStores/{example_store}`
   * </pre>
   *
   * <code>
   * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for exampleStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExampleStoreBytes() {
    java.lang.Object ref = exampleStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      exampleStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXAMPLE_IDS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList exampleIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Example IDs to remove. If both metadata filters and Example IDs
   * are specified, the metadata filters will be applied to the specified
   * examples in order to identify which should be removed.
   * </pre>
   *
   * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the exampleIds.
   */
  public com.google.protobuf.ProtocolStringList getExampleIdsList() {
    return exampleIds_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Example IDs to remove. If both metadata filters and Example IDs
   * are specified, the metadata filters will be applied to the specified
   * examples in order to identify which should be removed.
   * </pre>
   *
   * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of exampleIds.
   */
  public int getExampleIdsCount() {
    return exampleIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Example IDs to remove. If both metadata filters and Example IDs
   * are specified, the metadata filters will be applied to the specified
   * examples in order to identify which should be removed.
   * </pre>
   *
   * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The exampleIds at the given index.
   */
  public java.lang.String getExampleIds(int index) {
    return exampleIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Example IDs to remove. If both metadata filters and Example IDs
   * are specified, the metadata filters will be applied to the specified
   * examples in order to identify which should be removed.
   * </pre>
   *
   * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the exampleIds at the given index.
   */
  public com.google.protobuf.ByteString getExampleIdsBytes(int index) {
    return exampleIds_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, exampleStore_);
    }
    for (int i = 0; i < exampleIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, exampleIds_.getRaw(i));
    }
    if (metadataFilterCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, exampleStore_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < exampleIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(exampleIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExampleIdsList().size();
    }
    if (metadataFilterCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest other =
        (com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest) obj;

    if (!getExampleStore().equals(other.getExampleStore())) return false;
    if (!getExampleIdsList().equals(other.getExampleIdsList())) return false;
    if (!getMetadataFilterCase().equals(other.getMetadataFilterCase())) return false;
    switch (metadataFilterCase_) {
      case 8:
        if (!getStoredContentsExampleFilter().equals(other.getStoredContentsExampleFilter()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXAMPLE_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getExampleStore().hashCode();
    if (getExampleIdsCount() > 0) {
      hash = (37 * hash) + EXAMPLE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getExampleIdsList().hashCode();
    }
    switch (metadataFilterCase_) {
      case 8:
        hash = (37 * hash) + STORED_CONTENTS_EXAMPLE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getStoredContentsExampleFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ExampleStoreService.RemoveExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.RemoveExamples].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RemoveExamplesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RemoveExamplesRequest)
      com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RemoveExamplesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RemoveExamplesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.class,
              com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (storedContentsExampleFilterBuilder_ != null) {
        storedContentsExampleFilterBuilder_.clear();
      }
      exampleStore_ = "";
      exampleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      metadataFilterCase_ = 0;
      metadataFilter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RemoveExamplesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest build() {
      com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest result =
          new com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.exampleStore_ = exampleStore_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        exampleIds_.makeImmutable();
        result.exampleIds_ = exampleIds_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest result) {
      result.metadataFilterCase_ = metadataFilterCase_;
      result.metadataFilter_ = this.metadataFilter_;
      if (metadataFilterCase_ == 8 && storedContentsExampleFilterBuilder_ != null) {
        result.metadataFilter_ = storedContentsExampleFilterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.getDefaultInstance())
        return this;
      if (!other.getExampleStore().isEmpty()) {
        exampleStore_ = other.exampleStore_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.exampleIds_.isEmpty()) {
        if (exampleIds_.isEmpty()) {
          exampleIds_ = other.exampleIds_;
          bitField0_ |= 0x00000004;
        } else {
          ensureExampleIdsIsMutable();
          exampleIds_.addAll(other.exampleIds_);
        }
        onChanged();
      }
      switch (other.getMetadataFilterCase()) {
        case STORED_CONTENTS_EXAMPLE_FILTER:
          {
            mergeStoredContentsExampleFilter(other.getStoredContentsExampleFilter());
            break;
          }
        case METADATAFILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                exampleStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExampleIdsIsMutable();
                exampleIds_.add(s);
                break;
              } // case 50
            case 66:
              {
                input.readMessage(
                    getStoredContentsExampleFilterFieldBuilder().getBuilder(), extensionRegistry);
                metadataFilterCase_ = 8;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metadataFilterCase_ = 0;
    private java.lang.Object metadataFilter_;

    public MetadataFilterCase getMetadataFilterCase() {
      return MetadataFilterCase.forNumber(metadataFilterCase_);
    }

    public Builder clearMetadataFilter() {
      metadataFilterCase_ = 0;
      metadataFilter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.Builder,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilterOrBuilder>
        storedContentsExampleFilterBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     *
     * @return Whether the storedContentsExampleFilter field is set.
     */
    @java.lang.Override
    public boolean hasStoredContentsExampleFilter() {
      return metadataFilterCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     *
     * @return The storedContentsExampleFilter.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter
        getStoredContentsExampleFilter() {
      if (storedContentsExampleFilterBuilder_ == null) {
        if (metadataFilterCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_;
        }
        return com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.getDefaultInstance();
      } else {
        if (metadataFilterCase_ == 8) {
          return storedContentsExampleFilterBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    public Builder setStoredContentsExampleFilter(
        com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter value) {
      if (storedContentsExampleFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataFilter_ = value;
        onChanged();
      } else {
        storedContentsExampleFilterBuilder_.setMessage(value);
      }
      metadataFilterCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    public Builder setStoredContentsExampleFilter(
        com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.Builder builderForValue) {
      if (storedContentsExampleFilterBuilder_ == null) {
        metadataFilter_ = builderForValue.build();
        onChanged();
      } else {
        storedContentsExampleFilterBuilder_.setMessage(builderForValue.build());
      }
      metadataFilterCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    public Builder mergeStoredContentsExampleFilter(
        com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter value) {
      if (storedContentsExampleFilterBuilder_ == null) {
        if (metadataFilterCase_ == 8
            && metadataFilter_
                != com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter
                    .getDefaultInstance()) {
          metadataFilter_ =
              com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter)
                          metadataFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataFilter_ = value;
        }
        onChanged();
      } else {
        if (metadataFilterCase_ == 8) {
          storedContentsExampleFilterBuilder_.mergeFrom(value);
        } else {
          storedContentsExampleFilterBuilder_.setMessage(value);
        }
      }
      metadataFilterCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    public Builder clearStoredContentsExampleFilter() {
      if (storedContentsExampleFilterBuilder_ == null) {
        if (metadataFilterCase_ == 8) {
          metadataFilterCase_ = 0;
          metadataFilter_ = null;
          onChanged();
        }
      } else {
        if (metadataFilterCase_ == 8) {
          metadataFilterCase_ = 0;
          metadataFilter_ = null;
        }
        storedContentsExampleFilterBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.Builder
        getStoredContentsExampleFilterBuilder() {
      return getStoredContentsExampleFilterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilterOrBuilder
        getStoredContentsExampleFilterOrBuilder() {
      if ((metadataFilterCase_ == 8) && (storedContentsExampleFilterBuilder_ != null)) {
        return storedContentsExampleFilterBuilder_.getMessageOrBuilder();
      } else {
        if (metadataFilterCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_;
        }
        return com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata filters for StoredContentsExamples.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter stored_contents_example_filter = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.Builder,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilterOrBuilder>
        getStoredContentsExampleFilterFieldBuilder() {
      if (storedContentsExampleFilterBuilder_ == null) {
        if (!(metadataFilterCase_ == 8)) {
          metadataFilter_ =
              com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.getDefaultInstance();
        }
        storedContentsExampleFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter,
                com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter.Builder,
                com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilterOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter) metadataFilter_,
                getParentForChildren(),
                isClean());
        metadataFilter_ = null;
      }
      metadataFilterCase_ = 8;
      onChanged();
      return storedContentsExampleFilterBuilder_;
    }

    private java.lang.Object exampleStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that the examples should be
     * removed from. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The exampleStore.
     */
    public java.lang.String getExampleStore() {
      java.lang.Object ref = exampleStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exampleStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that the examples should be
     * removed from. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for exampleStore.
     */
    public com.google.protobuf.ByteString getExampleStoreBytes() {
      java.lang.Object ref = exampleStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exampleStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that the examples should be
     * removed from. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The exampleStore to set.
     * @return This builder for chaining.
     */
    public Builder setExampleStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      exampleStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that the examples should be
     * removed from. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleStore() {
      exampleStore_ = getDefaultInstance().getExampleStore();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that the examples should be
     * removed from. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for exampleStore to set.
     * @return This builder for chaining.
     */
    public Builder setExampleStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      exampleStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList exampleIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExampleIdsIsMutable() {
      if (!exampleIds_.isModifiable()) {
        exampleIds_ = new com.google.protobuf.LazyStringArrayList(exampleIds_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the exampleIds.
     */
    public com.google.protobuf.ProtocolStringList getExampleIdsList() {
      exampleIds_.makeImmutable();
      return exampleIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of exampleIds.
     */
    public int getExampleIdsCount() {
      return exampleIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The exampleIds at the given index.
     */
    public java.lang.String getExampleIds(int index) {
      return exampleIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exampleIds at the given index.
     */
    public com.google.protobuf.ByteString getExampleIdsBytes(int index) {
      return exampleIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The exampleIds to set.
     * @return This builder for chaining.
     */
    public Builder setExampleIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExampleIdsIsMutable();
      exampleIds_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The exampleIds to add.
     * @return This builder for chaining.
     */
    public Builder addExampleIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExampleIdsIsMutable();
      exampleIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The exampleIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllExampleIds(java.lang.Iterable<java.lang.String> values) {
      ensureExampleIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exampleIds_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleIds() {
      exampleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Example IDs to remove. If both metadata filters and Example IDs
     * are specified, the metadata filters will be applied to the specified
     * examples in order to identify which should be removed.
     * </pre>
     *
     * <code>repeated string example_ids = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the exampleIds to add.
     * @return This builder for chaining.
     */
    public Builder addExampleIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExampleIdsIsMutable();
      exampleIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RemoveExamplesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RemoveExamplesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RemoveExamplesRequest> PARSER =
      new com.google.protobuf.AbstractParser<RemoveExamplesRequest>() {
        @java.lang.Override
        public RemoveExamplesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RemoveExamplesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RemoveExamplesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
