/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tool.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Specifies the context retrieval config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig}
 */
public final class RagRetrievalConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig)
    RagRetrievalConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagRetrievalConfig.newBuilder() to construct.
  private RagRetrievalConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagRetrievalConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagRetrievalConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ToolProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ToolProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.class,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Builder.class);
  }

  public interface HybridSearchOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Alpha value controls the weight between dense and sparse vector
     * search results. The range is [0, 1], while 0 means sparse vector search
     * only and 1 means dense vector search only. The default value is 0.5 which
     * balances sparse and dense vector search equally.
     * </pre>
     *
     * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the alpha field is set.
     */
    boolean hasAlpha();

    /**
     *
     *
     * <pre>
     * Optional. Alpha value controls the weight between dense and sparse vector
     * search results. The range is [0, 1], while 0 means sparse vector search
     * only and 1 means dense vector search only. The default value is 0.5 which
     * balances sparse and dense vector search equally.
     * </pre>
     *
     * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alpha.
     */
    float getAlpha();
  }

  /**
   *
   *
   * <pre>
   * Config for Hybrid Search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch}
   */
  public static final class HybridSearch extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch)
      HybridSearchOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use HybridSearch.newBuilder() to construct.
    private HybridSearch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HybridSearch() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HybridSearch();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_HybridSearch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_HybridSearch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.class,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder.class);
    }

    private int bitField0_;
    public static final int ALPHA_FIELD_NUMBER = 1;
    private float alpha_ = 0F;

    /**
     *
     *
     * <pre>
     * Optional. Alpha value controls the weight between dense and sparse vector
     * search results. The range is [0, 1], while 0 means sparse vector search
     * only and 1 means dense vector search only. The default value is 0.5 which
     * balances sparse and dense vector search equally.
     * </pre>
     *
     * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the alpha field is set.
     */
    @java.lang.Override
    public boolean hasAlpha() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Alpha value controls the weight between dense and sparse vector
     * search results. The range is [0, 1], while 0 means sparse vector search
     * only and 1 means dense vector search only. The default value is 0.5 which
     * balances sparse and dense vector search equally.
     * </pre>
     *
     * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alpha.
     */
    @java.lang.Override
    public float getAlpha() {
      return alpha_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeFloat(1, alpha_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, alpha_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch other =
          (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch) obj;

      if (hasAlpha() != other.hasAlpha()) return false;
      if (hasAlpha()) {
        if (java.lang.Float.floatToIntBits(getAlpha())
            != java.lang.Float.floatToIntBits(other.getAlpha())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAlpha()) {
        hash = (37 * hash) + ALPHA_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getAlpha());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Config for Hybrid Search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch)
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearchOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_HybridSearch_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_HybridSearch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.class,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        alpha_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_HybridSearch_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch build() {
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch result =
            new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.alpha_ = alpha_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
                .getDefaultInstance()) return this;
        if (other.hasAlpha()) {
          setAlpha(other.getAlpha());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  alpha_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float alpha_;

      /**
       *
       *
       * <pre>
       * Optional. Alpha value controls the weight between dense and sparse vector
       * search results. The range is [0, 1], while 0 means sparse vector search
       * only and 1 means dense vector search only. The default value is 0.5 which
       * balances sparse and dense vector search equally.
       * </pre>
       *
       * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the alpha field is set.
       */
      @java.lang.Override
      public boolean hasAlpha() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Alpha value controls the weight between dense and sparse vector
       * search results. The range is [0, 1], while 0 means sparse vector search
       * only and 1 means dense vector search only. The default value is 0.5 which
       * balances sparse and dense vector search equally.
       * </pre>
       *
       * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alpha.
       */
      @java.lang.Override
      public float getAlpha() {
        return alpha_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Alpha value controls the weight between dense and sparse vector
       * search results. The range is [0, 1], while 0 means sparse vector search
       * only and 1 means dense vector search only. The default value is 0.5 which
       * balances sparse and dense vector search equally.
       * </pre>
       *
       * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The alpha to set.
       * @return This builder for chaining.
       */
      public Builder setAlpha(float value) {

        alpha_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Alpha value controls the weight between dense and sparse vector
       * search results. The range is [0, 1], while 0 means sparse vector search
       * only and 1 means dense vector search only. The default value is 0.5 which
       * balances sparse and dense vector search equally.
       * </pre>
       *
       * <code>optional float alpha = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlpha() {
        bitField0_ = (bitField0_ & ~0x00000001);
        alpha_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch)
    private static final com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch();
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HybridSearch> PARSER =
        new com.google.protobuf.AbstractParser<HybridSearch>() {
          @java.lang.Override
          public HybridSearch parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HybridSearch> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HybridSearch> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the vectorDistanceThreshold field is set.
     */
    boolean hasVectorDistanceThreshold();

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The vectorDistanceThreshold.
     */
    double getVectorDistanceThreshold();

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vectorSimilarityThreshold field is set.
     */
    boolean hasVectorSimilarityThreshold();

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vectorSimilarityThreshold.
     */
    double getVectorSimilarityThreshold();

    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The metadataFilter.
     */
    java.lang.String getMetadataFilter();

    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for metadataFilter.
     */
    com.google.protobuf.ByteString getMetadataFilterBytes();

    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.VectorDbThresholdCase
        getVectorDbThresholdCase();
  }

  /**
   *
   *
   * <pre>
   * Config for filters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter}
   */
  public static final class Filter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter)
      FilterOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Filter.newBuilder() to construct.
    private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Filter() {
      metadataFilter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Filter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.class,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder.class);
    }

    private int vectorDbThresholdCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object vectorDbThreshold_;

    public enum VectorDbThresholdCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VECTOR_DISTANCE_THRESHOLD(3),
      VECTOR_SIMILARITY_THRESHOLD(4),
      VECTORDBTHRESHOLD_NOT_SET(0);
      private final int value;

      private VectorDbThresholdCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static VectorDbThresholdCase valueOf(int value) {
        return forNumber(value);
      }

      public static VectorDbThresholdCase forNumber(int value) {
        switch (value) {
          case 3:
            return VECTOR_DISTANCE_THRESHOLD;
          case 4:
            return VECTOR_SIMILARITY_THRESHOLD;
          case 0:
            return VECTORDBTHRESHOLD_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public VectorDbThresholdCase getVectorDbThresholdCase() {
      return VectorDbThresholdCase.forNumber(vectorDbThresholdCase_);
    }

    public static final int VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the vectorDistanceThreshold field is set.
     */
    @java.lang.Override
    public boolean hasVectorDistanceThreshold() {
      return vectorDbThresholdCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The vectorDistanceThreshold.
     */
    @java.lang.Override
    public double getVectorDistanceThreshold() {
      if (vectorDbThresholdCase_ == 3) {
        return (java.lang.Double) vectorDbThreshold_;
      }
      return 0D;
    }

    public static final int VECTOR_SIMILARITY_THRESHOLD_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vectorSimilarityThreshold field is set.
     */
    @java.lang.Override
    public boolean hasVectorSimilarityThreshold() {
      return vectorDbThresholdCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vectorSimilarityThreshold.
     */
    @java.lang.Override
    public double getVectorSimilarityThreshold() {
      if (vectorDbThresholdCase_ == 4) {
        return (java.lang.Double) vectorDbThreshold_;
      }
      return 0D;
    }

    public static final int METADATA_FILTER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object metadataFilter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The metadataFilter.
     */
    @java.lang.Override
    public java.lang.String getMetadataFilter() {
      java.lang.Object ref = metadataFilter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataFilter_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for metadataFilter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetadataFilterBytes() {
      java.lang.Object ref = metadataFilter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataFilter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metadataFilter_);
      }
      if (vectorDbThresholdCase_ == 3) {
        output.writeDouble(3, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      if (vectorDbThresholdCase_ == 4) {
        output.writeDouble(4, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataFilter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, metadataFilter_);
      }
      if (vectorDbThresholdCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                3, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      if (vectorDbThresholdCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                4, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter other =
          (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter) obj;

      if (!getMetadataFilter().equals(other.getMetadataFilter())) return false;
      if (!getVectorDbThresholdCase().equals(other.getVectorDbThresholdCase())) return false;
      switch (vectorDbThresholdCase_) {
        case 3:
          if (java.lang.Double.doubleToLongBits(getVectorDistanceThreshold())
              != java.lang.Double.doubleToLongBits(other.getVectorDistanceThreshold()))
            return false;
          break;
        case 4:
          if (java.lang.Double.doubleToLongBits(getVectorSimilarityThreshold())
              != java.lang.Double.doubleToLongBits(other.getVectorSimilarityThreshold()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METADATA_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataFilter().hashCode();
      switch (vectorDbThresholdCase_) {
        case 3:
          hash = (37 * hash) + VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getVectorDistanceThreshold()));
          break;
        case 4:
          hash = (37 * hash) + VECTOR_SIMILARITY_THRESHOLD_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getVectorSimilarityThreshold()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Config for filters.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter)
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.FilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Filter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Filter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.class,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metadataFilter_ = "";
        vectorDbThresholdCase_ = 0;
        vectorDbThreshold_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Filter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter build() {
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter result =
            new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.metadataFilter_ = metadataFilter_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter result) {
        result.vectorDbThresholdCase_ = vectorDbThresholdCase_;
        result.vectorDbThreshold_ = this.vectorDbThreshold_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.getDefaultInstance())
          return this;
        if (!other.getMetadataFilter().isEmpty()) {
          metadataFilter_ = other.metadataFilter_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getVectorDbThresholdCase()) {
          case VECTOR_DISTANCE_THRESHOLD:
            {
              setVectorDistanceThreshold(other.getVectorDistanceThreshold());
              break;
            }
          case VECTOR_SIMILARITY_THRESHOLD:
            {
              setVectorSimilarityThreshold(other.getVectorSimilarityThreshold());
              break;
            }
          case VECTORDBTHRESHOLD_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  metadataFilter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 25:
                {
                  vectorDbThreshold_ = input.readDouble();
                  vectorDbThresholdCase_ = 3;
                  break;
                } // case 25
              case 33:
                {
                  vectorDbThreshold_ = input.readDouble();
                  vectorDbThresholdCase_ = 4;
                  break;
                } // case 33
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int vectorDbThresholdCase_ = 0;
      private java.lang.Object vectorDbThreshold_;

      public VectorDbThresholdCase getVectorDbThresholdCase() {
        return VectorDbThresholdCase.forNumber(vectorDbThresholdCase_);
      }

      public Builder clearVectorDbThreshold() {
        vectorDbThresholdCase_ = 0;
        vectorDbThreshold_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the vectorDistanceThreshold field is set.
       */
      public boolean hasVectorDistanceThreshold() {
        return vectorDbThresholdCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The vectorDistanceThreshold.
       */
      public double getVectorDistanceThreshold() {
        if (vectorDbThresholdCase_ == 3) {
          return (java.lang.Double) vectorDbThreshold_;
        }
        return 0D;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The vectorDistanceThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setVectorDistanceThreshold(double value) {

        vectorDbThresholdCase_ = 3;
        vectorDbThreshold_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVectorDistanceThreshold() {
        if (vectorDbThresholdCase_ == 3) {
          vectorDbThresholdCase_ = 0;
          vectorDbThreshold_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the vectorSimilarityThreshold field is set.
       */
      public boolean hasVectorSimilarityThreshold() {
        return vectorDbThresholdCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The vectorSimilarityThreshold.
       */
      public double getVectorSimilarityThreshold() {
        if (vectorDbThresholdCase_ == 4) {
          return (java.lang.Double) vectorDbThreshold_;
        }
        return 0D;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The vectorSimilarityThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setVectorSimilarityThreshold(double value) {

        vectorDbThresholdCase_ = 4;
        vectorDbThreshold_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVectorSimilarityThreshold() {
        if (vectorDbThresholdCase_ == 4) {
          vectorDbThresholdCase_ = 0;
          vectorDbThreshold_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object metadataFilter_ = "";

      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The metadataFilter.
       */
      public java.lang.String getMetadataFilter() {
        java.lang.Object ref = metadataFilter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metadataFilter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for metadataFilter.
       */
      public com.google.protobuf.ByteString getMetadataFilterBytes() {
        java.lang.Object ref = metadataFilter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metadataFilter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The metadataFilter to set.
       * @return This builder for chaining.
       */
      public Builder setMetadataFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataFilter_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetadataFilter() {
        metadataFilter_ = getDefaultInstance().getMetadataFilter();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for metadataFilter to set.
       * @return This builder for chaining.
       */
      public Builder setMetadataFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        metadataFilter_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter)
    private static final com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter();
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Filter> PARSER =
        new com.google.protobuf.AbstractParser<Filter>() {
          @java.lang.Override
          public Filter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Filter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Filter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RankingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Config for Rank Service.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rankService field is set.
     */
    boolean hasRankService();

    /**
     *
     *
     * <pre>
     * Optional. Config for Rank Service.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rankService.
     */
    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService getRankService();

    /**
     *
     *
     * <pre>
     * Optional. Config for Rank Service.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankServiceOrBuilder
        getRankServiceOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Config for LlmRanker.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the llmRanker field is set.
     */
    boolean hasLlmRanker();

    /**
     *
     *
     * <pre>
     * Optional. Config for LlmRanker.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The llmRanker.
     */
    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker getLlmRanker();

    /**
     *
     *
     * <pre>
     * Optional. Config for LlmRanker.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRankerOrBuilder
        getLlmRankerOrBuilder();

    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankingConfigCase
        getRankingConfigCase();
  }

  /**
   *
   *
   * <pre>
   * Config for ranking and reranking.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking}
   */
  public static final class Ranking extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking)
      RankingOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Ranking.newBuilder() to construct.
    private Ranking(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Ranking() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Ranking();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.class,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder.class);
    }

    public interface RankServiceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The model name of the rank service.
       * Format: `semantic-ranker-512&#64;latest`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the modelName field is set.
       */
      boolean hasModelName();

      /**
       *
       *
       * <pre>
       * Optional. The model name of the rank service.
       * Format: `semantic-ranker-512&#64;latest`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelName.
       */
      java.lang.String getModelName();

      /**
       *
       *
       * <pre>
       * Optional. The model name of the rank service.
       * Format: `semantic-ranker-512&#64;latest`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelName.
       */
      com.google.protobuf.ByteString getModelNameBytes();
    }

    /**
     *
     *
     * <pre>
     * Config for Rank Service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService}
     */
    public static final class RankService extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
        RankServiceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use RankService.newBuilder() to construct.
      private RankService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RankService() {
        modelName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RankService();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_RankService_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_RankService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.class,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.Builder
                    .class);
      }

      private int bitField0_;
      public static final int MODEL_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The model name of the rank service.
       * Format: `semantic-ranker-512&#64;latest`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the modelName field is set.
       */
      @java.lang.Override
      public boolean hasModelName() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The model name of the rank service.
       * Format: `semantic-ranker-512&#64;latest`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelName.
       */
      @java.lang.Override
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The model name of the rank service.
       * Format: `semantic-ranker-512&#64;latest`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService other =
            (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService) obj;

        if (hasModelName() != other.hasModelName()) return false;
        if (hasModelName()) {
          if (!getModelName().equals(other.getModelName())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasModelName()) {
          hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getModelName().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Config for Rank Service.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankServiceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ToolProto
              .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_RankService_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ToolProto
              .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_RankService_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.class,
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          modelName_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ToolProto
              .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_RankService_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService build() {
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService result =
              new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.modelName_ = modelName_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
                  .getDefaultInstance()) return this;
          if (other.hasModelName()) {
            modelName_ = other.modelName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    modelName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object modelName_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The model name of the rank service.
         * Format: `semantic-ranker-512&#64;latest`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return Whether the modelName field is set.
         */
        public boolean hasModelName() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name of the rank service.
         * Format: `semantic-ranker-512&#64;latest`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The modelName.
         */
        public java.lang.String getModelName() {
          java.lang.Object ref = modelName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name of the rank service.
         * Format: `semantic-ranker-512&#64;latest`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for modelName.
         */
        public com.google.protobuf.ByteString getModelNameBytes() {
          java.lang.Object ref = modelName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name of the rank service.
         * Format: `semantic-ranker-512&#64;latest`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The modelName to set.
         * @return This builder for chaining.
         */
        public Builder setModelName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name of the rank service.
         * Format: `semantic-ranker-512&#64;latest`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelName() {
          modelName_ = getDefaultInstance().getModelName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name of the rank service.
         * Format: `semantic-ranker-512&#64;latest`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for modelName to set.
         * @return This builder for chaining.
         */
        public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
      private static final com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
              .RankService
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService();
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RankService> PARSER =
          new com.google.protobuf.AbstractParser<RankService>() {
            @java.lang.Override
            public RankService parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RankService> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RankService> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LlmRankerOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The model name used for ranking.
       * Format: `gemini-1.5-pro`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the modelName field is set.
       */
      boolean hasModelName();

      /**
       *
       *
       * <pre>
       * Optional. The model name used for ranking.
       * Format: `gemini-1.5-pro`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelName.
       */
      java.lang.String getModelName();

      /**
       *
       *
       * <pre>
       * Optional. The model name used for ranking.
       * Format: `gemini-1.5-pro`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelName.
       */
      com.google.protobuf.ByteString getModelNameBytes();
    }

    /**
     *
     *
     * <pre>
     * Config for LlmRanker.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker}
     */
    public static final class LlmRanker extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
        LlmRankerOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use LlmRanker.newBuilder() to construct.
      private LlmRanker(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private LlmRanker() {
        modelName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new LlmRanker();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_LlmRanker_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_LlmRanker_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.class,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder
                    .class);
      }

      private int bitField0_;
      public static final int MODEL_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The model name used for ranking.
       * Format: `gemini-1.5-pro`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the modelName field is set.
       */
      @java.lang.Override
      public boolean hasModelName() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The model name used for ranking.
       * Format: `gemini-1.5-pro`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelName.
       */
      @java.lang.Override
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The model name used for ranking.
       * Format: `gemini-1.5-pro`
       * </pre>
       *
       * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker other =
            (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker) obj;

        if (hasModelName() != other.hasModelName()) return false;
        if (hasModelName()) {
          if (!getModelName().equals(other.getModelName())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasModelName()) {
          hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getModelName().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Config for LlmRanker.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRankerOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ToolProto
              .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_LlmRanker_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ToolProto
              .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_LlmRanker_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.class,
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          modelName_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ToolProto
              .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_LlmRanker_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker build() {
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker result =
              new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.modelName_ = modelName_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
                  .getDefaultInstance()) return this;
          if (other.hasModelName()) {
            modelName_ = other.modelName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    modelName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object modelName_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The model name used for ranking.
         * Format: `gemini-1.5-pro`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return Whether the modelName field is set.
         */
        public boolean hasModelName() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name used for ranking.
         * Format: `gemini-1.5-pro`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The modelName.
         */
        public java.lang.String getModelName() {
          java.lang.Object ref = modelName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name used for ranking.
         * Format: `gemini-1.5-pro`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for modelName.
         */
        public com.google.protobuf.ByteString getModelNameBytes() {
          java.lang.Object ref = modelName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name used for ranking.
         * Format: `gemini-1.5-pro`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The modelName to set.
         * @return This builder for chaining.
         */
        public Builder setModelName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name used for ranking.
         * Format: `gemini-1.5-pro`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelName() {
          modelName_ = getDefaultInstance().getModelName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The model name used for ranking.
         * Format: `gemini-1.5-pro`
         * </pre>
         *
         * <code>optional string model_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for modelName to set.
         * @return This builder for chaining.
         */
        public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
      private static final com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker();
      }

      public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<LlmRanker> PARSER =
          new com.google.protobuf.AbstractParser<LlmRanker>() {
            @java.lang.Override
            public LlmRanker parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<LlmRanker> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<LlmRanker> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int rankingConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object rankingConfig_;

    public enum RankingConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      RANK_SERVICE(1),
      LLM_RANKER(3),
      RANKINGCONFIG_NOT_SET(0);
      private final int value;

      private RankingConfigCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RankingConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static RankingConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return RANK_SERVICE;
          case 3:
            return LLM_RANKER;
          case 0:
            return RANKINGCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public RankingConfigCase getRankingConfigCase() {
      return RankingConfigCase.forNumber(rankingConfigCase_);
    }

    public static final int RANK_SERVICE_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Optional. Config for Rank Service.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rankService field is set.
     */
    @java.lang.Override
    public boolean hasRankService() {
      return rankingConfigCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Rank Service.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rankService.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
        getRankService() {
      if (rankingConfigCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
            rankingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Rank Service.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankServiceOrBuilder
        getRankServiceOrBuilder() {
      if (rankingConfigCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
            rankingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          .getDefaultInstance();
    }

    public static final int LLM_RANKER_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Optional. Config for LlmRanker.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the llmRanker field is set.
     */
    @java.lang.Override
    public boolean hasLlmRanker() {
      return rankingConfigCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for LlmRanker.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The llmRanker.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker getLlmRanker() {
      if (rankingConfigCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
            rankingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for LlmRanker.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRankerOrBuilder
        getLlmRankerOrBuilder() {
      if (rankingConfigCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
            rankingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (rankingConfigCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
                rankingConfig_);
      }
      if (rankingConfigCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
                rankingConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (rankingConfigCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
                    rankingConfig_);
      }
      if (rankingConfigCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
                    rankingConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking other =
          (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking) obj;

      if (!getRankingConfigCase().equals(other.getRankingConfigCase())) return false;
      switch (rankingConfigCase_) {
        case 1:
          if (!getRankService().equals(other.getRankService())) return false;
          break;
        case 3:
          if (!getLlmRanker().equals(other.getLlmRanker())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (rankingConfigCase_) {
        case 1:
          hash = (37 * hash) + RANK_SERVICE_FIELD_NUMBER;
          hash = (53 * hash) + getRankService().hashCode();
          break;
        case 3:
          hash = (37 * hash) + LLM_RANKER_FIELD_NUMBER;
          hash = (53 * hash) + getLlmRanker().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Config for ranking and reranking.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking)
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.RankingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.class,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (rankServiceBuilder_ != null) {
          rankServiceBuilder_.clear();
        }
        if (llmRankerBuilder_ != null) {
          llmRankerBuilder_.clear();
        }
        rankingConfigCase_ = 0;
        rankingConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ToolProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_Ranking_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking build() {
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking result =
            new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking result) {
        result.rankingConfigCase_ = rankingConfigCase_;
        result.rankingConfig_ = this.rankingConfig_;
        if (rankingConfigCase_ == 1 && rankServiceBuilder_ != null) {
          result.rankingConfig_ = rankServiceBuilder_.build();
        }
        if (rankingConfigCase_ == 3 && llmRankerBuilder_ != null) {
          result.rankingConfig_ = llmRankerBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.getDefaultInstance())
          return this;
        switch (other.getRankingConfigCase()) {
          case RANK_SERVICE:
            {
              mergeRankService(other.getRankService());
              break;
            }
          case LLM_RANKER:
            {
              mergeLlmRanker(other.getLlmRanker());
              break;
            }
          case RANKINGCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getRankServiceFieldBuilder().getBuilder(), extensionRegistry);
                  rankingConfigCase_ = 1;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(getLlmRankerFieldBuilder().getBuilder(), extensionRegistry);
                  rankingConfigCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int rankingConfigCase_ = 0;
      private java.lang.Object rankingConfig_;

      public RankingConfigCase getRankingConfigCase() {
        return RankingConfigCase.forNumber(rankingConfigCase_);
      }

      public Builder clearRankingConfig() {
        rankingConfigCase_ = 0;
        rankingConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.Builder,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankServiceOrBuilder>
          rankServiceBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the rankService field is set.
       */
      @java.lang.Override
      public boolean hasRankService() {
        return rankingConfigCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The rankService.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
          getRankService() {
        if (rankServiceBuilder_ == null) {
          if (rankingConfigCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
                rankingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
              .getDefaultInstance();
        } else {
          if (rankingConfigCase_ == 1) {
            return rankServiceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRankService(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService value) {
        if (rankServiceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rankingConfig_ = value;
          onChanged();
        } else {
          rankServiceBuilder_.setMessage(value);
        }
        rankingConfigCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRankService(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.Builder
              builderForValue) {
        if (rankServiceBuilder_ == null) {
          rankingConfig_ = builderForValue.build();
          onChanged();
        } else {
          rankServiceBuilder_.setMessage(builderForValue.build());
        }
        rankingConfigCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRankService(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService value) {
        if (rankServiceBuilder_ == null) {
          if (rankingConfigCase_ == 1
              && rankingConfig_
                  != com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
                      .getDefaultInstance()) {
            rankingConfig_ =
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
                            rankingConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rankingConfig_ = value;
          }
          onChanged();
        } else {
          if (rankingConfigCase_ == 1) {
            rankServiceBuilder_.mergeFrom(value);
          } else {
            rankServiceBuilder_.setMessage(value);
          }
        }
        rankingConfigCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRankService() {
        if (rankServiceBuilder_ == null) {
          if (rankingConfigCase_ == 1) {
            rankingConfigCase_ = 0;
            rankingConfig_ = null;
            onChanged();
          }
        } else {
          if (rankingConfigCase_ == 1) {
            rankingConfigCase_ = 0;
            rankingConfig_ = null;
          }
          rankServiceBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.Builder
          getRankServiceBuilder() {
        return getRankServiceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankServiceOrBuilder
          getRankServiceOrBuilder() {
        if ((rankingConfigCase_ == 1) && (rankServiceBuilder_ != null)) {
          return rankServiceBuilder_.getMessageOrBuilder();
        } else {
          if (rankingConfigCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
                rankingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for Rank Service.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService rank_service = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService.Builder,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankServiceOrBuilder>
          getRankServiceFieldBuilder() {
        if (rankServiceBuilder_ == null) {
          if (!(rankingConfigCase_ == 1)) {
            rankingConfig_ =
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
                    .getDefaultInstance();
          }
          rankServiceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService,
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
                      .RankServiceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService)
                      rankingConfig_,
                  getParentForChildren(),
                  isClean());
          rankingConfig_ = null;
        }
        rankingConfigCase_ = 1;
        onChanged();
        return rankServiceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRankerOrBuilder>
          llmRankerBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the llmRanker field is set.
       */
      @java.lang.Override
      public boolean hasLlmRanker() {
        return rankingConfigCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The llmRanker.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
          getLlmRanker() {
        if (llmRankerBuilder_ == null) {
          if (rankingConfigCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
                rankingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
              .getDefaultInstance();
        } else {
          if (rankingConfigCase_ == 3) {
            return llmRankerBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setLlmRanker(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker value) {
        if (llmRankerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rankingConfig_ = value;
          onChanged();
        } else {
          llmRankerBuilder_.setMessage(value);
        }
        rankingConfigCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setLlmRanker(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder
              builderForValue) {
        if (llmRankerBuilder_ == null) {
          rankingConfig_ = builderForValue.build();
          onChanged();
        } else {
          llmRankerBuilder_.setMessage(builderForValue.build());
        }
        rankingConfigCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeLlmRanker(
          com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker value) {
        if (llmRankerBuilder_ == null) {
          if (rankingConfigCase_ == 3
              && rankingConfig_
                  != com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
                      .getDefaultInstance()) {
            rankingConfig_ =
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
                            rankingConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rankingConfig_ = value;
          }
          onChanged();
        } else {
          if (rankingConfigCase_ == 3) {
            llmRankerBuilder_.mergeFrom(value);
          } else {
            llmRankerBuilder_.setMessage(value);
          }
        }
        rankingConfigCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearLlmRanker() {
        if (llmRankerBuilder_ == null) {
          if (rankingConfigCase_ == 3) {
            rankingConfigCase_ = 0;
            rankingConfig_ = null;
            onChanged();
          }
        } else {
          if (rankingConfigCase_ == 3) {
            rankingConfigCase_ = 0;
            rankingConfig_ = null;
          }
          llmRankerBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder
          getLlmRankerBuilder() {
        return getLlmRankerFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRankerOrBuilder
          getLlmRankerOrBuilder() {
        if ((rankingConfigCase_ == 3) && (llmRankerBuilder_ != null)) {
          return llmRankerBuilder_.getMessageOrBuilder();
        } else {
          if (rankingConfigCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
                rankingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Config for LlmRanker.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker llm_ranker = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRankerOrBuilder>
          getLlmRankerFieldBuilder() {
        if (llmRankerBuilder_ == null) {
          if (!(rankingConfigCase_ == 3)) {
            rankingConfig_ =
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
                    .getDefaultInstance();
          }
          llmRankerBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker,
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker.Builder,
                  com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
                      .LlmRankerOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker)
                      rankingConfig_,
                  getParentForChildren(),
                  isClean());
          rankingConfig_ = null;
        }
        rankingConfigCase_ = 3;
        onChanged();
        return llmRankerBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking)
    private static final com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking();
    }

    public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Ranking> PARSER =
        new com.google.protobuf.AbstractParser<Ranking>() {
          @java.lang.Override
          public Ranking parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Ranking> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Ranking> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TOP_K_FIELD_NUMBER = 1;
  private int topK_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The number of contexts to retrieve.
   * </pre>
   *
   * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The topK.
   */
  @java.lang.Override
  public int getTopK() {
    return topK_;
  }

  public static final int HYBRID_SEARCH_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybridSearch_;

  /**
   *
   *
   * <pre>
   * Optional. Config for Hybrid Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hybridSearch field is set.
   */
  @java.lang.Override
  public boolean hasHybridSearch() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for Hybrid Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hybridSearch.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch getHybridSearch() {
    return hybridSearch_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.getDefaultInstance()
        : hybridSearch_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for Hybrid Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearchOrBuilder
      getHybridSearchOrBuilder() {
    return hybridSearch_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.getDefaultInstance()
        : hybridSearch_;
  }

  public static final int FILTER_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter_;

  /**
   *
   *
   * <pre>
   * Optional. Config for filters.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for filters.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter getFilter() {
    return filter_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.getDefaultInstance()
        : filter_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for filters.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.FilterOrBuilder
      getFilterOrBuilder() {
    return filter_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.getDefaultInstance()
        : filter_;
  }

  public static final int RANKING_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking_;

  /**
   *
   *
   * <pre>
   * Optional. Config for ranking and reranking.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ranking field is set.
   */
  @java.lang.Override
  public boolean hasRanking() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for ranking and reranking.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ranking.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking getRanking() {
    return ranking_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.getDefaultInstance()
        : ranking_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for ranking and reranking.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.RankingOrBuilder
      getRankingOrBuilder() {
    return ranking_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.getDefaultInstance()
        : ranking_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (topK_ != 0) {
      output.writeInt32(1, topK_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getHybridSearch());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getFilter());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getRanking());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (topK_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, topK_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getHybridSearch());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFilter());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRanking());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig other =
        (com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig) obj;

    if (getTopK() != other.getTopK()) return false;
    if (hasHybridSearch() != other.hasHybridSearch()) return false;
    if (hasHybridSearch()) {
      if (!getHybridSearch().equals(other.getHybridSearch())) return false;
    }
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (hasRanking() != other.hasRanking()) return false;
    if (hasRanking()) {
      if (!getRanking().equals(other.getRanking())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOP_K_FIELD_NUMBER;
    hash = (53 * hash) + getTopK();
    if (hasHybridSearch()) {
      hash = (37 * hash) + HYBRID_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + getHybridSearch().hashCode();
    }
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    if (hasRanking()) {
      hash = (37 * hash) + RANKING_FIELD_NUMBER;
      hash = (53 * hash) + getRanking().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specifies the context retrieval config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagRetrievalConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagRetrievalConfig)
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.class,
              com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHybridSearchFieldBuilder();
        getFilterFieldBuilder();
        getRankingFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      topK_ = 0;
      hybridSearch_ = null;
      if (hybridSearchBuilder_ != null) {
        hybridSearchBuilder_.dispose();
        hybridSearchBuilder_ = null;
      }
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      ranking_ = null;
      if (rankingBuilder_ != null) {
        rankingBuilder_.dispose();
        rankingBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagRetrievalConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig build() {
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig result =
          new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.topK_ = topK_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.hybridSearch_ =
            hybridSearchBuilder_ == null ? hybridSearch_ : hybridSearchBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ranking_ = rankingBuilder_ == null ? ranking_ : rankingBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.getDefaultInstance())
        return this;
      if (other.getTopK() != 0) {
        setTopK(other.getTopK());
      }
      if (other.hasHybridSearch()) {
        mergeHybridSearch(other.getHybridSearch());
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.hasRanking()) {
        mergeRanking(other.getRanking());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                topK_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getHybridSearchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRankingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int topK_;

    /**
     *
     *
     * <pre>
     * Optional. The number of contexts to retrieve.
     * </pre>
     *
     * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public int getTopK() {
      return topK_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The number of contexts to retrieve.
     * </pre>
     *
     * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The topK to set.
     * @return This builder for chaining.
     */
    public Builder setTopK(int value) {

      topK_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The number of contexts to retrieve.
     * </pre>
     *
     * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopK() {
      bitField0_ = (bitField0_ & ~0x00000001);
      topK_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybridSearch_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearchOrBuilder>
        hybridSearchBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the hybridSearch field is set.
     */
    public boolean hasHybridSearch() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The hybridSearch.
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch getHybridSearch() {
      if (hybridSearchBuilder_ == null) {
        return hybridSearch_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
                .getDefaultInstance()
            : hybridSearch_;
      } else {
        return hybridSearchBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHybridSearch(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch value) {
      if (hybridSearchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hybridSearch_ = value;
      } else {
        hybridSearchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHybridSearch(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder
            builderForValue) {
      if (hybridSearchBuilder_ == null) {
        hybridSearch_ = builderForValue.build();
      } else {
        hybridSearchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHybridSearch(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch value) {
      if (hybridSearchBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && hybridSearch_ != null
            && hybridSearch_
                != com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
                    .getDefaultInstance()) {
          getHybridSearchBuilder().mergeFrom(value);
        } else {
          hybridSearch_ = value;
        }
      } else {
        hybridSearchBuilder_.mergeFrom(value);
      }
      if (hybridSearch_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHybridSearch() {
      bitField0_ = (bitField0_ & ~0x00000002);
      hybridSearch_ = null;
      if (hybridSearchBuilder_ != null) {
        hybridSearchBuilder_.dispose();
        hybridSearchBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder
        getHybridSearchBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getHybridSearchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearchOrBuilder
        getHybridSearchOrBuilder() {
      if (hybridSearchBuilder_ != null) {
        return hybridSearchBuilder_.getMessageOrBuilder();
      } else {
        return hybridSearch_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
                .getDefaultInstance()
            : hybridSearch_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for Hybrid Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch hybrid_search = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearchOrBuilder>
        getHybridSearchFieldBuilder() {
      if (hybridSearchBuilder_ == null) {
        hybridSearchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch.Builder,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearchOrBuilder>(
                getHybridSearch(), getParentForChildren(), isClean());
        hybridSearch_ = null;
      }
      return hybridSearchBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.FilterOrBuilder>
        filterBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filter.
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilter(com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilter(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFilter(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && filter_ != null
            && filter_
                != com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
                    .getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000004);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder
        getFilterBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.FilterOrBuilder
        getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.getDefaultInstance()
            : filter_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.FilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter.Builder,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.FilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.RankingOrBuilder>
        rankingBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ranking field is set.
     */
    public boolean hasRanking() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ranking.
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking getRanking() {
      if (rankingBuilder_ == null) {
        return ranking_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.getDefaultInstance()
            : ranking_;
      } else {
        return rankingBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRanking(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking value) {
      if (rankingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ranking_ = value;
      } else {
        rankingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRanking(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder builderForValue) {
      if (rankingBuilder_ == null) {
        ranking_ = builderForValue.build();
      } else {
        rankingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRanking(
        com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking value) {
      if (rankingBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ranking_ != null
            && ranking_
                != com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
                    .getDefaultInstance()) {
          getRankingBuilder().mergeFrom(value);
        } else {
          ranking_ = value;
        }
      } else {
        rankingBuilder_.mergeFrom(value);
      }
      if (ranking_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRanking() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ranking_ = null;
      if (rankingBuilder_ != null) {
        rankingBuilder_.dispose();
        rankingBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder
        getRankingBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRankingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.RankingOrBuilder
        getRankingOrBuilder() {
      if (rankingBuilder_ != null) {
        return rankingBuilder_.getMessageOrBuilder();
      } else {
        return ranking_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.getDefaultInstance()
            : ranking_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for ranking and reranking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking ranking = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder,
            com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.RankingOrBuilder>
        getRankingFieldBuilder() {
      if (rankingBuilder_ == null) {
        rankingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.Builder,
                com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig.RankingOrBuilder>(
                getRanking(), getParentForChildren(), isClean());
        ranking_ = null;
      }
      return rankingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagRetrievalConfig)
  private static final com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagRetrievalConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagRetrievalConfig>() {
        @java.lang.Override
        public RagRetrievalConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagRetrievalConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagRetrievalConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagRetrievalConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
