/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_deployment_monitoring_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Statistics and anomalies generated by Model Monitoring.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies}
 */
public final class ModelMonitoringStatsAnomalies extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies)
    ModelMonitoringStatsAnomaliesOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ModelMonitoringStatsAnomalies.newBuilder() to construct.
  private ModelMonitoringStatsAnomalies(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringStatsAnomalies() {
    objective_ = 0;
    deployedModelId_ = "";
    featureStats_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringStatsAnomalies();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder.class);
  }

  public interface FeatureHistoricStatsAnomaliesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Display Name of the Feature.
     * </pre>
     *
     * <code>string feature_display_name = 1;</code>
     *
     * @return The featureDisplayName.
     */
    java.lang.String getFeatureDisplayName();

    /**
     *
     *
     * <pre>
     * Display Name of the Feature.
     * </pre>
     *
     * <code>string feature_display_name = 1;</code>
     *
     * @return The bytes for featureDisplayName.
     */
    com.google.protobuf.ByteString getFeatureDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Threshold for anomaly detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
     *
     * @return Whether the threshold field is set.
     */
    boolean hasThreshold();

    /**
     *
     *
     * <pre>
     * Threshold for anomaly detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
     *
     * @return The threshold.
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getThreshold();

    /**
     *
     *
     * <pre>
     * Threshold for anomaly detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder getThresholdOrBuilder();

    /**
     *
     *
     * <pre>
     * Stats calculated for the Training Dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
     *
     * @return Whether the trainingStats field is set.
     */
    boolean hasTrainingStats();

    /**
     *
     *
     * <pre>
     * Stats calculated for the Training Dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
     *
     * @return The trainingStats.
     */
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getTrainingStats();

    /**
     *
     *
     * <pre>
     * Stats calculated for the Training Dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder getTrainingStatsOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        getPredictionStatsList();

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getPredictionStats(int index);

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    int getPredictionStatsCount();

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        getPredictionStatsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder getPredictionStatsOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * Historical Stats (and Anomalies) for a specific Feature.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies}
   */
  public static final class FeatureHistoricStatsAnomalies
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies)
      FeatureHistoricStatsAnomaliesOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FeatureHistoricStatsAnomalies.newBuilder() to construct.
    private FeatureHistoricStatsAnomalies(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FeatureHistoricStatsAnomalies() {
      featureDisplayName_ = "";
      predictionStats_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FeatureHistoricStatsAnomalies();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies.Builder.class);
    }

    private int bitField0_;
    public static final int FEATURE_DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object featureDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Display Name of the Feature.
     * </pre>
     *
     * <code>string feature_display_name = 1;</code>
     *
     * @return The featureDisplayName.
     */
    @java.lang.Override
    public java.lang.String getFeatureDisplayName() {
      java.lang.Object ref = featureDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureDisplayName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Display Name of the Feature.
     * </pre>
     *
     * <code>string feature_display_name = 1;</code>
     *
     * @return The bytes for featureDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFeatureDisplayNameBytes() {
      java.lang.Object ref = featureDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int THRESHOLD_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold_;

    /**
     *
     *
     * <pre>
     * Threshold for anomaly detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
     *
     * @return Whether the threshold field is set.
     */
    @java.lang.Override
    public boolean hasThreshold() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Threshold for anomaly detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
     *
     * @return The threshold.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getThreshold() {
      return threshold_ == null
          ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
          : threshold_;
    }

    /**
     *
     *
     * <pre>
     * Threshold for anomaly detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder getThresholdOrBuilder() {
      return threshold_ == null
          ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
          : threshold_;
    }

    public static final int TRAINING_STATS_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly trainingStats_;

    /**
     *
     *
     * <pre>
     * Stats calculated for the Training Dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
     *
     * @return Whether the trainingStats field is set.
     */
    @java.lang.Override
    public boolean hasTrainingStats() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Stats calculated for the Training Dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
     *
     * @return The trainingStats.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getTrainingStats() {
      return trainingStats_ == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
          : trainingStats_;
    }

    /**
     *
     *
     * <pre>
     * Stats calculated for the Training Dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
        getTrainingStatsOrBuilder() {
      return trainingStats_ == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
          : trainingStats_;
    }

    public static final int PREDICTION_STATS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        predictionStats_;

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        getPredictionStatsList() {
      return predictionStats_;
    }

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        getPredictionStatsOrBuilderList() {
      return predictionStats_;
    }

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    @java.lang.Override
    public int getPredictionStatsCount() {
      return predictionStats_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getPredictionStats(int index) {
      return predictionStats_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of historical stats generated by different time window's
     * Prediction Dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
        getPredictionStatsOrBuilder(int index) {
      return predictionStats_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, featureDisplayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getThreshold());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getTrainingStats());
      }
      for (int i = 0; i < predictionStats_.size(); i++) {
        output.writeMessage(5, predictionStats_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, featureDisplayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getThreshold());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTrainingStats());
      }
      for (int i = 0; i < predictionStats_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, predictionStats_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies
          other =
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                      .FeatureHistoricStatsAnomalies)
                  obj;

      if (!getFeatureDisplayName().equals(other.getFeatureDisplayName())) return false;
      if (hasThreshold() != other.hasThreshold()) return false;
      if (hasThreshold()) {
        if (!getThreshold().equals(other.getThreshold())) return false;
      }
      if (hasTrainingStats() != other.hasTrainingStats()) return false;
      if (hasTrainingStats()) {
        if (!getTrainingStats().equals(other.getTrainingStats())) return false;
      }
      if (!getPredictionStatsList().equals(other.getPredictionStatsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FEATURE_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureDisplayName().hashCode();
      if (hasThreshold()) {
        hash = (37 * hash) + THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getThreshold().hashCode();
      }
      if (hasTrainingStats()) {
        hash = (37 * hash) + TRAINING_STATS_FIELD_NUMBER;
        hash = (53 * hash) + getTrainingStats().hashCode();
      }
      if (getPredictionStatsCount() > 0) {
        hash = (37 * hash) + PREDICTION_STATS_FIELD_NUMBER;
        hash = (53 * hash) + getPredictionStatsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Historical Stats (and Anomalies) for a specific Feature.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomaliesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomalies.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomalies.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getThresholdFieldBuilder();
          getTrainingStatsFieldBuilder();
          getPredictionStatsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        featureDisplayName_ = "";
        threshold_ = null;
        if (thresholdBuilder_ != null) {
          thresholdBuilder_.dispose();
          thresholdBuilder_ = null;
        }
        trainingStats_ = null;
        if (trainingStatsBuilder_ != null) {
          trainingStatsBuilder_.dispose();
          trainingStatsBuilder_ = null;
        }
        if (predictionStatsBuilder_ == null) {
          predictionStats_ = java.util.Collections.emptyList();
        } else {
          predictionStats_ = null;
          predictionStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies
            result =
                new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomalies(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies
              result) {
        if (predictionStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            predictionStats_ = java.util.Collections.unmodifiableList(predictionStats_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.predictionStats_ = predictionStats_;
        } else {
          result.predictionStats_ = predictionStatsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.featureDisplayName_ = featureDisplayName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.threshold_ = thresholdBuilder_ == null ? threshold_ : thresholdBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.trainingStats_ =
              trainingStatsBuilder_ == null ? trainingStats_ : trainingStatsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                      .FeatureHistoricStatsAnomalies)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.getDefaultInstance()) return this;
        if (!other.getFeatureDisplayName().isEmpty()) {
          featureDisplayName_ = other.featureDisplayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasThreshold()) {
          mergeThreshold(other.getThreshold());
        }
        if (other.hasTrainingStats()) {
          mergeTrainingStats(other.getTrainingStats());
        }
        if (predictionStatsBuilder_ == null) {
          if (!other.predictionStats_.isEmpty()) {
            if (predictionStats_.isEmpty()) {
              predictionStats_ = other.predictionStats_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensurePredictionStatsIsMutable();
              predictionStats_.addAll(other.predictionStats_);
            }
            onChanged();
          }
        } else {
          if (!other.predictionStats_.isEmpty()) {
            if (predictionStatsBuilder_.isEmpty()) {
              predictionStatsBuilder_.dispose();
              predictionStatsBuilder_ = null;
              predictionStats_ = other.predictionStats_;
              bitField0_ = (bitField0_ & ~0x00000008);
              predictionStatsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPredictionStatsFieldBuilder()
                      : null;
            } else {
              predictionStatsBuilder_.addAllMessages(other.predictionStats_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  featureDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(getThresholdFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getTrainingStatsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.parser(),
                          extensionRegistry);
                  if (predictionStatsBuilder_ == null) {
                    ensurePredictionStatsIsMutable();
                    predictionStats_.add(m);
                  } else {
                    predictionStatsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object featureDisplayName_ = "";

      /**
       *
       *
       * <pre>
       * Display Name of the Feature.
       * </pre>
       *
       * <code>string feature_display_name = 1;</code>
       *
       * @return The featureDisplayName.
       */
      public java.lang.String getFeatureDisplayName() {
        java.lang.Object ref = featureDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          featureDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Display Name of the Feature.
       * </pre>
       *
       * <code>string feature_display_name = 1;</code>
       *
       * @return The bytes for featureDisplayName.
       */
      public com.google.protobuf.ByteString getFeatureDisplayNameBytes() {
        java.lang.Object ref = featureDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          featureDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Display Name of the Feature.
       * </pre>
       *
       * <code>string feature_display_name = 1;</code>
       *
       * @param value The featureDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setFeatureDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        featureDisplayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Display Name of the Feature.
       * </pre>
       *
       * <code>string feature_display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFeatureDisplayName() {
        featureDisplayName_ = getDefaultInstance().getFeatureDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Display Name of the Feature.
       * </pre>
       *
       * <code>string feature_display_name = 1;</code>
       *
       * @param value The bytes for featureDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setFeatureDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        featureDisplayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>
          thresholdBuilder_;

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       *
       * @return Whether the threshold field is set.
       */
      public boolean hasThreshold() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       *
       * @return The threshold.
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getThreshold() {
        if (thresholdBuilder_ == null) {
          return threshold_ == null
              ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
              : threshold_;
        } else {
          return thresholdBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      public Builder setThreshold(com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (thresholdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          threshold_ = value;
        } else {
          thresholdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      public Builder setThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder builderForValue) {
        if (thresholdBuilder_ == null) {
          threshold_ = builderForValue.build();
        } else {
          thresholdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      public Builder mergeThreshold(com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (thresholdBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && threshold_ != null
              && threshold_
                  != com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()) {
            getThresholdBuilder().mergeFrom(value);
          } else {
            threshold_ = value;
          }
        } else {
          thresholdBuilder_.mergeFrom(value);
        }
        if (threshold_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      public Builder clearThreshold() {
        bitField0_ = (bitField0_ & ~0x00000002);
        threshold_ = null;
        if (thresholdBuilder_ != null) {
          thresholdBuilder_.dispose();
          thresholdBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder getThresholdBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getThresholdFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder getThresholdOrBuilder() {
        if (thresholdBuilder_ != null) {
          return thresholdBuilder_.getMessageOrBuilder();
        } else {
          return threshold_ == null
              ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
              : threshold_;
        }
      }

      /**
       *
       *
       * <pre>
       * Threshold for anomaly detection.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig threshold = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>
          getThresholdFieldBuilder() {
        if (thresholdBuilder_ == null) {
          thresholdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>(
                  getThreshold(), getParentForChildren(), isClean());
          threshold_ = null;
        }
        return thresholdBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly trainingStats_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          trainingStatsBuilder_;

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       *
       * @return Whether the trainingStats field is set.
       */
      public boolean hasTrainingStats() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       *
       * @return The trainingStats.
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getTrainingStats() {
        if (trainingStatsBuilder_ == null) {
          return trainingStats_ == null
              ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
              : trainingStats_;
        } else {
          return trainingStatsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      public Builder setTrainingStats(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (trainingStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trainingStats_ = value;
        } else {
          trainingStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      public Builder setTrainingStats(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
        if (trainingStatsBuilder_ == null) {
          trainingStats_ = builderForValue.build();
        } else {
          trainingStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      public Builder mergeTrainingStats(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (trainingStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && trainingStats_ != null
              && trainingStats_
                  != com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()) {
            getTrainingStatsBuilder().mergeFrom(value);
          } else {
            trainingStats_ = value;
          }
        } else {
          trainingStatsBuilder_.mergeFrom(value);
        }
        if (trainingStats_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      public Builder clearTrainingStats() {
        bitField0_ = (bitField0_ & ~0x00000004);
        trainingStats_ = null;
        if (trainingStatsBuilder_ != null) {
          trainingStatsBuilder_.dispose();
          trainingStatsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
          getTrainingStatsBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTrainingStatsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
          getTrainingStatsOrBuilder() {
        if (trainingStatsBuilder_ != null) {
          return trainingStatsBuilder_.getMessageOrBuilder();
        } else {
          return trainingStats_ == null
              ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
              : trainingStats_;
        }
      }

      /**
       *
       *
       * <pre>
       * Stats calculated for the Training Dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly training_stats = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          getTrainingStatsFieldBuilder() {
        if (trainingStatsBuilder_ == null) {
          trainingStatsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>(
                  getTrainingStats(), getParentForChildren(), isClean());
          trainingStats_ = null;
        }
        return trainingStatsBuilder_;
      }

      private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
          predictionStats_ = java.util.Collections.emptyList();

      private void ensurePredictionStatsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          predictionStats_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>(
                  predictionStats_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          predictionStatsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
          getPredictionStatsList() {
        if (predictionStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(predictionStats_);
        } else {
          return predictionStatsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public int getPredictionStatsCount() {
        if (predictionStatsBuilder_ == null) {
          return predictionStats_.size();
        } else {
          return predictionStatsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getPredictionStats(int index) {
        if (predictionStatsBuilder_ == null) {
          return predictionStats_.get(index);
        } else {
          return predictionStatsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder setPredictionStats(
          int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (predictionStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePredictionStatsIsMutable();
          predictionStats_.set(index, value);
          onChanged();
        } else {
          predictionStatsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder setPredictionStats(
          int index,
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
        if (predictionStatsBuilder_ == null) {
          ensurePredictionStatsIsMutable();
          predictionStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          predictionStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder addPredictionStats(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (predictionStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePredictionStatsIsMutable();
          predictionStats_.add(value);
          onChanged();
        } else {
          predictionStatsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder addPredictionStats(
          int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (predictionStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePredictionStatsIsMutable();
          predictionStats_.add(index, value);
          onChanged();
        } else {
          predictionStatsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder addPredictionStats(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
        if (predictionStatsBuilder_ == null) {
          ensurePredictionStatsIsMutable();
          predictionStats_.add(builderForValue.build());
          onChanged();
        } else {
          predictionStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder addPredictionStats(
          int index,
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
        if (predictionStatsBuilder_ == null) {
          ensurePredictionStatsIsMutable();
          predictionStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          predictionStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder addAllPredictionStats(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
              values) {
        if (predictionStatsBuilder_ == null) {
          ensurePredictionStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, predictionStats_);
          onChanged();
        } else {
          predictionStatsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder clearPredictionStats() {
        if (predictionStatsBuilder_ == null) {
          predictionStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          predictionStatsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public Builder removePredictionStats(int index) {
        if (predictionStatsBuilder_ == null) {
          ensurePredictionStatsIsMutable();
          predictionStats_.remove(index);
          onChanged();
        } else {
          predictionStatsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
          getPredictionStatsBuilder(int index) {
        return getPredictionStatsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
          getPredictionStatsOrBuilder(int index) {
        if (predictionStatsBuilder_ == null) {
          return predictionStats_.get(index);
        } else {
          return predictionStatsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          getPredictionStatsOrBuilderList() {
        if (predictionStatsBuilder_ != null) {
          return predictionStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(predictionStats_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
          addPredictionStatsBuilder() {
        return getPredictionStatsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
          addPredictionStatsBuilder(int index) {
        return getPredictionStatsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of historical stats generated by different time window's
       * Prediction Dataset.
       * </pre>
       *
       * <code>repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly prediction_stats = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder>
          getPredictionStatsBuilderList() {
        return getPredictionStatsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          getPredictionStatsFieldBuilder() {
        if (predictionStatsBuilder_ == null) {
          predictionStatsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>(
                  predictionStats_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          predictionStats_ = null;
        }
        return predictionStatsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FeatureHistoricStatsAnomalies> PARSER =
        new com.google.protobuf.AbstractParser<FeatureHistoricStatsAnomalies>() {
          @java.lang.Override
          public FeatureHistoricStatsAnomalies parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FeatureHistoricStatsAnomalies> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeatureHistoricStatsAnomalies> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int OBJECTIVE_FIELD_NUMBER = 1;
  private int objective_ = 0;

  /**
   *
   *
   * <pre>
   * Model Monitoring Objective those stats and anomalies belonging to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for objective.
   */
  @java.lang.Override
  public int getObjectiveValue() {
    return objective_;
  }

  /**
   *
   *
   * <pre>
   * Model Monitoring Objective those stats and anomalies belonging to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
   * </code>
   *
   * @return The objective.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType getObjective() {
    com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType result =
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.forNumber(
            objective_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.UNRECOGNIZED
        : result;
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployedModelId_ = "";

  /**
   *
   *
   * <pre>
   * Deployed Model ID.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Deployed Model ID.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANOMALY_COUNT_FIELD_NUMBER = 3;
  private int anomalyCount_ = 0;

  /**
   *
   *
   * <pre>
   * Number of anomalies within all stats.
   * </pre>
   *
   * <code>int32 anomaly_count = 3;</code>
   *
   * @return The anomalyCount.
   */
  @java.lang.Override
  public int getAnomalyCount() {
    return anomalyCount_;
  }

  public static final int FEATURE_STATS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies>
      featureStats_;

  /**
   *
   *
   * <pre>
   * A list of historical Stats and Anomalies generated for all Features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
              .FeatureHistoricStatsAnomalies>
      getFeatureStatsList() {
    return featureStats_;
  }

  /**
   *
   *
   * <pre>
   * A list of historical Stats and Anomalies generated for all Features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomaliesOrBuilder>
      getFeatureStatsOrBuilderList() {
    return featureStats_;
  }

  /**
   *
   *
   * <pre>
   * A list of historical Stats and Anomalies generated for all Features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
   * </code>
   */
  @java.lang.Override
  public int getFeatureStatsCount() {
    return featureStats_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of historical Stats and Anomalies generated for all Features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
          .FeatureHistoricStatsAnomalies
      getFeatureStats(int index) {
    return featureStats_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of historical Stats and Anomalies generated for all Features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
          .FeatureHistoricStatsAnomaliesOrBuilder
      getFeatureStatsOrBuilder(int index) {
    return featureStats_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (objective_
        != com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
            .MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, objective_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    if (anomalyCount_ != 0) {
      output.writeInt32(3, anomalyCount_);
    }
    for (int i = 0; i < featureStats_.size(); i++) {
      output.writeMessage(4, featureStats_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (objective_
        != com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
            .MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, objective_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    if (anomalyCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, anomalyCount_);
    }
    for (int i = 0; i < featureStats_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, featureStats_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies) obj;

    if (objective_ != other.objective_) return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (getAnomalyCount() != other.getAnomalyCount()) return false;
    if (!getFeatureStatsList().equals(other.getFeatureStatsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + OBJECTIVE_FIELD_NUMBER;
    hash = (53 * hash) + objective_;
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    hash = (37 * hash) + ANOMALY_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getAnomalyCount();
    if (getFeatureStatsCount() > 0) {
      hash = (37 * hash) + FEATURE_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureStatsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Statistics and anomalies generated by Model Monitoring.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      objective_ = 0;
      deployedModelId_ = "";
      anomalyCount_ = 0;
      if (featureStatsBuilder_ == null) {
        featureStats_ = java.util.Collections.emptyList();
      } else {
        featureStats_ = null;
        featureStatsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsAnomalies_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies result) {
      if (featureStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          featureStats_ = java.util.Collections.unmodifiableList(featureStats_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.featureStats_ = featureStats_;
      } else {
        result.featureStats_ = featureStatsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.objective_ = objective_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedModelId_ = deployedModelId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.anomalyCount_ = anomalyCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.getDefaultInstance())
        return this;
      if (other.objective_ != 0) {
        setObjectiveValue(other.getObjectiveValue());
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getAnomalyCount() != 0) {
        setAnomalyCount(other.getAnomalyCount());
      }
      if (featureStatsBuilder_ == null) {
        if (!other.featureStats_.isEmpty()) {
          if (featureStats_.isEmpty()) {
            featureStats_ = other.featureStats_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFeatureStatsIsMutable();
            featureStats_.addAll(other.featureStats_);
          }
          onChanged();
        }
      } else {
        if (!other.featureStats_.isEmpty()) {
          if (featureStatsBuilder_.isEmpty()) {
            featureStatsBuilder_.dispose();
            featureStatsBuilder_ = null;
            featureStats_ = other.featureStats_;
            bitField0_ = (bitField0_ & ~0x00000008);
            featureStatsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeatureStatsFieldBuilder()
                    : null;
          } else {
            featureStatsBuilder_.addAllMessages(other.featureStats_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                objective_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                deployedModelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                anomalyCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                        .FeatureHistoricStatsAnomalies
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                                .FeatureHistoricStatsAnomalies.parser(),
                            extensionRegistry);
                if (featureStatsBuilder_ == null) {
                  ensureFeatureStatsIsMutable();
                  featureStats_.add(m);
                } else {
                  featureStatsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int objective_ = 0;

    /**
     *
     *
     * <pre>
     * Model Monitoring Objective those stats and anomalies belonging to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for objective.
     */
    @java.lang.Override
    public int getObjectiveValue() {
      return objective_;
    }

    /**
     *
     *
     * <pre>
     * Model Monitoring Objective those stats and anomalies belonging to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for objective to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveValue(int value) {
      objective_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Model Monitoring Objective those stats and anomalies belonging to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
     * </code>
     *
     * @return The objective.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
        getObjective() {
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType result =
          com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.forNumber(
              objective_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Model Monitoring Objective those stats and anomalies belonging to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
     * </code>
     *
     * @param value The objective to set.
     * @return This builder for chaining.
     */
    public Builder setObjective(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      objective_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Model Monitoring Objective those stats and anomalies belonging to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType objective = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjective() {
      bitField0_ = (bitField0_ & ~0x00000001);
      objective_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object deployedModelId_ = "";

    /**
     *
     *
     * <pre>
     * Deployed Model ID.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Deployed Model ID.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Deployed Model ID.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deployed Model ID.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {
      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deployed Model ID.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int anomalyCount_;

    /**
     *
     *
     * <pre>
     * Number of anomalies within all stats.
     * </pre>
     *
     * <code>int32 anomaly_count = 3;</code>
     *
     * @return The anomalyCount.
     */
    @java.lang.Override
    public int getAnomalyCount() {
      return anomalyCount_;
    }

    /**
     *
     *
     * <pre>
     * Number of anomalies within all stats.
     * </pre>
     *
     * <code>int32 anomaly_count = 3;</code>
     *
     * @param value The anomalyCount to set.
     * @return This builder for chaining.
     */
    public Builder setAnomalyCount(int value) {

      anomalyCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of anomalies within all stats.
     * </pre>
     *
     * <code>int32 anomaly_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnomalyCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      anomalyCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies>
        featureStats_ = java.util.Collections.emptyList();

    private void ensureFeatureStatsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        featureStats_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomalies>(featureStats_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomaliesOrBuilder>
        featureStatsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies>
        getFeatureStatsList() {
      if (featureStatsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(featureStats_);
      } else {
        return featureStatsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public int getFeatureStatsCount() {
      if (featureStatsBuilder_ == null) {
        return featureStats_.size();
      } else {
        return featureStatsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies
        getFeatureStats(int index) {
      if (featureStatsBuilder_ == null) {
        return featureStats_.get(index);
      } else {
        return featureStatsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder setFeatureStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies
            value) {
      if (featureStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureStatsIsMutable();
        featureStats_.set(index, value);
        onChanged();
      } else {
        featureStatsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder setFeatureStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.Builder
            builderForValue) {
      if (featureStatsBuilder_ == null) {
        ensureFeatureStatsIsMutable();
        featureStats_.set(index, builderForValue.build());
        onChanged();
      } else {
        featureStatsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder addFeatureStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies
            value) {
      if (featureStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureStatsIsMutable();
        featureStats_.add(value);
        onChanged();
      } else {
        featureStatsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder addFeatureStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies
            value) {
      if (featureStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureStatsIsMutable();
        featureStats_.add(index, value);
        onChanged();
      } else {
        featureStatsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder addFeatureStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.Builder
            builderForValue) {
      if (featureStatsBuilder_ == null) {
        ensureFeatureStatsIsMutable();
        featureStats_.add(builderForValue.build());
        onChanged();
      } else {
        featureStatsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder addFeatureStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.Builder
            builderForValue) {
      if (featureStatsBuilder_ == null) {
        ensureFeatureStatsIsMutable();
        featureStats_.add(index, builderForValue.build());
        onChanged();
      } else {
        featureStatsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder addAllFeatureStats(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                        .FeatureHistoricStatsAnomalies>
            values) {
      if (featureStatsBuilder_ == null) {
        ensureFeatureStatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureStats_);
        onChanged();
      } else {
        featureStatsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder clearFeatureStats() {
      if (featureStatsBuilder_ == null) {
        featureStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        featureStatsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public Builder removeFeatureStats(int index) {
      if (featureStatsBuilder_ == null) {
        ensureFeatureStatsIsMutable();
        featureStats_.remove(index);
        onChanged();
      } else {
        featureStatsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies.Builder
        getFeatureStatsBuilder(int index) {
      return getFeatureStatsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomaliesOrBuilder
        getFeatureStatsOrBuilder(int index) {
      if (featureStatsBuilder_ == null) {
        return featureStats_.get(index);
      } else {
        return featureStatsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomaliesOrBuilder>
        getFeatureStatsOrBuilderList() {
      if (featureStatsBuilder_ != null) {
        return featureStatsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(featureStats_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies.Builder
        addFeatureStatsBuilder() {
      return getFeatureStatsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
            .FeatureHistoricStatsAnomalies.Builder
        addFeatureStatsBuilder(int index) {
      return getFeatureStatsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .FeatureHistoricStatsAnomalies.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of historical Stats and Anomalies generated for all Features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies feature_stats = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.Builder>
        getFeatureStatsBuilderList() {
      return getFeatureStatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomalies.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                .FeatureHistoricStatsAnomaliesOrBuilder>
        getFeatureStatsFieldBuilder() {
      if (featureStatsBuilder_ == null) {
        featureStatsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomalies,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomalies.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                    .FeatureHistoricStatsAnomaliesOrBuilder>(
                featureStats_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        featureStats_ = null;
      }
      return featureStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringStatsAnomalies> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringStatsAnomalies>() {
        @java.lang.Override
        public ModelMonitoringStatsAnomalies parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringStatsAnomalies> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringStatsAnomalies> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
