/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_alert.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a single monitoring alert. This is currently used in the
 * SearchModelMonitoringAlerts api, thus the alert wrapped in this message
 * belongs to the resource asked in the request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringAlert}
 */
public final class ModelMonitoringAlert extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringAlert)
    ModelMonitoringAlertOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ModelMonitoringAlert.newBuilder() to construct.
  private ModelMonitoringAlert(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringAlert() {
    statsName_ = "";
    objectiveType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringAlert();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAlert_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAlert_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.Builder.class);
  }

  private int bitField0_;
  public static final int STATS_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statsName_ = "";

  /**
   *
   *
   * <pre>
   * The stats name.
   * </pre>
   *
   * <code>string stats_name = 1;</code>
   *
   * @return The statsName.
   */
  @java.lang.Override
  public java.lang.String getStatsName() {
    java.lang.Object ref = statsName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statsName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The stats name.
   * </pre>
   *
   * <code>string stats_name = 1;</code>
   *
   * @return The bytes for statsName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatsNameBytes() {
    java.lang.Object ref = statsName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statsName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECTIVE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object objectiveType_ = "";

  /**
   *
   *
   * <pre>
   * One of the supported monitoring objectives:
   * `raw-feature-drift`
   * `prediction-output-drift`
   * `feature-attribution`
   * </pre>
   *
   * <code>string objective_type = 2;</code>
   *
   * @return The objectiveType.
   */
  @java.lang.Override
  public java.lang.String getObjectiveType() {
    java.lang.Object ref = objectiveType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      objectiveType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * One of the supported monitoring objectives:
   * `raw-feature-drift`
   * `prediction-output-drift`
   * `feature-attribution`
   * </pre>
   *
   * <code>string objective_type = 2;</code>
   *
   * @return The bytes for objectiveType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObjectiveTypeBytes() {
    java.lang.Object ref = objectiveType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      objectiveType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALERT_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp alertTime_;

  /**
   *
   *
   * <pre>
   * Alert creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp alert_time = 3;</code>
   *
   * @return Whether the alertTime field is set.
   */
  @java.lang.Override
  public boolean hasAlertTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Alert creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp alert_time = 3;</code>
   *
   * @return The alertTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getAlertTime() {
    return alertTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : alertTime_;
  }

  /**
   *
   *
   * <pre>
   * Alert creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp alert_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getAlertTimeOrBuilder() {
    return alertTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : alertTime_;
  }

  public static final int ANOMALY_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly_;

  /**
   *
   *
   * <pre>
   * Anomaly details.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
   *
   * @return Whether the anomaly field is set.
   */
  @java.lang.Override
  public boolean hasAnomaly() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Anomaly details.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
   *
   * @return The anomaly.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly getAnomaly() {
    return anomaly_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.getDefaultInstance()
        : anomaly_;
  }

  /**
   *
   *
   * <pre>
   * Anomaly details.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomalyOrBuilder getAnomalyOrBuilder() {
    return anomaly_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.getDefaultInstance()
        : anomaly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, statsName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, objectiveType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAlertTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getAnomaly());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, statsName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, objectiveType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAlertTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAnomaly());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert) obj;

    if (!getStatsName().equals(other.getStatsName())) return false;
    if (!getObjectiveType().equals(other.getObjectiveType())) return false;
    if (hasAlertTime() != other.hasAlertTime()) return false;
    if (hasAlertTime()) {
      if (!getAlertTime().equals(other.getAlertTime())) return false;
    }
    if (hasAnomaly() != other.hasAnomaly()) return false;
    if (hasAnomaly()) {
      if (!getAnomaly().equals(other.getAnomaly())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATS_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getStatsName().hashCode();
    hash = (37 * hash) + OBJECTIVE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getObjectiveType().hashCode();
    if (hasAlertTime()) {
      hash = (37 * hash) + ALERT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getAlertTime().hashCode();
    }
    if (hasAnomaly()) {
      hash = (37 * hash) + ANOMALY_FIELD_NUMBER;
      hash = (53 * hash) + getAnomaly().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a single monitoring alert. This is currently used in the
   * SearchModelMonitoringAlerts api, thus the alert wrapped in this message
   * belongs to the resource asked in the request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringAlert}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringAlert)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAlert_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAlert_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAlertTimeFieldBuilder();
        getAnomalyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      statsName_ = "";
      objectiveType_ = "";
      alertTime_ = null;
      if (alertTimeBuilder_ != null) {
        alertTimeBuilder_.dispose();
        alertTimeBuilder_ = null;
      }
      anomaly_ = null;
      if (anomalyBuilder_ != null) {
        anomalyBuilder_.dispose();
        anomalyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAlert_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.statsName_ = statsName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.objectiveType_ = objectiveType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.alertTime_ = alertTimeBuilder_ == null ? alertTime_ : alertTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.anomaly_ = anomalyBuilder_ == null ? anomaly_ : anomalyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert.getDefaultInstance())
        return this;
      if (!other.getStatsName().isEmpty()) {
        statsName_ = other.statsName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getObjectiveType().isEmpty()) {
        objectiveType_ = other.objectiveType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAlertTime()) {
        mergeAlertTime(other.getAlertTime());
      }
      if (other.hasAnomaly()) {
        mergeAnomaly(other.getAnomaly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                statsName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                objectiveType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAlertTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getAnomalyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object statsName_ = "";

    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The statsName.
     */
    public java.lang.String getStatsName() {
      java.lang.Object ref = statsName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statsName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The bytes for statsName.
     */
    public com.google.protobuf.ByteString getStatsNameBytes() {
      java.lang.Object ref = statsName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statsName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @param value The statsName to set.
     * @return This builder for chaining.
     */
    public Builder setStatsName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statsName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatsName() {
      statsName_ = getDefaultInstance().getStatsName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @param value The bytes for statsName to set.
     * @return This builder for chaining.
     */
    public Builder setStatsNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statsName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object objectiveType_ = "";

    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The objectiveType.
     */
    public java.lang.String getObjectiveType() {
      java.lang.Object ref = objectiveType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectiveType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The bytes for objectiveType.
     */
    public com.google.protobuf.ByteString getObjectiveTypeBytes() {
      java.lang.Object ref = objectiveType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectiveType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @param value The objectiveType to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      objectiveType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjectiveType() {
      objectiveType_ = getDefaultInstance().getObjectiveType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @param value The bytes for objectiveType to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      objectiveType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp alertTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        alertTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     *
     * @return Whether the alertTime field is set.
     */
    public boolean hasAlertTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     *
     * @return The alertTime.
     */
    public com.google.protobuf.Timestamp getAlertTime() {
      if (alertTimeBuilder_ == null) {
        return alertTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : alertTime_;
      } else {
        return alertTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    public Builder setAlertTime(com.google.protobuf.Timestamp value) {
      if (alertTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alertTime_ = value;
      } else {
        alertTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    public Builder setAlertTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (alertTimeBuilder_ == null) {
        alertTime_ = builderForValue.build();
      } else {
        alertTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    public Builder mergeAlertTime(com.google.protobuf.Timestamp value) {
      if (alertTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && alertTime_ != null
            && alertTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getAlertTimeBuilder().mergeFrom(value);
        } else {
          alertTime_ = value;
        }
      } else {
        alertTimeBuilder_.mergeFrom(value);
      }
      if (alertTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    public Builder clearAlertTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      alertTime_ = null;
      if (alertTimeBuilder_ != null) {
        alertTimeBuilder_.dispose();
        alertTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getAlertTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAlertTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getAlertTimeOrBuilder() {
      if (alertTimeBuilder_ != null) {
        return alertTimeBuilder_.getMessageOrBuilder();
      } else {
        return alertTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : alertTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Alert creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp alert_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getAlertTimeFieldBuilder() {
      if (alertTimeBuilder_ == null) {
        alertTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getAlertTime(), getParentForChildren(), isClean());
        alertTime_ = null;
      }
      return alertTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomalyOrBuilder>
        anomalyBuilder_;

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     *
     * @return Whether the anomaly field is set.
     */
    public boolean hasAnomaly() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     *
     * @return The anomaly.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly getAnomaly() {
      if (anomalyBuilder_ == null) {
        return anomaly_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.getDefaultInstance()
            : anomaly_;
      } else {
        return anomalyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    public Builder setAnomaly(com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly value) {
      if (anomalyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        anomaly_ = value;
      } else {
        anomalyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    public Builder setAnomaly(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder builderForValue) {
      if (anomalyBuilder_ == null) {
        anomaly_ = builderForValue.build();
      } else {
        anomalyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    public Builder mergeAnomaly(com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly value) {
      if (anomalyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && anomaly_ != null
            && anomaly_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly
                    .getDefaultInstance()) {
          getAnomalyBuilder().mergeFrom(value);
        } else {
          anomaly_ = value;
        }
      } else {
        anomalyBuilder_.mergeFrom(value);
      }
      if (anomaly_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    public Builder clearAnomaly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      anomaly_ = null;
      if (anomalyBuilder_ != null) {
        anomalyBuilder_.dispose();
        anomalyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder getAnomalyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAnomalyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomalyOrBuilder
        getAnomalyOrBuilder() {
      if (anomalyBuilder_ != null) {
        return anomalyBuilder_.getMessageOrBuilder();
      } else {
        return anomaly_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.getDefaultInstance()
            : anomaly_;
      }
    }

    /**
     *
     *
     * <pre>
     * Anomaly details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly anomaly = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomalyOrBuilder>
        getAnomalyFieldBuilder() {
      if (anomalyBuilder_ == null) {
        anomalyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomalyOrBuilder>(
                getAnomaly(), getParentForChildren(), isClean());
        anomaly_ = null;
      }
      return anomalyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringAlert)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringAlert)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringAlert> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringAlert>() {
        @java.lang.Override
        public ModelMonitoringAlert parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringAlert> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringAlert> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
