/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/notebook_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest}
 */
public final class ListNotebookRuntimesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest)
    ListNotebookRuntimesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListNotebookRuntimesRequest.newBuilder() to construct.
  private ListNotebookRuntimesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListNotebookRuntimesRequest() {
    parent_ = "";
    filter_ = "";
    pageToken_ = "";
    orderBy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListNotebookRuntimesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.NotebookServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ListNotebookRuntimesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.NotebookServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ListNotebookRuntimesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.class,
            com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location from which to list the
   * NotebookRuntimes.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location from which to list the
   * NotebookRuntimes.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An expression for filtering the results of the request. For field
   * names both snake_case and camelCase are supported.
   *
   *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
   *     NotebookRuntime ID,
   *     i.e. the last segment of the NotebookRuntime's [resource name]
   *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
   *   * `displayName` supports = and != and regex.
   *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
   *     represents the NotebookRuntimeTemplate ID,
   *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
   *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
   *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
   *   HEALTH_STATE_UNSPECIFIED].
   *   * `runtimeState` supports = and !=. runtimeState enum:
   *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
   *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
   *   * `runtimeUser` supports = and !=.
   *   * API version is UI only: `uiState` supports = and !=. uiState enum:
   *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
   *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
   *   UI_RESOURCE_STATE_CREATION_FAILED].
   *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
   *   [USER_DEFINED, ONE_CLICK].
   *   * `machineType` supports = and !=.
   *   * `acceleratorType` supports = and !=.
   *
   * Some examples:
   *
   *   * `notebookRuntime="notebookRuntime123"`
   *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
   *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
   *   * `healthState=HEALTHY`
   *   * `runtimeState=RUNNING`
   *   * `runtimeUser="test&#64;google.com"`
   *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
   *   * `notebookRuntimeType=USER_DEFINED`
   *   * `machineType=e2-standard-4`
   *   * `acceleratorType=NVIDIA_TESLA_T4`
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An expression for filtering the results of the request. For field
   * names both snake_case and camelCase are supported.
   *
   *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
   *     NotebookRuntime ID,
   *     i.e. the last segment of the NotebookRuntime's [resource name]
   *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
   *   * `displayName` supports = and != and regex.
   *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
   *     represents the NotebookRuntimeTemplate ID,
   *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
   *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
   *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
   *   HEALTH_STATE_UNSPECIFIED].
   *   * `runtimeState` supports = and !=. runtimeState enum:
   *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
   *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
   *   * `runtimeUser` supports = and !=.
   *   * API version is UI only: `uiState` supports = and !=. uiState enum:
   *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
   *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
   *   UI_RESOURCE_STATE_CREATION_FAILED].
   *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
   *   [USER_DEFINED, ONE_CLICK].
   *   * `machineType` supports = and !=.
   *   * `acceleratorType` supports = and !=.
   *
   * Some examples:
   *
   *   * `notebookRuntime="notebookRuntime123"`
   *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
   *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
   *   * `healthState=HEALTHY`
   *   * `runtimeState=RUNNING`
   *   * `runtimeUser="test&#64;google.com"`
   *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
   *   * `notebookRuntimeType=USER_DEFINED`
   *   * `machineType=e2-standard-4`
   *   * `acceleratorType=NVIDIA_TESLA_T4`
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The standard list page size.
   * </pre>
   *
   * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The standard list page token.
   * Typically obtained via
   * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
   * of the previous
   * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
   * call.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The standard list page token.
   * Typically obtained via
   * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
   * of the previous
   * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
   * call.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_MASK_FIELD_NUMBER = 5;
  private com.google.protobuf.FieldMask readMask_;

  /**
   *
   *
   * <pre>
   * Optional. Mask specifying which fields to read.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the readMask field is set.
   */
  @java.lang.Override
  public boolean hasReadMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Mask specifying which fields to read.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The readMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getReadMask() {
    return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Mask specifying which fields to read.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder() {
    return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
  }

  public static final int ORDER_BY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A comma-separated list of fields to order by, sorted in ascending
   * order. Use "desc" after a field name for descending. Supported fields:
   *
   *   * `display_name`
   *   * `create_time`
   *   * `update_time`
   *
   * Example: `display_name, create_time desc`.
   * </pre>
   *
   * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A comma-separated list of fields to order by, sorted in ascending
   * order. Use "desc" after a field name for descending. Supported fields:
   *
   *   * `display_name`
   *   * `create_time`
   *   * `update_time`
   *
   * Example: `display_name, create_time desc`.
   * </pre>
   *
   * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getReadMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, orderBy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getReadMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, orderBy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest other =
        (com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (hasReadMask() != other.hasReadMask()) return false;
    if (hasReadMask()) {
      if (!getReadMask().equals(other.getReadMask())) return false;
    }
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    if (hasReadMask()) {
      hash = (37 * hash) + READ_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getReadMask().hashCode();
    }
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest)
      com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ListNotebookRuntimesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NotebookServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ListNotebookRuntimesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.class,
              com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReadMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      filter_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      readMask_ = null;
      if (readMaskBuilder_ != null) {
        readMaskBuilder_.dispose();
        readMaskBuilder_ = null;
      }
      orderBy_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.NotebookServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ListNotebookRuntimesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest build() {
      com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest result =
          new com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageToken_ = pageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.readMask_ = readMaskBuilder_ == null ? readMask_ : readMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.orderBy_ = orderBy_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasReadMask()) {
        mergeReadMask(other.getReadMask());
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getReadMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to list the
     * NotebookRuntimes.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to list the
     * NotebookRuntimes.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to list the
     * NotebookRuntimes.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to list the
     * NotebookRuntimes.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to list the
     * NotebookRuntimes.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An expression for filtering the results of the request. For field
     * names both snake_case and camelCase are supported.
     *
     *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
     *     NotebookRuntime ID,
     *     i.e. the last segment of the NotebookRuntime's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
     *   * `displayName` supports = and != and regex.
     *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *     represents the NotebookRuntimeTemplate ID,
     *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
     *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
     *   HEALTH_STATE_UNSPECIFIED].
     *   * `runtimeState` supports = and !=. runtimeState enum:
     *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
     *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
     *   * `runtimeUser` supports = and !=.
     *   * API version is UI only: `uiState` supports = and !=. uiState enum:
     *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
     *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
     *   UI_RESOURCE_STATE_CREATION_FAILED].
     *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *   [USER_DEFINED, ONE_CLICK].
     *   * `machineType` supports = and !=.
     *   * `acceleratorType` supports = and !=.
     *
     * Some examples:
     *
     *   * `notebookRuntime="notebookRuntime123"`
     *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
     *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
     *   * `healthState=HEALTHY`
     *   * `runtimeState=RUNNING`
     *   * `runtimeUser="test&#64;google.com"`
     *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
     *   * `notebookRuntimeType=USER_DEFINED`
     *   * `machineType=e2-standard-4`
     *   * `acceleratorType=NVIDIA_TESLA_T4`
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression for filtering the results of the request. For field
     * names both snake_case and camelCase are supported.
     *
     *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
     *     NotebookRuntime ID,
     *     i.e. the last segment of the NotebookRuntime's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
     *   * `displayName` supports = and != and regex.
     *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *     represents the NotebookRuntimeTemplate ID,
     *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
     *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
     *   HEALTH_STATE_UNSPECIFIED].
     *   * `runtimeState` supports = and !=. runtimeState enum:
     *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
     *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
     *   * `runtimeUser` supports = and !=.
     *   * API version is UI only: `uiState` supports = and !=. uiState enum:
     *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
     *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
     *   UI_RESOURCE_STATE_CREATION_FAILED].
     *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *   [USER_DEFINED, ONE_CLICK].
     *   * `machineType` supports = and !=.
     *   * `acceleratorType` supports = and !=.
     *
     * Some examples:
     *
     *   * `notebookRuntime="notebookRuntime123"`
     *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
     *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
     *   * `healthState=HEALTHY`
     *   * `runtimeState=RUNNING`
     *   * `runtimeUser="test&#64;google.com"`
     *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
     *   * `notebookRuntimeType=USER_DEFINED`
     *   * `machineType=e2-standard-4`
     *   * `acceleratorType=NVIDIA_TESLA_T4`
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression for filtering the results of the request. For field
     * names both snake_case and camelCase are supported.
     *
     *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
     *     NotebookRuntime ID,
     *     i.e. the last segment of the NotebookRuntime's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
     *   * `displayName` supports = and != and regex.
     *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *     represents the NotebookRuntimeTemplate ID,
     *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
     *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
     *   HEALTH_STATE_UNSPECIFIED].
     *   * `runtimeState` supports = and !=. runtimeState enum:
     *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
     *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
     *   * `runtimeUser` supports = and !=.
     *   * API version is UI only: `uiState` supports = and !=. uiState enum:
     *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
     *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
     *   UI_RESOURCE_STATE_CREATION_FAILED].
     *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *   [USER_DEFINED, ONE_CLICK].
     *   * `machineType` supports = and !=.
     *   * `acceleratorType` supports = and !=.
     *
     * Some examples:
     *
     *   * `notebookRuntime="notebookRuntime123"`
     *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
     *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
     *   * `healthState=HEALTHY`
     *   * `runtimeState=RUNNING`
     *   * `runtimeUser="test&#64;google.com"`
     *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
     *   * `notebookRuntimeType=USER_DEFINED`
     *   * `machineType=e2-standard-4`
     *   * `acceleratorType=NVIDIA_TESLA_T4`
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression for filtering the results of the request. For field
     * names both snake_case and camelCase are supported.
     *
     *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
     *     NotebookRuntime ID,
     *     i.e. the last segment of the NotebookRuntime's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
     *   * `displayName` supports = and != and regex.
     *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *     represents the NotebookRuntimeTemplate ID,
     *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
     *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
     *   HEALTH_STATE_UNSPECIFIED].
     *   * `runtimeState` supports = and !=. runtimeState enum:
     *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
     *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
     *   * `runtimeUser` supports = and !=.
     *   * API version is UI only: `uiState` supports = and !=. uiState enum:
     *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
     *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
     *   UI_RESOURCE_STATE_CREATION_FAILED].
     *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *   [USER_DEFINED, ONE_CLICK].
     *   * `machineType` supports = and !=.
     *   * `acceleratorType` supports = and !=.
     *
     * Some examples:
     *
     *   * `notebookRuntime="notebookRuntime123"`
     *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
     *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
     *   * `healthState=HEALTHY`
     *   * `runtimeState=RUNNING`
     *   * `runtimeUser="test&#64;google.com"`
     *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
     *   * `notebookRuntimeType=USER_DEFINED`
     *   * `machineType=e2-standard-4`
     *   * `acceleratorType=NVIDIA_TESLA_T4`
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression for filtering the results of the request. For field
     * names both snake_case and camelCase are supported.
     *
     *   * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
     *     NotebookRuntime ID,
     *     i.e. the last segment of the NotebookRuntime's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntime.name].
     *   * `displayName` supports = and != and regex.
     *   * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *     represents the NotebookRuntimeTemplate ID,
     *     i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *     [google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate.name].
     *   * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
     *   HEALTH_STATE_UNSPECIFIED].
     *   * `runtimeState` supports = and !=. runtimeState enum:
     *   [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
     *   STOPPED, BEING_UPGRADED, ERROR, INVALID].
     *   * `runtimeUser` supports = and !=.
     *   * API version is UI only: `uiState` supports = and !=. uiState enum:
     *   [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
     *   UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
     *   UI_RESOURCE_STATE_CREATION_FAILED].
     *   * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *   [USER_DEFINED, ONE_CLICK].
     *   * `machineType` supports = and !=.
     *   * `acceleratorType` supports = and !=.
     *
     * Some examples:
     *
     *   * `notebookRuntime="notebookRuntime123"`
     *   * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
     *   * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
     *   * `healthState=HEALTHY`
     *   * `runtimeState=RUNNING`
     *   * `runtimeUser="test&#64;google.com"`
     *   * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
     *   * `notebookRuntimeType=USER_DEFINED`
     *   * `machineType=e2-standard-4`
     *   * `acceleratorType=NVIDIA_TESLA_T4`
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * Optional. The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The standard list page token.
     * Typically obtained via
     * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
     * of the previous
     * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
     * call.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The standard list page token.
     * Typically obtained via
     * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
     * of the previous
     * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
     * call.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The standard list page token.
     * Typically obtained via
     * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
     * of the previous
     * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
     * call.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The standard list page token.
     * Typically obtained via
     * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
     * of the previous
     * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
     * call.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The standard list page token.
     * Typically obtained via
     * [ListNotebookRuntimesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse.next_page_token]
     * of the previous
     * [NotebookService.ListNotebookRuntimes][google.cloud.aiplatform.v1beta1.NotebookService.ListNotebookRuntimes]
     * call.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask readMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        readMaskBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the readMask field is set.
     */
    public boolean hasReadMask() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The readMask.
     */
    public com.google.protobuf.FieldMask getReadMask() {
      if (readMaskBuilder_ == null) {
        return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
      } else {
        return readMaskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadMask(com.google.protobuf.FieldMask value) {
      if (readMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readMask_ = value;
      } else {
        readMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (readMaskBuilder_ == null) {
        readMask_ = builderForValue.build();
      } else {
        readMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReadMask(com.google.protobuf.FieldMask value) {
      if (readMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && readMask_ != null
            && readMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getReadMaskBuilder().mergeFrom(value);
        } else {
          readMask_ = value;
        }
      } else {
        readMaskBuilder_.mergeFrom(value);
      }
      if (readMask_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReadMask() {
      bitField0_ = (bitField0_ & ~0x00000010);
      readMask_ = null;
      if (readMaskBuilder_ != null) {
        readMaskBuilder_.dispose();
        readMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getReadMaskBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getReadMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder() {
      if (readMaskBuilder_ != null) {
        return readMaskBuilder_.getMessageOrBuilder();
      } else {
        return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Mask specifying which fields to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getReadMaskFieldBuilder() {
      if (readMaskBuilder_ == null) {
        readMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getReadMask(), getParentForChildren(), isClean());
        readMask_ = null;
      }
      return readMaskBuilder_;
    }

    private java.lang.Object orderBy_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A comma-separated list of fields to order by, sorted in ascending
     * order. Use "desc" after a field name for descending. Supported fields:
     *
     *   * `display_name`
     *   * `create_time`
     *   * `update_time`
     *
     * Example: `display_name, create_time desc`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A comma-separated list of fields to order by, sorted in ascending
     * order. Use "desc" after a field name for descending. Supported fields:
     *
     *   * `display_name`
     *   * `create_time`
     *   * `update_time`
     *
     * Example: `display_name, create_time desc`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A comma-separated list of fields to order by, sorted in ascending
     * order. Use "desc" after a field name for descending. Supported fields:
     *
     *   * `display_name`
     *   * `create_time`
     *   * `update_time`
     *
     * Example: `display_name, create_time desc`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A comma-separated list of fields to order by, sorted in ascending
     * order. Use "desc" after a field name for descending. Supported fields:
     *
     *   * `display_name`
     *   * `create_time`
     *   * `update_time`
     *
     * Example: `display_name, create_time desc`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A comma-separated list of fields to order by, sorted in ascending
     * order. Use "desc" after a field name for descending. Supported fields:
     *
     *   * `display_name`
     *   * `create_time`
     *   * `update_time`
     *
     * Example: `display_name, create_time desc`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListNotebookRuntimesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListNotebookRuntimesRequest>() {
        @java.lang.Override
        public ListNotebookRuntimesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListNotebookRuntimesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListNotebookRuntimesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
