/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/dataset_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for how to read Gemini requests from a multimodal dataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig}
 */
public final class GeminiRequestReadConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig)
    GeminiRequestReadConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GeminiRequestReadConfig.newBuilder() to construct.
  private GeminiRequestReadConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GeminiRequestReadConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GeminiRequestReadConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GeminiRequestReadConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GeminiRequestReadConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.class,
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder.class);
  }

  private int readConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object readConfig_;

  public enum ReadConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEMPLATE_CONFIG(1),
    ASSEMBLED_REQUEST_COLUMN_NAME(4),
    READCONFIG_NOT_SET(0);
    private final int value;

    private ReadConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReadConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReadConfigCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEMPLATE_CONFIG;
        case 4:
          return ASSEMBLED_REQUEST_COLUMN_NAME;
        case 0:
          return READCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReadConfigCase getReadConfigCase() {
    return ReadConfigCase.forNumber(readConfigCase_);
  }

  public static final int TEMPLATE_CONFIG_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Gemini request template with placeholders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
   *
   * @return Whether the templateConfig field is set.
   */
  @java.lang.Override
  public boolean hasTemplateConfig() {
    return readConfigCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Gemini request template with placeholders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
   *
   * @return The templateConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig getTemplateConfig() {
    if (readConfigCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Gemini request template with placeholders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder
      getTemplateConfigOrBuilder() {
    if (readConfigCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
  }

  public static final int ASSEMBLED_REQUEST_COLUMN_NAME_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Optional. Column name in the dataset table that contains already fully
   * assembled Gemini requests.
   * </pre>
   *
   * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the assembledRequestColumnName field is set.
   */
  public boolean hasAssembledRequestColumnName() {
    return readConfigCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Optional. Column name in the dataset table that contains already fully
   * assembled Gemini requests.
   * </pre>
   *
   * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The assembledRequestColumnName.
   */
  public java.lang.String getAssembledRequestColumnName() {
    java.lang.Object ref = "";
    if (readConfigCase_ == 4) {
      ref = readConfig_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (readConfigCase_ == 4) {
        readConfig_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Column name in the dataset table that contains already fully
   * assembled Gemini requests.
   * </pre>
   *
   * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for assembledRequestColumnName.
   */
  public com.google.protobuf.ByteString getAssembledRequestColumnNameBytes() {
    java.lang.Object ref = "";
    if (readConfigCase_ == 4) {
      ref = readConfig_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (readConfigCase_ == 4) {
        readConfig_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (readConfigCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_);
    }
    if (readConfigCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, readConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (readConfigCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_);
    }
    if (readConfigCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, readConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig other =
        (com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig) obj;

    if (!getReadConfigCase().equals(other.getReadConfigCase())) return false;
    switch (readConfigCase_) {
      case 1:
        if (!getTemplateConfig().equals(other.getTemplateConfig())) return false;
        break;
      case 4:
        if (!getAssembledRequestColumnName().equals(other.getAssembledRequestColumnName()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (readConfigCase_) {
      case 1:
        hash = (37 * hash) + TEMPLATE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTemplateConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ASSEMBLED_REQUEST_COLUMN_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getAssembledRequestColumnName().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration for how to read Gemini requests from a multimodal dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig)
      com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GeminiRequestReadConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GeminiRequestReadConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.class,
              com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (templateConfigBuilder_ != null) {
        templateConfigBuilder_.clear();
      }
      readConfigCase_ = 0;
      readConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GeminiRequestReadConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig build() {
      com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig result =
          new com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig result) {
      result.readConfigCase_ = readConfigCase_;
      result.readConfig_ = this.readConfig_;
      if (readConfigCase_ == 1 && templateConfigBuilder_ != null) {
        result.readConfig_ = templateConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.getDefaultInstance())
        return this;
      switch (other.getReadConfigCase()) {
        case TEMPLATE_CONFIG:
          {
            mergeTemplateConfig(other.getTemplateConfig());
            break;
          }
        case ASSEMBLED_REQUEST_COLUMN_NAME:
          {
            readConfigCase_ = 4;
            readConfig_ = other.readConfig_;
            onChanged();
            break;
          }
        case READCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTemplateConfigFieldBuilder().getBuilder(), extensionRegistry);
                readConfigCase_ = 1;
                break;
              } // case 10
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                readConfigCase_ = 4;
                readConfig_ = s;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int readConfigCase_ = 0;
    private java.lang.Object readConfig_;

    public ReadConfigCase getReadConfigCase() {
      return ReadConfigCase.forNumber(readConfigCase_);
    }

    public Builder clearReadConfig() {
      readConfigCase_ = 0;
      readConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder>
        templateConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     *
     * @return Whether the templateConfig field is set.
     */
    @java.lang.Override
    public boolean hasTemplateConfig() {
      return readConfigCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     *
     * @return The templateConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig getTemplateConfig() {
      if (templateConfigBuilder_ == null) {
        if (readConfigCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
      } else {
        if (readConfigCase_ == 1) {
          return templateConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    public Builder setTemplateConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig value) {
      if (templateConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readConfig_ = value;
        onChanged();
      } else {
        templateConfigBuilder_.setMessage(value);
      }
      readConfigCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    public Builder setTemplateConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder builderForValue) {
      if (templateConfigBuilder_ == null) {
        readConfig_ = builderForValue.build();
        onChanged();
      } else {
        templateConfigBuilder_.setMessage(builderForValue.build());
      }
      readConfigCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    public Builder mergeTemplateConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig value) {
      if (templateConfigBuilder_ == null) {
        if (readConfigCase_ == 1
            && readConfig_
                != com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance()) {
          readConfig_ =
              com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          readConfig_ = value;
        }
        onChanged();
      } else {
        if (readConfigCase_ == 1) {
          templateConfigBuilder_.mergeFrom(value);
        } else {
          templateConfigBuilder_.setMessage(value);
        }
      }
      readConfigCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    public Builder clearTemplateConfig() {
      if (templateConfigBuilder_ == null) {
        if (readConfigCase_ == 1) {
          readConfigCase_ = 0;
          readConfig_ = null;
          onChanged();
        }
      } else {
        if (readConfigCase_ == 1) {
          readConfigCase_ = 0;
          readConfig_ = null;
        }
        templateConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder
        getTemplateConfigBuilder() {
      return getTemplateConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder
        getTemplateConfigOrBuilder() {
      if ((readConfigCase_ == 1) && (templateConfigBuilder_ != null)) {
        return templateConfigBuilder_.getMessageOrBuilder();
      } else {
        if (readConfigCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Gemini request template with placeholders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig template_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder>
        getTemplateConfigFieldBuilder() {
      if (templateConfigBuilder_ == null) {
        if (!(readConfigCase_ == 1)) {
          readConfig_ =
              com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
        }
        templateConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig,
                com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_,
                getParentForChildren(),
                isClean());
        readConfig_ = null;
      }
      readConfigCase_ = 1;
      onChanged();
      return templateConfigBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Column name in the dataset table that contains already fully
     * assembled Gemini requests.
     * </pre>
     *
     * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the assembledRequestColumnName field is set.
     */
    @java.lang.Override
    public boolean hasAssembledRequestColumnName() {
      return readConfigCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Column name in the dataset table that contains already fully
     * assembled Gemini requests.
     * </pre>
     *
     * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The assembledRequestColumnName.
     */
    @java.lang.Override
    public java.lang.String getAssembledRequestColumnName() {
      java.lang.Object ref = "";
      if (readConfigCase_ == 4) {
        ref = readConfig_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (readConfigCase_ == 4) {
          readConfig_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Column name in the dataset table that contains already fully
     * assembled Gemini requests.
     * </pre>
     *
     * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for assembledRequestColumnName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAssembledRequestColumnNameBytes() {
      java.lang.Object ref = "";
      if (readConfigCase_ == 4) {
        ref = readConfig_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (readConfigCase_ == 4) {
          readConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Column name in the dataset table that contains already fully
     * assembled Gemini requests.
     * </pre>
     *
     * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The assembledRequestColumnName to set.
     * @return This builder for chaining.
     */
    public Builder setAssembledRequestColumnName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      readConfigCase_ = 4;
      readConfig_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Column name in the dataset table that contains already fully
     * assembled Gemini requests.
     * </pre>
     *
     * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssembledRequestColumnName() {
      if (readConfigCase_ == 4) {
        readConfigCase_ = 0;
        readConfig_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Column name in the dataset table that contains already fully
     * assembled Gemini requests.
     * </pre>
     *
     * <code>string assembled_request_column_name = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for assembledRequestColumnName to set.
     * @return This builder for chaining.
     */
    public Builder setAssembledRequestColumnNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      readConfigCase_ = 4;
      readConfig_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig)
  private static final com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GeminiRequestReadConfig> PARSER =
      new com.google.protobuf.AbstractParser<GeminiRequestReadConfig>() {
        @java.lang.Override
        public GeminiRequestReadConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GeminiRequestReadConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GeminiRequestReadConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
