/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/explanation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Overrides for example-based explanations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExamplesOverride}
 */
public final class ExamplesOverride extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ExamplesOverride)
    ExamplesOverrideOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ExamplesOverride.newBuilder() to construct.
  private ExamplesOverride(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExamplesOverride() {
    restrictions_ = java.util.Collections.emptyList();
    dataFormat_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExamplesOverride();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExamplesOverride_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExamplesOverride_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ExamplesOverride.class,
            com.google.cloud.aiplatform.v1beta1.ExamplesOverride.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Data format enum.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat}
   */
  public enum DataFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified format. Must not be used.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    DATA_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Provided data is a set of model inputs.
     * </pre>
     *
     * <code>INSTANCES = 1;</code>
     */
    INSTANCES(1),
    /**
     *
     *
     * <pre>
     * Provided data is a set of embeddings.
     * </pre>
     *
     * <code>EMBEDDINGS = 2;</code>
     */
    EMBEDDINGS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified format. Must not be used.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_FORMAT_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Provided data is a set of model inputs.
     * </pre>
     *
     * <code>INSTANCES = 1;</code>
     */
    public static final int INSTANCES_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Provided data is a set of embeddings.
     * </pre>
     *
     * <code>EMBEDDINGS = 2;</code>
     */
    public static final int EMBEDDINGS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataFormat forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_FORMAT_UNSPECIFIED;
        case 1:
          return INSTANCES;
        case 2:
          return EMBEDDINGS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataFormat>() {
          public DataFormat findValueByNumber(int number) {
            return DataFormat.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExamplesOverride.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DataFormat[] VALUES = values();

    public static DataFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat)
  }

  public static final int NEIGHBOR_COUNT_FIELD_NUMBER = 1;
  private int neighborCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of neighbors to return.
   * </pre>
   *
   * <code>int32 neighbor_count = 1;</code>
   *
   * @return The neighborCount.
   */
  @java.lang.Override
  public int getNeighborCount() {
    return neighborCount_;
  }

  public static final int CROWDING_COUNT_FIELD_NUMBER = 2;
  private int crowdingCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of neighbors to return that have the same crowding tag.
   * </pre>
   *
   * <code>int32 crowding_count = 2;</code>
   *
   * @return The crowdingCount.
   */
  @java.lang.Override
  public int getCrowdingCount() {
    return crowdingCount_;
  }

  public static final int RESTRICTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace>
      restrictions_;

  /**
   *
   *
   * <pre>
   * Restrict the resulting nearest neighbors to respect these constraints.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace>
      getRestrictionsList() {
    return restrictions_;
  }

  /**
   *
   *
   * <pre>
   * Restrict the resulting nearest neighbors to respect these constraints.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder>
      getRestrictionsOrBuilderList() {
    return restrictions_;
  }

  /**
   *
   *
   * <pre>
   * Restrict the resulting nearest neighbors to respect these constraints.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
   * </code>
   */
  @java.lang.Override
  public int getRestrictionsCount() {
    return restrictions_.size();
  }

  /**
   *
   *
   * <pre>
   * Restrict the resulting nearest neighbors to respect these constraints.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace getRestrictions(
      int index) {
    return restrictions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Restrict the resulting nearest neighbors to respect these constraints.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder
      getRestrictionsOrBuilder(int index) {
    return restrictions_.get(index);
  }

  public static final int RETURN_EMBEDDINGS_FIELD_NUMBER = 4;
  private boolean returnEmbeddings_ = false;

  /**
   *
   *
   * <pre>
   * If true, return the embeddings instead of neighbors.
   * </pre>
   *
   * <code>bool return_embeddings = 4;</code>
   *
   * @return The returnEmbeddings.
   */
  @java.lang.Override
  public boolean getReturnEmbeddings() {
    return returnEmbeddings_;
  }

  public static final int DATA_FORMAT_FIELD_NUMBER = 5;
  private int dataFormat_ = 0;

  /**
   *
   *
   * <pre>
   * The format of the data being provided with each call.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
   *
   * @return The enum numeric value on the wire for dataFormat.
   */
  @java.lang.Override
  public int getDataFormatValue() {
    return dataFormat_;
  }

  /**
   *
   *
   * <pre>
   * The format of the data being provided with each call.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
   *
   * @return The dataFormat.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat getDataFormat() {
    com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat result =
        com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat.forNumber(dataFormat_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (neighborCount_ != 0) {
      output.writeInt32(1, neighborCount_);
    }
    if (crowdingCount_ != 0) {
      output.writeInt32(2, crowdingCount_);
    }
    for (int i = 0; i < restrictions_.size(); i++) {
      output.writeMessage(3, restrictions_.get(i));
    }
    if (returnEmbeddings_ != false) {
      output.writeBool(4, returnEmbeddings_);
    }
    if (dataFormat_
        != com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat.DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, dataFormat_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (neighborCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, neighborCount_);
    }
    if (crowdingCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, crowdingCount_);
    }
    for (int i = 0; i < restrictions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, restrictions_.get(i));
    }
    if (returnEmbeddings_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, returnEmbeddings_);
    }
    if (dataFormat_
        != com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat.DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, dataFormat_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ExamplesOverride)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ExamplesOverride other =
        (com.google.cloud.aiplatform.v1beta1.ExamplesOverride) obj;

    if (getNeighborCount() != other.getNeighborCount()) return false;
    if (getCrowdingCount() != other.getCrowdingCount()) return false;
    if (!getRestrictionsList().equals(other.getRestrictionsList())) return false;
    if (getReturnEmbeddings() != other.getReturnEmbeddings()) return false;
    if (dataFormat_ != other.dataFormat_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NEIGHBOR_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNeighborCount();
    hash = (37 * hash) + CROWDING_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCrowdingCount();
    if (getRestrictionsCount() > 0) {
      hash = (37 * hash) + RESTRICTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRestrictionsList().hashCode();
    }
    hash = (37 * hash) + RETURN_EMBEDDINGS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnEmbeddings());
    hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + dataFormat_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.ExamplesOverride prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Overrides for example-based explanations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExamplesOverride}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ExamplesOverride)
      com.google.cloud.aiplatform.v1beta1.ExamplesOverrideOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExamplesOverride_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExamplesOverride_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ExamplesOverride.class,
              com.google.cloud.aiplatform.v1beta1.ExamplesOverride.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ExamplesOverride.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      neighborCount_ = 0;
      crowdingCount_ = 0;
      if (restrictionsBuilder_ == null) {
        restrictions_ = java.util.Collections.emptyList();
      } else {
        restrictions_ = null;
        restrictionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      returnEmbeddings_ = false;
      dataFormat_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExamplesOverride_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesOverride getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ExamplesOverride.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesOverride build() {
      com.google.cloud.aiplatform.v1beta1.ExamplesOverride result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesOverride buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ExamplesOverride result =
          new com.google.cloud.aiplatform.v1beta1.ExamplesOverride(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ExamplesOverride result) {
      if (restrictionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          restrictions_ = java.util.Collections.unmodifiableList(restrictions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.restrictions_ = restrictions_;
      } else {
        result.restrictions_ = restrictionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ExamplesOverride result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.neighborCount_ = neighborCount_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.crowdingCount_ = crowdingCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.returnEmbeddings_ = returnEmbeddings_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dataFormat_ = dataFormat_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ExamplesOverride) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ExamplesOverride) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ExamplesOverride other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ExamplesOverride.getDefaultInstance())
        return this;
      if (other.getNeighborCount() != 0) {
        setNeighborCount(other.getNeighborCount());
      }
      if (other.getCrowdingCount() != 0) {
        setCrowdingCount(other.getCrowdingCount());
      }
      if (restrictionsBuilder_ == null) {
        if (!other.restrictions_.isEmpty()) {
          if (restrictions_.isEmpty()) {
            restrictions_ = other.restrictions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRestrictionsIsMutable();
            restrictions_.addAll(other.restrictions_);
          }
          onChanged();
        }
      } else {
        if (!other.restrictions_.isEmpty()) {
          if (restrictionsBuilder_.isEmpty()) {
            restrictionsBuilder_.dispose();
            restrictionsBuilder_ = null;
            restrictions_ = other.restrictions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            restrictionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRestrictionsFieldBuilder()
                    : null;
          } else {
            restrictionsBuilder_.addAllMessages(other.restrictions_);
          }
        }
      }
      if (other.getReturnEmbeddings() != false) {
        setReturnEmbeddings(other.getReturnEmbeddings());
      }
      if (other.dataFormat_ != 0) {
        setDataFormatValue(other.getDataFormatValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                neighborCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                crowdingCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.parser(),
                        extensionRegistry);
                if (restrictionsBuilder_ == null) {
                  ensureRestrictionsIsMutable();
                  restrictions_.add(m);
                } else {
                  restrictionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                returnEmbeddings_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                dataFormat_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int neighborCount_;

    /**
     *
     *
     * <pre>
     * The number of neighbors to return.
     * </pre>
     *
     * <code>int32 neighbor_count = 1;</code>
     *
     * @return The neighborCount.
     */
    @java.lang.Override
    public int getNeighborCount() {
      return neighborCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of neighbors to return.
     * </pre>
     *
     * <code>int32 neighbor_count = 1;</code>
     *
     * @param value The neighborCount to set.
     * @return This builder for chaining.
     */
    public Builder setNeighborCount(int value) {

      neighborCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of neighbors to return.
     * </pre>
     *
     * <code>int32 neighbor_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNeighborCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      neighborCount_ = 0;
      onChanged();
      return this;
    }

    private int crowdingCount_;

    /**
     *
     *
     * <pre>
     * The number of neighbors to return that have the same crowding tag.
     * </pre>
     *
     * <code>int32 crowding_count = 2;</code>
     *
     * @return The crowdingCount.
     */
    @java.lang.Override
    public int getCrowdingCount() {
      return crowdingCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of neighbors to return that have the same crowding tag.
     * </pre>
     *
     * <code>int32 crowding_count = 2;</code>
     *
     * @param value The crowdingCount to set.
     * @return This builder for chaining.
     */
    public Builder setCrowdingCount(int value) {

      crowdingCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of neighbors to return that have the same crowding tag.
     * </pre>
     *
     * <code>int32 crowding_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCrowdingCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      crowdingCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace>
        restrictions_ = java.util.Collections.emptyList();

    private void ensureRestrictionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        restrictions_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace>(restrictions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace,
            com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder,
            com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder>
        restrictionsBuilder_;

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace>
        getRestrictionsList() {
      if (restrictionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(restrictions_);
      } else {
        return restrictionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public int getRestrictionsCount() {
      if (restrictionsBuilder_ == null) {
        return restrictions_.size();
      } else {
        return restrictionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace getRestrictions(
        int index) {
      if (restrictionsBuilder_ == null) {
        return restrictions_.get(index);
      } else {
        return restrictionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder setRestrictions(
        int index, com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace value) {
      if (restrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRestrictionsIsMutable();
        restrictions_.set(index, value);
        onChanged();
      } else {
        restrictionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder setRestrictions(
        int index,
        com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder builderForValue) {
      if (restrictionsBuilder_ == null) {
        ensureRestrictionsIsMutable();
        restrictions_.set(index, builderForValue.build());
        onChanged();
      } else {
        restrictionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder addRestrictions(
        com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace value) {
      if (restrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRestrictionsIsMutable();
        restrictions_.add(value);
        onChanged();
      } else {
        restrictionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder addRestrictions(
        int index, com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace value) {
      if (restrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRestrictionsIsMutable();
        restrictions_.add(index, value);
        onChanged();
      } else {
        restrictionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder addRestrictions(
        com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder builderForValue) {
      if (restrictionsBuilder_ == null) {
        ensureRestrictionsIsMutable();
        restrictions_.add(builderForValue.build());
        onChanged();
      } else {
        restrictionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder addRestrictions(
        int index,
        com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder builderForValue) {
      if (restrictionsBuilder_ == null) {
        ensureRestrictionsIsMutable();
        restrictions_.add(index, builderForValue.build());
        onChanged();
      } else {
        restrictionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder addAllRestrictions(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace>
            values) {
      if (restrictionsBuilder_ == null) {
        ensureRestrictionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, restrictions_);
        onChanged();
      } else {
        restrictionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder clearRestrictions() {
      if (restrictionsBuilder_ == null) {
        restrictions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        restrictionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public Builder removeRestrictions(int index) {
      if (restrictionsBuilder_ == null) {
        ensureRestrictionsIsMutable();
        restrictions_.remove(index);
        onChanged();
      } else {
        restrictionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder
        getRestrictionsBuilder(int index) {
      return getRestrictionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder
        getRestrictionsOrBuilder(int index) {
      if (restrictionsBuilder_ == null) {
        return restrictions_.get(index);
      } else {
        return restrictionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder>
        getRestrictionsOrBuilderList() {
      if (restrictionsBuilder_ != null) {
        return restrictionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(restrictions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder
        addRestrictionsBuilder() {
      return getRestrictionsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder
        addRestrictionsBuilder(int index) {
      return getRestrictionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Restrict the resulting nearest neighbors to respect these constraints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace restrictions = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder>
        getRestrictionsBuilderList() {
      return getRestrictionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace,
            com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder,
            com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder>
        getRestrictionsFieldBuilder() {
      if (restrictionsBuilder_ == null) {
        restrictionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace,
                com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespace.Builder,
                com.google.cloud.aiplatform.v1beta1.ExamplesRestrictionsNamespaceOrBuilder>(
                restrictions_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        restrictions_ = null;
      }
      return restrictionsBuilder_;
    }

    private boolean returnEmbeddings_;

    /**
     *
     *
     * <pre>
     * If true, return the embeddings instead of neighbors.
     * </pre>
     *
     * <code>bool return_embeddings = 4;</code>
     *
     * @return The returnEmbeddings.
     */
    @java.lang.Override
    public boolean getReturnEmbeddings() {
      return returnEmbeddings_;
    }

    /**
     *
     *
     * <pre>
     * If true, return the embeddings instead of neighbors.
     * </pre>
     *
     * <code>bool return_embeddings = 4;</code>
     *
     * @param value The returnEmbeddings to set.
     * @return This builder for chaining.
     */
    public Builder setReturnEmbeddings(boolean value) {

      returnEmbeddings_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, return the embeddings instead of neighbors.
     * </pre>
     *
     * <code>bool return_embeddings = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnEmbeddings() {
      bitField0_ = (bitField0_ & ~0x00000008);
      returnEmbeddings_ = false;
      onChanged();
      return this;
    }

    private int dataFormat_ = 0;

    /**
     *
     *
     * <pre>
     * The format of the data being provided with each call.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
     *
     * @return The enum numeric value on the wire for dataFormat.
     */
    @java.lang.Override
    public int getDataFormatValue() {
      return dataFormat_;
    }

    /**
     *
     *
     * <pre>
     * The format of the data being provided with each call.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
     *
     * @param value The enum numeric value on the wire for dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormatValue(int value) {
      dataFormat_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The format of the data being provided with each call.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
     *
     * @return The dataFormat.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat getDataFormat() {
      com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat result =
          com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat.forNumber(dataFormat_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The format of the data being provided with each call.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
     *
     * @param value The dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormat(
        com.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      dataFormat_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The format of the data being provided with each call.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExamplesOverride.DataFormat data_format = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataFormat() {
      bitField0_ = (bitField0_ & ~0x00000010);
      dataFormat_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ExamplesOverride)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ExamplesOverride)
  private static final com.google.cloud.aiplatform.v1beta1.ExamplesOverride DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ExamplesOverride();
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesOverride getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExamplesOverride> PARSER =
      new com.google.protobuf.AbstractParser<ExamplesOverride>() {
        @java.lang.Override
        public ExamplesOverride parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExamplesOverride> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExamplesOverride> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExamplesOverride getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
