/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/evaluation_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for EvaluationService.EvaluateDataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest}
 */
public final class EvaluateDatasetRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest)
    EvaluateDatasetRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EvaluateDatasetRequest.newBuilder() to construct.
  private EvaluateDatasetRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluateDatasetRequest() {
    location_ = "";
    metrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluateDatasetRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_EvaluateDatasetRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_EvaluateDatasetRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.class,
            com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.Builder.class);
  }

  private int bitField0_;
  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to evaluate the dataset.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to evaluate the dataset.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset_;

  /**
   *
   *
   * <pre>
   * Required. The dataset used for evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the dataset field is set.
   */
  @java.lang.Override
  public boolean hasDataset() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The dataset used for evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationDataset getDataset() {
    return dataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
        : dataset_;
  }

  /**
   *
   *
   * <pre>
   * Required. The dataset used for evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder getDatasetOrBuilder() {
    return dataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
        : dataset_;
  }

  public static final int METRICS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> metrics_;

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> getMetricsList() {
    return metrics_;
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Metric getMetrics(int index) {
    return metrics_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MetricOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.OutputConfig outputConfig_;

  /**
   *
   *
   * <pre>
   * Required. Config for evaluation output.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Config for evaluation output.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  /**
   *
   *
   * <pre>
   * Required. Config for evaluation output.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  public static final int AUTORATER_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.AutoraterConfig autoraterConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Autorater config used for evaluation. Currently only publisher
   * Gemini models are supported. Format:
   * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoraterConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutoraterConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Autorater config used for evaluation. Currently only publisher
   * Gemini models are supported. Format:
   * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoraterConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoraterConfig getAutoraterConfig() {
    return autoraterConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
        : autoraterConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Autorater config used for evaluation. Currently only publisher
   * Gemini models are supported. Format:
   * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder
      getAutoraterConfigOrBuilder() {
    return autoraterConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
        : autoraterConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getDataset());
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(3, metrics_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getOutputConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getAutoraterConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDataset());
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metrics_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOutputConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAutoraterConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest other =
        (com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (hasDataset() != other.hasDataset()) return false;
    if (hasDataset()) {
      if (!getDataset().equals(other.getDataset())) return false;
    }
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasAutoraterConfig() != other.hasAutoraterConfig()) return false;
    if (hasAutoraterConfig()) {
      if (!getAutoraterConfig().equals(other.getAutoraterConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    if (hasDataset()) {
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
    }
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasAutoraterConfig()) {
      hash = (37 * hash) + AUTORATER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutoraterConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for EvaluationService.EvaluateDataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest)
      com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluateDatasetRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluateDatasetRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.class,
              com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDatasetFieldBuilder();
        getMetricsFieldBuilder();
        getOutputConfigFieldBuilder();
        getAutoraterConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = "";
      dataset_ = null;
      if (datasetBuilder_ != null) {
        datasetBuilder_.dispose();
        datasetBuilder_ = null;
      }
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      autoraterConfig_ = null;
      if (autoraterConfigBuilder_ != null) {
        autoraterConfigBuilder_.dispose();
        autoraterConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluateDatasetRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest build() {
      com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest result =
          new com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest result) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = location_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataset_ = datasetBuilder_ == null ? dataset_ : datasetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.autoraterConfig_ =
            autoraterConfigBuilder_ == null ? autoraterConfig_ : autoraterConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDataset()) {
        mergeDataset(other.getDataset());
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasAutoraterConfig()) {
        mergeAutoraterConfig(other.getAutoraterConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.Metric m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Metric.parser(), extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAutoraterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the dataset.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the dataset.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the dataset.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the dataset.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the dataset.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset,
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder,
            com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder>
        datasetBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the dataset field is set.
     */
    public boolean hasDataset() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dataset.
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationDataset getDataset() {
      if (datasetBuilder_ == null) {
        return dataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
            : dataset_;
      } else {
        return datasetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDataset(com.google.cloud.aiplatform.v1beta1.EvaluationDataset value) {
      if (datasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
      } else {
        datasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDataset(
        com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder builderForValue) {
      if (datasetBuilder_ == null) {
        dataset_ = builderForValue.build();
      } else {
        datasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDataset(com.google.cloud.aiplatform.v1beta1.EvaluationDataset value) {
      if (datasetBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dataset_ != null
            && dataset_
                != com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()) {
          getDatasetBuilder().mergeFrom(value);
        } else {
          dataset_ = value;
        }
      } else {
        datasetBuilder_.mergeFrom(value);
      }
      if (dataset_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDataset() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dataset_ = null;
      if (datasetBuilder_ != null) {
        datasetBuilder_.dispose();
        datasetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder getDatasetBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDatasetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder getDatasetOrBuilder() {
      if (datasetBuilder_ != null) {
        return datasetBuilder_.getMessageOrBuilder();
      } else {
        return dataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
            : dataset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset used for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset,
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder,
            com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder>
        getDatasetFieldBuilder() {
      if (datasetBuilder_ == null) {
        datasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EvaluationDataset,
                com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder,
                com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder>(
                getDataset(), getParentForChildren(), isClean());
        dataset_ = null;
      }
      return datasetBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        metrics_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Metric>(metrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Metric,
            com.google.cloud.aiplatform.v1beta1.Metric.Builder,
            com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(int index, com.google.cloud.aiplatform.v1beta1.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1beta1.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(int index, com.google.cloud.aiplatform.v1beta1.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1beta1.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Metric> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MetricOrBuilder getMetricsOrBuilder(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Metric.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Metric.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Metric,
            com.google.cloud.aiplatform.v1beta1.Metric.Builder,
            com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Metric,
                com.google.cloud.aiplatform.v1beta1.Metric.Builder,
                com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder>
        outputConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(com.google.cloud.aiplatform.v1beta1.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(com.google.cloud.aiplatform.v1beta1.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder getOutputConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.OutputConfig,
                com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.AutoraterConfig autoraterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder>
        autoraterConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoraterConfig field is set.
     */
    public boolean hasAutoraterConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoraterConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.AutoraterConfig getAutoraterConfig() {
      if (autoraterConfigBuilder_ == null) {
        return autoraterConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
            : autoraterConfig_;
      } else {
        return autoraterConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoraterConfig(com.google.cloud.aiplatform.v1beta1.AutoraterConfig value) {
      if (autoraterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoraterConfig_ = value;
      } else {
        autoraterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoraterConfig(
        com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder builderForValue) {
      if (autoraterConfigBuilder_ == null) {
        autoraterConfig_ = builderForValue.build();
      } else {
        autoraterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoraterConfig(com.google.cloud.aiplatform.v1beta1.AutoraterConfig value) {
      if (autoraterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && autoraterConfig_ != null
            && autoraterConfig_
                != com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()) {
          getAutoraterConfigBuilder().mergeFrom(value);
        } else {
          autoraterConfig_ = value;
        }
      } else {
        autoraterConfigBuilder_.mergeFrom(value);
      }
      if (autoraterConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoraterConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      autoraterConfig_ = null;
      if (autoraterConfigBuilder_ != null) {
        autoraterConfigBuilder_.dispose();
        autoraterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder getAutoraterConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAutoraterConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder
        getAutoraterConfigOrBuilder() {
      if (autoraterConfigBuilder_ != null) {
        return autoraterConfigBuilder_.getMessageOrBuilder();
      } else {
        return autoraterConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
            : autoraterConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config used for evaluation. Currently only publisher
     * Gemini models are supported. Format:
     * `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder>
        getAutoraterConfigFieldBuilder() {
      if (autoraterConfigBuilder_ == null) {
        autoraterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AutoraterConfig,
                com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder>(
                getAutoraterConfig(), getParentForChildren(), isClean());
        autoraterConfig_ = null;
      }
      return autoraterConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest)
  private static final com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluateDatasetRequest> PARSER =
      new com.google.protobuf.AbstractParser<EvaluateDatasetRequest>() {
        @java.lang.Override
        public EvaluateDatasetRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EvaluateDatasetRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluateDatasetRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluateDatasetRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
