/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_garden_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelGardenService.DeployPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest}
 */
@java.lang.Deprecated
public final class DeployPublisherModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest)
    DeployPublisherModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DeployPublisherModelRequest.newBuilder() to construct.
  private DeployPublisherModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployPublisherModelRequest() {
    model_ = "";
    destination_ = "";
    endpointDisplayName_ = "";
    modelDisplayName_ = "";
    huggingFaceAccessToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployPublisherModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_DeployPublisherModelRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_DeployPublisherModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.class,
            com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.Builder.class);
  }

  private int bitField0_;
  public static final int MODEL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";

  /**
   *
   *
   * <pre>
   * Required. The model to deploy.
   * Format:
   * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
   * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
   * 4. Custom model zip file like `https://example.com/a.zip`.
   * </pre>
   *
   * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The model to deploy.
   * Format:
   * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
   * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
   * 4. Custom model zip file like `https://example.com/a.zip`.
   * </pre>
   *
   * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destination_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to deploy the model in.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public java.lang.String getDestination() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destination_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to deploy the model in.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for destination.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationBytes() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destination_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENDPOINT_DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpointDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The user-specified display name of the endpoint. If not set, a
   * default name will be used.
   * </pre>
   *
   * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The endpointDisplayName.
   */
  @java.lang.Override
  public java.lang.String getEndpointDisplayName() {
    java.lang.Object ref = endpointDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpointDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The user-specified display name of the endpoint. If not set, a
   * default name will be used.
   * </pre>
   *
   * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for endpointDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointDisplayNameBytes() {
    java.lang.Object ref = endpointDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpointDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.DedicatedResources dedicatedResources_;

  /**
   *
   *
   * <pre>
   * Optional. The dedicated resources to use for the endpoint. If not set, the
   * default resources will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dedicatedResources field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedResources() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The dedicated resources to use for the endpoint. If not set, the
   * default resources will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dedicatedResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
    return dedicatedResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
        : dedicatedResources_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The dedicated resources to use for the endpoint. If not set, the
   * default resources will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
      getDedicatedResourcesOrBuilder() {
    return dedicatedResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
        : dedicatedResources_;
  }

  public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The user-specified display name of the uploaded model. If not
   * set, a default name will be used.
   * </pre>
   *
   * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelDisplayName.
   */
  @java.lang.Override
  public java.lang.String getModelDisplayName() {
    java.lang.Object ref = modelDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The user-specified display name of the uploaded model. If not
   * set, a default name will be used.
   * </pre>
   *
   * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelDisplayNameBytes() {
    java.lang.Object ref = modelDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HUGGING_FACE_ACCESS_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object huggingFaceAccessToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The Hugging Face read access token used to access the model
   * artifacts of gated models.
   * </pre>
   *
   * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The huggingFaceAccessToken.
   */
  @java.lang.Override
  public java.lang.String getHuggingFaceAccessToken() {
    java.lang.Object ref = huggingFaceAccessToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      huggingFaceAccessToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The Hugging Face read access token used to access the model
   * artifacts of gated models.
   * </pre>
   *
   * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for huggingFaceAccessToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHuggingFaceAccessTokenBytes() {
    java.lang.Object ref = huggingFaceAccessToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      huggingFaceAccessToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCEPT_EULA_FIELD_NUMBER = 7;
  private boolean acceptEula_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether the user accepts the End User License Agreement (EULA)
   * for the model.
   * </pre>
   *
   * <code>bool accept_eula = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The acceptEula.
   */
  @java.lang.Override
  public boolean getAcceptEula() {
    return acceptEula_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, endpointDisplayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getDedicatedResources());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(huggingFaceAccessToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, huggingFaceAccessToken_);
    }
    if (acceptEula_ != false) {
      output.writeBool(7, acceptEula_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, endpointDisplayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDedicatedResources());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(huggingFaceAccessToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, huggingFaceAccessToken_);
    }
    if (acceptEula_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, acceptEula_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest other =
        (com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest) obj;

    if (!getModel().equals(other.getModel())) return false;
    if (!getDestination().equals(other.getDestination())) return false;
    if (!getEndpointDisplayName().equals(other.getEndpointDisplayName())) return false;
    if (hasDedicatedResources() != other.hasDedicatedResources()) return false;
    if (hasDedicatedResources()) {
      if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
    }
    if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
    if (!getHuggingFaceAccessToken().equals(other.getHuggingFaceAccessToken())) return false;
    if (getAcceptEula() != other.getAcceptEula()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
    hash = (53 * hash) + getDestination().hashCode();
    hash = (37 * hash) + ENDPOINT_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getEndpointDisplayName().hashCode();
    if (hasDedicatedResources()) {
      hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getDedicatedResources().hashCode();
    }
    hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getModelDisplayName().hashCode();
    hash = (37 * hash) + HUGGING_FACE_ACCESS_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getHuggingFaceAccessToken().hashCode();
    hash = (37 * hash) + ACCEPT_EULA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAcceptEula());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelGardenService.DeployPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest)
      com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployPublisherModelRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployPublisherModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.class,
              com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDedicatedResourcesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      model_ = "";
      destination_ = "";
      endpointDisplayName_ = "";
      dedicatedResources_ = null;
      if (dedicatedResourcesBuilder_ != null) {
        dedicatedResourcesBuilder_.dispose();
        dedicatedResourcesBuilder_ = null;
      }
      modelDisplayName_ = "";
      huggingFaceAccessToken_ = "";
      acceptEula_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployPublisherModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest build() {
      com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest result =
          new com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destination_ = destination_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endpointDisplayName_ = endpointDisplayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dedicatedResources_ =
            dedicatedResourcesBuilder_ == null
                ? dedicatedResources_
                : dedicatedResourcesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modelDisplayName_ = modelDisplayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.huggingFaceAccessToken_ = huggingFaceAccessToken_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.acceptEula_ = acceptEula_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.getDefaultInstance())
        return this;
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDestination().isEmpty()) {
        destination_ = other.destination_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEndpointDisplayName().isEmpty()) {
        endpointDisplayName_ = other.endpointDisplayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDedicatedResources()) {
        mergeDedicatedResources(other.getDedicatedResources());
      }
      if (!other.getModelDisplayName().isEmpty()) {
        modelDisplayName_ = other.modelDisplayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getHuggingFaceAccessToken().isEmpty()) {
        huggingFaceAccessToken_ = other.huggingFaceAccessToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getAcceptEula() != false) {
        setAcceptEula(other.getAcceptEula());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                destination_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                endpointDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getDedicatedResourcesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                modelDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                huggingFaceAccessToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                acceptEula_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object model_ = "";

    /**
     *
     *
     * <pre>
     * Required. The model to deploy.
     * Format:
     * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
     * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
     * 4. Custom model zip file like `https://example.com/a.zip`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The model to deploy.
     * Format:
     * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
     * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
     * 4. Custom model zip file like `https://example.com/a.zip`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The model to deploy.
     * Format:
     * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
     * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
     * 4. Custom model zip file like `https://example.com/a.zip`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The model to deploy.
     * Format:
     * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
     * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
     * 4. Custom model zip file like `https://example.com/a.zip`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The model to deploy.
     * Format:
     * 1. `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * 2. Hugging Face model ID like `google/gemma-2-2b-it`.
     * 3. Custom model Google Cloud Storage URI like `gs://bucket`.
     * 4. Custom model zip file like `https://example.com/a.zip`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object destination_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The destination.
     */
    public java.lang.String getDestination() {
      java.lang.Object ref = destination_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destination_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for destination.
     */
    public com.google.protobuf.ByteString getDestinationBytes() {
      java.lang.Object ref = destination_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestination(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destination_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestination() {
      destination_ = getDefaultInstance().getDestination();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destination_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object endpointDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The endpointDisplayName.
     */
    public java.lang.String getEndpointDisplayName() {
      java.lang.Object ref = endpointDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for endpointDisplayName.
     */
    public com.google.protobuf.ByteString getEndpointDisplayNameBytes() {
      java.lang.Object ref = endpointDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The endpointDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpointDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpointDisplayName() {
      endpointDisplayName_ = getDefaultInstance().getEndpointDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for endpointDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpointDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DedicatedResources dedicatedResources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DedicatedResources,
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
        dedicatedResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    public boolean hasDedicatedResources() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dedicatedResources.
     */
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      } else {
        return dedicatedResourcesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dedicatedResources_ = value;
      } else {
        dedicatedResourcesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder builderForValue) {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = builderForValue.build();
      } else {
        dedicatedResourcesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && dedicatedResources_ != null
            && dedicatedResources_
                != com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()) {
          getDedicatedResourcesBuilder().mergeFrom(value);
        } else {
          dedicatedResources_ = value;
        }
      } else {
        dedicatedResourcesBuilder_.mergeFrom(value);
      }
      if (dedicatedResources_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDedicatedResources() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dedicatedResources_ = null;
      if (dedicatedResourcesBuilder_ != null) {
        dedicatedResourcesBuilder_.dispose();
        dedicatedResourcesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder
        getDedicatedResourcesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDedicatedResourcesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      if (dedicatedResourcesBuilder_ != null) {
        return dedicatedResourcesBuilder_.getMessageOrBuilder();
      } else {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set, the
     * default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DedicatedResources,
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
        getDedicatedResourcesFieldBuilder() {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DedicatedResources,
                com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>(
                getDedicatedResources(), getParentForChildren(), isClean());
        dedicatedResources_ = null;
      }
      return dedicatedResourcesBuilder_;
    }

    private java.lang.Object modelDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelDisplayName.
     */
    public java.lang.String getModelDisplayName() {
      java.lang.Object ref = modelDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    public com.google.protobuf.ByteString getModelDisplayNameBytes() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The modelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setModelDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelDisplayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelDisplayName() {
      modelDisplayName_ = getDefaultInstance().getModelDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for modelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelDisplayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object huggingFaceAccessToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The huggingFaceAccessToken.
     */
    public java.lang.String getHuggingFaceAccessToken() {
      java.lang.Object ref = huggingFaceAccessToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        huggingFaceAccessToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for huggingFaceAccessToken.
     */
    public com.google.protobuf.ByteString getHuggingFaceAccessTokenBytes() {
      java.lang.Object ref = huggingFaceAccessToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        huggingFaceAccessToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The huggingFaceAccessToken to set.
     * @return This builder for chaining.
     */
    public Builder setHuggingFaceAccessToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      huggingFaceAccessToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHuggingFaceAccessToken() {
      huggingFaceAccessToken_ = getDefaultInstance().getHuggingFaceAccessToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for huggingFaceAccessToken to set.
     * @return This builder for chaining.
     */
    public Builder setHuggingFaceAccessTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      huggingFaceAccessToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean acceptEula_;

    /**
     *
     *
     * <pre>
     * Optional. Whether the user accepts the End User License Agreement (EULA)
     * for the model.
     * </pre>
     *
     * <code>bool accept_eula = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The acceptEula.
     */
    @java.lang.Override
    public boolean getAcceptEula() {
      return acceptEula_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether the user accepts the End User License Agreement (EULA)
     * for the model.
     * </pre>
     *
     * <code>bool accept_eula = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The acceptEula to set.
     * @return This builder for chaining.
     */
    public Builder setAcceptEula(boolean value) {

      acceptEula_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether the user accepts the End User License Agreement (EULA)
     * for the model.
     * </pre>
     *
     * <code>bool accept_eula = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAcceptEula() {
      bitField0_ = (bitField0_ & ~0x00000040);
      acceptEula_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest)
  private static final com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployPublisherModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<DeployPublisherModelRequest>() {
        @java.lang.Override
        public DeployPublisherModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployPublisherModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployPublisherModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
