/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_stats.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Filter for searching ModelMonitoringStats.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter}
 */
public final class SearchModelMonitoringStatsFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter)
    SearchModelMonitoringStatsFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchModelMonitoringStatsFilter.newBuilder() to construct.
  private SearchModelMonitoringStatsFilter(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchModelMonitoringStatsFilter() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchModelMonitoringStatsFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.class,
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.Builder.class);
  }

  public interface TabularStatsFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If not specified, will return all the stats_names.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The statsName.
     */
    java.lang.String getStatsName();
    /**
     *
     *
     * <pre>
     * If not specified, will return all the stats_names.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The bytes for statsName.
     */
    com.google.protobuf.ByteString getStatsNameBytes();

    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The objectiveType.
     */
    java.lang.String getObjectiveType();
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The bytes for objectiveType.
     */
    com.google.protobuf.ByteString getObjectiveTypeBytes();

    /**
     *
     *
     * <pre>
     * From a particular monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 3;</code>
     *
     * @return The modelMonitoringJob.
     */
    java.lang.String getModelMonitoringJob();
    /**
     *
     *
     * <pre>
     * From a particular monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 3;</code>
     *
     * @return The bytes for modelMonitoringJob.
     */
    com.google.protobuf.ByteString getModelMonitoringJobBytes();

    /**
     *
     *
     * <pre>
     * From a particular monitoring schedule.
     * </pre>
     *
     * <code>string model_monitoring_schedule = 4;</code>
     *
     * @return The modelMonitoringSchedule.
     */
    java.lang.String getModelMonitoringSchedule();
    /**
     *
     *
     * <pre>
     * From a particular monitoring schedule.
     * </pre>
     *
     * <code>string model_monitoring_schedule = 4;</code>
     *
     * @return The bytes for modelMonitoringSchedule.
     */
    com.google.protobuf.ByteString getModelMonitoringScheduleBytes();

    /**
     *
     *
     * <pre>
     * Specify the algorithm type used for distance calculation, eg:
     * jensen_shannon_divergence, l_infinity.
     * </pre>
     *
     * <code>string algorithm = 5;</code>
     *
     * @return The algorithm.
     */
    java.lang.String getAlgorithm();
    /**
     *
     *
     * <pre>
     * Specify the algorithm type used for distance calculation, eg:
     * jensen_shannon_divergence, l_infinity.
     * </pre>
     *
     * <code>string algorithm = 5;</code>
     *
     * @return The bytes for algorithm.
     */
    com.google.protobuf.ByteString getAlgorithmBytes();
  }
  /**
   *
   *
   * <pre>
   * Tabular statistics filter.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter}
   */
  public static final class TabularStatsFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter)
      TabularStatsFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TabularStatsFilter.newBuilder() to construct.
    private TabularStatsFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TabularStatsFilter() {
      statsName_ = "";
      objectiveType_ = "";
      modelMonitoringJob_ = "";
      modelMonitoringSchedule_ = "";
      algorithm_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TabularStatsFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_TabularStatsFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_TabularStatsFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                  .TabularStatsFilter.class,
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                  .TabularStatsFilter.Builder.class);
    }

    public static final int STATS_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object statsName_ = "";
    /**
     *
     *
     * <pre>
     * If not specified, will return all the stats_names.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The statsName.
     */
    @java.lang.Override
    public java.lang.String getStatsName() {
      java.lang.Object ref = statsName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statsName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If not specified, will return all the stats_names.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The bytes for statsName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStatsNameBytes() {
      java.lang.Object ref = statsName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statsName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OBJECTIVE_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object objectiveType_ = "";
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The objectiveType.
     */
    @java.lang.Override
    public java.lang.String getObjectiveType() {
      java.lang.Object ref = objectiveType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectiveType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The bytes for objectiveType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getObjectiveTypeBytes() {
      java.lang.Object ref = objectiveType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectiveType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_MONITORING_JOB_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelMonitoringJob_ = "";
    /**
     *
     *
     * <pre>
     * From a particular monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 3;</code>
     *
     * @return The modelMonitoringJob.
     */
    @java.lang.Override
    public java.lang.String getModelMonitoringJob() {
      java.lang.Object ref = modelMonitoringJob_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelMonitoringJob_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * From a particular monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 3;</code>
     *
     * @return The bytes for modelMonitoringJob.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
      java.lang.Object ref = modelMonitoringJob_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_MONITORING_SCHEDULE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelMonitoringSchedule_ = "";
    /**
     *
     *
     * <pre>
     * From a particular monitoring schedule.
     * </pre>
     *
     * <code>string model_monitoring_schedule = 4;</code>
     *
     * @return The modelMonitoringSchedule.
     */
    @java.lang.Override
    public java.lang.String getModelMonitoringSchedule() {
      java.lang.Object ref = modelMonitoringSchedule_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelMonitoringSchedule_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * From a particular monitoring schedule.
     * </pre>
     *
     * <code>string model_monitoring_schedule = 4;</code>
     *
     * @return The bytes for modelMonitoringSchedule.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelMonitoringScheduleBytes() {
      java.lang.Object ref = modelMonitoringSchedule_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelMonitoringSchedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALGORITHM_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object algorithm_ = "";
    /**
     *
     *
     * <pre>
     * Specify the algorithm type used for distance calculation, eg:
     * jensen_shannon_divergence, l_infinity.
     * </pre>
     *
     * <code>string algorithm = 5;</code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public java.lang.String getAlgorithm() {
      java.lang.Object ref = algorithm_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        algorithm_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the algorithm type used for distance calculation, eg:
     * jensen_shannon_divergence, l_infinity.
     * </pre>
     *
     * <code>string algorithm = 5;</code>
     *
     * @return The bytes for algorithm.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAlgorithmBytes() {
      java.lang.Object ref = algorithm_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        algorithm_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, statsName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, objectiveType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelMonitoringJob_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringSchedule_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modelMonitoringSchedule_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(algorithm_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, algorithm_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, statsName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, objectiveType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelMonitoringJob_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringSchedule_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modelMonitoringSchedule_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(algorithm_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, algorithm_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
              .TabularStatsFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
          other =
              (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                      .TabularStatsFilter)
                  obj;

      if (!getStatsName().equals(other.getStatsName())) return false;
      if (!getObjectiveType().equals(other.getObjectiveType())) return false;
      if (!getModelMonitoringJob().equals(other.getModelMonitoringJob())) return false;
      if (!getModelMonitoringSchedule().equals(other.getModelMonitoringSchedule())) return false;
      if (!getAlgorithm().equals(other.getAlgorithm())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATS_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getStatsName().hashCode();
      hash = (37 * hash) + OBJECTIVE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getObjectiveType().hashCode();
      hash = (37 * hash) + MODEL_MONITORING_JOB_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringJob().hashCode();
      hash = (37 * hash) + MODEL_MONITORING_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringSchedule().hashCode();
      hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + getAlgorithm().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter)
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_TabularStatsFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_TabularStatsFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilter.class,
                com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilter.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        statsName_ = "";
        objectiveType_ = "";
        modelMonitoringJob_ = "";
        modelMonitoringSchedule_ = "";
        algorithm_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_TabularStatsFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
          build() {
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
            result =
                new com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.statsName_ = statsName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.objectiveType_ = objectiveType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.modelMonitoringJob_ = modelMonitoringJob_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.modelMonitoringSchedule_ = modelMonitoringSchedule_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.algorithm_ = algorithm_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                .TabularStatsFilter) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                      .TabularStatsFilter)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                .TabularStatsFilter.getDefaultInstance()) return this;
        if (!other.getStatsName().isEmpty()) {
          statsName_ = other.statsName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getObjectiveType().isEmpty()) {
          objectiveType_ = other.objectiveType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getModelMonitoringJob().isEmpty()) {
          modelMonitoringJob_ = other.modelMonitoringJob_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getModelMonitoringSchedule().isEmpty()) {
          modelMonitoringSchedule_ = other.modelMonitoringSchedule_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getAlgorithm().isEmpty()) {
          algorithm_ = other.algorithm_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  statsName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  objectiveType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  modelMonitoringJob_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  modelMonitoringSchedule_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  algorithm_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object statsName_ = "";
      /**
       *
       *
       * <pre>
       * If not specified, will return all the stats_names.
       * </pre>
       *
       * <code>string stats_name = 1;</code>
       *
       * @return The statsName.
       */
      public java.lang.String getStatsName() {
        java.lang.Object ref = statsName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          statsName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If not specified, will return all the stats_names.
       * </pre>
       *
       * <code>string stats_name = 1;</code>
       *
       * @return The bytes for statsName.
       */
      public com.google.protobuf.ByteString getStatsNameBytes() {
        java.lang.Object ref = statsName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          statsName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If not specified, will return all the stats_names.
       * </pre>
       *
       * <code>string stats_name = 1;</code>
       *
       * @param value The statsName to set.
       * @return This builder for chaining.
       */
      public Builder setStatsName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        statsName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If not specified, will return all the stats_names.
       * </pre>
       *
       * <code>string stats_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStatsName() {
        statsName_ = getDefaultInstance().getStatsName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If not specified, will return all the stats_names.
       * </pre>
       *
       * <code>string stats_name = 1;</code>
       *
       * @param value The bytes for statsName to set.
       * @return This builder for chaining.
       */
      public Builder setStatsNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        statsName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object objectiveType_ = "";
      /**
       *
       *
       * <pre>
       * One of the supported monitoring objectives:
       * `raw-feature-drift`
       * `prediction-output-drift`
       * `feature-attribution`
       * </pre>
       *
       * <code>string objective_type = 2;</code>
       *
       * @return The objectiveType.
       */
      public java.lang.String getObjectiveType() {
        java.lang.Object ref = objectiveType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          objectiveType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * One of the supported monitoring objectives:
       * `raw-feature-drift`
       * `prediction-output-drift`
       * `feature-attribution`
       * </pre>
       *
       * <code>string objective_type = 2;</code>
       *
       * @return The bytes for objectiveType.
       */
      public com.google.protobuf.ByteString getObjectiveTypeBytes() {
        java.lang.Object ref = objectiveType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          objectiveType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * One of the supported monitoring objectives:
       * `raw-feature-drift`
       * `prediction-output-drift`
       * `feature-attribution`
       * </pre>
       *
       * <code>string objective_type = 2;</code>
       *
       * @param value The objectiveType to set.
       * @return This builder for chaining.
       */
      public Builder setObjectiveType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectiveType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * One of the supported monitoring objectives:
       * `raw-feature-drift`
       * `prediction-output-drift`
       * `feature-attribution`
       * </pre>
       *
       * <code>string objective_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObjectiveType() {
        objectiveType_ = getDefaultInstance().getObjectiveType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * One of the supported monitoring objectives:
       * `raw-feature-drift`
       * `prediction-output-drift`
       * `feature-attribution`
       * </pre>
       *
       * <code>string objective_type = 2;</code>
       *
       * @param value The bytes for objectiveType to set.
       * @return This builder for chaining.
       */
      public Builder setObjectiveTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        objectiveType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object modelMonitoringJob_ = "";
      /**
       *
       *
       * <pre>
       * From a particular monitoring job.
       * </pre>
       *
       * <code>string model_monitoring_job = 3;</code>
       *
       * @return The modelMonitoringJob.
       */
      public java.lang.String getModelMonitoringJob() {
        java.lang.Object ref = modelMonitoringJob_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelMonitoringJob_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring job.
       * </pre>
       *
       * <code>string model_monitoring_job = 3;</code>
       *
       * @return The bytes for modelMonitoringJob.
       */
      public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
        java.lang.Object ref = modelMonitoringJob_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelMonitoringJob_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring job.
       * </pre>
       *
       * <code>string model_monitoring_job = 3;</code>
       *
       * @param value The modelMonitoringJob to set.
       * @return This builder for chaining.
       */
      public Builder setModelMonitoringJob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringJob_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring job.
       * </pre>
       *
       * <code>string model_monitoring_job = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelMonitoringJob() {
        modelMonitoringJob_ = getDefaultInstance().getModelMonitoringJob();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring job.
       * </pre>
       *
       * <code>string model_monitoring_job = 3;</code>
       *
       * @param value The bytes for modelMonitoringJob to set.
       * @return This builder for chaining.
       */
      public Builder setModelMonitoringJobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelMonitoringJob_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object modelMonitoringSchedule_ = "";
      /**
       *
       *
       * <pre>
       * From a particular monitoring schedule.
       * </pre>
       *
       * <code>string model_monitoring_schedule = 4;</code>
       *
       * @return The modelMonitoringSchedule.
       */
      public java.lang.String getModelMonitoringSchedule() {
        java.lang.Object ref = modelMonitoringSchedule_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelMonitoringSchedule_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring schedule.
       * </pre>
       *
       * <code>string model_monitoring_schedule = 4;</code>
       *
       * @return The bytes for modelMonitoringSchedule.
       */
      public com.google.protobuf.ByteString getModelMonitoringScheduleBytes() {
        java.lang.Object ref = modelMonitoringSchedule_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelMonitoringSchedule_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring schedule.
       * </pre>
       *
       * <code>string model_monitoring_schedule = 4;</code>
       *
       * @param value The modelMonitoringSchedule to set.
       * @return This builder for chaining.
       */
      public Builder setModelMonitoringSchedule(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringSchedule_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring schedule.
       * </pre>
       *
       * <code>string model_monitoring_schedule = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelMonitoringSchedule() {
        modelMonitoringSchedule_ = getDefaultInstance().getModelMonitoringSchedule();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * From a particular monitoring schedule.
       * </pre>
       *
       * <code>string model_monitoring_schedule = 4;</code>
       *
       * @param value The bytes for modelMonitoringSchedule to set.
       * @return This builder for chaining.
       */
      public Builder setModelMonitoringScheduleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelMonitoringSchedule_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object algorithm_ = "";
      /**
       *
       *
       * <pre>
       * Specify the algorithm type used for distance calculation, eg:
       * jensen_shannon_divergence, l_infinity.
       * </pre>
       *
       * <code>string algorithm = 5;</code>
       *
       * @return The algorithm.
       */
      public java.lang.String getAlgorithm() {
        java.lang.Object ref = algorithm_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          algorithm_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the algorithm type used for distance calculation, eg:
       * jensen_shannon_divergence, l_infinity.
       * </pre>
       *
       * <code>string algorithm = 5;</code>
       *
       * @return The bytes for algorithm.
       */
      public com.google.protobuf.ByteString getAlgorithmBytes() {
        java.lang.Object ref = algorithm_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          algorithm_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the algorithm type used for distance calculation, eg:
       * jensen_shannon_divergence, l_infinity.
       * </pre>
       *
       * <code>string algorithm = 5;</code>
       *
       * @param value The algorithm to set.
       * @return This builder for chaining.
       */
      public Builder setAlgorithm(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        algorithm_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the algorithm type used for distance calculation, eg:
       * jensen_shannon_divergence, l_infinity.
       * </pre>
       *
       * <code>string algorithm = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlgorithm() {
        algorithm_ = getDefaultInstance().getAlgorithm();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the algorithm type used for distance calculation, eg:
       * jensen_shannon_divergence, l_infinity.
       * </pre>
       *
       * <code>string algorithm = 5;</code>
       *
       * @param value The bytes for algorithm to set.
       * @return This builder for chaining.
       */
      public Builder setAlgorithmBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        algorithm_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter)
    private static final com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
              .TabularStatsFilter();
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TabularStatsFilter> PARSER =
        new com.google.protobuf.AbstractParser<TabularStatsFilter>() {
          @java.lang.Override
          public TabularStatsFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TabularStatsFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TabularStatsFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int filterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TABULAR_STATS_FILTER(1),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 1:
          return TABULAR_STATS_FILTER;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  public static final int TABULAR_STATS_FILTER_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Tabular statistics filter.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
   * </code>
   *
   * @return Whether the tabularStatsFilter field is set.
   */
  @java.lang.Override
  public boolean hasTabularStatsFilter() {
    return filterCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Tabular statistics filter.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
   * </code>
   *
   * @return The tabularStatsFilter.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
      getTabularStatsFilter() {
    if (filterCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
              .TabularStatsFilter)
          filter_;
    }
    return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tabular statistics filter.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
          .TabularStatsFilterOrBuilder
      getTabularStatsFilterOrBuilder() {
    if (filterCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
              .TabularStatsFilter)
          filter_;
    }
    return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (filterCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter)
              filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (filterCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                      .TabularStatsFilter)
                  filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter other =
        (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter) obj;

    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 1:
        if (!getTabularStatsFilter().equals(other.getTabularStatsFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (filterCase_) {
      case 1:
        hash = (37 * hash) + TABULAR_STATS_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getTabularStatsFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Filter for searching ModelMonitoringStats.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter)
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.class,
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tabularStatsFilterBuilder_ != null) {
        tabularStatsFilterBuilder_.clear();
      }
      filterCase_ = 0;
      filter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringStatsFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter build() {
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter result =
          new com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
      if (filterCase_ == 1 && tabularStatsFilterBuilder_ != null) {
        result.filter_ = tabularStatsFilterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
              .getDefaultInstance()) return this;
      switch (other.getFilterCase()) {
        case TABULAR_STATS_FILTER:
          {
            mergeTabularStatsFilter(other.getTabularStatsFilter());
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getTabularStatsFilterFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter,
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
                .Builder,
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                .TabularStatsFilterOrBuilder>
        tabularStatsFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     *
     * @return Whether the tabularStatsFilter field is set.
     */
    @java.lang.Override
    public boolean hasTabularStatsFilter() {
      return filterCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     *
     * @return The tabularStatsFilter.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
        getTabularStatsFilter() {
      if (tabularStatsFilterBuilder_ == null) {
        if (filterCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                  .TabularStatsFilter)
              filter_;
        }
        return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter.getDefaultInstance();
      } else {
        if (filterCase_ == 1) {
          return tabularStatsFilterBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    public Builder setTabularStatsFilter(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
            value) {
      if (tabularStatsFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        tabularStatsFilterBuilder_.setMessage(value);
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    public Builder setTabularStatsFilter(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
                .Builder
            builderForValue) {
      if (tabularStatsFilterBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        tabularStatsFilterBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    public Builder mergeTabularStatsFilter(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
            value) {
      if (tabularStatsFilterBuilder_ == null) {
        if (filterCase_ == 1
            && filter_
                != com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilter.getDefaultInstance()) {
          filter_ =
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                  .TabularStatsFilter.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                              .TabularStatsFilter)
                          filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 1) {
          tabularStatsFilterBuilder_.mergeFrom(value);
        } else {
          tabularStatsFilterBuilder_.setMessage(value);
        }
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    public Builder clearTabularStatsFilter() {
      if (tabularStatsFilterBuilder_ == null) {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
        }
        tabularStatsFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
            .Builder
        getTabularStatsFilterBuilder() {
      return getTabularStatsFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilterOrBuilder
        getTabularStatsFilterOrBuilder() {
      if ((filterCase_ == 1) && (tabularStatsFilterBuilder_ != null)) {
        return tabularStatsFilterBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                  .TabularStatsFilter)
              filter_;
        }
        return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
            .TabularStatsFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tabular statistics filter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter tabular_stats_filter = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter,
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
                .Builder,
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                .TabularStatsFilterOrBuilder>
        getTabularStatsFilterFieldBuilder() {
      if (tabularStatsFilterBuilder_ == null) {
        if (!(filterCase_ == 1)) {
          filter_ =
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                  .TabularStatsFilter.getDefaultInstance();
        }
        tabularStatsFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilter,
                com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilter.Builder,
                com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                    .TabularStatsFilterOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
                        .TabularStatsFilter)
                    filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 1;
      onChanged();
      return tabularStatsFilterBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter)
  private static final com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter();
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchModelMonitoringStatsFilter> PARSER =
      new com.google.protobuf.AbstractParser<SearchModelMonitoringStatsFilter>() {
        @java.lang.Override
        public SearchModelMonitoringStatsFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchModelMonitoringStatsFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchModelMonitoringStatsFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
