/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_spec.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Monitoring objectives spec.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec}
 */
public final class ModelMonitoringObjectiveSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec)
    ModelMonitoringObjectiveSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringObjectiveSpec.newBuilder() to construct.
  private ModelMonitoringObjectiveSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringObjectiveSpec() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringObjectiveSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.Builder.class);
  }

  public interface DataDriftSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return A list containing the features.
     */
    java.util.List<java.lang.String> getFeaturesList();
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return The count of features.
     */
    int getFeaturesCount();
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The features at the given index.
     */
    java.lang.String getFeatures(int index);
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the features at the given index.
     */
    com.google.protobuf.ByteString getFeaturesBytes(int index);

    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * l_infinity
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string categorical_metric_type = 2;</code>
     *
     * @return The categoricalMetricType.
     */
    java.lang.String getCategoricalMetricType();
    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * l_infinity
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string categorical_metric_type = 2;</code>
     *
     * @return The bytes for categoricalMetricType.
     */
    com.google.protobuf.ByteString getCategoricalMetricTypeBytes();

    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string numeric_metric_type = 3;</code>
     *
     * @return The numericMetricType.
     */
    java.lang.String getNumericMetricType();
    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string numeric_metric_type = 3;</code>
     *
     * @return The bytes for numericMetricType.
     */
    com.google.protobuf.ByteString getNumericMetricTypeBytes();

    /**
     *
     *
     * <pre>
     * Default alert condition for all the categorical features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
     * </code>
     *
     * @return Whether the defaultCategoricalAlertCondition field is set.
     */
    boolean hasDefaultCategoricalAlertCondition();
    /**
     *
     *
     * <pre>
     * Default alert condition for all the categorical features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
     * </code>
     *
     * @return The defaultCategoricalAlertCondition.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getDefaultCategoricalAlertCondition();
    /**
     *
     *
     * <pre>
     * Default alert condition for all the categorical features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getDefaultCategoricalAlertConditionOrBuilder();

    /**
     *
     *
     * <pre>
     * Default alert condition for all the numeric features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
     * </code>
     *
     * @return Whether the defaultNumericAlertCondition field is set.
     */
    boolean hasDefaultNumericAlertCondition();
    /**
     *
     *
     * <pre>
     * Default alert condition for all the numeric features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
     * </code>
     *
     * @return The defaultNumericAlertCondition.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getDefaultNumericAlertCondition();
    /**
     *
     *
     * <pre>
     * Default alert condition for all the numeric features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getDefaultNumericAlertConditionOrBuilder();

    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    int getFeatureAlertConditionsCount();
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    boolean containsFeatureAlertConditions(java.lang.String key);
    /** Use {@link #getFeatureAlertConditionsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditions();
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditionsMap();
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition defaultValue);
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Data drift monitoring spec.
   * Data drift measures the distribution distance between the current dataset
   * and a baseline dataset. A typical use case is to detect data drift between
   * the recent production serving dataset and the training dataset, or to
   * compare the recent production dataset with a dataset from a previous
   * period.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec}
   */
  public static final class DataDriftSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)
      DataDriftSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DataDriftSpec.newBuilder() to construct.
    private DataDriftSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataDriftSpec() {
      features_ = com.google.protobuf.LazyStringArrayList.emptyList();
      categoricalMetricType_ = "";
      numericMetricType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataDriftSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_DataDriftSpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetFeatureAlertConditions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_DataDriftSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.Builder
                  .class);
    }

    private int bitField0_;
    public static final int FEATURES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList features_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return A list containing the features.
     */
    public com.google.protobuf.ProtocolStringList getFeaturesList() {
      return features_;
    }
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return The count of features.
     */
    public int getFeaturesCount() {
      return features_.size();
    }
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The features at the given index.
     */
    public java.lang.String getFeatures(int index) {
      return features_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Feature names / Prediction output names interested in monitoring.
     * These should be a subset of the input feature names or prediction output
     * names specified in the monitoring schema.
     * If the field is not specified all features / prediction outputs outlied
     * in the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the features at the given index.
     */
    public com.google.protobuf.ByteString getFeaturesBytes(int index) {
      return features_.getByteString(index);
    }

    public static final int CATEGORICAL_METRIC_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object categoricalMetricType_ = "";
    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * l_infinity
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string categorical_metric_type = 2;</code>
     *
     * @return The categoricalMetricType.
     */
    @java.lang.Override
    public java.lang.String getCategoricalMetricType() {
      java.lang.Object ref = categoricalMetricType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoricalMetricType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * l_infinity
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string categorical_metric_type = 2;</code>
     *
     * @return The bytes for categoricalMetricType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCategoricalMetricTypeBytes() {
      java.lang.Object ref = categoricalMetricType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        categoricalMetricType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NUMERIC_METRIC_TYPE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object numericMetricType_ = "";
    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string numeric_metric_type = 3;</code>
     *
     * @return The numericMetricType.
     */
    @java.lang.Override
    public java.lang.String getNumericMetricType() {
      java.lang.Object ref = numericMetricType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        numericMetricType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Supported metrics type:
     *  * jensen_shannon_divergence
     * </pre>
     *
     * <code>string numeric_metric_type = 3;</code>
     *
     * @return The bytes for numericMetricType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNumericMetricTypeBytes() {
      java.lang.Object ref = numericMetricType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        numericMetricType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEFAULT_CATEGORICAL_ALERT_CONDITION_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        defaultCategoricalAlertCondition_;
    /**
     *
     *
     * <pre>
     * Default alert condition for all the categorical features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
     * </code>
     *
     * @return Whether the defaultCategoricalAlertCondition field is set.
     */
    @java.lang.Override
    public boolean hasDefaultCategoricalAlertCondition() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default alert condition for all the categorical features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
     * </code>
     *
     * @return The defaultCategoricalAlertCondition.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getDefaultCategoricalAlertCondition() {
      return defaultCategoricalAlertCondition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : defaultCategoricalAlertCondition_;
    }
    /**
     *
     *
     * <pre>
     * Default alert condition for all the categorical features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getDefaultCategoricalAlertConditionOrBuilder() {
      return defaultCategoricalAlertCondition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : defaultCategoricalAlertCondition_;
    }

    public static final int DEFAULT_NUMERIC_ALERT_CONDITION_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        defaultNumericAlertCondition_;
    /**
     *
     *
     * <pre>
     * Default alert condition for all the numeric features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
     * </code>
     *
     * @return Whether the defaultNumericAlertCondition field is set.
     */
    @java.lang.Override
    public boolean hasDefaultNumericAlertCondition() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default alert condition for all the numeric features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
     * </code>
     *
     * @return The defaultNumericAlertCondition.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getDefaultNumericAlertCondition() {
      return defaultNumericAlertCondition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : defaultNumericAlertCondition_;
    }
    /**
     *
     *
     * <pre>
     * Default alert condition for all the numeric features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getDefaultNumericAlertConditionOrBuilder() {
      return defaultNumericAlertCondition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : defaultNumericAlertCondition_;
    }

    public static final int FEATURE_ALERT_CONDITIONS_FIELD_NUMBER = 6;

    private static final class FeatureAlertConditionsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
                              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_DataDriftSpec_FeatureAlertConditionsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                              .getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        featureAlertConditions_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        internalGetFeatureAlertConditions() {
      if (featureAlertConditions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FeatureAlertConditionsDefaultEntryHolder.defaultEntry);
      }
      return featureAlertConditions_;
    }

    public int getFeatureAlertConditionsCount() {
      return internalGetFeatureAlertConditions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    @java.lang.Override
    public boolean containsFeatureAlertConditions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFeatureAlertConditions().getMap().containsKey(key);
    }
    /** Use {@link #getFeatureAlertConditionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditions() {
      return getFeatureAlertConditionsMap();
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditionsMap() {
      return internalGetFeatureAlertConditions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          map = internalGetFeatureAlertConditions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          map = internalGetFeatureAlertConditions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < features_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, features_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(categoricalMetricType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, categoricalMetricType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(numericMetricType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, numericMetricType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getDefaultCategoricalAlertCondition());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(5, getDefaultNumericAlertCondition());
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetFeatureAlertConditions(),
          FeatureAlertConditionsDefaultEntryHolder.defaultEntry,
          6);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < features_.size(); i++) {
          dataSize += computeStringSizeNoTag(features_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFeaturesList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(categoricalMetricType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, categoricalMetricType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(numericMetricType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, numericMetricType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getDefaultCategoricalAlertCondition());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, getDefaultNumericAlertCondition());
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          entry : internalGetFeatureAlertConditions().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
            featureAlertConditions__ =
                FeatureAlertConditionsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(6, featureAlertConditions__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec) obj;

      if (!getFeaturesList().equals(other.getFeaturesList())) return false;
      if (!getCategoricalMetricType().equals(other.getCategoricalMetricType())) return false;
      if (!getNumericMetricType().equals(other.getNumericMetricType())) return false;
      if (hasDefaultCategoricalAlertCondition() != other.hasDefaultCategoricalAlertCondition())
        return false;
      if (hasDefaultCategoricalAlertCondition()) {
        if (!getDefaultCategoricalAlertCondition()
            .equals(other.getDefaultCategoricalAlertCondition())) return false;
      }
      if (hasDefaultNumericAlertCondition() != other.hasDefaultNumericAlertCondition())
        return false;
      if (hasDefaultNumericAlertCondition()) {
        if (!getDefaultNumericAlertCondition().equals(other.getDefaultNumericAlertCondition()))
          return false;
      }
      if (!internalGetFeatureAlertConditions().equals(other.internalGetFeatureAlertConditions()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFeaturesCount() > 0) {
        hash = (37 * hash) + FEATURES_FIELD_NUMBER;
        hash = (53 * hash) + getFeaturesList().hashCode();
      }
      hash = (37 * hash) + CATEGORICAL_METRIC_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getCategoricalMetricType().hashCode();
      hash = (37 * hash) + NUMERIC_METRIC_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getNumericMetricType().hashCode();
      if (hasDefaultCategoricalAlertCondition()) {
        hash = (37 * hash) + DEFAULT_CATEGORICAL_ALERT_CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultCategoricalAlertCondition().hashCode();
      }
      if (hasDefaultNumericAlertCondition()) {
        hash = (37 * hash) + DEFAULT_NUMERIC_ALERT_CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultNumericAlertCondition().hashCode();
      }
      if (!internalGetFeatureAlertConditions().getMap().isEmpty()) {
        hash = (37 * hash) + FEATURE_ALERT_CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetFeatureAlertConditions().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Data drift monitoring spec.
     * Data drift measures the distribution distance between the current dataset
     * and a baseline dataset. A typical use case is to detect data drift between
     * the recent production serving dataset and the training dataset, or to
     * compare the recent production dataset with a dataset from a previous
     * period.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_DataDriftSpec_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetFeatureAlertConditions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetMutableFeatureAlertConditions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_DataDriftSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDefaultCategoricalAlertConditionFieldBuilder();
          getDefaultNumericAlertConditionFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        features_ = com.google.protobuf.LazyStringArrayList.emptyList();
        categoricalMetricType_ = "";
        numericMetricType_ = "";
        defaultCategoricalAlertCondition_ = null;
        if (defaultCategoricalAlertConditionBuilder_ != null) {
          defaultCategoricalAlertConditionBuilder_.dispose();
          defaultCategoricalAlertConditionBuilder_ = null;
        }
        defaultNumericAlertCondition_ = null;
        if (defaultNumericAlertConditionBuilder_ != null) {
          defaultNumericAlertConditionBuilder_.dispose();
          defaultNumericAlertConditionBuilder_ = null;
        }
        internalGetMutableFeatureAlertConditions().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_DataDriftSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          features_.makeImmutable();
          result.features_ = features_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.categoricalMetricType_ = categoricalMetricType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.numericMetricType_ = numericMetricType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.defaultCategoricalAlertCondition_ =
              defaultCategoricalAlertConditionBuilder_ == null
                  ? defaultCategoricalAlertCondition_
                  : defaultCategoricalAlertConditionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.defaultNumericAlertCondition_ =
              defaultNumericAlertConditionBuilder_ == null
                  ? defaultNumericAlertCondition_
                  : defaultNumericAlertConditionBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.featureAlertConditions_ =
              internalGetFeatureAlertConditions()
                  .build(FeatureAlertConditionsDefaultEntryHolder.defaultEntry);
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                .getDefaultInstance()) return this;
        if (!other.features_.isEmpty()) {
          if (features_.isEmpty()) {
            features_ = other.features_;
            bitField0_ |= 0x00000001;
          } else {
            ensureFeaturesIsMutable();
            features_.addAll(other.features_);
          }
          onChanged();
        }
        if (!other.getCategoricalMetricType().isEmpty()) {
          categoricalMetricType_ = other.categoricalMetricType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getNumericMetricType().isEmpty()) {
          numericMetricType_ = other.numericMetricType_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasDefaultCategoricalAlertCondition()) {
          mergeDefaultCategoricalAlertCondition(other.getDefaultCategoricalAlertCondition());
        }
        if (other.hasDefaultNumericAlertCondition()) {
          mergeDefaultNumericAlertCondition(other.getDefaultNumericAlertCondition());
        }
        internalGetMutableFeatureAlertConditions()
            .mergeFrom(other.internalGetFeatureAlertConditions());
        bitField0_ |= 0x00000020;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureFeaturesIsMutable();
                  features_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  categoricalMetricType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  numericMetricType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getDefaultCategoricalAlertConditionFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getDefaultNumericAlertConditionFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
                      featureAlertConditions__ =
                          input.readMessage(
                              FeatureAlertConditionsDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableFeatureAlertConditions()
                      .ensureBuilderMap()
                      .put(featureAlertConditions__.getKey(), featureAlertConditions__.getValue());
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList features_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureFeaturesIsMutable() {
        if (!features_.isModifiable()) {
          features_ = new com.google.protobuf.LazyStringArrayList(features_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @return A list containing the features.
       */
      public com.google.protobuf.ProtocolStringList getFeaturesList() {
        features_.makeImmutable();
        return features_;
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @return The count of features.
       */
      public int getFeaturesCount() {
        return features_.size();
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The features at the given index.
       */
      public java.lang.String getFeatures(int index) {
        return features_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the features at the given index.
       */
      public com.google.protobuf.ByteString getFeaturesBytes(int index) {
        return features_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The features to set.
       * @return This builder for chaining.
       */
      public Builder setFeatures(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param value The features to add.
       * @return This builder for chaining.
       */
      public Builder addFeatures(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param values The features to add.
       * @return This builder for chaining.
       */
      public Builder addAllFeatures(java.lang.Iterable<java.lang.String> values) {
        ensureFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFeatures() {
        features_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names / Prediction output names interested in monitoring.
       * These should be a subset of the input feature names or prediction output
       * names specified in the monitoring schema.
       * If the field is not specified all features / prediction outputs outlied
       * in the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param value The bytes of the features to add.
       * @return This builder for chaining.
       */
      public Builder addFeaturesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureFeaturesIsMutable();
        features_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object categoricalMetricType_ = "";
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * l_infinity
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string categorical_metric_type = 2;</code>
       *
       * @return The categoricalMetricType.
       */
      public java.lang.String getCategoricalMetricType() {
        java.lang.Object ref = categoricalMetricType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          categoricalMetricType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * l_infinity
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string categorical_metric_type = 2;</code>
       *
       * @return The bytes for categoricalMetricType.
       */
      public com.google.protobuf.ByteString getCategoricalMetricTypeBytes() {
        java.lang.Object ref = categoricalMetricType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          categoricalMetricType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * l_infinity
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string categorical_metric_type = 2;</code>
       *
       * @param value The categoricalMetricType to set.
       * @return This builder for chaining.
       */
      public Builder setCategoricalMetricType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        categoricalMetricType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * l_infinity
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string categorical_metric_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCategoricalMetricType() {
        categoricalMetricType_ = getDefaultInstance().getCategoricalMetricType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * l_infinity
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string categorical_metric_type = 2;</code>
       *
       * @param value The bytes for categoricalMetricType to set.
       * @return This builder for chaining.
       */
      public Builder setCategoricalMetricTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        categoricalMetricType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object numericMetricType_ = "";
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string numeric_metric_type = 3;</code>
       *
       * @return The numericMetricType.
       */
      public java.lang.String getNumericMetricType() {
        java.lang.Object ref = numericMetricType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          numericMetricType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string numeric_metric_type = 3;</code>
       *
       * @return The bytes for numericMetricType.
       */
      public com.google.protobuf.ByteString getNumericMetricTypeBytes() {
        java.lang.Object ref = numericMetricType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          numericMetricType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string numeric_metric_type = 3;</code>
       *
       * @param value The numericMetricType to set.
       * @return This builder for chaining.
       */
      public Builder setNumericMetricType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        numericMetricType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string numeric_metric_type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNumericMetricType() {
        numericMetricType_ = getDefaultInstance().getNumericMetricType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supported metrics type:
       *  * jensen_shannon_divergence
       * </pre>
       *
       * <code>string numeric_metric_type = 3;</code>
       *
       * @param value The bytes for numericMetricType to set.
       * @return This builder for chaining.
       */
      public Builder setNumericMetricTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        numericMetricType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          defaultCategoricalAlertCondition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          defaultCategoricalAlertConditionBuilder_;
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       *
       * @return Whether the defaultCategoricalAlertCondition field is set.
       */
      public boolean hasDefaultCategoricalAlertCondition() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       *
       * @return The defaultCategoricalAlertCondition.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getDefaultCategoricalAlertCondition() {
        if (defaultCategoricalAlertConditionBuilder_ == null) {
          return defaultCategoricalAlertCondition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : defaultCategoricalAlertCondition_;
        } else {
          return defaultCategoricalAlertConditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      public Builder setDefaultCategoricalAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (defaultCategoricalAlertConditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultCategoricalAlertCondition_ = value;
        } else {
          defaultCategoricalAlertConditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      public Builder setDefaultCategoricalAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
              builderForValue) {
        if (defaultCategoricalAlertConditionBuilder_ == null) {
          defaultCategoricalAlertCondition_ = builderForValue.build();
        } else {
          defaultCategoricalAlertConditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      public Builder mergeDefaultCategoricalAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (defaultCategoricalAlertConditionBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && defaultCategoricalAlertCondition_ != null
              && defaultCategoricalAlertCondition_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                      .getDefaultInstance()) {
            getDefaultCategoricalAlertConditionBuilder().mergeFrom(value);
          } else {
            defaultCategoricalAlertCondition_ = value;
          }
        } else {
          defaultCategoricalAlertConditionBuilder_.mergeFrom(value);
        }
        if (defaultCategoricalAlertCondition_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      public Builder clearDefaultCategoricalAlertCondition() {
        bitField0_ = (bitField0_ & ~0x00000008);
        defaultCategoricalAlertCondition_ = null;
        if (defaultCategoricalAlertConditionBuilder_ != null) {
          defaultCategoricalAlertConditionBuilder_.dispose();
          defaultCategoricalAlertConditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
          getDefaultCategoricalAlertConditionBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getDefaultCategoricalAlertConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
          getDefaultCategoricalAlertConditionOrBuilder() {
        if (defaultCategoricalAlertConditionBuilder_ != null) {
          return defaultCategoricalAlertConditionBuilder_.getMessageOrBuilder();
        } else {
          return defaultCategoricalAlertCondition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : defaultCategoricalAlertCondition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the categorical features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_categorical_alert_condition = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          getDefaultCategoricalAlertConditionFieldBuilder() {
        if (defaultCategoricalAlertConditionBuilder_ == null) {
          defaultCategoricalAlertConditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>(
                  getDefaultCategoricalAlertCondition(), getParentForChildren(), isClean());
          defaultCategoricalAlertCondition_ = null;
        }
        return defaultCategoricalAlertConditionBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          defaultNumericAlertCondition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          defaultNumericAlertConditionBuilder_;
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       *
       * @return Whether the defaultNumericAlertCondition field is set.
       */
      public boolean hasDefaultNumericAlertCondition() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       *
       * @return The defaultNumericAlertCondition.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getDefaultNumericAlertCondition() {
        if (defaultNumericAlertConditionBuilder_ == null) {
          return defaultNumericAlertCondition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : defaultNumericAlertCondition_;
        } else {
          return defaultNumericAlertConditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      public Builder setDefaultNumericAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (defaultNumericAlertConditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultNumericAlertCondition_ = value;
        } else {
          defaultNumericAlertConditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      public Builder setDefaultNumericAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
              builderForValue) {
        if (defaultNumericAlertConditionBuilder_ == null) {
          defaultNumericAlertCondition_ = builderForValue.build();
        } else {
          defaultNumericAlertConditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      public Builder mergeDefaultNumericAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (defaultNumericAlertConditionBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && defaultNumericAlertCondition_ != null
              && defaultNumericAlertCondition_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                      .getDefaultInstance()) {
            getDefaultNumericAlertConditionBuilder().mergeFrom(value);
          } else {
            defaultNumericAlertCondition_ = value;
          }
        } else {
          defaultNumericAlertConditionBuilder_.mergeFrom(value);
        }
        if (defaultNumericAlertCondition_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      public Builder clearDefaultNumericAlertCondition() {
        bitField0_ = (bitField0_ & ~0x00000010);
        defaultNumericAlertCondition_ = null;
        if (defaultNumericAlertConditionBuilder_ != null) {
          defaultNumericAlertConditionBuilder_.dispose();
          defaultNumericAlertConditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
          getDefaultNumericAlertConditionBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getDefaultNumericAlertConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
          getDefaultNumericAlertConditionOrBuilder() {
        if (defaultNumericAlertConditionBuilder_ != null) {
          return defaultNumericAlertConditionBuilder_.getMessageOrBuilder();
        } else {
          return defaultNumericAlertCondition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : defaultNumericAlertCondition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the numeric features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_numeric_alert_condition = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          getDefaultNumericAlertConditionFieldBuilder() {
        if (defaultNumericAlertConditionBuilder_ == null) {
          defaultNumericAlertConditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>(
                  getDefaultNumericAlertCondition(), getParentForChildren(), isClean());
          defaultNumericAlertCondition_ = null;
        }
        return defaultNumericAlertConditionBuilder_;
      }

      private static final class FeatureAlertConditionsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition> {
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition build(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder val) {
          if (val instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) val;
          }
          return ((com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder) val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
            defaultEntry() {
          return FeatureAlertConditionsDefaultEntryHolder.defaultEntry;
        }
      };

      private static final FeatureAlertConditionsConverter featureAlertConditionsConverter =
          new FeatureAlertConditionsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder>
          featureAlertConditions_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder>
          internalGetFeatureAlertConditions() {
        if (featureAlertConditions_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(featureAlertConditionsConverter);
        }
        return featureAlertConditions_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder>
          internalGetMutableFeatureAlertConditions() {
        if (featureAlertConditions_ == null) {
          featureAlertConditions_ =
              new com.google.protobuf.MapFieldBuilder<>(featureAlertConditionsConverter);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return featureAlertConditions_;
      }

      public int getFeatureAlertConditionsCount() {
        return internalGetFeatureAlertConditions().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      @java.lang.Override
      public boolean containsFeatureAlertConditions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetFeatureAlertConditions().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getFeatureAlertConditionsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          getFeatureAlertConditions() {
        return getFeatureAlertConditionsMap();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          getFeatureAlertConditionsMap() {
        return internalGetFeatureAlertConditions().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getFeatureAlertConditionsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
            map = internalGetMutableFeatureAlertConditions().ensureBuilderMap();
        return map.containsKey(key)
            ? featureAlertConditionsConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getFeatureAlertConditionsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
            map = internalGetMutableFeatureAlertConditions().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return featureAlertConditionsConverter.build(map.get(key));
      }

      public Builder clearFeatureAlertConditions() {
        bitField0_ = (bitField0_ & ~0x00000020);
        internalGetMutableFeatureAlertConditions().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      public Builder removeFeatureAlertConditions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableFeatureAlertConditions().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          getMutableFeatureAlertConditions() {
        bitField0_ |= 0x00000020;
        return internalGetMutableFeatureAlertConditions().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      public Builder putFeatureAlertConditions(
          java.lang.String key,
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableFeatureAlertConditions().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      public Builder putAllFeatureAlertConditions(
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
              values) {
        for (java.util.Map.Entry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableFeatureAlertConditions().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 6;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
          putFeatureAlertConditionsBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
            builderMap = internalGetMutableFeatureAlertConditions().ensureBuilderMap();
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder entry =
            builderMap.get(key);
        if (entry == null) {
          entry = com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) {
          entry =
              ((com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder) entry;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .DataDriftSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataDriftSpec> PARSER =
        new com.google.protobuf.AbstractParser<DataDriftSpec>() {
          @java.lang.Override
          public DataDriftSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataDriftSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataDriftSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FeatureAttributionSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return A list containing the features.
     */
    java.util.List<java.lang.String> getFeaturesList();
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return The count of features.
     */
    int getFeaturesCount();
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The features at the given index.
     */
    java.lang.String getFeatures(int index);
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the features at the given index.
     */
    com.google.protobuf.ByteString getFeaturesBytes(int index);

    /**
     *
     *
     * <pre>
     * Default alert condition for all the features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
     * </code>
     *
     * @return Whether the defaultAlertCondition field is set.
     */
    boolean hasDefaultAlertCondition();
    /**
     *
     *
     * <pre>
     * Default alert condition for all the features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
     * </code>
     *
     * @return The defaultAlertCondition.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition getDefaultAlertCondition();
    /**
     *
     *
     * <pre>
     * Default alert condition for all the features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getDefaultAlertConditionOrBuilder();

    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    int getFeatureAlertConditionsCount();
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    boolean containsFeatureAlertConditions(java.lang.String key);
    /** Use {@link #getFeatureAlertConditionsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditions();
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditionsMap();
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition defaultValue);
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The config of resources used by the Model Monitoring during the batch
     * explanation for non-AutoML models. If not set, `n1-standard-2` machine
     * type will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
     * </code>
     *
     * @return Whether the batchExplanationDedicatedResources field is set.
     */
    boolean hasBatchExplanationDedicatedResources();
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model Monitoring during the batch
     * explanation for non-AutoML models. If not set, `n1-standard-2` machine
     * type will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
     * </code>
     *
     * @return The batchExplanationDedicatedResources.
     */
    com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
        getBatchExplanationDedicatedResources();
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model Monitoring during the batch
     * explanation for non-AutoML models. If not set, `n1-standard-2` machine
     * type will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
        getBatchExplanationDedicatedResourcesOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Feature attribution monitoring spec.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec}
   */
  public static final class FeatureAttributionSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec)
      FeatureAttributionSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FeatureAttributionSpec.newBuilder() to construct.
    private FeatureAttributionSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FeatureAttributionSpec() {
      features_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FeatureAttributionSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_FeatureAttributionSpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetFeatureAlertConditions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_FeatureAttributionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec.Builder.class);
    }

    private int bitField0_;
    public static final int FEATURES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList features_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return A list containing the features.
     */
    public com.google.protobuf.ProtocolStringList getFeaturesList() {
      return features_;
    }
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @return The count of features.
     */
    public int getFeaturesCount() {
      return features_.size();
    }
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The features at the given index.
     */
    public java.lang.String getFeatures(int index) {
      return features_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Feature names interested in monitoring.
     * These should be a subset of the input feature names specified in the
     * monitoring schema. If the field is not specified all features outlied in
     * the monitoring schema will be used.
     * </pre>
     *
     * <code>repeated string features = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the features at the given index.
     */
    public com.google.protobuf.ByteString getFeaturesBytes(int index) {
      return features_.getByteString(index);
    }

    public static final int DEFAULT_ALERT_CONDITION_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        defaultAlertCondition_;
    /**
     *
     *
     * <pre>
     * Default alert condition for all the features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
     * </code>
     *
     * @return Whether the defaultAlertCondition field is set.
     */
    @java.lang.Override
    public boolean hasDefaultAlertCondition() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default alert condition for all the features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
     * </code>
     *
     * @return The defaultAlertCondition.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getDefaultAlertCondition() {
      return defaultAlertCondition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : defaultAlertCondition_;
    }
    /**
     *
     *
     * <pre>
     * Default alert condition for all the features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getDefaultAlertConditionOrBuilder() {
      return defaultAlertCondition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : defaultAlertCondition_;
    }

    public static final int FEATURE_ALERT_CONDITIONS_FIELD_NUMBER = 3;

    private static final class FeatureAlertConditionsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
                              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_FeatureAttributionSpec_FeatureAlertConditionsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                              .getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        featureAlertConditions_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        internalGetFeatureAlertConditions() {
      if (featureAlertConditions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FeatureAlertConditionsDefaultEntryHolder.defaultEntry);
      }
      return featureAlertConditions_;
    }

    public int getFeatureAlertConditionsCount() {
      return internalGetFeatureAlertConditions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    @java.lang.Override
    public boolean containsFeatureAlertConditions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFeatureAlertConditions().getMap().containsKey(key);
    }
    /** Use {@link #getFeatureAlertConditionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditions() {
      return getFeatureAlertConditionsMap();
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
        getFeatureAlertConditionsMap() {
      return internalGetFeatureAlertConditions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          map = internalGetFeatureAlertConditions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Per feature alert condition will override default alert condition.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
        getFeatureAlertConditionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          map = internalGetFeatureAlertConditions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int BATCH_EXPLANATION_DEDICATED_RESOURCES_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
        batchExplanationDedicatedResources_;
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model Monitoring during the batch
     * explanation for non-AutoML models. If not set, `n1-standard-2` machine
     * type will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
     * </code>
     *
     * @return Whether the batchExplanationDedicatedResources field is set.
     */
    @java.lang.Override
    public boolean hasBatchExplanationDedicatedResources() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model Monitoring during the batch
     * explanation for non-AutoML models. If not set, `n1-standard-2` machine
     * type will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
     * </code>
     *
     * @return The batchExplanationDedicatedResources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
        getBatchExplanationDedicatedResources() {
      return batchExplanationDedicatedResources_ == null
          ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
          : batchExplanationDedicatedResources_;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model Monitoring during the batch
     * explanation for non-AutoML models. If not set, `n1-standard-2` machine
     * type will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
        getBatchExplanationDedicatedResourcesOrBuilder() {
      return batchExplanationDedicatedResources_ == null
          ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
          : batchExplanationDedicatedResources_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < features_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, features_.getRaw(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getDefaultAlertCondition());
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetFeatureAlertConditions(),
          FeatureAlertConditionsDefaultEntryHolder.defaultEntry,
          3);
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getBatchExplanationDedicatedResources());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < features_.size(); i++) {
          dataSize += computeStringSizeNoTag(features_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFeaturesList().size();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDefaultAlertCondition());
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          entry : internalGetFeatureAlertConditions().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
            featureAlertConditions__ =
                FeatureAlertConditionsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, featureAlertConditions__);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getBatchExplanationDedicatedResources());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
              .FeatureAttributionSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
          other =
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .FeatureAttributionSpec)
                  obj;

      if (!getFeaturesList().equals(other.getFeaturesList())) return false;
      if (hasDefaultAlertCondition() != other.hasDefaultAlertCondition()) return false;
      if (hasDefaultAlertCondition()) {
        if (!getDefaultAlertCondition().equals(other.getDefaultAlertCondition())) return false;
      }
      if (!internalGetFeatureAlertConditions().equals(other.internalGetFeatureAlertConditions()))
        return false;
      if (hasBatchExplanationDedicatedResources() != other.hasBatchExplanationDedicatedResources())
        return false;
      if (hasBatchExplanationDedicatedResources()) {
        if (!getBatchExplanationDedicatedResources()
            .equals(other.getBatchExplanationDedicatedResources())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFeaturesCount() > 0) {
        hash = (37 * hash) + FEATURES_FIELD_NUMBER;
        hash = (53 * hash) + getFeaturesList().hashCode();
      }
      if (hasDefaultAlertCondition()) {
        hash = (37 * hash) + DEFAULT_ALERT_CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultAlertCondition().hashCode();
      }
      if (!internalGetFeatureAlertConditions().getMap().isEmpty()) {
        hash = (37 * hash) + FEATURE_ALERT_CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetFeatureAlertConditions().hashCode();
      }
      if (hasBatchExplanationDedicatedResources()) {
        hash = (37 * hash) + BATCH_EXPLANATION_DEDICATED_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getBatchExplanationDedicatedResources().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_FeatureAttributionSpec_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetFeatureAlertConditions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetMutableFeatureAlertConditions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_FeatureAttributionSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                    .FeatureAttributionSpec.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                    .FeatureAttributionSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDefaultAlertConditionFieldBuilder();
          getBatchExplanationDedicatedResourcesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        features_ = com.google.protobuf.LazyStringArrayList.emptyList();
        defaultAlertCondition_ = null;
        if (defaultAlertConditionBuilder_ != null) {
          defaultAlertConditionBuilder_.dispose();
          defaultAlertConditionBuilder_ = null;
        }
        internalGetMutableFeatureAlertConditions().clear();
        batchExplanationDedicatedResources_ = null;
        if (batchExplanationDedicatedResourcesBuilder_ != null) {
          batchExplanationDedicatedResourcesBuilder_.dispose();
          batchExplanationDedicatedResourcesBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_FeatureAttributionSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
            result =
                new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                    .FeatureAttributionSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          features_.makeImmutable();
          result.features_ = features_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.defaultAlertCondition_ =
              defaultAlertConditionBuilder_ == null
                  ? defaultAlertCondition_
                  : defaultAlertConditionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.featureAlertConditions_ =
              internalGetFeatureAlertConditions()
                  .build(FeatureAlertConditionsDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.batchExplanationDedicatedResources_ =
              batchExplanationDedicatedResourcesBuilder_ == null
                  ? batchExplanationDedicatedResources_
                  : batchExplanationDedicatedResourcesBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                .FeatureAttributionSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .FeatureAttributionSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                .FeatureAttributionSpec.getDefaultInstance()) return this;
        if (!other.features_.isEmpty()) {
          if (features_.isEmpty()) {
            features_ = other.features_;
            bitField0_ |= 0x00000001;
          } else {
            ensureFeaturesIsMutable();
            features_.addAll(other.features_);
          }
          onChanged();
        }
        if (other.hasDefaultAlertCondition()) {
          mergeDefaultAlertCondition(other.getDefaultAlertCondition());
        }
        internalGetMutableFeatureAlertConditions()
            .mergeFrom(other.internalGetFeatureAlertConditions());
        bitField0_ |= 0x00000004;
        if (other.hasBatchExplanationDedicatedResources()) {
          mergeBatchExplanationDedicatedResources(other.getBatchExplanationDedicatedResources());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureFeaturesIsMutable();
                  features_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getDefaultAlertConditionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
                      featureAlertConditions__ =
                          input.readMessage(
                              FeatureAlertConditionsDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableFeatureAlertConditions()
                      .ensureBuilderMap()
                      .put(featureAlertConditions__.getKey(), featureAlertConditions__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getBatchExplanationDedicatedResourcesFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList features_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureFeaturesIsMutable() {
        if (!features_.isModifiable()) {
          features_ = new com.google.protobuf.LazyStringArrayList(features_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @return A list containing the features.
       */
      public com.google.protobuf.ProtocolStringList getFeaturesList() {
        features_.makeImmutable();
        return features_;
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @return The count of features.
       */
      public int getFeaturesCount() {
        return features_.size();
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The features at the given index.
       */
      public java.lang.String getFeatures(int index) {
        return features_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the features at the given index.
       */
      public com.google.protobuf.ByteString getFeaturesBytes(int index) {
        return features_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The features to set.
       * @return This builder for chaining.
       */
      public Builder setFeatures(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param value The features to add.
       * @return This builder for chaining.
       */
      public Builder addFeatures(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param values The features to add.
       * @return This builder for chaining.
       */
      public Builder addAllFeatures(java.lang.Iterable<java.lang.String> values) {
        ensureFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFeatures() {
        features_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature names interested in monitoring.
       * These should be a subset of the input feature names specified in the
       * monitoring schema. If the field is not specified all features outlied in
       * the monitoring schema will be used.
       * </pre>
       *
       * <code>repeated string features = 1;</code>
       *
       * @param value The bytes of the features to add.
       * @return This builder for chaining.
       */
      public Builder addFeaturesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureFeaturesIsMutable();
        features_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          defaultAlertCondition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          defaultAlertConditionBuilder_;
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       *
       * @return Whether the defaultAlertCondition field is set.
       */
      public boolean hasDefaultAlertCondition() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       *
       * @return The defaultAlertCondition.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getDefaultAlertCondition() {
        if (defaultAlertConditionBuilder_ == null) {
          return defaultAlertCondition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : defaultAlertCondition_;
        } else {
          return defaultAlertConditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      public Builder setDefaultAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (defaultAlertConditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultAlertCondition_ = value;
        } else {
          defaultAlertConditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      public Builder setDefaultAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
              builderForValue) {
        if (defaultAlertConditionBuilder_ == null) {
          defaultAlertCondition_ = builderForValue.build();
        } else {
          defaultAlertConditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      public Builder mergeDefaultAlertCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (defaultAlertConditionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && defaultAlertCondition_ != null
              && defaultAlertCondition_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                      .getDefaultInstance()) {
            getDefaultAlertConditionBuilder().mergeFrom(value);
          } else {
            defaultAlertCondition_ = value;
          }
        } else {
          defaultAlertConditionBuilder_.mergeFrom(value);
        }
        if (defaultAlertCondition_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      public Builder clearDefaultAlertCondition() {
        bitField0_ = (bitField0_ & ~0x00000002);
        defaultAlertCondition_ = null;
        if (defaultAlertConditionBuilder_ != null) {
          defaultAlertConditionBuilder_.dispose();
          defaultAlertConditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
          getDefaultAlertConditionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDefaultAlertConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
          getDefaultAlertConditionOrBuilder() {
        if (defaultAlertConditionBuilder_ != null) {
          return defaultAlertConditionBuilder_.getMessageOrBuilder();
        } else {
          return defaultAlertCondition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : defaultAlertCondition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Default alert condition for all the features.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition default_alert_condition = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          getDefaultAlertConditionFieldBuilder() {
        if (defaultAlertConditionBuilder_ == null) {
          defaultAlertConditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>(
                  getDefaultAlertCondition(), getParentForChildren(), isClean());
          defaultAlertCondition_ = null;
        }
        return defaultAlertConditionBuilder_;
      }

      private static final class FeatureAlertConditionsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition> {
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition build(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder val) {
          if (val instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) val;
          }
          return ((com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder) val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
            defaultEntry() {
          return FeatureAlertConditionsDefaultEntryHolder.defaultEntry;
        }
      };

      private static final FeatureAlertConditionsConverter featureAlertConditionsConverter =
          new FeatureAlertConditionsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder>
          featureAlertConditions_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder>
          internalGetFeatureAlertConditions() {
        if (featureAlertConditions_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(featureAlertConditionsConverter);
        }
        return featureAlertConditions_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder>
          internalGetMutableFeatureAlertConditions() {
        if (featureAlertConditions_ == null) {
          featureAlertConditions_ =
              new com.google.protobuf.MapFieldBuilder<>(featureAlertConditionsConverter);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return featureAlertConditions_;
      }

      public int getFeatureAlertConditionsCount() {
        return internalGetFeatureAlertConditions().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      @java.lang.Override
      public boolean containsFeatureAlertConditions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetFeatureAlertConditions().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getFeatureAlertConditionsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          getFeatureAlertConditions() {
        return getFeatureAlertConditionsMap();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          getFeatureAlertConditionsMap() {
        return internalGetFeatureAlertConditions().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getFeatureAlertConditionsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
            map = internalGetMutableFeatureAlertConditions().ensureBuilderMap();
        return map.containsKey(key)
            ? featureAlertConditionsConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
          getFeatureAlertConditionsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
            map = internalGetMutableFeatureAlertConditions().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return featureAlertConditionsConverter.build(map.get(key));
      }

      public Builder clearFeatureAlertConditions() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableFeatureAlertConditions().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      public Builder removeFeatureAlertConditions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableFeatureAlertConditions().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
          getMutableFeatureAlertConditions() {
        bitField0_ |= 0x00000004;
        return internalGetMutableFeatureAlertConditions().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      public Builder putFeatureAlertConditions(
          java.lang.String key,
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableFeatureAlertConditions().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      public Builder putAllFeatureAlertConditions(
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
              values) {
        for (java.util.Map.Entry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableFeatureAlertConditions().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per feature alert condition will override default alert condition.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition&gt; feature_alert_conditions = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
          putFeatureAlertConditionsBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
            builderMap = internalGetMutableFeatureAlertConditions().ensureBuilderMap();
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder entry =
            builderMap.get(key);
        if (entry == null) {
          entry = com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) {
          entry =
              ((com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition) entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder) entry;
      }

      private com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
          batchExplanationDedicatedResources_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>
          batchExplanationDedicatedResourcesBuilder_;
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       *
       * @return Whether the batchExplanationDedicatedResources field is set.
       */
      public boolean hasBatchExplanationDedicatedResources() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       *
       * @return The batchExplanationDedicatedResources.
       */
      public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
          getBatchExplanationDedicatedResources() {
        if (batchExplanationDedicatedResourcesBuilder_ == null) {
          return batchExplanationDedicatedResources_ == null
              ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
              : batchExplanationDedicatedResources_;
        } else {
          return batchExplanationDedicatedResourcesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      public Builder setBatchExplanationDedicatedResources(
          com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources value) {
        if (batchExplanationDedicatedResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          batchExplanationDedicatedResources_ = value;
        } else {
          batchExplanationDedicatedResourcesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      public Builder setBatchExplanationDedicatedResources(
          com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder builderForValue) {
        if (batchExplanationDedicatedResourcesBuilder_ == null) {
          batchExplanationDedicatedResources_ = builderForValue.build();
        } else {
          batchExplanationDedicatedResourcesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      public Builder mergeBatchExplanationDedicatedResources(
          com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources value) {
        if (batchExplanationDedicatedResourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && batchExplanationDedicatedResources_ != null
              && batchExplanationDedicatedResources_
                  != com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
                      .getDefaultInstance()) {
            getBatchExplanationDedicatedResourcesBuilder().mergeFrom(value);
          } else {
            batchExplanationDedicatedResources_ = value;
          }
        } else {
          batchExplanationDedicatedResourcesBuilder_.mergeFrom(value);
        }
        if (batchExplanationDedicatedResources_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      public Builder clearBatchExplanationDedicatedResources() {
        bitField0_ = (bitField0_ & ~0x00000008);
        batchExplanationDedicatedResources_ = null;
        if (batchExplanationDedicatedResourcesBuilder_ != null) {
          batchExplanationDedicatedResourcesBuilder_.dispose();
          batchExplanationDedicatedResourcesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder
          getBatchExplanationDedicatedResourcesBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getBatchExplanationDedicatedResourcesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
          getBatchExplanationDedicatedResourcesOrBuilder() {
        if (batchExplanationDedicatedResourcesBuilder_ != null) {
          return batchExplanationDedicatedResourcesBuilder_.getMessageOrBuilder();
        } else {
          return batchExplanationDedicatedResources_ == null
              ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
              : batchExplanationDedicatedResources_;
        }
      }
      /**
       *
       *
       * <pre>
       * The config of resources used by the Model Monitoring during the batch
       * explanation for non-AutoML models. If not set, `n1-standard-2` machine
       * type will be used by default.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BatchDedicatedResources batch_explanation_dedicated_resources = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>
          getBatchExplanationDedicatedResourcesFieldBuilder() {
        if (batchExplanationDedicatedResourcesBuilder_ == null) {
          batchExplanationDedicatedResourcesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
                  com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
                  com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>(
                  getBatchExplanationDedicatedResources(), getParentForChildren(), isClean());
          batchExplanationDedicatedResources_ = null;
        }
        return batchExplanationDedicatedResourcesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
              .FeatureAttributionSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FeatureAttributionSpec> PARSER =
        new com.google.protobuf.AbstractParser<FeatureAttributionSpec>() {
          @java.lang.Override
          public FeatureAttributionSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FeatureAttributionSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeatureAttributionSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TabularObjectiveOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Input feature distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
     * </code>
     *
     * @return Whether the featureDriftSpec field is set.
     */
    boolean hasFeatureDriftSpec();
    /**
     *
     *
     * <pre>
     * Input feature distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
     * </code>
     *
     * @return The featureDriftSpec.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        getFeatureDriftSpec();
    /**
     *
     *
     * <pre>
     * Input feature distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder
        getFeatureDriftSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Prediction output distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
     * </code>
     *
     * @return Whether the predictionOutputDriftSpec field is set.
     */
    boolean hasPredictionOutputDriftSpec();
    /**
     *
     *
     * <pre>
     * Prediction output distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
     * </code>
     *
     * @return The predictionOutputDriftSpec.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        getPredictionOutputDriftSpec();
    /**
     *
     *
     * <pre>
     * Prediction output distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder
        getPredictionOutputDriftSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
     * </code>
     *
     * @return Whether the featureAttributionSpec field is set.
     */
    boolean hasFeatureAttributionSpec();
    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
     * </code>
     *
     * @return The featureAttributionSpec.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
        getFeatureAttributionSpec();
    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpecOrBuilder
        getFeatureAttributionSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Tabular monitoring objective.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective}
   */
  public static final class TabularObjective extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
      TabularObjectiveOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TabularObjective.newBuilder() to construct.
    private TabularObjective(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TabularObjective() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TabularObjective();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_TabularObjective_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_TabularObjective_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                  .class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                  .Builder.class);
    }

    private int bitField0_;
    public static final int FEATURE_DRIFT_SPEC_FIELD_NUMBER = 10;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        featureDriftSpec_;
    /**
     *
     *
     * <pre>
     * Input feature distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
     * </code>
     *
     * @return Whether the featureDriftSpec field is set.
     */
    @java.lang.Override
    public boolean hasFeatureDriftSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Input feature distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
     * </code>
     *
     * @return The featureDriftSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        getFeatureDriftSpec() {
      return featureDriftSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
              .getDefaultInstance()
          : featureDriftSpec_;
    }
    /**
     *
     *
     * <pre>
     * Input feature distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder
        getFeatureDriftSpecOrBuilder() {
      return featureDriftSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
              .getDefaultInstance()
          : featureDriftSpec_;
    }

    public static final int PREDICTION_OUTPUT_DRIFT_SPEC_FIELD_NUMBER = 11;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        predictionOutputDriftSpec_;
    /**
     *
     *
     * <pre>
     * Prediction output distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
     * </code>
     *
     * @return Whether the predictionOutputDriftSpec field is set.
     */
    @java.lang.Override
    public boolean hasPredictionOutputDriftSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Prediction output distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
     * </code>
     *
     * @return The predictionOutputDriftSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
        getPredictionOutputDriftSpec() {
      return predictionOutputDriftSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
              .getDefaultInstance()
          : predictionOutputDriftSpec_;
    }
    /**
     *
     *
     * <pre>
     * Prediction output distribution drift monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder
        getPredictionOutputDriftSpecOrBuilder() {
      return predictionOutputDriftSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
              .getDefaultInstance()
          : predictionOutputDriftSpec_;
    }

    public static final int FEATURE_ATTRIBUTION_SPEC_FIELD_NUMBER = 12;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
        featureAttributionSpec_;
    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
     * </code>
     *
     * @return Whether the featureAttributionSpec field is set.
     */
    @java.lang.Override
    public boolean hasFeatureAttributionSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
     * </code>
     *
     * @return The featureAttributionSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
        getFeatureAttributionSpec() {
      return featureAttributionSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              .getDefaultInstance()
          : featureAttributionSpec_;
    }
    /**
     *
     *
     * <pre>
     * Feature attribution monitoring spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .FeatureAttributionSpecOrBuilder
        getFeatureAttributionSpecOrBuilder() {
      return featureAttributionSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              .getDefaultInstance()
          : featureAttributionSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(10, getFeatureDriftSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(11, getPredictionOutputDriftSpec());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(12, getFeatureAttributionSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getFeatureDriftSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                11, getPredictionOutputDriftSpec());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                12, getFeatureAttributionSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective) obj;

      if (hasFeatureDriftSpec() != other.hasFeatureDriftSpec()) return false;
      if (hasFeatureDriftSpec()) {
        if (!getFeatureDriftSpec().equals(other.getFeatureDriftSpec())) return false;
      }
      if (hasPredictionOutputDriftSpec() != other.hasPredictionOutputDriftSpec()) return false;
      if (hasPredictionOutputDriftSpec()) {
        if (!getPredictionOutputDriftSpec().equals(other.getPredictionOutputDriftSpec()))
          return false;
      }
      if (hasFeatureAttributionSpec() != other.hasFeatureAttributionSpec()) return false;
      if (hasFeatureAttributionSpec()) {
        if (!getFeatureAttributionSpec().equals(other.getFeatureAttributionSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFeatureDriftSpec()) {
        hash = (37 * hash) + FEATURE_DRIFT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureDriftSpec().hashCode();
      }
      if (hasPredictionOutputDriftSpec()) {
        hash = (37 * hash) + PREDICTION_OUTPUT_DRIFT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPredictionOutputDriftSpec().hashCode();
      }
      if (hasFeatureAttributionSpec()) {
        hash = (37 * hash) + FEATURE_ATTRIBUTION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureAttributionSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjectiveOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_TabularObjective_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_TabularObjective_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFeatureDriftSpecFieldBuilder();
          getPredictionOutputDriftSpecFieldBuilder();
          getFeatureAttributionSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        featureDriftSpec_ = null;
        if (featureDriftSpecBuilder_ != null) {
          featureDriftSpecBuilder_.dispose();
          featureDriftSpecBuilder_ = null;
        }
        predictionOutputDriftSpec_ = null;
        if (predictionOutputDriftSpecBuilder_ != null) {
          predictionOutputDriftSpecBuilder_.dispose();
          predictionOutputDriftSpecBuilder_ = null;
        }
        featureAttributionSpec_ = null;
        if (featureAttributionSpecBuilder_ != null) {
          featureAttributionSpecBuilder_.dispose();
          featureAttributionSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_TabularObjective_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.featureDriftSpec_ =
              featureDriftSpecBuilder_ == null
                  ? featureDriftSpec_
                  : featureDriftSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.predictionOutputDriftSpec_ =
              predictionOutputDriftSpecBuilder_ == null
                  ? predictionOutputDriftSpec_
                  : predictionOutputDriftSpecBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.featureAttributionSpec_ =
              featureAttributionSpecBuilder_ == null
                  ? featureAttributionSpec_
                  : featureAttributionSpecBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                .getDefaultInstance()) return this;
        if (other.hasFeatureDriftSpec()) {
          mergeFeatureDriftSpec(other.getFeatureDriftSpec());
        }
        if (other.hasPredictionOutputDriftSpec()) {
          mergePredictionOutputDriftSpec(other.getPredictionOutputDriftSpec());
        }
        if (other.hasFeatureAttributionSpec()) {
          mergeFeatureAttributionSpec(other.getFeatureAttributionSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 82:
                {
                  input.readMessage(
                      getFeatureDriftSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 82
              case 90:
                {
                  input.readMessage(
                      getPredictionOutputDriftSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 90
              case 98:
                {
                  input.readMessage(
                      getFeatureAttributionSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 98
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          featureDriftSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .DataDriftSpecOrBuilder>
          featureDriftSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       *
       * @return Whether the featureDriftSpec field is set.
       */
      public boolean hasFeatureDriftSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       *
       * @return The featureDriftSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          getFeatureDriftSpec() {
        if (featureDriftSpecBuilder_ == null) {
          return featureDriftSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .getDefaultInstance()
              : featureDriftSpec_;
        } else {
          return featureDriftSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      public Builder setFeatureDriftSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec value) {
        if (featureDriftSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          featureDriftSpec_ = value;
        } else {
          featureDriftSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      public Builder setFeatureDriftSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.Builder
              builderForValue) {
        if (featureDriftSpecBuilder_ == null) {
          featureDriftSpec_ = builderForValue.build();
        } else {
          featureDriftSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      public Builder mergeFeatureDriftSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec value) {
        if (featureDriftSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && featureDriftSpec_ != null
              && featureDriftSpec_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                      .getDefaultInstance()) {
            getFeatureDriftSpecBuilder().mergeFrom(value);
          } else {
            featureDriftSpec_ = value;
          }
        } else {
          featureDriftSpecBuilder_.mergeFrom(value);
        }
        if (featureDriftSpec_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      public Builder clearFeatureDriftSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        featureDriftSpec_ = null;
        if (featureDriftSpecBuilder_ != null) {
          featureDriftSpecBuilder_.dispose();
          featureDriftSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.Builder
          getFeatureDriftSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getFeatureDriftSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder
          getFeatureDriftSpecOrBuilder() {
        if (featureDriftSpecBuilder_ != null) {
          return featureDriftSpecBuilder_.getMessageOrBuilder();
        } else {
          return featureDriftSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .getDefaultInstance()
              : featureDriftSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Input feature distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec feature_drift_spec = 10;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .DataDriftSpecOrBuilder>
          getFeatureDriftSpecFieldBuilder() {
        if (featureDriftSpecBuilder_ == null) {
          featureDriftSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .DataDriftSpecOrBuilder>(
                  getFeatureDriftSpec(), getParentForChildren(), isClean());
          featureDriftSpec_ = null;
        }
        return featureDriftSpecBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          predictionOutputDriftSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .DataDriftSpecOrBuilder>
          predictionOutputDriftSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       *
       * @return Whether the predictionOutputDriftSpec field is set.
       */
      public boolean hasPredictionOutputDriftSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       *
       * @return The predictionOutputDriftSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
          getPredictionOutputDriftSpec() {
        if (predictionOutputDriftSpecBuilder_ == null) {
          return predictionOutputDriftSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .getDefaultInstance()
              : predictionOutputDriftSpec_;
        } else {
          return predictionOutputDriftSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      public Builder setPredictionOutputDriftSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec value) {
        if (predictionOutputDriftSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          predictionOutputDriftSpec_ = value;
        } else {
          predictionOutputDriftSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      public Builder setPredictionOutputDriftSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.Builder
              builderForValue) {
        if (predictionOutputDriftSpecBuilder_ == null) {
          predictionOutputDriftSpec_ = builderForValue.build();
        } else {
          predictionOutputDriftSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      public Builder mergePredictionOutputDriftSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec value) {
        if (predictionOutputDriftSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && predictionOutputDriftSpec_ != null
              && predictionOutputDriftSpec_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                      .getDefaultInstance()) {
            getPredictionOutputDriftSpecBuilder().mergeFrom(value);
          } else {
            predictionOutputDriftSpec_ = value;
          }
        } else {
          predictionOutputDriftSpecBuilder_.mergeFrom(value);
        }
        if (predictionOutputDriftSpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      public Builder clearPredictionOutputDriftSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        predictionOutputDriftSpec_ = null;
        if (predictionOutputDriftSpecBuilder_ != null) {
          predictionOutputDriftSpecBuilder_.dispose();
          predictionOutputDriftSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.Builder
          getPredictionOutputDriftSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPredictionOutputDriftSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpecOrBuilder
          getPredictionOutputDriftSpecOrBuilder() {
        if (predictionOutputDriftSpecBuilder_ != null) {
          return predictionOutputDriftSpecBuilder_.getMessageOrBuilder();
        } else {
          return predictionOutputDriftSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .getDefaultInstance()
              : predictionOutputDriftSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Prediction output distribution drift monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec prediction_output_drift_spec = 11;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .DataDriftSpecOrBuilder>
          getPredictionOutputDriftSpecFieldBuilder() {
        if (predictionOutputDriftSpecBuilder_ == null) {
          predictionOutputDriftSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .DataDriftSpecOrBuilder>(
                  getPredictionOutputDriftSpec(), getParentForChildren(), isClean());
          predictionOutputDriftSpec_ = null;
        }
        return predictionOutputDriftSpecBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
              .FeatureAttributionSpec
          featureAttributionSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpecOrBuilder>
          featureAttributionSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       *
       * @return Whether the featureAttributionSpec field is set.
       */
      public boolean hasFeatureAttributionSpec() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       *
       * @return The featureAttributionSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
          getFeatureAttributionSpec() {
        if (featureAttributionSpecBuilder_ == null) {
          return featureAttributionSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec.getDefaultInstance()
              : featureAttributionSpec_;
        } else {
          return featureAttributionSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      public Builder setFeatureAttributionSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              value) {
        if (featureAttributionSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          featureAttributionSpec_ = value;
        } else {
          featureAttributionSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      public Builder setFeatureAttributionSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
                  .Builder
              builderForValue) {
        if (featureAttributionSpecBuilder_ == null) {
          featureAttributionSpec_ = builderForValue.build();
        } else {
          featureAttributionSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      public Builder mergeFeatureAttributionSpec(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              value) {
        if (featureAttributionSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && featureAttributionSpec_ != null
              && featureAttributionSpec_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .FeatureAttributionSpec.getDefaultInstance()) {
            getFeatureAttributionSpecBuilder().mergeFrom(value);
          } else {
            featureAttributionSpec_ = value;
          }
        } else {
          featureAttributionSpecBuilder_.mergeFrom(value);
        }
        if (featureAttributionSpec_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      public Builder clearFeatureAttributionSpec() {
        bitField0_ = (bitField0_ & ~0x00000004);
        featureAttributionSpec_ = null;
        if (featureAttributionSpecBuilder_ != null) {
          featureAttributionSpecBuilder_.dispose();
          featureAttributionSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
              .Builder
          getFeatureAttributionSpecBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getFeatureAttributionSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
              .FeatureAttributionSpecOrBuilder
          getFeatureAttributionSpecOrBuilder() {
        if (featureAttributionSpecBuilder_ != null) {
          return featureAttributionSpecBuilder_.getMessageOrBuilder();
        } else {
          return featureAttributionSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec.getDefaultInstance()
              : featureAttributionSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Feature attribution monitoring spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec feature_attribution_spec = 12;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                  .FeatureAttributionSpecOrBuilder>
          getFeatureAttributionSpecFieldBuilder() {
        if (featureAttributionSpecBuilder_ == null) {
          featureAttributionSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .FeatureAttributionSpec,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .FeatureAttributionSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                      .FeatureAttributionSpecOrBuilder>(
                  getFeatureAttributionSpec(), getParentForChildren(), isClean());
          featureAttributionSpec_ = null;
        }
        return featureAttributionSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .TabularObjective
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TabularObjective> PARSER =
        new com.google.protobuf.AbstractParser<TabularObjective>() {
          @java.lang.Override
          public TabularObjective parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TabularObjective> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TabularObjective> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int objectiveCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object objective_;

  public enum ObjectiveCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TABULAR_OBJECTIVE(1),
    OBJECTIVE_NOT_SET(0);
    private final int value;

    private ObjectiveCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ObjectiveCase valueOf(int value) {
      return forNumber(value);
    }

    public static ObjectiveCase forNumber(int value) {
      switch (value) {
        case 1:
          return TABULAR_OBJECTIVE;
        case 0:
          return OBJECTIVE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ObjectiveCase getObjectiveCase() {
    return ObjectiveCase.forNumber(objectiveCase_);
  }

  public static final int TABULAR_OBJECTIVE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Tabular monitoring objective.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
   * </code>
   *
   * @return Whether the tabularObjective field is set.
   */
  @java.lang.Override
  public boolean hasTabularObjective() {
    return objectiveCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Tabular monitoring objective.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
   * </code>
   *
   * @return The tabularObjective.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
      getTabularObjective() {
    if (objectiveCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
          objective_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tabular monitoring objective.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjectiveOrBuilder
      getTabularObjectiveOrBuilder() {
    if (objectiveCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
          objective_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        .getDefaultInstance();
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
  /**
   *
   *
   * <pre>
   * The explanation spec.
   * This spec is required when the objectives spec includes feature attribution
   * objectives.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The explanation spec.
   * This spec is required when the objectives spec includes feature attribution
   * objectives.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }
  /**
   *
   *
   * <pre>
   * The explanation spec.
   * This spec is required when the objectives spec includes feature attribution
   * objectives.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
      getExplanationSpecOrBuilder() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }

  public static final int BASELINE_DATASET_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baselineDataset_;
  /**
   *
   *
   * <pre>
   * Baseline dataset.
   * It could be the training dataset or production serving dataset from a
   * previous period.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
   *
   * @return Whether the baselineDataset field is set.
   */
  @java.lang.Override
  public boolean hasBaselineDataset() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Baseline dataset.
   * It could be the training dataset or production serving dataset from a
   * previous period.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
   *
   * @return The baselineDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getBaselineDataset() {
    return baselineDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
        : baselineDataset_;
  }
  /**
   *
   *
   * <pre>
   * Baseline dataset.
   * It could be the training dataset or production serving dataset from a
   * previous period.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder
      getBaselineDatasetOrBuilder() {
    return baselineDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
        : baselineDataset_;
  }

  public static final int TARGET_DATASET_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput targetDataset_;
  /**
   *
   *
   * <pre>
   * Target dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
   *
   * @return Whether the targetDataset field is set.
   */
  @java.lang.Override
  public boolean hasTargetDataset() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Target dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
   *
   * @return The targetDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getTargetDataset() {
    return targetDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
        : targetDataset_;
  }
  /**
   *
   *
   * <pre>
   * Target dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder
      getTargetDatasetOrBuilder() {
    return targetDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
        : targetDataset_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (objectiveCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
              objective_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getExplanationSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getBaselineDataset());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getTargetDataset());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (objectiveCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
                  objective_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExplanationSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBaselineDataset());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTargetDataset());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec) obj;

    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (hasBaselineDataset() != other.hasBaselineDataset()) return false;
    if (hasBaselineDataset()) {
      if (!getBaselineDataset().equals(other.getBaselineDataset())) return false;
    }
    if (hasTargetDataset() != other.hasTargetDataset()) return false;
    if (hasTargetDataset()) {
      if (!getTargetDataset().equals(other.getTargetDataset())) return false;
    }
    if (!getObjectiveCase().equals(other.getObjectiveCase())) return false;
    switch (objectiveCase_) {
      case 1:
        if (!getTabularObjective().equals(other.getTabularObjective())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    if (hasBaselineDataset()) {
      hash = (37 * hash) + BASELINE_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getBaselineDataset().hashCode();
    }
    if (hasTargetDataset()) {
      hash = (37 * hash) + TARGET_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getTargetDataset().hashCode();
    }
    switch (objectiveCase_) {
      case 1:
        hash = (37 * hash) + TABULAR_OBJECTIVE_FIELD_NUMBER;
        hash = (53 * hash) + getTabularObjective().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Monitoring objectives spec.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExplanationSpecFieldBuilder();
        getBaselineDatasetFieldBuilder();
        getTargetDatasetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tabularObjectiveBuilder_ != null) {
        tabularObjectiveBuilder_.clear();
      }
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      baselineDataset_ = null;
      if (baselineDatasetBuilder_ != null) {
        baselineDatasetBuilder_.dispose();
        baselineDatasetBuilder_ = null;
      }
      targetDataset_ = null;
      if (targetDatasetBuilder_ != null) {
        targetDatasetBuilder_.dispose();
        targetDatasetBuilder_ = null;
      }
      objectiveCase_ = 0;
      objective_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.explanationSpec_ =
            explanationSpecBuilder_ == null ? explanationSpec_ : explanationSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.baselineDataset_ =
            baselineDatasetBuilder_ == null ? baselineDataset_ : baselineDatasetBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.targetDataset_ =
            targetDatasetBuilder_ == null ? targetDataset_ : targetDatasetBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec result) {
      result.objectiveCase_ = objectiveCase_;
      result.objective_ = this.objective_;
      if (objectiveCase_ == 1 && tabularObjectiveBuilder_ != null) {
        result.objective_ = tabularObjectiveBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.getDefaultInstance())
        return this;
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (other.hasBaselineDataset()) {
        mergeBaselineDataset(other.getBaselineDataset());
      }
      if (other.hasTargetDataset()) {
        mergeTargetDataset(other.getTargetDataset());
      }
      switch (other.getObjectiveCase()) {
        case TABULAR_OBJECTIVE:
          {
            mergeTabularObjective(other.getTabularObjective());
            break;
          }
        case OBJECTIVE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getTabularObjectiveFieldBuilder().getBuilder(), extensionRegistry);
                objectiveCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getExplanationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBaselineDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getTargetDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int objectiveCase_ = 0;
    private java.lang.Object objective_;

    public ObjectiveCase getObjectiveCase() {
      return ObjectiveCase.forNumber(objectiveCase_);
    }

    public Builder clearObjective() {
      objectiveCase_ = 0;
      objective_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                .TabularObjectiveOrBuilder>
        tabularObjectiveBuilder_;
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     *
     * @return Whether the tabularObjective field is set.
     */
    @java.lang.Override
    public boolean hasTabularObjective() {
      return objectiveCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     *
     * @return The tabularObjective.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        getTabularObjective() {
      if (tabularObjectiveBuilder_ == null) {
        if (objectiveCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
              objective_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      } else {
        if (objectiveCase_ == 1) {
          return tabularObjectiveBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    public Builder setTabularObjective(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective value) {
      if (tabularObjectiveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objective_ = value;
        onChanged();
      } else {
        tabularObjectiveBuilder_.setMessage(value);
      }
      objectiveCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    public Builder setTabularObjective(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.Builder
            builderForValue) {
      if (tabularObjectiveBuilder_ == null) {
        objective_ = builderForValue.build();
        onChanged();
      } else {
        tabularObjectiveBuilder_.setMessage(builderForValue.build());
      }
      objectiveCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    public Builder mergeTabularObjective(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective value) {
      if (tabularObjectiveBuilder_ == null) {
        if (objectiveCase_ == 1
            && objective_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                    .getDefaultInstance()) {
          objective_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                              .TabularObjective)
                          objective_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          objective_ = value;
        }
        onChanged();
      } else {
        if (objectiveCase_ == 1) {
          tabularObjectiveBuilder_.mergeFrom(value);
        } else {
          tabularObjectiveBuilder_.setMessage(value);
        }
      }
      objectiveCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    public Builder clearTabularObjective() {
      if (tabularObjectiveBuilder_ == null) {
        if (objectiveCase_ == 1) {
          objectiveCase_ = 0;
          objective_ = null;
          onChanged();
        }
      } else {
        if (objectiveCase_ == 1) {
          objectiveCase_ = 0;
          objective_ = null;
        }
        tabularObjectiveBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.Builder
        getTabularObjectiveBuilder() {
      return getTabularObjectiveFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .TabularObjectiveOrBuilder
        getTabularObjectiveOrBuilder() {
      if ((objectiveCase_ == 1) && (tabularObjectiveBuilder_ != null)) {
        return tabularObjectiveBuilder_.getMessageOrBuilder();
      } else {
        if (objectiveCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
              objective_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tabular monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                .TabularObjectiveOrBuilder>
        getTabularObjectiveFieldBuilder() {
      if (tabularObjectiveBuilder_ == null) {
        if (!(objectiveCase_ == 1)) {
          objective_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                  .getDefaultInstance();
        }
        tabularObjectiveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                    .TabularObjectiveOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
                    objective_,
                getParentForChildren(),
                isClean());
        objective_ = null;
      }
      objectiveCase_ = 1;
      onChanged();
      return tabularObjectiveBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
      } else {
        explanationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && explanationSpec_ != null
            && explanationSpec_
                != com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()) {
          getExplanationSpecBuilder().mergeFrom(value);
        } else {
          explanationSpec_ = value;
        }
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }
      if (explanationSpec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    public Builder clearExplanationSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder getExplanationSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
        getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The explanation spec.
     * This spec is required when the objectives spec includes feature attribution
     * objectives.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baselineDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>
        baselineDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     *
     * @return Whether the baselineDataset field is set.
     */
    public boolean hasBaselineDataset() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     *
     * @return The baselineDataset.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getBaselineDataset() {
      if (baselineDatasetBuilder_ == null) {
        return baselineDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
            : baselineDataset_;
      } else {
        return baselineDatasetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    public Builder setBaselineDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput value) {
      if (baselineDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baselineDataset_ = value;
      } else {
        baselineDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    public Builder setBaselineDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder builderForValue) {
      if (baselineDatasetBuilder_ == null) {
        baselineDataset_ = builderForValue.build();
      } else {
        baselineDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    public Builder mergeBaselineDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput value) {
      if (baselineDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && baselineDataset_ != null
            && baselineDataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()) {
          getBaselineDatasetBuilder().mergeFrom(value);
        } else {
          baselineDataset_ = value;
        }
      } else {
        baselineDatasetBuilder_.mergeFrom(value);
      }
      if (baselineDataset_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    public Builder clearBaselineDataset() {
      bitField0_ = (bitField0_ & ~0x00000004);
      baselineDataset_ = null;
      if (baselineDatasetBuilder_ != null) {
        baselineDatasetBuilder_.dispose();
        baselineDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder
        getBaselineDatasetBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getBaselineDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder
        getBaselineDatasetOrBuilder() {
      if (baselineDatasetBuilder_ != null) {
        return baselineDatasetBuilder_.getMessageOrBuilder();
      } else {
        return baselineDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
            : baselineDataset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Baseline dataset.
     * It could be the training dataset or production serving dataset from a
     * previous period.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput baseline_dataset = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>
        getBaselineDatasetFieldBuilder() {
      if (baselineDatasetBuilder_ == null) {
        baselineDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>(
                getBaselineDataset(), getParentForChildren(), isClean());
        baselineDataset_ = null;
      }
      return baselineDatasetBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput targetDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>
        targetDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     *
     * @return Whether the targetDataset field is set.
     */
    public boolean hasTargetDataset() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     *
     * @return The targetDataset.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getTargetDataset() {
      if (targetDatasetBuilder_ == null) {
        return targetDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
            : targetDataset_;
      } else {
        return targetDatasetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    public Builder setTargetDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput value) {
      if (targetDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetDataset_ = value;
      } else {
        targetDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    public Builder setTargetDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder builderForValue) {
      if (targetDatasetBuilder_ == null) {
        targetDataset_ = builderForValue.build();
      } else {
        targetDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    public Builder mergeTargetDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput value) {
      if (targetDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && targetDataset_ != null
            && targetDataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()) {
          getTargetDatasetBuilder().mergeFrom(value);
        } else {
          targetDataset_ = value;
        }
      } else {
        targetDatasetBuilder_.mergeFrom(value);
      }
      if (targetDataset_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    public Builder clearTargetDataset() {
      bitField0_ = (bitField0_ & ~0x00000008);
      targetDataset_ = null;
      if (targetDatasetBuilder_ != null) {
        targetDatasetBuilder_.dispose();
        targetDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder
        getTargetDatasetBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTargetDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder
        getTargetDatasetOrBuilder() {
      if (targetDatasetBuilder_ != null) {
        return targetDatasetBuilder_.getMessageOrBuilder();
      } else {
        return targetDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
            : targetDataset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Target dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput target_dataset = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>
        getTargetDatasetFieldBuilder() {
      if (targetDatasetBuilder_ == null) {
        targetDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>(
                getTargetDataset(), getParentForChildren(), isClean());
        targetDataset_ = null;
      }
      return targetDatasetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringObjectiveSpec> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringObjectiveSpec>() {
        @java.lang.Override
        public ModelMonitoringObjectiveSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringObjectiveSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringObjectiveSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
