/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/io.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The Jira source for the ImportRagFilesRequest.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.JiraSource}
 */
public final class JiraSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.JiraSource)
    JiraSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use JiraSource.newBuilder() to construct.
  private JiraSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JiraSource() {
    jiraQueries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JiraSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.IoProto
        .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.IoProto
        .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.JiraSource.class,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder.class);
  }

  public interface JiraQueriesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @return A list containing the projects.
     */
    java.util.List<java.lang.String> getProjectsList();
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @return The count of projects.
     */
    int getProjectsCount();
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The projects at the given index.
     */
    java.lang.String getProjects(int index);
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the projects at the given index.
     */
    com.google.protobuf.ByteString getProjectsBytes(int index);

    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @return A list containing the customQueries.
     */
    java.util.List<java.lang.String> getCustomQueriesList();
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @return The count of customQueries.
     */
    int getCustomQueriesCount();
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The customQueries at the given index.
     */
    java.lang.String getCustomQueries(int index);
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customQueries at the given index.
     */
    com.google.protobuf.ByteString getCustomQueriesBytes(int index);

    /**
     *
     *
     * <pre>
     * Required. The Jira email address.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The email.
     */
    java.lang.String getEmail();
    /**
     *
     *
     * <pre>
     * Required. The Jira email address.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for email.
     */
    com.google.protobuf.ByteString getEmailBytes();

    /**
     *
     *
     * <pre>
     * Required. The Jira server URI.
     * </pre>
     *
     * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serverUri.
     */
    java.lang.String getServerUri();
    /**
     *
     *
     * <pre>
     * Required. The Jira server URI.
     * </pre>
     *
     * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serverUri.
     */
    com.google.protobuf.ByteString getServerUriBytes();

    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Jira API key
     * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    boolean hasApiKeyConfig();
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Jira API key
     * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The apiKeyConfig.
     */
    com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig getApiKeyConfig();
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Jira API key
     * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder getApiKeyConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * JiraQueries contains the Jira queries and corresponding authentication.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries}
   */
  public static final class JiraQueries extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries)
      JiraQueriesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use JiraQueries.newBuilder() to construct.
    private JiraQueries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private JiraQueries() {
      projects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      customQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
      email_ = "";
      serverUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new JiraQueries();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_JiraQueries_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_JiraQueries_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.class,
              com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder.class);
    }

    private int bitField0_;
    public static final int PROJECTS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList projects_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @return A list containing the projects.
     */
    public com.google.protobuf.ProtocolStringList getProjectsList() {
      return projects_;
    }
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @return The count of projects.
     */
    public int getProjectsCount() {
      return projects_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The projects at the given index.
     */
    public java.lang.String getProjects(int index) {
      return projects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Jira projects to import in their entirety.
     * </pre>
     *
     * <code>repeated string projects = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the projects at the given index.
     */
    public com.google.protobuf.ByteString getProjectsBytes(int index) {
      return projects_.getByteString(index);
    }

    public static final int CUSTOM_QUERIES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList customQueries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @return A list containing the customQueries.
     */
    public com.google.protobuf.ProtocolStringList getCustomQueriesList() {
      return customQueries_;
    }
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @return The count of customQueries.
     */
    public int getCustomQueriesCount() {
      return customQueries_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The customQueries at the given index.
     */
    public java.lang.String getCustomQueries(int index) {
      return customQueries_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of custom Jira queries to import. For information about JQL (Jira
     * Query Language), see
     * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
     * </pre>
     *
     * <code>repeated string custom_queries = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customQueries at the given index.
     */
    public com.google.protobuf.ByteString getCustomQueriesBytes(int index) {
      return customQueries_.getByteString(index);
    }

    public static final int EMAIL_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object email_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Jira email address.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The email.
     */
    @java.lang.Override
    public java.lang.String getEmail() {
      java.lang.Object ref = email_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        email_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira email address.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for email.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEmailBytes() {
      java.lang.Object ref = email_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        email_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVER_URI_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serverUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Jira server URI.
     * </pre>
     *
     * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serverUri.
     */
    @java.lang.Override
    public java.lang.String getServerUri() {
      java.lang.Object ref = serverUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira server URI.
     * </pre>
     *
     * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serverUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServerUriBytes() {
      java.lang.Object ref = serverUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serverUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int API_KEY_CONFIG_FIELD_NUMBER = 7;
    private com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig apiKeyConfig_;
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Jira API key
     * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    @java.lang.Override
    public boolean hasApiKeyConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Jira API key
     * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The apiKeyConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig getApiKeyConfig() {
      return apiKeyConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
          : apiKeyConfig_;
    }
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Jira API key
     * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder
        getApiKeyConfigOrBuilder() {
      return apiKeyConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
          : apiKeyConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < projects_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, projects_.getRaw(i));
      }
      for (int i = 0; i < customQueries_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, customQueries_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, email_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, serverUri_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(7, getApiKeyConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < projects_.size(); i++) {
          dataSize += computeStringSizeNoTag(projects_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getProjectsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < customQueries_.size(); i++) {
          dataSize += computeStringSizeNoTag(customQueries_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCustomQueriesList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, email_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, serverUri_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getApiKeyConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries other =
          (com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries) obj;

      if (!getProjectsList().equals(other.getProjectsList())) return false;
      if (!getCustomQueriesList().equals(other.getCustomQueriesList())) return false;
      if (!getEmail().equals(other.getEmail())) return false;
      if (!getServerUri().equals(other.getServerUri())) return false;
      if (hasApiKeyConfig() != other.hasApiKeyConfig()) return false;
      if (hasApiKeyConfig()) {
        if (!getApiKeyConfig().equals(other.getApiKeyConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getProjectsCount() > 0) {
        hash = (37 * hash) + PROJECTS_FIELD_NUMBER;
        hash = (53 * hash) + getProjectsList().hashCode();
      }
      if (getCustomQueriesCount() > 0) {
        hash = (37 * hash) + CUSTOM_QUERIES_FIELD_NUMBER;
        hash = (53 * hash) + getCustomQueriesList().hashCode();
      }
      hash = (37 * hash) + EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getEmail().hashCode();
      hash = (37 * hash) + SERVER_URI_FIELD_NUMBER;
      hash = (53 * hash) + getServerUri().hashCode();
      if (hasApiKeyConfig()) {
        hash = (37 * hash) + API_KEY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getApiKeyConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * JiraQueries contains the Jira queries and corresponding authentication.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries)
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_JiraQueries_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_JiraQueries_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.class,
                com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getApiKeyConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        projects_ = com.google.protobuf.LazyStringArrayList.emptyList();
        customQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
        email_ = "";
        serverUri_ = "";
        apiKeyConfig_ = null;
        if (apiKeyConfigBuilder_ != null) {
          apiKeyConfigBuilder_.dispose();
          apiKeyConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_JiraQueries_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries build() {
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries buildPartial() {
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries result =
            new com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          projects_.makeImmutable();
          result.projects_ = projects_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          customQueries_.makeImmutable();
          result.customQueries_ = customQueries_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.email_ = email_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.serverUri_ = serverUri_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.apiKeyConfig_ =
              apiKeyConfigBuilder_ == null ? apiKeyConfig_ : apiKeyConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.getDefaultInstance())
          return this;
        if (!other.projects_.isEmpty()) {
          if (projects_.isEmpty()) {
            projects_ = other.projects_;
            bitField0_ |= 0x00000001;
          } else {
            ensureProjectsIsMutable();
            projects_.addAll(other.projects_);
          }
          onChanged();
        }
        if (!other.customQueries_.isEmpty()) {
          if (customQueries_.isEmpty()) {
            customQueries_ = other.customQueries_;
            bitField0_ |= 0x00000002;
          } else {
            ensureCustomQueriesIsMutable();
            customQueries_.addAll(other.customQueries_);
          }
          onChanged();
        }
        if (!other.getEmail().isEmpty()) {
          email_ = other.email_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getServerUri().isEmpty()) {
          serverUri_ = other.serverUri_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.hasApiKeyConfig()) {
          mergeApiKeyConfig(other.getApiKeyConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureProjectsIsMutable();
                  projects_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCustomQueriesIsMutable();
                  customQueries_.add(s);
                  break;
                } // case 34
              case 42:
                {
                  email_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 42
              case 50:
                {
                  serverUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getApiKeyConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList projects_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureProjectsIsMutable() {
        if (!projects_.isModifiable()) {
          projects_ = new com.google.protobuf.LazyStringArrayList(projects_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @return A list containing the projects.
       */
      public com.google.protobuf.ProtocolStringList getProjectsList() {
        projects_.makeImmutable();
        return projects_;
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @return The count of projects.
       */
      public int getProjectsCount() {
        return projects_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The projects at the given index.
       */
      public java.lang.String getProjects(int index) {
        return projects_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the projects at the given index.
       */
      public com.google.protobuf.ByteString getProjectsBytes(int index) {
        return projects_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The projects to set.
       * @return This builder for chaining.
       */
      public Builder setProjects(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectsIsMutable();
        projects_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @param value The projects to add.
       * @return This builder for chaining.
       */
      public Builder addProjects(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectsIsMutable();
        projects_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @param values The projects to add.
       * @return This builder for chaining.
       */
      public Builder addAllProjects(java.lang.Iterable<java.lang.String> values) {
        ensureProjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, projects_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjects() {
        projects_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of Jira projects to import in their entirety.
       * </pre>
       *
       * <code>repeated string projects = 3;</code>
       *
       * @param value The bytes of the projects to add.
       * @return This builder for chaining.
       */
      public Builder addProjectsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureProjectsIsMutable();
        projects_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList customQueries_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCustomQueriesIsMutable() {
        if (!customQueries_.isModifiable()) {
          customQueries_ = new com.google.protobuf.LazyStringArrayList(customQueries_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @return A list containing the customQueries.
       */
      public com.google.protobuf.ProtocolStringList getCustomQueriesList() {
        customQueries_.makeImmutable();
        return customQueries_;
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @return The count of customQueries.
       */
      public int getCustomQueriesCount() {
        return customQueries_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The customQueries at the given index.
       */
      public java.lang.String getCustomQueries(int index) {
        return customQueries_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the customQueries at the given index.
       */
      public com.google.protobuf.ByteString getCustomQueriesBytes(int index) {
        return customQueries_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The customQueries to set.
       * @return This builder for chaining.
       */
      public Builder setCustomQueries(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomQueriesIsMutable();
        customQueries_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @param value The customQueries to add.
       * @return This builder for chaining.
       */
      public Builder addCustomQueries(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomQueriesIsMutable();
        customQueries_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @param values The customQueries to add.
       * @return This builder for chaining.
       */
      public Builder addAllCustomQueries(java.lang.Iterable<java.lang.String> values) {
        ensureCustomQueriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customQueries_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCustomQueries() {
        customQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom Jira queries to import. For information about JQL (Jira
       * Query Language), see
       * https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
       * </pre>
       *
       * <code>repeated string custom_queries = 4;</code>
       *
       * @param value The bytes of the customQueries to add.
       * @return This builder for chaining.
       */
      public Builder addCustomQueriesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCustomQueriesIsMutable();
        customQueries_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object email_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Jira email address.
       * </pre>
       *
       * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The email.
       */
      public java.lang.String getEmail() {
        java.lang.Object ref = email_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          email_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira email address.
       * </pre>
       *
       * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for email.
       */
      public com.google.protobuf.ByteString getEmailBytes() {
        java.lang.Object ref = email_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          email_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira email address.
       * </pre>
       *
       * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The email to set.
       * @return This builder for chaining.
       */
      public Builder setEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        email_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira email address.
       * </pre>
       *
       * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmail() {
        email_ = getDefaultInstance().getEmail();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira email address.
       * </pre>
       *
       * <code>string email = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for email to set.
       * @return This builder for chaining.
       */
      public Builder setEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        email_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object serverUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Jira server URI.
       * </pre>
       *
       * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The serverUri.
       */
      public java.lang.String getServerUri() {
        java.lang.Object ref = serverUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serverUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira server URI.
       * </pre>
       *
       * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for serverUri.
       */
      public com.google.protobuf.ByteString getServerUriBytes() {
        java.lang.Object ref = serverUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serverUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira server URI.
       * </pre>
       *
       * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The serverUri to set.
       * @return This builder for chaining.
       */
      public Builder setServerUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serverUri_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira server URI.
       * </pre>
       *
       * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServerUri() {
        serverUri_ = getDefaultInstance().getServerUri();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Jira server URI.
       * </pre>
       *
       * <code>string server_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for serverUri to set.
       * @return This builder for chaining.
       */
      public Builder setServerUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serverUri_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig apiKeyConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder>
          apiKeyConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the apiKeyConfig field is set.
       */
      public boolean hasApiKeyConfig() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The apiKeyConfig.
       */
      public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig getApiKeyConfig() {
        if (apiKeyConfigBuilder_ == null) {
          return apiKeyConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
              : apiKeyConfig_;
        } else {
          return apiKeyConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setApiKeyConfig(
          com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig value) {
        if (apiKeyConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          apiKeyConfig_ = value;
        } else {
          apiKeyConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setApiKeyConfig(
          com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder builderForValue) {
        if (apiKeyConfigBuilder_ == null) {
          apiKeyConfig_ = builderForValue.build();
        } else {
          apiKeyConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeApiKeyConfig(
          com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig value) {
        if (apiKeyConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && apiKeyConfig_ != null
              && apiKeyConfig_
                  != com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig
                      .getDefaultInstance()) {
            getApiKeyConfigBuilder().mergeFrom(value);
          } else {
            apiKeyConfig_ = value;
          }
        } else {
          apiKeyConfigBuilder_.mergeFrom(value);
        }
        if (apiKeyConfig_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearApiKeyConfig() {
        bitField0_ = (bitField0_ & ~0x00000010);
        apiKeyConfig_ = null;
        if (apiKeyConfigBuilder_ != null) {
          apiKeyConfigBuilder_.dispose();
          apiKeyConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder
          getApiKeyConfigBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getApiKeyConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder
          getApiKeyConfigOrBuilder() {
        if (apiKeyConfigBuilder_ != null) {
          return apiKeyConfigBuilder_.getMessageOrBuilder();
        } else {
          return apiKeyConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
              : apiKeyConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Jira API key
       * (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig api_key_config = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder>
          getApiKeyConfigFieldBuilder() {
        if (apiKeyConfigBuilder_ == null) {
          apiKeyConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig,
                  com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder>(
                  getApiKeyConfig(), getParentForChildren(), isClean());
          apiKeyConfig_ = null;
        }
        return apiKeyConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries)
    private static final com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries();
    }

    public static com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<JiraQueries> PARSER =
        new com.google.protobuf.AbstractParser<JiraQueries>() {
          @java.lang.Override
          public JiraQueries parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<JiraQueries> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<JiraQueries> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int JIRA_QUERIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries> jiraQueries_;
  /**
   *
   *
   * <pre>
   * Required. The Jira queries.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries>
      getJiraQueriesList() {
    return jiraQueries_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Jira queries.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder>
      getJiraQueriesOrBuilderList() {
    return jiraQueries_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Jira queries.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getJiraQueriesCount() {
    return jiraQueries_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The Jira queries.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries getJiraQueries(int index) {
    return jiraQueries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The Jira queries.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder
      getJiraQueriesOrBuilder(int index) {
    return jiraQueries_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < jiraQueries_.size(); i++) {
      output.writeMessage(1, jiraQueries_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < jiraQueries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, jiraQueries_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.JiraSource)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.JiraSource other =
        (com.google.cloud.aiplatform.v1beta1.JiraSource) obj;

    if (!getJiraQueriesList().equals(other.getJiraQueriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getJiraQueriesCount() > 0) {
      hash = (37 * hash) + JIRA_QUERIES_FIELD_NUMBER;
      hash = (53 * hash) + getJiraQueriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.JiraSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Jira source for the ImportRagFilesRequest.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.JiraSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.JiraSource)
      com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.JiraSource.class,
              com.google.cloud.aiplatform.v1beta1.JiraSource.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.JiraSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (jiraQueriesBuilder_ == null) {
        jiraQueries_ = java.util.Collections.emptyList();
      } else {
        jiraQueries_ = null;
        jiraQueriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_JiraSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource build() {
      com.google.cloud.aiplatform.v1beta1.JiraSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource buildPartial() {
      com.google.cloud.aiplatform.v1beta1.JiraSource result =
          new com.google.cloud.aiplatform.v1beta1.JiraSource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.JiraSource result) {
      if (jiraQueriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          jiraQueries_ = java.util.Collections.unmodifiableList(jiraQueries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.jiraQueries_ = jiraQueries_;
      } else {
        result.jiraQueries_ = jiraQueriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.JiraSource result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.JiraSource) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.JiraSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.JiraSource other) {
      if (other == com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance()) return this;
      if (jiraQueriesBuilder_ == null) {
        if (!other.jiraQueries_.isEmpty()) {
          if (jiraQueries_.isEmpty()) {
            jiraQueries_ = other.jiraQueries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureJiraQueriesIsMutable();
            jiraQueries_.addAll(other.jiraQueries_);
          }
          onChanged();
        }
      } else {
        if (!other.jiraQueries_.isEmpty()) {
          if (jiraQueriesBuilder_.isEmpty()) {
            jiraQueriesBuilder_.dispose();
            jiraQueriesBuilder_ = null;
            jiraQueries_ = other.jiraQueries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            jiraQueriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getJiraQueriesFieldBuilder()
                    : null;
          } else {
            jiraQueriesBuilder_.addAllMessages(other.jiraQueries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.parser(),
                        extensionRegistry);
                if (jiraQueriesBuilder_ == null) {
                  ensureJiraQueriesIsMutable();
                  jiraQueries_.add(m);
                } else {
                  jiraQueriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries>
        jiraQueries_ = java.util.Collections.emptyList();

    private void ensureJiraQueriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        jiraQueries_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries>(
                jiraQueries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries,
            com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder>
        jiraQueriesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries>
        getJiraQueriesList() {
      if (jiraQueriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(jiraQueries_);
      } else {
        return jiraQueriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getJiraQueriesCount() {
      if (jiraQueriesBuilder_ == null) {
        return jiraQueries_.size();
      } else {
        return jiraQueriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries getJiraQueries(int index) {
      if (jiraQueriesBuilder_ == null) {
        return jiraQueries_.get(index);
      } else {
        return jiraQueriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setJiraQueries(
        int index, com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries value) {
      if (jiraQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJiraQueriesIsMutable();
        jiraQueries_.set(index, value);
        onChanged();
      } else {
        jiraQueriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setJiraQueries(
        int index,
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder builderForValue) {
      if (jiraQueriesBuilder_ == null) {
        ensureJiraQueriesIsMutable();
        jiraQueries_.set(index, builderForValue.build());
        onChanged();
      } else {
        jiraQueriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJiraQueries(
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries value) {
      if (jiraQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJiraQueriesIsMutable();
        jiraQueries_.add(value);
        onChanged();
      } else {
        jiraQueriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJiraQueries(
        int index, com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries value) {
      if (jiraQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJiraQueriesIsMutable();
        jiraQueries_.add(index, value);
        onChanged();
      } else {
        jiraQueriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJiraQueries(
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder builderForValue) {
      if (jiraQueriesBuilder_ == null) {
        ensureJiraQueriesIsMutable();
        jiraQueries_.add(builderForValue.build());
        onChanged();
      } else {
        jiraQueriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJiraQueries(
        int index,
        com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder builderForValue) {
      if (jiraQueriesBuilder_ == null) {
        ensureJiraQueriesIsMutable();
        jiraQueries_.add(index, builderForValue.build());
        onChanged();
      } else {
        jiraQueriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllJiraQueries(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries>
            values) {
      if (jiraQueriesBuilder_ == null) {
        ensureJiraQueriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jiraQueries_);
        onChanged();
      } else {
        jiraQueriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearJiraQueries() {
      if (jiraQueriesBuilder_ == null) {
        jiraQueries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        jiraQueriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeJiraQueries(int index) {
      if (jiraQueriesBuilder_ == null) {
        ensureJiraQueriesIsMutable();
        jiraQueries_.remove(index);
        onChanged();
      } else {
        jiraQueriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder getJiraQueriesBuilder(
        int index) {
      return getJiraQueriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder
        getJiraQueriesOrBuilder(int index) {
      if (jiraQueriesBuilder_ == null) {
        return jiraQueries_.get(index);
      } else {
        return jiraQueriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder>
        getJiraQueriesOrBuilderList() {
      if (jiraQueriesBuilder_ != null) {
        return jiraQueriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(jiraQueries_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder
        addJiraQueriesBuilder() {
      return getJiraQueriesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder addJiraQueriesBuilder(
        int index) {
      return getJiraQueriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Jira queries.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries jira_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder>
        getJiraQueriesBuilderList() {
      return getJiraQueriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries,
            com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder>
        getJiraQueriesFieldBuilder() {
      if (jiraQueriesBuilder_ == null) {
        jiraQueriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries,
                com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.Builder,
                com.google.cloud.aiplatform.v1beta1.JiraSource.JiraQueriesOrBuilder>(
                jiraQueries_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        jiraQueries_ = null;
      }
      return jiraQueriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.JiraSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.JiraSource)
  private static final com.google.cloud.aiplatform.v1beta1.JiraSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.JiraSource();
  }

  public static com.google.cloud.aiplatform.v1beta1.JiraSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JiraSource> PARSER =
      new com.google.protobuf.AbstractParser<JiraSource>() {
        @java.lang.Override
        public JiraSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JiraSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JiraSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
