/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/featurestore.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Vertex AI Feature Store provides a centralized repository for organizing,
 * storing, and serving ML features. The Featurestore is a top-level container
 * for your features and their values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Featurestore}
 */
public final class Featurestore extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Featurestore)
    FeaturestoreOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Featurestore.newBuilder() to construct.
  private Featurestore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Featurestore() {
    name_ = "";
    etag_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Featurestore();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
        .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
        .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Featurestore.class,
            com.google.cloud.aiplatform.v1beta1.Featurestore.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states a featurestore can have.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.Featurestore.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * State when the featurestore configuration is not being updated and the
     * fields reflect the current configuration of the featurestore. The
     * featurestore is usable in this state.
     * </pre>
     *
     * <code>STABLE = 1;</code>
     */
    STABLE(1),
    /**
     *
     *
     * <pre>
     * The state of the featurestore configuration when it is being updated.
     * During an update, the fields reflect either the original configuration
     * or the updated configuration of the featurestore. For example,
     * `online_serving_config.fixed_node_count` can take minutes to update.
     * While the update is in progress, the featurestore is in the UPDATING
     * state, and the value of `fixed_node_count` can be the original value or
     * the updated value, depending on the progress of the operation. Until the
     * update completes, the actual number of nodes can still be the original
     * value of `fixed_node_count`. The featurestore is still usable in this
     * state.
     * </pre>
     *
     * <code>UPDATING = 2;</code>
     */
    UPDATING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * State when the featurestore configuration is not being updated and the
     * fields reflect the current configuration of the featurestore. The
     * featurestore is usable in this state.
     * </pre>
     *
     * <code>STABLE = 1;</code>
     */
    public static final int STABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The state of the featurestore configuration when it is being updated.
     * During an update, the fields reflect either the original configuration
     * or the updated configuration of the featurestore. For example,
     * `online_serving_config.fixed_node_count` can take minutes to update.
     * While the update is in progress, the featurestore is in the UPDATING
     * state, and the value of `fixed_node_count` can be the original value or
     * the updated value, depending on the progress of the operation. Until the
     * update completes, the actual number of nodes can still be the original
     * value of `fixed_node_count`. The featurestore is still usable in this
     * state.
     * </pre>
     *
     * <code>UPDATING = 2;</code>
     */
    public static final int UPDATING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STABLE;
        case 2:
          return UPDATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Featurestore.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.Featurestore.State)
  }

  public interface OnlineServingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of nodes for the online store. The number of nodes doesn't
     * scale automatically, but you can manually update the number of
     * nodes. If set to 0, the featurestore will not have an
     * online store and cannot be used for online serving.
     * </pre>
     *
     * <code>int32 fixed_node_count = 2;</code>
     *
     * @return The fixedNodeCount.
     */
    int getFixedNodeCount();

    /**
     *
     *
     * <pre>
     * Online serving scaling configuration.
     * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
     * reset the other.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
     * </code>
     *
     * @return Whether the scaling field is set.
     */
    boolean hasScaling();
    /**
     *
     *
     * <pre>
     * Online serving scaling configuration.
     * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
     * reset the other.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
     * </code>
     *
     * @return The scaling.
     */
    com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling getScaling();
    /**
     *
     *
     * <pre>
     * Online serving scaling configuration.
     * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
     * reset the other.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.ScalingOrBuilder
        getScalingOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * OnlineServingConfig specifies the details for provisioning online serving
   * resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig}
   */
  public static final class OnlineServingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig)
      OnlineServingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OnlineServingConfig.newBuilder() to construct.
    private OnlineServingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OnlineServingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OnlineServingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.class,
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder.class);
    }

    public interface ScalingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The minimum number of nodes to scale down to. Must be greater
       * than or equal to 1.
       * </pre>
       *
       * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minNodeCount.
       */
      int getMinNodeCount();

      /**
       *
       *
       * <pre>
       * The maximum number of nodes to scale up to. Must be greater than
       * min_node_count, and less than or equal to 10 times of 'min_node_count'.
       * </pre>
       *
       * <code>int32 max_node_count = 2;</code>
       *
       * @return The maxNodeCount.
       */
      int getMaxNodeCount();

      /**
       *
       *
       * <pre>
       * Optional. The cpu utilization that the Autoscaler should be trying to
       * achieve. This number is on a scale from 0 (no utilization) to 100
       * (total utilization), and is limited between 10 and 80. When a cluster's
       * CPU utilization exceeds the target that you have set, Bigtable
       * immediately adds nodes to the cluster. When CPU utilization is
       * substantially lower than the target, Bigtable removes nodes. If not set
       * or set to 0, default to 50.
       * </pre>
       *
       * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpuUtilizationTarget.
       */
      int getCpuUtilizationTarget();
    }
    /**
     *
     *
     * <pre>
     * Online serving scaling configuration. If min_node_count and
     * max_node_count are set to the same value, the cluster will be configured
     * with the fixed number of node (no auto-scaling).
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling}
     */
    public static final class Scaling extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)
        ScalingOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Scaling.newBuilder() to construct.
      private Scaling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Scaling() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Scaling();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_Scaling_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_Scaling_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.class,
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.Builder
                    .class);
      }

      public static final int MIN_NODE_COUNT_FIELD_NUMBER = 1;
      private int minNodeCount_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The minimum number of nodes to scale down to. Must be greater
       * than or equal to 1.
       * </pre>
       *
       * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minNodeCount.
       */
      @java.lang.Override
      public int getMinNodeCount() {
        return minNodeCount_;
      }

      public static final int MAX_NODE_COUNT_FIELD_NUMBER = 2;
      private int maxNodeCount_ = 0;
      /**
       *
       *
       * <pre>
       * The maximum number of nodes to scale up to. Must be greater than
       * min_node_count, and less than or equal to 10 times of 'min_node_count'.
       * </pre>
       *
       * <code>int32 max_node_count = 2;</code>
       *
       * @return The maxNodeCount.
       */
      @java.lang.Override
      public int getMaxNodeCount() {
        return maxNodeCount_;
      }

      public static final int CPU_UTILIZATION_TARGET_FIELD_NUMBER = 3;
      private int cpuUtilizationTarget_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The cpu utilization that the Autoscaler should be trying to
       * achieve. This number is on a scale from 0 (no utilization) to 100
       * (total utilization), and is limited between 10 and 80. When a cluster's
       * CPU utilization exceeds the target that you have set, Bigtable
       * immediately adds nodes to the cluster. When CPU utilization is
       * substantially lower than the target, Bigtable removes nodes. If not set
       * or set to 0, default to 50.
       * </pre>
       *
       * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpuUtilizationTarget.
       */
      @java.lang.Override
      public int getCpuUtilizationTarget() {
        return cpuUtilizationTarget_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (minNodeCount_ != 0) {
          output.writeInt32(1, minNodeCount_);
        }
        if (maxNodeCount_ != 0) {
          output.writeInt32(2, maxNodeCount_);
        }
        if (cpuUtilizationTarget_ != 0) {
          output.writeInt32(3, cpuUtilizationTarget_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (minNodeCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, minNodeCount_);
        }
        if (maxNodeCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxNodeCount_);
        }
        if (cpuUtilizationTarget_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, cpuUtilizationTarget_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling other =
            (com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling) obj;

        if (getMinNodeCount() != other.getMinNodeCount()) return false;
        if (getMaxNodeCount() != other.getMaxNodeCount()) return false;
        if (getCpuUtilizationTarget() != other.getCpuUtilizationTarget()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_NODE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMinNodeCount();
        hash = (37 * hash) + MAX_NODE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxNodeCount();
        hash = (37 * hash) + CPU_UTILIZATION_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getCpuUtilizationTarget();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration. If min_node_count and
       * max_node_count are set to the same value, the cluster will be configured
       * with the fixed number of node (no auto-scaling).
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.ScalingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
              .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_Scaling_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
              .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_Scaling_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                      .class,
                  com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          minNodeCount_ = 0;
          maxNodeCount_ = 0;
          cpuUtilizationTarget_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
              .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_Scaling_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
            build() {
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling result =
              new com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.minNodeCount_ = minNodeCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxNodeCount_ = maxNodeCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.cpuUtilizationTarget_ = cpuUtilizationTarget_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                  .getDefaultInstance()) return this;
          if (other.getMinNodeCount() != 0) {
            setMinNodeCount(other.getMinNodeCount());
          }
          if (other.getMaxNodeCount() != 0) {
            setMaxNodeCount(other.getMaxNodeCount());
          }
          if (other.getCpuUtilizationTarget() != 0) {
            setCpuUtilizationTarget(other.getCpuUtilizationTarget());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    minNodeCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    maxNodeCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    cpuUtilizationTarget_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int minNodeCount_;
        /**
         *
         *
         * <pre>
         * Required. The minimum number of nodes to scale down to. Must be greater
         * than or equal to 1.
         * </pre>
         *
         * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The minNodeCount.
         */
        @java.lang.Override
        public int getMinNodeCount() {
          return minNodeCount_;
        }
        /**
         *
         *
         * <pre>
         * Required. The minimum number of nodes to scale down to. Must be greater
         * than or equal to 1.
         * </pre>
         *
         * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The minNodeCount to set.
         * @return This builder for chaining.
         */
        public Builder setMinNodeCount(int value) {

          minNodeCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The minimum number of nodes to scale down to. Must be greater
         * than or equal to 1.
         * </pre>
         *
         * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinNodeCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          minNodeCount_ = 0;
          onChanged();
          return this;
        }

        private int maxNodeCount_;
        /**
         *
         *
         * <pre>
         * The maximum number of nodes to scale up to. Must be greater than
         * min_node_count, and less than or equal to 10 times of 'min_node_count'.
         * </pre>
         *
         * <code>int32 max_node_count = 2;</code>
         *
         * @return The maxNodeCount.
         */
        @java.lang.Override
        public int getMaxNodeCount() {
          return maxNodeCount_;
        }
        /**
         *
         *
         * <pre>
         * The maximum number of nodes to scale up to. Must be greater than
         * min_node_count, and less than or equal to 10 times of 'min_node_count'.
         * </pre>
         *
         * <code>int32 max_node_count = 2;</code>
         *
         * @param value The maxNodeCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxNodeCount(int value) {

          maxNodeCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The maximum number of nodes to scale up to. Must be greater than
         * min_node_count, and less than or equal to 10 times of 'min_node_count'.
         * </pre>
         *
         * <code>int32 max_node_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxNodeCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxNodeCount_ = 0;
          onChanged();
          return this;
        }

        private int cpuUtilizationTarget_;
        /**
         *
         *
         * <pre>
         * Optional. The cpu utilization that the Autoscaler should be trying to
         * achieve. This number is on a scale from 0 (no utilization) to 100
         * (total utilization), and is limited between 10 and 80. When a cluster's
         * CPU utilization exceeds the target that you have set, Bigtable
         * immediately adds nodes to the cluster. When CPU utilization is
         * substantially lower than the target, Bigtable removes nodes. If not set
         * or set to 0, default to 50.
         * </pre>
         *
         * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The cpuUtilizationTarget.
         */
        @java.lang.Override
        public int getCpuUtilizationTarget() {
          return cpuUtilizationTarget_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The cpu utilization that the Autoscaler should be trying to
         * achieve. This number is on a scale from 0 (no utilization) to 100
         * (total utilization), and is limited between 10 and 80. When a cluster's
         * CPU utilization exceeds the target that you have set, Bigtable
         * immediately adds nodes to the cluster. When CPU utilization is
         * substantially lower than the target, Bigtable removes nodes. If not set
         * or set to 0, default to 50.
         * </pre>
         *
         * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The cpuUtilizationTarget to set.
         * @return This builder for chaining.
         */
        public Builder setCpuUtilizationTarget(int value) {

          cpuUtilizationTarget_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The cpu utilization that the Autoscaler should be trying to
         * achieve. This number is on a scale from 0 (no utilization) to 100
         * (total utilization), and is limited between 10 and 80. When a cluster's
         * CPU utilization exceeds the target that you have set, Bigtable
         * immediately adds nodes to the cluster. When CPU utilization is
         * substantially lower than the target, Bigtable removes nodes. If not set
         * or set to 0, default to 50.
         * </pre>
         *
         * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCpuUtilizationTarget() {
          bitField0_ = (bitField0_ & ~0x00000004);
          cpuUtilizationTarget_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling)
      private static final com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
              .Scaling
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling();
      }

      public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Scaling> PARSER =
          new com.google.protobuf.AbstractParser<Scaling>() {
            @java.lang.Override
            public Scaling parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Scaling> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Scaling> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int FIXED_NODE_COUNT_FIELD_NUMBER = 2;
    private int fixedNodeCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of nodes for the online store. The number of nodes doesn't
     * scale automatically, but you can manually update the number of
     * nodes. If set to 0, the featurestore will not have an
     * online store and cannot be used for online serving.
     * </pre>
     *
     * <code>int32 fixed_node_count = 2;</code>
     *
     * @return The fixedNodeCount.
     */
    @java.lang.Override
    public int getFixedNodeCount() {
      return fixedNodeCount_;
    }

    public static final int SCALING_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling_;
    /**
     *
     *
     * <pre>
     * Online serving scaling configuration.
     * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
     * reset the other.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
     * </code>
     *
     * @return Whether the scaling field is set.
     */
    @java.lang.Override
    public boolean hasScaling() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Online serving scaling configuration.
     * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
     * reset the other.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
     * </code>
     *
     * @return The scaling.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
        getScaling() {
      return scaling_ == null
          ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
              .getDefaultInstance()
          : scaling_;
    }
    /**
     *
     *
     * <pre>
     * Online serving scaling configuration.
     * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
     * reset the other.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.ScalingOrBuilder
        getScalingOrBuilder() {
      return scaling_ == null
          ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
              .getDefaultInstance()
          : scaling_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (fixedNodeCount_ != 0) {
        output.writeInt32(2, fixedNodeCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getScaling());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (fixedNodeCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, fixedNodeCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getScaling());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig other =
          (com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig) obj;

      if (getFixedNodeCount() != other.getFixedNodeCount()) return false;
      if (hasScaling() != other.hasScaling()) return false;
      if (hasScaling()) {
        if (!getScaling().equals(other.getScaling())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIXED_NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getFixedNodeCount();
      if (hasScaling()) {
        hash = (37 * hash) + SCALING_FIELD_NUMBER;
        hash = (53 * hash) + getScaling().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * OnlineServingConfig specifies the details for provisioning online serving
     * resources.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig)
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.class,
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getScalingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        fixedNodeCount_ = 0;
        scaling_ = null;
        if (scalingBuilder_ != null) {
          scalingBuilder_.dispose();
          scalingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_OnlineServingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig build() {
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig result =
            new com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.fixedNodeCount_ = fixedNodeCount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.scaling_ = scalingBuilder_ == null ? scaling_ : scalingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
                .getDefaultInstance()) return this;
        if (other.getFixedNodeCount() != 0) {
          setFixedNodeCount(other.getFixedNodeCount());
        }
        if (other.hasScaling()) {
          mergeScaling(other.getScaling());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  fixedNodeCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 34:
                {
                  input.readMessage(getScalingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int fixedNodeCount_;
      /**
       *
       *
       * <pre>
       * The number of nodes for the online store. The number of nodes doesn't
       * scale automatically, but you can manually update the number of
       * nodes. If set to 0, the featurestore will not have an
       * online store and cannot be used for online serving.
       * </pre>
       *
       * <code>int32 fixed_node_count = 2;</code>
       *
       * @return The fixedNodeCount.
       */
      @java.lang.Override
      public int getFixedNodeCount() {
        return fixedNodeCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes for the online store. The number of nodes doesn't
       * scale automatically, but you can manually update the number of
       * nodes. If set to 0, the featurestore will not have an
       * online store and cannot be used for online serving.
       * </pre>
       *
       * <code>int32 fixed_node_count = 2;</code>
       *
       * @param value The fixedNodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setFixedNodeCount(int value) {

        fixedNodeCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes for the online store. The number of nodes doesn't
       * scale automatically, but you can manually update the number of
       * nodes. If set to 0, the featurestore will not have an
       * online store and cannot be used for online serving.
       * </pre>
       *
       * <code>int32 fixed_node_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFixedNodeCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        fixedNodeCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling,
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.Builder,
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.ScalingOrBuilder>
          scalingBuilder_;
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       *
       * @return Whether the scaling field is set.
       */
      public boolean hasScaling() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       *
       * @return The scaling.
       */
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
          getScaling() {
        if (scalingBuilder_ == null) {
          return scaling_ == null
              ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                  .getDefaultInstance()
              : scaling_;
        } else {
          return scalingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      public Builder setScaling(
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling value) {
        if (scalingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scaling_ = value;
        } else {
          scalingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      public Builder setScaling(
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.Builder
              builderForValue) {
        if (scalingBuilder_ == null) {
          scaling_ = builderForValue.build();
        } else {
          scalingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      public Builder mergeScaling(
          com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling value) {
        if (scalingBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && scaling_ != null
              && scaling_
                  != com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                      .getDefaultInstance()) {
            getScalingBuilder().mergeFrom(value);
          } else {
            scaling_ = value;
          }
        } else {
          scalingBuilder_.mergeFrom(value);
        }
        if (scaling_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      public Builder clearScaling() {
        bitField0_ = (bitField0_ & ~0x00000002);
        scaling_ = null;
        if (scalingBuilder_ != null) {
          scalingBuilder_.dispose();
          scalingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.Builder
          getScalingBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getScalingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.ScalingOrBuilder
          getScalingOrBuilder() {
        if (scalingBuilder_ != null) {
          return scalingBuilder_.getMessageOrBuilder();
        } else {
          return scaling_ == null
              ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                  .getDefaultInstance()
              : scaling_;
        }
      }
      /**
       *
       *
       * <pre>
       * Online serving scaling configuration.
       * Only one of `fixed_node_count` and `scaling` can be set. Setting one will
       * reset the other.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling scaling = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling,
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling.Builder,
              com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.ScalingOrBuilder>
          getScalingFieldBuilder() {
        if (scalingBuilder_ == null) {
          scalingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling,
                  com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Scaling
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
                      .ScalingOrBuilder>(getScaling(), getParentForChildren(), isClean());
          scaling_ = null;
        }
        return scalingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig)
    private static final com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OnlineServingConfig> PARSER =
        new com.google.protobuf.AbstractParser<OnlineServingConfig>() {
          @java.lang.Override
          public OnlineServingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OnlineServingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OnlineServingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the Featurestore. Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the Featurestore. Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Featurestore was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Featurestore was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Featurestore was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Featurestore was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Featurestore was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Featurestore was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
                .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * Featurestore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Featurestore(System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * Featurestore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Featurestore(System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * Featurestore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Featurestore(System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * Featurestore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Featurestore(System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ONLINE_SERVING_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig onlineServingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Config for online storage resources. The field should not
   * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
   * and OnlineStoreReplicationConfig are unset, the feature store will not have
   * an online store and cannot be used for online serving.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the onlineServingConfig field is set.
   */
  @java.lang.Override
  public boolean hasOnlineServingConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Config for online storage resources. The field should not
   * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
   * and OnlineStoreReplicationConfig are unset, the feature store will not have
   * an online store and cannot be used for online serving.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The onlineServingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
      getOnlineServingConfig() {
    return onlineServingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.getDefaultInstance()
        : onlineServingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Config for online storage resources. The field should not
   * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
   * and OnlineStoreReplicationConfig are unset, the feature store will not have
   * an online store and cannot be used for online serving.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfigOrBuilder
      getOnlineServingConfigOrBuilder() {
    return onlineServingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.getDefaultInstance()
        : onlineServingConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the featurestore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the featurestore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Featurestore.State getState() {
    com.google.cloud.aiplatform.v1beta1.Featurestore.State result =
        com.google.cloud.aiplatform.v1beta1.Featurestore.State.forNumber(state_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.Featurestore.State.UNRECOGNIZED
        : result;
  }

  public static final int ONLINE_STORAGE_TTL_DAYS_FIELD_NUMBER = 13;
  private int onlineStorageTtlDays_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. TTL in days for feature values that will be stored in online
   * serving storage. The Feature Store online storage periodically removes
   * obsolete feature values older than `online_storage_ttl_days` since the
   * feature generation time. Note that `online_storage_ttl_days` should be less
   * than or equal to `offline_storage_ttl_days` for each EntityType under a
   * featurestore. If not set, default to 4000 days
   * </pre>
   *
   * <code>int32 online_storage_ttl_days = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The onlineStorageTtlDays.
   */
  @java.lang.Override
  public int getOnlineStorageTtlDays() {
    return onlineStorageTtlDays_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 10;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Customer-managed encryption key spec for data storage. If set,
   * both of the online and offline data storage will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Customer-managed encryption key spec for data storage. If set,
   * both of the online and offline data storage will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Customer-managed encryption key spec for data storage. If set,
   * both of the online and offline data storage will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 14;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 15;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getOnlineServingConfig());
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.Featurestore.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getEncryptionSpec());
    }
    if (onlineStorageTtlDays_ != 0) {
      output.writeInt32(13, onlineStorageTtlDays_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(14, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(15, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOnlineServingConfig());
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.Featurestore.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getEncryptionSpec());
    }
    if (onlineStorageTtlDays_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, onlineStorageTtlDays_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Featurestore)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Featurestore other =
        (com.google.cloud.aiplatform.v1beta1.Featurestore) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasOnlineServingConfig() != other.hasOnlineServingConfig()) return false;
    if (hasOnlineServingConfig()) {
      if (!getOnlineServingConfig().equals(other.getOnlineServingConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (getOnlineStorageTtlDays() != other.getOnlineStorageTtlDays()) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasOnlineServingConfig()) {
      hash = (37 * hash) + ONLINE_SERVING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOnlineServingConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ONLINE_STORAGE_TTL_DAYS_FIELD_NUMBER;
    hash = (53 * hash) + getOnlineStorageTtlDays();
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Featurestore prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Feature Store provides a centralized repository for organizing,
   * storing, and serving ML features. The Featurestore is a top-level container
   * for your features and their values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Featurestore}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Featurestore)
      com.google.cloud.aiplatform.v1beta1.FeaturestoreOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Featurestore.class,
              com.google.cloud.aiplatform.v1beta1.Featurestore.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Featurestore.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getOnlineServingConfigFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      internalGetMutableLabels().clear();
      onlineServingConfig_ = null;
      if (onlineServingConfigBuilder_ != null) {
        onlineServingConfigBuilder_.dispose();
        onlineServingConfigBuilder_ = null;
      }
      state_ = 0;
      onlineStorageTtlDays_ = 0;
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_Featurestore_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Featurestore.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore build() {
      com.google.cloud.aiplatform.v1beta1.Featurestore result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Featurestore result =
          new com.google.cloud.aiplatform.v1beta1.Featurestore(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Featurestore result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.onlineServingConfig_ =
            onlineServingConfigBuilder_ == null
                ? onlineServingConfig_
                : onlineServingConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.onlineStorageTtlDays_ = onlineStorageTtlDays_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Featurestore) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Featurestore) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Featurestore other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Featurestore.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.hasOnlineServingConfig()) {
        mergeOnlineServingConfig(other.getOnlineServingConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getOnlineStorageTtlDays() != 0) {
        setOnlineStorageTtlDays(other.getOnlineStorageTtlDays());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getOnlineServingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 82:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 104:
              {
                onlineStorageTtlDays_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 104
            case 112:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 112
            case 120:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 120
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the Featurestore. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the Featurestore. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the Featurestore. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the Featurestore. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the Featurestore. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Featurestore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * Featurestore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Featurestore(System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        onlineServingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig,
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfigOrBuilder>
        onlineServingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the onlineServingConfig field is set.
     */
    public boolean hasOnlineServingConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The onlineServingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
        getOnlineServingConfig() {
      if (onlineServingConfigBuilder_ == null) {
        return onlineServingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
                .getDefaultInstance()
            : onlineServingConfig_;
      } else {
        return onlineServingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOnlineServingConfig(
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig value) {
      if (onlineServingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onlineServingConfig_ = value;
      } else {
        onlineServingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOnlineServingConfig(
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder
            builderForValue) {
      if (onlineServingConfigBuilder_ == null) {
        onlineServingConfig_ = builderForValue.build();
      } else {
        onlineServingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOnlineServingConfig(
        com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig value) {
      if (onlineServingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && onlineServingConfig_ != null
            && onlineServingConfig_
                != com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
                    .getDefaultInstance()) {
          getOnlineServingConfigBuilder().mergeFrom(value);
        } else {
          onlineServingConfig_ = value;
        }
      } else {
        onlineServingConfigBuilder_.mergeFrom(value);
      }
      if (onlineServingConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOnlineServingConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      onlineServingConfig_ = null;
      if (onlineServingConfigBuilder_ != null) {
        onlineServingConfigBuilder_.dispose();
        onlineServingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder
        getOnlineServingConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getOnlineServingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfigOrBuilder
        getOnlineServingConfigOrBuilder() {
      if (onlineServingConfigBuilder_ != null) {
        return onlineServingConfigBuilder_.getMessageOrBuilder();
      } else {
        return onlineServingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig
                .getDefaultInstance()
            : onlineServingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for online storage resources. The field should not
     * co-exist with the field of `OnlineStoreReplicationConfig`. If both of it
     * and OnlineStoreReplicationConfig are unset, the feature store will not have
     * an online store and cannot be used for online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig online_serving_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig,
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfigOrBuilder>
        getOnlineServingConfigFieldBuilder() {
      if (onlineServingConfigBuilder_ == null) {
        onlineServingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig,
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.Featurestore.OnlineServingConfigOrBuilder>(
                getOnlineServingConfig(), getParentForChildren(), isClean());
        onlineServingConfig_ = null;
      }
      return onlineServingConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the featurestore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featurestore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featurestore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Featurestore.State getState() {
      com.google.cloud.aiplatform.v1beta1.Featurestore.State result =
          com.google.cloud.aiplatform.v1beta1.Featurestore.State.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.Featurestore.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featurestore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.Featurestore.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featurestore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Featurestore.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      state_ = 0;
      onChanged();
      return this;
    }

    private int onlineStorageTtlDays_;
    /**
     *
     *
     * <pre>
     * Optional. TTL in days for feature values that will be stored in online
     * serving storage. The Feature Store online storage periodically removes
     * obsolete feature values older than `online_storage_ttl_days` since the
     * feature generation time. Note that `online_storage_ttl_days` should be less
     * than or equal to `offline_storage_ttl_days` for each EntityType under a
     * featurestore. If not set, default to 4000 days
     * </pre>
     *
     * <code>int32 online_storage_ttl_days = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The onlineStorageTtlDays.
     */
    @java.lang.Override
    public int getOnlineStorageTtlDays() {
      return onlineStorageTtlDays_;
    }
    /**
     *
     *
     * <pre>
     * Optional. TTL in days for feature values that will be stored in online
     * serving storage. The Feature Store online storage periodically removes
     * obsolete feature values older than `online_storage_ttl_days` since the
     * feature generation time. Note that `online_storage_ttl_days` should be less
     * than or equal to `offline_storage_ttl_days` for each EntityType under a
     * featurestore. If not set, default to 4000 days
     * </pre>
     *
     * <code>int32 online_storage_ttl_days = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The onlineStorageTtlDays to set.
     * @return This builder for chaining.
     */
    public Builder setOnlineStorageTtlDays(int value) {

      onlineStorageTtlDays_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. TTL in days for feature values that will be stored in online
     * serving storage. The Feature Store online storage periodically removes
     * obsolete feature values older than `online_storage_ttl_days` since the
     * feature generation time. Note that `online_storage_ttl_days` should be less
     * than or equal to `offline_storage_ttl_days` for each EntityType under a
     * featurestore. If not set, default to 4000 days
     * </pre>
     *
     * <code>int32 online_storage_ttl_days = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOnlineStorageTtlDays() {
      bitField0_ = (bitField0_ & ~0x00000080);
      onlineStorageTtlDays_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000100);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for data storage. If set,
     * both of the online and offline data storage will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000200);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00000400);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Featurestore)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Featurestore)
  private static final com.google.cloud.aiplatform.v1beta1.Featurestore DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Featurestore();
  }

  public static com.google.cloud.aiplatform.v1beta1.Featurestore getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Featurestore> PARSER =
      new com.google.protobuf.AbstractParser<Featurestore>() {
        @java.lang.Override
        public Featurestore parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Featurestore> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Featurestore> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Featurestore getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
