/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/extension_execution_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ExtensionExecutionService.ExecuteExtension][google.cloud.aiplatform.v1beta1.ExtensionExecutionService.ExecuteExtension].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest}
 */
public final class ExecuteExtensionRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest)
    ExecuteExtensionRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecuteExtensionRequest.newBuilder() to construct.
  private ExecuteExtensionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecuteExtensionRequest() {
    name_ = "";
    operationId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecuteExtensionRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExecuteExtensionRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExecuteExtensionRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.class,
            com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name (identifier) of the extension;
   * Format:
   * `projects/{project}/locations/{location}/extensions/{extension}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name (identifier) of the extension;
   * Format:
   * `projects/{project}/locations/{location}/extensions/{extension}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The desired ID of the operation to be executed in this extension
   *  as defined in
   *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
   * </pre>
   *
   * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The operationId.
   */
  @java.lang.Override
  public java.lang.String getOperationId() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The desired ID of the operation to be executed in this extension
   *  as defined in
   *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
   * </pre>
   *
   * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for operationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationIdBytes() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_PARAMS_FIELD_NUMBER = 3;
  private com.google.protobuf.Struct operationParams_;
  /**
   *
   *
   * <pre>
   * Optional. Request parameters that will be used for executing this
   * operation.
   *
   * The struct should be in a form of map with param name as the key and actual
   * param value as the value.
   * E.g. If this operation requires a param "name" to be set to "abc". you can
   * set this to something like {"name": "abc"}.
   * </pre>
   *
   * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the operationParams field is set.
   */
  @java.lang.Override
  public boolean hasOperationParams() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Request parameters that will be used for executing this
   * operation.
   *
   * The struct should be in a form of map with param name as the key and actual
   * param value as the value.
   * E.g. If this operation requires a param "name" to be set to "abc". you can
   * set this to something like {"name": "abc"}.
   * </pre>
   *
   * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The operationParams.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getOperationParams() {
    return operationParams_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : operationParams_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Request parameters that will be used for executing this
   * operation.
   *
   * The struct should be in a form of map with param name as the key and actual
   * param value as the value.
   * E.g. If this operation requires a param "name" to be set to "abc". you can
   * set this to something like {"name": "abc"}.
   * </pre>
   *
   * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getOperationParamsOrBuilder() {
    return operationParams_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : operationParams_;
  }

  public static final int RUNTIME_AUTH_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.AuthConfig runtimeAuthConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Auth config provided at runtime to override the default value in
   * [Extension.manifest.auth_config][].
   * The AuthConfig.auth_type should match the value in
   * [Extension.manifest.auth_config][].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runtimeAuthConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeAuthConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Auth config provided at runtime to override the default value in
   * [Extension.manifest.auth_config][].
   * The AuthConfig.auth_type should match the value in
   * [Extension.manifest.auth_config][].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runtimeAuthConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig getRuntimeAuthConfig() {
    return runtimeAuthConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance()
        : runtimeAuthConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Auth config provided at runtime to override the default value in
   * [Extension.manifest.auth_config][].
   * The AuthConfig.auth_type should match the value in
   * [Extension.manifest.auth_config][].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfigOrBuilder getRuntimeAuthConfigOrBuilder() {
    return runtimeAuthConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance()
        : runtimeAuthConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, operationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getOperationParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getRuntimeAuthConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, operationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOperationParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRuntimeAuthConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest other =
        (com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getOperationId().equals(other.getOperationId())) return false;
    if (hasOperationParams() != other.hasOperationParams()) return false;
    if (hasOperationParams()) {
      if (!getOperationParams().equals(other.getOperationParams())) return false;
    }
    if (hasRuntimeAuthConfig() != other.hasRuntimeAuthConfig()) return false;
    if (hasRuntimeAuthConfig()) {
      if (!getRuntimeAuthConfig().equals(other.getRuntimeAuthConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + OPERATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOperationId().hashCode();
    if (hasOperationParams()) {
      hash = (37 * hash) + OPERATION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getOperationParams().hashCode();
    }
    if (hasRuntimeAuthConfig()) {
      hash = (37 * hash) + RUNTIME_AUTH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeAuthConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ExtensionExecutionService.ExecuteExtension][google.cloud.aiplatform.v1beta1.ExtensionExecutionService.ExecuteExtension].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest)
      com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExecuteExtensionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExecuteExtensionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.class,
              com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOperationParamsFieldBuilder();
        getRuntimeAuthConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      operationId_ = "";
      operationParams_ = null;
      if (operationParamsBuilder_ != null) {
        operationParamsBuilder_.dispose();
        operationParamsBuilder_ = null;
      }
      runtimeAuthConfig_ = null;
      if (runtimeAuthConfigBuilder_ != null) {
        runtimeAuthConfigBuilder_.dispose();
        runtimeAuthConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExecuteExtensionRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest build() {
      com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest result =
          new com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.operationId_ = operationId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationParams_ =
            operationParamsBuilder_ == null ? operationParams_ : operationParamsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.runtimeAuthConfig_ =
            runtimeAuthConfigBuilder_ == null
                ? runtimeAuthConfig_
                : runtimeAuthConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getOperationId().isEmpty()) {
        operationId_ = other.operationId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasOperationParams()) {
        mergeOperationParams(other.getOperationParams());
      }
      if (other.hasRuntimeAuthConfig()) {
        mergeRuntimeAuthConfig(other.getRuntimeAuthConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                operationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getOperationParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getRuntimeAuthConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name (identifier) of the extension;
     * Format:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name (identifier) of the extension;
     * Format:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name (identifier) of the extension;
     * Format:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name (identifier) of the extension;
     * Format:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name (identifier) of the extension;
     * Format:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object operationId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The desired ID of the operation to be executed in this extension
     *  as defined in
     *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
     * </pre>
     *
     * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The operationId.
     */
    public java.lang.String getOperationId() {
      java.lang.Object ref = operationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired ID of the operation to be executed in this extension
     *  as defined in
     *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
     * </pre>
     *
     * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for operationId.
     */
    public com.google.protobuf.ByteString getOperationIdBytes() {
      java.lang.Object ref = operationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired ID of the operation to be executed in this extension
     *  as defined in
     *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
     * </pre>
     *
     * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The operationId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired ID of the operation to be executed in this extension
     *  as defined in
     *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
     * </pre>
     *
     * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationId() {
      operationId_ = getDefaultInstance().getOperationId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired ID of the operation to be executed in this extension
     *  as defined in
     *  [ExtensionOperation.operation_id][google.cloud.aiplatform.v1beta1.ExtensionOperation.operation_id].
     * </pre>
     *
     * <code>string operation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for operationId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct operationParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        operationParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the operationParams field is set.
     */
    public boolean hasOperationParams() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The operationParams.
     */
    public com.google.protobuf.Struct getOperationParams() {
      if (operationParamsBuilder_ == null) {
        return operationParams_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : operationParams_;
      } else {
        return operationParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOperationParams(com.google.protobuf.Struct value) {
      if (operationParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operationParams_ = value;
      } else {
        operationParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOperationParams(com.google.protobuf.Struct.Builder builderForValue) {
      if (operationParamsBuilder_ == null) {
        operationParams_ = builderForValue.build();
      } else {
        operationParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOperationParams(com.google.protobuf.Struct value) {
      if (operationParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && operationParams_ != null
            && operationParams_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getOperationParamsBuilder().mergeFrom(value);
        } else {
          operationParams_ = value;
        }
      } else {
        operationParamsBuilder_.mergeFrom(value);
      }
      if (operationParams_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOperationParams() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operationParams_ = null;
      if (operationParamsBuilder_ != null) {
        operationParamsBuilder_.dispose();
        operationParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getOperationParamsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOperationParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getOperationParamsOrBuilder() {
      if (operationParamsBuilder_ != null) {
        return operationParamsBuilder_.getMessageOrBuilder();
      } else {
        return operationParams_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : operationParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Request parameters that will be used for executing this
     * operation.
     *
     * The struct should be in a form of map with param name as the key and actual
     * param value as the value.
     * E.g. If this operation requires a param "name" to be set to "abc". you can
     * set this to something like {"name": "abc"}.
     * </pre>
     *
     * <code>.google.protobuf.Struct operation_params = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getOperationParamsFieldBuilder() {
      if (operationParamsBuilder_ == null) {
        operationParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getOperationParams(), getParentForChildren(), isClean());
        operationParams_ = null;
      }
      return operationParamsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.AuthConfig runtimeAuthConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfigOrBuilder>
        runtimeAuthConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runtimeAuthConfig field is set.
     */
    public boolean hasRuntimeAuthConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runtimeAuthConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig getRuntimeAuthConfig() {
      if (runtimeAuthConfigBuilder_ == null) {
        return runtimeAuthConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance()
            : runtimeAuthConfig_;
      } else {
        return runtimeAuthConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeAuthConfig(com.google.cloud.aiplatform.v1beta1.AuthConfig value) {
      if (runtimeAuthConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeAuthConfig_ = value;
      } else {
        runtimeAuthConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeAuthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder builderForValue) {
      if (runtimeAuthConfigBuilder_ == null) {
        runtimeAuthConfig_ = builderForValue.build();
      } else {
        runtimeAuthConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRuntimeAuthConfig(com.google.cloud.aiplatform.v1beta1.AuthConfig value) {
      if (runtimeAuthConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && runtimeAuthConfig_ != null
            && runtimeAuthConfig_
                != com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance()) {
          getRuntimeAuthConfigBuilder().mergeFrom(value);
        } else {
          runtimeAuthConfig_ = value;
        }
      } else {
        runtimeAuthConfigBuilder_.mergeFrom(value);
      }
      if (runtimeAuthConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRuntimeAuthConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      runtimeAuthConfig_ = null;
      if (runtimeAuthConfigBuilder_ != null) {
        runtimeAuthConfigBuilder_.dispose();
        runtimeAuthConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder getRuntimeAuthConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRuntimeAuthConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfigOrBuilder getRuntimeAuthConfigOrBuilder() {
      if (runtimeAuthConfigBuilder_ != null) {
        return runtimeAuthConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeAuthConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance()
            : runtimeAuthConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Auth config provided at runtime to override the default value in
     * [Extension.manifest.auth_config][].
     * The AuthConfig.auth_type should match the value in
     * [Extension.manifest.auth_config][].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig runtime_auth_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfigOrBuilder>
        getRuntimeAuthConfigFieldBuilder() {
      if (runtimeAuthConfigBuilder_ == null) {
        runtimeAuthConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AuthConfig,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AuthConfigOrBuilder>(
                getRuntimeAuthConfig(), getParentForChildren(), isClean());
        runtimeAuthConfig_ = null;
      }
      return runtimeAuthConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest)
  private static final com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecuteExtensionRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExecuteExtensionRequest>() {
        @java.lang.Override
        public ExecuteExtensionRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecuteExtensionRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecuteExtensionRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
