/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/evaluation_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for EvaluationService.EvaluateInstances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest}
 */
public final class EvaluateInstancesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest)
    EvaluateInstancesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluateInstancesRequest.newBuilder() to construct.
  private EvaluateInstancesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluateInstancesRequest() {
    location_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluateInstancesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_EvaluateInstancesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_EvaluateInstancesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.class,
            com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.Builder.class);
  }

  private int metricInputsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metricInputs_;

  public enum MetricInputsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXACT_MATCH_INPUT(2),
    BLEU_INPUT(3),
    ROUGE_INPUT(4),
    FLUENCY_INPUT(5),
    COHERENCE_INPUT(6),
    SAFETY_INPUT(8),
    GROUNDEDNESS_INPUT(9),
    FULFILLMENT_INPUT(12),
    SUMMARIZATION_QUALITY_INPUT(7),
    PAIRWISE_SUMMARIZATION_QUALITY_INPUT(23),
    SUMMARIZATION_HELPFULNESS_INPUT(14),
    SUMMARIZATION_VERBOSITY_INPUT(15),
    QUESTION_ANSWERING_QUALITY_INPUT(10),
    PAIRWISE_QUESTION_ANSWERING_QUALITY_INPUT(24),
    QUESTION_ANSWERING_RELEVANCE_INPUT(16),
    QUESTION_ANSWERING_HELPFULNESS_INPUT(17),
    QUESTION_ANSWERING_CORRECTNESS_INPUT(18),
    POINTWISE_METRIC_INPUT(28),
    PAIRWISE_METRIC_INPUT(29),
    TOOL_CALL_VALID_INPUT(19),
    TOOL_NAME_MATCH_INPUT(20),
    TOOL_PARAMETER_KEY_MATCH_INPUT(21),
    TOOL_PARAMETER_KV_MATCH_INPUT(22),
    METRICINPUTS_NOT_SET(0);
    private final int value;

    private MetricInputsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetricInputsCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetricInputsCase forNumber(int value) {
      switch (value) {
        case 2:
          return EXACT_MATCH_INPUT;
        case 3:
          return BLEU_INPUT;
        case 4:
          return ROUGE_INPUT;
        case 5:
          return FLUENCY_INPUT;
        case 6:
          return COHERENCE_INPUT;
        case 8:
          return SAFETY_INPUT;
        case 9:
          return GROUNDEDNESS_INPUT;
        case 12:
          return FULFILLMENT_INPUT;
        case 7:
          return SUMMARIZATION_QUALITY_INPUT;
        case 23:
          return PAIRWISE_SUMMARIZATION_QUALITY_INPUT;
        case 14:
          return SUMMARIZATION_HELPFULNESS_INPUT;
        case 15:
          return SUMMARIZATION_VERBOSITY_INPUT;
        case 10:
          return QUESTION_ANSWERING_QUALITY_INPUT;
        case 24:
          return PAIRWISE_QUESTION_ANSWERING_QUALITY_INPUT;
        case 16:
          return QUESTION_ANSWERING_RELEVANCE_INPUT;
        case 17:
          return QUESTION_ANSWERING_HELPFULNESS_INPUT;
        case 18:
          return QUESTION_ANSWERING_CORRECTNESS_INPUT;
        case 28:
          return POINTWISE_METRIC_INPUT;
        case 29:
          return PAIRWISE_METRIC_INPUT;
        case 19:
          return TOOL_CALL_VALID_INPUT;
        case 20:
          return TOOL_NAME_MATCH_INPUT;
        case 21:
          return TOOL_PARAMETER_KEY_MATCH_INPUT;
        case 22:
          return TOOL_PARAMETER_KV_MATCH_INPUT;
        case 0:
          return METRICINPUTS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetricInputsCase getMetricInputsCase() {
    return MetricInputsCase.forNumber(metricInputsCase_);
  }

  public static final int EXACT_MATCH_INPUT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Auto metric instances.
   * Instances and metric spec for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
   *
   * @return Whether the exactMatchInput field is set.
   */
  @java.lang.Override
  public boolean hasExactMatchInput() {
    return metricInputsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Auto metric instances.
   * Instances and metric spec for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
   *
   * @return The exactMatchInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExactMatchInput getExactMatchInput() {
    if (metricInputsCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Auto metric instances.
   * Instances and metric spec for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExactMatchInputOrBuilder
      getExactMatchInputOrBuilder() {
    if (metricInputsCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance();
  }

  public static final int BLEU_INPUT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Instances and metric spec for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
   *
   * @return Whether the bleuInput field is set.
   */
  @java.lang.Override
  public boolean hasBleuInput() {
    return metricInputsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Instances and metric spec for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
   *
   * @return The bleuInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BleuInput getBleuInput() {
    if (metricInputsCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Instances and metric spec for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BleuInputOrBuilder getBleuInputOrBuilder() {
    if (metricInputsCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance();
  }

  public static final int ROUGE_INPUT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Instances and metric spec for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
   *
   * @return Whether the rougeInput field is set.
   */
  @java.lang.Override
  public boolean hasRougeInput() {
    return metricInputsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Instances and metric spec for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
   *
   * @return The rougeInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RougeInput getRougeInput() {
    if (metricInputsCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Instances and metric spec for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RougeInputOrBuilder getRougeInputOrBuilder() {
    if (metricInputsCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance();
  }

  public static final int FLUENCY_INPUT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * LLM-based metric instance.
   * General text generation metrics, applicable to other categories.
   * Input for fluency metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
   *
   * @return Whether the fluencyInput field is set.
   */
  @java.lang.Override
  public boolean hasFluencyInput() {
    return metricInputsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * LLM-based metric instance.
   * General text generation metrics, applicable to other categories.
   * Input for fluency metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
   *
   * @return The fluencyInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FluencyInput getFluencyInput() {
    if (metricInputsCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * LLM-based metric instance.
   * General text generation metrics, applicable to other categories.
   * Input for fluency metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FluencyInputOrBuilder getFluencyInputOrBuilder() {
    if (metricInputsCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance();
  }

  public static final int COHERENCE_INPUT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Input for coherence metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
   *
   * @return Whether the coherenceInput field is set.
   */
  @java.lang.Override
  public boolean hasCoherenceInput() {
    return metricInputsCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Input for coherence metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
   *
   * @return The coherenceInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CoherenceInput getCoherenceInput() {
    if (metricInputsCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for coherence metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CoherenceInputOrBuilder getCoherenceInputOrBuilder() {
    if (metricInputsCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance();
  }

  public static final int SAFETY_INPUT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Input for safety metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
   *
   * @return Whether the safetyInput field is set.
   */
  @java.lang.Override
  public boolean hasSafetyInput() {
    return metricInputsCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Input for safety metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
   *
   * @return The safetyInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SafetyInput getSafetyInput() {
    if (metricInputsCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for safety metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SafetyInputOrBuilder getSafetyInputOrBuilder() {
    if (metricInputsCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance();
  }

  public static final int GROUNDEDNESS_INPUT_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Input for groundedness metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
   *
   * @return Whether the groundednessInput field is set.
   */
  @java.lang.Override
  public boolean hasGroundednessInput() {
    return metricInputsCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Input for groundedness metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
   *
   * @return The groundednessInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundednessInput getGroundednessInput() {
    if (metricInputsCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for groundedness metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundednessInputOrBuilder
      getGroundednessInputOrBuilder() {
    if (metricInputsCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance();
  }

  public static final int FULFILLMENT_INPUT_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Input for fulfillment metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
   *
   * @return Whether the fulfillmentInput field is set.
   */
  @java.lang.Override
  public boolean hasFulfillmentInput() {
    return metricInputsCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Input for fulfillment metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
   *
   * @return The fulfillmentInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FulfillmentInput getFulfillmentInput() {
    if (metricInputsCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for fulfillment metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FulfillmentInputOrBuilder
      getFulfillmentInputOrBuilder() {
    if (metricInputsCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance();
  }

  public static final int SUMMARIZATION_QUALITY_INPUT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Input for summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
   * </code>
   *
   * @return Whether the summarizationQualityInput field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationQualityInput() {
    return metricInputsCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Input for summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
   * </code>
   *
   * @return The summarizationQualityInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput
      getSummarizationQualityInput() {
    if (metricInputsCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SummarizationQualityInputOrBuilder
      getSummarizationQualityInputOrBuilder() {
    if (metricInputsCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.getDefaultInstance();
  }

  public static final int PAIRWISE_SUMMARIZATION_QUALITY_INPUT_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Input for pairwise summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
   * </code>
   *
   * @return Whether the pairwiseSummarizationQualityInput field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseSummarizationQualityInput() {
    return metricInputsCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Input for pairwise summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
   * </code>
   *
   * @return The pairwiseSummarizationQualityInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
      getPairwiseSummarizationQualityInput() {
    if (metricInputsCase_ == 23) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for pairwise summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInputOrBuilder
      getPairwiseSummarizationQualityInputOrBuilder() {
    if (metricInputsCase_ == 23) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
        .getDefaultInstance();
  }

  public static final int SUMMARIZATION_HELPFULNESS_INPUT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Input for summarization helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
   * </code>
   *
   * @return Whether the summarizationHelpfulnessInput field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationHelpfulnessInput() {
    return metricInputsCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Input for summarization helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
   * </code>
   *
   * @return The summarizationHelpfulnessInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
      getSummarizationHelpfulnessInput() {
    if (metricInputsCase_ == 14) {
      return (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for summarization helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInputOrBuilder
      getSummarizationHelpfulnessInputOrBuilder() {
    if (metricInputsCase_ == 14) {
      return (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.getDefaultInstance();
  }

  public static final int SUMMARIZATION_VERBOSITY_INPUT_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Input for summarization verbosity metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
   * </code>
   *
   * @return Whether the summarizationVerbosityInput field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationVerbosityInput() {
    return metricInputsCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Input for summarization verbosity metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
   * </code>
   *
   * @return The summarizationVerbosityInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput
      getSummarizationVerbosityInput() {
    if (metricInputsCase_ == 15) {
      return (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for summarization verbosity metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInputOrBuilder
      getSummarizationVerbosityInputOrBuilder() {
    if (metricInputsCase_ == 15) {
      return (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_QUALITY_INPUT_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Input for question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
   * </code>
   *
   * @return Whether the questionAnsweringQualityInput field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringQualityInput() {
    return metricInputsCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Input for question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
   * </code>
   *
   * @return The questionAnsweringQualityInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
      getQuestionAnsweringQualityInput() {
    if (metricInputsCase_ == 10) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInputOrBuilder
      getQuestionAnsweringQualityInputOrBuilder() {
    if (metricInputsCase_ == 10) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.getDefaultInstance();
  }

  public static final int PAIRWISE_QUESTION_ANSWERING_QUALITY_INPUT_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Input for pairwise question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
   * </code>
   *
   * @return Whether the pairwiseQuestionAnsweringQualityInput field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseQuestionAnsweringQualityInput() {
    return metricInputsCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Input for pairwise question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
   * </code>
   *
   * @return The pairwiseQuestionAnsweringQualityInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
      getPairwiseQuestionAnsweringQualityInput() {
    if (metricInputsCase_ == 24) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
          metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for pairwise question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInputOrBuilder
      getPairwiseQuestionAnsweringQualityInputOrBuilder() {
    if (metricInputsCase_ == 24) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
          metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
        .getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_RELEVANCE_INPUT_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Input for question answering relevance metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
   * </code>
   *
   * @return Whether the questionAnsweringRelevanceInput field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringRelevanceInput() {
    return metricInputsCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Input for question answering relevance metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
   * </code>
   *
   * @return The questionAnsweringRelevanceInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
      getQuestionAnsweringRelevanceInput() {
    if (metricInputsCase_ == 16) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for question answering relevance metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInputOrBuilder
      getQuestionAnsweringRelevanceInputOrBuilder() {
    if (metricInputsCase_ == 16) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_HELPFULNESS_INPUT_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Input for question answering helpfulness
   * metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
   * </code>
   *
   * @return Whether the questionAnsweringHelpfulnessInput field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringHelpfulnessInput() {
    return metricInputsCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Input for question answering helpfulness
   * metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
   * </code>
   *
   * @return The questionAnsweringHelpfulnessInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
      getQuestionAnsweringHelpfulnessInput() {
    if (metricInputsCase_ == 17) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for question answering helpfulness
   * metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInputOrBuilder
      getQuestionAnsweringHelpfulnessInputOrBuilder() {
    if (metricInputsCase_ == 17) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
        .getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_CORRECTNESS_INPUT_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Input for question answering correctness
   * metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
   * </code>
   *
   * @return Whether the questionAnsweringCorrectnessInput field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringCorrectnessInput() {
    return metricInputsCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Input for question answering correctness
   * metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
   * </code>
   *
   * @return The questionAnsweringCorrectnessInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
      getQuestionAnsweringCorrectnessInput() {
    if (metricInputsCase_ == 18) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for question answering correctness
   * metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInputOrBuilder
      getQuestionAnsweringCorrectnessInputOrBuilder() {
    if (metricInputsCase_ == 18) {
      return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
        .getDefaultInstance();
  }

  public static final int POINTWISE_METRIC_INPUT_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Input for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;</code>
   *
   * @return Whether the pointwiseMetricInput field is set.
   */
  @java.lang.Override
  public boolean hasPointwiseMetricInput() {
    return metricInputsCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Input for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;</code>
   *
   * @return The pointwiseMetricInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput getPointwiseMetricInput() {
    if (metricInputsCase_ == 28) {
      return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PointwiseMetricInputOrBuilder
      getPointwiseMetricInputOrBuilder() {
    if (metricInputsCase_ == 28) {
      return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance();
  }

  public static final int PAIRWISE_METRIC_INPUT_FIELD_NUMBER = 29;
  /**
   *
   *
   * <pre>
   * Input for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
   *
   * @return Whether the pairwiseMetricInput field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseMetricInput() {
    return metricInputsCase_ == 29;
  }
  /**
   *
   *
   * <pre>
   * Input for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
   *
   * @return The pairwiseMetricInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput getPairwiseMetricInput() {
    if (metricInputsCase_ == 29) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseMetricInputOrBuilder
      getPairwiseMetricInputOrBuilder() {
    if (metricInputsCase_ == 29) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance();
  }

  public static final int TOOL_CALL_VALID_INPUT_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Tool call metric instances.
   * Input for tool call valid metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
   *
   * @return Whether the toolCallValidInput field is set.
   */
  @java.lang.Override
  public boolean hasToolCallValidInput() {
    return metricInputsCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Tool call metric instances.
   * Input for tool call valid metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
   *
   * @return The toolCallValidInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolCallValidInput getToolCallValidInput() {
    if (metricInputsCase_ == 19) {
      return (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tool call metric instances.
   * Input for tool call valid metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolCallValidInputOrBuilder
      getToolCallValidInputOrBuilder() {
    if (metricInputsCase_ == 19) {
      return (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance();
  }

  public static final int TOOL_NAME_MATCH_INPUT_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Input for tool name match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
   *
   * @return Whether the toolNameMatchInput field is set.
   */
  @java.lang.Override
  public boolean hasToolNameMatchInput() {
    return metricInputsCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Input for tool name match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
   *
   * @return The toolNameMatchInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput getToolNameMatchInput() {
    if (metricInputsCase_ == 20) {
      return (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for tool name match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolNameMatchInputOrBuilder
      getToolNameMatchInputOrBuilder() {
    if (metricInputsCase_ == 20) {
      return (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance();
  }

  public static final int TOOL_PARAMETER_KEY_MATCH_INPUT_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Input for tool parameter key match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
   * </code>
   *
   * @return Whether the toolParameterKeyMatchInput field is set.
   */
  @java.lang.Override
  public boolean hasToolParameterKeyMatchInput() {
    return metricInputsCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Input for tool parameter key match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
   * </code>
   *
   * @return The toolParameterKeyMatchInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput
      getToolParameterKeyMatchInput() {
    if (metricInputsCase_ == 21) {
      return (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for tool parameter key match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInputOrBuilder
      getToolParameterKeyMatchInputOrBuilder() {
    if (metricInputsCase_ == 21) {
      return (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.getDefaultInstance();
  }

  public static final int TOOL_PARAMETER_KV_MATCH_INPUT_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Input for tool parameter key value match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
   * </code>
   *
   * @return Whether the toolParameterKvMatchInput field is set.
   */
  @java.lang.Override
  public boolean hasToolParameterKvMatchInput() {
    return metricInputsCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Input for tool parameter key value match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
   * </code>
   *
   * @return The toolParameterKvMatchInput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput
      getToolParameterKvMatchInput() {
    if (metricInputsCase_ == 22) {
      return (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input for tool parameter key value match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInputOrBuilder
      getToolParameterKvMatchInputOrBuilder() {
    if (metricInputsCase_ == 22) {
      return (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_;
    }
    return com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.getDefaultInstance();
  }

  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to evaluate the instances.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to evaluate the instances.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (metricInputsCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_);
    }
    if (metricInputsCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_);
    }
    if (metricInputsCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_);
    }
    if (metricInputsCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_);
    }
    if (metricInputsCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_);
    }
    if (metricInputsCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_);
    }
    if (metricInputsCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_);
    }
    if (metricInputsCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_);
    }
    if (metricInputsCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_);
    }
    if (metricInputsCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_);
    }
    if (metricInputsCase_ == 15) {
      output.writeMessage(
          15, (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_);
    }
    if (metricInputsCase_ == 16) {
      output.writeMessage(
          16, (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput) metricInputs_);
    }
    if (metricInputsCase_ == 17) {
      output.writeMessage(
          17,
          (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput) metricInputs_);
    }
    if (metricInputsCase_ == 18) {
      output.writeMessage(
          18,
          (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput) metricInputs_);
    }
    if (metricInputsCase_ == 19) {
      output.writeMessage(
          19, (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_);
    }
    if (metricInputsCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 21) {
      output.writeMessage(
          21, (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 22) {
      output.writeMessage(
          22, (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 23) {
      output.writeMessage(
          23,
          (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput) metricInputs_);
    }
    if (metricInputsCase_ == 24) {
      output.writeMessage(
          24,
          (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
              metricInputs_);
    }
    if (metricInputsCase_ == 28) {
      output.writeMessage(
          28, (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_);
    }
    if (metricInputsCase_ == 29) {
      output.writeMessage(
          29, (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (metricInputsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_);
    }
    if (metricInputsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_);
    }
    if (metricInputsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_);
    }
    if (metricInputsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_);
    }
    if (metricInputsCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_);
    }
    if (metricInputsCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_);
    }
    if (metricInputsCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_);
    }
    if (metricInputsCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10,
              (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_);
    }
    if (metricInputsCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_);
    }
    if (metricInputsCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14,
              (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_);
    }
    if (metricInputsCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_);
    }
    if (metricInputsCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16,
              (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput) metricInputs_);
    }
    if (metricInputsCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17,
              (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput)
                  metricInputs_);
    }
    if (metricInputsCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18,
              (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput)
                  metricInputs_);
    }
    if (metricInputsCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_);
    }
    if (metricInputsCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_);
    }
    if (metricInputsCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23,
              (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput)
                  metricInputs_);
    }
    if (metricInputsCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24,
              (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
                  metricInputs_);
    }
    if (metricInputsCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_);
    }
    if (metricInputsCase_ == 29) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              29, (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest other =
        (com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (!getMetricInputsCase().equals(other.getMetricInputsCase())) return false;
    switch (metricInputsCase_) {
      case 2:
        if (!getExactMatchInput().equals(other.getExactMatchInput())) return false;
        break;
      case 3:
        if (!getBleuInput().equals(other.getBleuInput())) return false;
        break;
      case 4:
        if (!getRougeInput().equals(other.getRougeInput())) return false;
        break;
      case 5:
        if (!getFluencyInput().equals(other.getFluencyInput())) return false;
        break;
      case 6:
        if (!getCoherenceInput().equals(other.getCoherenceInput())) return false;
        break;
      case 8:
        if (!getSafetyInput().equals(other.getSafetyInput())) return false;
        break;
      case 9:
        if (!getGroundednessInput().equals(other.getGroundednessInput())) return false;
        break;
      case 12:
        if (!getFulfillmentInput().equals(other.getFulfillmentInput())) return false;
        break;
      case 7:
        if (!getSummarizationQualityInput().equals(other.getSummarizationQualityInput()))
          return false;
        break;
      case 23:
        if (!getPairwiseSummarizationQualityInput()
            .equals(other.getPairwiseSummarizationQualityInput())) return false;
        break;
      case 14:
        if (!getSummarizationHelpfulnessInput().equals(other.getSummarizationHelpfulnessInput()))
          return false;
        break;
      case 15:
        if (!getSummarizationVerbosityInput().equals(other.getSummarizationVerbosityInput()))
          return false;
        break;
      case 10:
        if (!getQuestionAnsweringQualityInput().equals(other.getQuestionAnsweringQualityInput()))
          return false;
        break;
      case 24:
        if (!getPairwiseQuestionAnsweringQualityInput()
            .equals(other.getPairwiseQuestionAnsweringQualityInput())) return false;
        break;
      case 16:
        if (!getQuestionAnsweringRelevanceInput()
            .equals(other.getQuestionAnsweringRelevanceInput())) return false;
        break;
      case 17:
        if (!getQuestionAnsweringHelpfulnessInput()
            .equals(other.getQuestionAnsweringHelpfulnessInput())) return false;
        break;
      case 18:
        if (!getQuestionAnsweringCorrectnessInput()
            .equals(other.getQuestionAnsweringCorrectnessInput())) return false;
        break;
      case 28:
        if (!getPointwiseMetricInput().equals(other.getPointwiseMetricInput())) return false;
        break;
      case 29:
        if (!getPairwiseMetricInput().equals(other.getPairwiseMetricInput())) return false;
        break;
      case 19:
        if (!getToolCallValidInput().equals(other.getToolCallValidInput())) return false;
        break;
      case 20:
        if (!getToolNameMatchInput().equals(other.getToolNameMatchInput())) return false;
        break;
      case 21:
        if (!getToolParameterKeyMatchInput().equals(other.getToolParameterKeyMatchInput()))
          return false;
        break;
      case 22:
        if (!getToolParameterKvMatchInput().equals(other.getToolParameterKvMatchInput()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    switch (metricInputsCase_) {
      case 2:
        hash = (37 * hash) + EXACT_MATCH_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getExactMatchInput().hashCode();
        break;
      case 3:
        hash = (37 * hash) + BLEU_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getBleuInput().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ROUGE_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getRougeInput().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FLUENCY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getFluencyInput().hashCode();
        break;
      case 6:
        hash = (37 * hash) + COHERENCE_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getCoherenceInput().hashCode();
        break;
      case 8:
        hash = (37 * hash) + SAFETY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyInput().hashCode();
        break;
      case 9:
        hash = (37 * hash) + GROUNDEDNESS_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getGroundednessInput().hashCode();
        break;
      case 12:
        hash = (37 * hash) + FULFILLMENT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getFulfillmentInput().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SUMMARIZATION_QUALITY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationQualityInput().hashCode();
        break;
      case 23:
        hash = (37 * hash) + PAIRWISE_SUMMARIZATION_QUALITY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseSummarizationQualityInput().hashCode();
        break;
      case 14:
        hash = (37 * hash) + SUMMARIZATION_HELPFULNESS_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationHelpfulnessInput().hashCode();
        break;
      case 15:
        hash = (37 * hash) + SUMMARIZATION_VERBOSITY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationVerbosityInput().hashCode();
        break;
      case 10:
        hash = (37 * hash) + QUESTION_ANSWERING_QUALITY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringQualityInput().hashCode();
        break;
      case 24:
        hash = (37 * hash) + PAIRWISE_QUESTION_ANSWERING_QUALITY_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseQuestionAnsweringQualityInput().hashCode();
        break;
      case 16:
        hash = (37 * hash) + QUESTION_ANSWERING_RELEVANCE_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringRelevanceInput().hashCode();
        break;
      case 17:
        hash = (37 * hash) + QUESTION_ANSWERING_HELPFULNESS_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringHelpfulnessInput().hashCode();
        break;
      case 18:
        hash = (37 * hash) + QUESTION_ANSWERING_CORRECTNESS_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringCorrectnessInput().hashCode();
        break;
      case 28:
        hash = (37 * hash) + POINTWISE_METRIC_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getPointwiseMetricInput().hashCode();
        break;
      case 29:
        hash = (37 * hash) + PAIRWISE_METRIC_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseMetricInput().hashCode();
        break;
      case 19:
        hash = (37 * hash) + TOOL_CALL_VALID_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getToolCallValidInput().hashCode();
        break;
      case 20:
        hash = (37 * hash) + TOOL_NAME_MATCH_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getToolNameMatchInput().hashCode();
        break;
      case 21:
        hash = (37 * hash) + TOOL_PARAMETER_KEY_MATCH_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getToolParameterKeyMatchInput().hashCode();
        break;
      case 22:
        hash = (37 * hash) + TOOL_PARAMETER_KV_MATCH_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getToolParameterKvMatchInput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for EvaluationService.EvaluateInstances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest)
      com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluateInstancesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluateInstancesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.class,
              com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (exactMatchInputBuilder_ != null) {
        exactMatchInputBuilder_.clear();
      }
      if (bleuInputBuilder_ != null) {
        bleuInputBuilder_.clear();
      }
      if (rougeInputBuilder_ != null) {
        rougeInputBuilder_.clear();
      }
      if (fluencyInputBuilder_ != null) {
        fluencyInputBuilder_.clear();
      }
      if (coherenceInputBuilder_ != null) {
        coherenceInputBuilder_.clear();
      }
      if (safetyInputBuilder_ != null) {
        safetyInputBuilder_.clear();
      }
      if (groundednessInputBuilder_ != null) {
        groundednessInputBuilder_.clear();
      }
      if (fulfillmentInputBuilder_ != null) {
        fulfillmentInputBuilder_.clear();
      }
      if (summarizationQualityInputBuilder_ != null) {
        summarizationQualityInputBuilder_.clear();
      }
      if (pairwiseSummarizationQualityInputBuilder_ != null) {
        pairwiseSummarizationQualityInputBuilder_.clear();
      }
      if (summarizationHelpfulnessInputBuilder_ != null) {
        summarizationHelpfulnessInputBuilder_.clear();
      }
      if (summarizationVerbosityInputBuilder_ != null) {
        summarizationVerbosityInputBuilder_.clear();
      }
      if (questionAnsweringQualityInputBuilder_ != null) {
        questionAnsweringQualityInputBuilder_.clear();
      }
      if (pairwiseQuestionAnsweringQualityInputBuilder_ != null) {
        pairwiseQuestionAnsweringQualityInputBuilder_.clear();
      }
      if (questionAnsweringRelevanceInputBuilder_ != null) {
        questionAnsweringRelevanceInputBuilder_.clear();
      }
      if (questionAnsweringHelpfulnessInputBuilder_ != null) {
        questionAnsweringHelpfulnessInputBuilder_.clear();
      }
      if (questionAnsweringCorrectnessInputBuilder_ != null) {
        questionAnsweringCorrectnessInputBuilder_.clear();
      }
      if (pointwiseMetricInputBuilder_ != null) {
        pointwiseMetricInputBuilder_.clear();
      }
      if (pairwiseMetricInputBuilder_ != null) {
        pairwiseMetricInputBuilder_.clear();
      }
      if (toolCallValidInputBuilder_ != null) {
        toolCallValidInputBuilder_.clear();
      }
      if (toolNameMatchInputBuilder_ != null) {
        toolNameMatchInputBuilder_.clear();
      }
      if (toolParameterKeyMatchInputBuilder_ != null) {
        toolParameterKeyMatchInputBuilder_.clear();
      }
      if (toolParameterKvMatchInputBuilder_ != null) {
        toolParameterKvMatchInputBuilder_.clear();
      }
      location_ = "";
      metricInputsCase_ = 0;
      metricInputs_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluateInstancesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest build() {
      com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest result =
          new com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.location_ = location_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest result) {
      result.metricInputsCase_ = metricInputsCase_;
      result.metricInputs_ = this.metricInputs_;
      if (metricInputsCase_ == 2 && exactMatchInputBuilder_ != null) {
        result.metricInputs_ = exactMatchInputBuilder_.build();
      }
      if (metricInputsCase_ == 3 && bleuInputBuilder_ != null) {
        result.metricInputs_ = bleuInputBuilder_.build();
      }
      if (metricInputsCase_ == 4 && rougeInputBuilder_ != null) {
        result.metricInputs_ = rougeInputBuilder_.build();
      }
      if (metricInputsCase_ == 5 && fluencyInputBuilder_ != null) {
        result.metricInputs_ = fluencyInputBuilder_.build();
      }
      if (metricInputsCase_ == 6 && coherenceInputBuilder_ != null) {
        result.metricInputs_ = coherenceInputBuilder_.build();
      }
      if (metricInputsCase_ == 8 && safetyInputBuilder_ != null) {
        result.metricInputs_ = safetyInputBuilder_.build();
      }
      if (metricInputsCase_ == 9 && groundednessInputBuilder_ != null) {
        result.metricInputs_ = groundednessInputBuilder_.build();
      }
      if (metricInputsCase_ == 12 && fulfillmentInputBuilder_ != null) {
        result.metricInputs_ = fulfillmentInputBuilder_.build();
      }
      if (metricInputsCase_ == 7 && summarizationQualityInputBuilder_ != null) {
        result.metricInputs_ = summarizationQualityInputBuilder_.build();
      }
      if (metricInputsCase_ == 23 && pairwiseSummarizationQualityInputBuilder_ != null) {
        result.metricInputs_ = pairwiseSummarizationQualityInputBuilder_.build();
      }
      if (metricInputsCase_ == 14 && summarizationHelpfulnessInputBuilder_ != null) {
        result.metricInputs_ = summarizationHelpfulnessInputBuilder_.build();
      }
      if (metricInputsCase_ == 15 && summarizationVerbosityInputBuilder_ != null) {
        result.metricInputs_ = summarizationVerbosityInputBuilder_.build();
      }
      if (metricInputsCase_ == 10 && questionAnsweringQualityInputBuilder_ != null) {
        result.metricInputs_ = questionAnsweringQualityInputBuilder_.build();
      }
      if (metricInputsCase_ == 24 && pairwiseQuestionAnsweringQualityInputBuilder_ != null) {
        result.metricInputs_ = pairwiseQuestionAnsweringQualityInputBuilder_.build();
      }
      if (metricInputsCase_ == 16 && questionAnsweringRelevanceInputBuilder_ != null) {
        result.metricInputs_ = questionAnsweringRelevanceInputBuilder_.build();
      }
      if (metricInputsCase_ == 17 && questionAnsweringHelpfulnessInputBuilder_ != null) {
        result.metricInputs_ = questionAnsweringHelpfulnessInputBuilder_.build();
      }
      if (metricInputsCase_ == 18 && questionAnsweringCorrectnessInputBuilder_ != null) {
        result.metricInputs_ = questionAnsweringCorrectnessInputBuilder_.build();
      }
      if (metricInputsCase_ == 28 && pointwiseMetricInputBuilder_ != null) {
        result.metricInputs_ = pointwiseMetricInputBuilder_.build();
      }
      if (metricInputsCase_ == 29 && pairwiseMetricInputBuilder_ != null) {
        result.metricInputs_ = pairwiseMetricInputBuilder_.build();
      }
      if (metricInputsCase_ == 19 && toolCallValidInputBuilder_ != null) {
        result.metricInputs_ = toolCallValidInputBuilder_.build();
      }
      if (metricInputsCase_ == 20 && toolNameMatchInputBuilder_ != null) {
        result.metricInputs_ = toolNameMatchInputBuilder_.build();
      }
      if (metricInputsCase_ == 21 && toolParameterKeyMatchInputBuilder_ != null) {
        result.metricInputs_ = toolParameterKeyMatchInputBuilder_.build();
      }
      if (metricInputsCase_ == 22 && toolParameterKvMatchInputBuilder_ != null) {
        result.metricInputs_ = toolParameterKvMatchInputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      switch (other.getMetricInputsCase()) {
        case EXACT_MATCH_INPUT:
          {
            mergeExactMatchInput(other.getExactMatchInput());
            break;
          }
        case BLEU_INPUT:
          {
            mergeBleuInput(other.getBleuInput());
            break;
          }
        case ROUGE_INPUT:
          {
            mergeRougeInput(other.getRougeInput());
            break;
          }
        case FLUENCY_INPUT:
          {
            mergeFluencyInput(other.getFluencyInput());
            break;
          }
        case COHERENCE_INPUT:
          {
            mergeCoherenceInput(other.getCoherenceInput());
            break;
          }
        case SAFETY_INPUT:
          {
            mergeSafetyInput(other.getSafetyInput());
            break;
          }
        case GROUNDEDNESS_INPUT:
          {
            mergeGroundednessInput(other.getGroundednessInput());
            break;
          }
        case FULFILLMENT_INPUT:
          {
            mergeFulfillmentInput(other.getFulfillmentInput());
            break;
          }
        case SUMMARIZATION_QUALITY_INPUT:
          {
            mergeSummarizationQualityInput(other.getSummarizationQualityInput());
            break;
          }
        case PAIRWISE_SUMMARIZATION_QUALITY_INPUT:
          {
            mergePairwiseSummarizationQualityInput(other.getPairwiseSummarizationQualityInput());
            break;
          }
        case SUMMARIZATION_HELPFULNESS_INPUT:
          {
            mergeSummarizationHelpfulnessInput(other.getSummarizationHelpfulnessInput());
            break;
          }
        case SUMMARIZATION_VERBOSITY_INPUT:
          {
            mergeSummarizationVerbosityInput(other.getSummarizationVerbosityInput());
            break;
          }
        case QUESTION_ANSWERING_QUALITY_INPUT:
          {
            mergeQuestionAnsweringQualityInput(other.getQuestionAnsweringQualityInput());
            break;
          }
        case PAIRWISE_QUESTION_ANSWERING_QUALITY_INPUT:
          {
            mergePairwiseQuestionAnsweringQualityInput(
                other.getPairwiseQuestionAnsweringQualityInput());
            break;
          }
        case QUESTION_ANSWERING_RELEVANCE_INPUT:
          {
            mergeQuestionAnsweringRelevanceInput(other.getQuestionAnsweringRelevanceInput());
            break;
          }
        case QUESTION_ANSWERING_HELPFULNESS_INPUT:
          {
            mergeQuestionAnsweringHelpfulnessInput(other.getQuestionAnsweringHelpfulnessInput());
            break;
          }
        case QUESTION_ANSWERING_CORRECTNESS_INPUT:
          {
            mergeQuestionAnsweringCorrectnessInput(other.getQuestionAnsweringCorrectnessInput());
            break;
          }
        case POINTWISE_METRIC_INPUT:
          {
            mergePointwiseMetricInput(other.getPointwiseMetricInput());
            break;
          }
        case PAIRWISE_METRIC_INPUT:
          {
            mergePairwiseMetricInput(other.getPairwiseMetricInput());
            break;
          }
        case TOOL_CALL_VALID_INPUT:
          {
            mergeToolCallValidInput(other.getToolCallValidInput());
            break;
          }
        case TOOL_NAME_MATCH_INPUT:
          {
            mergeToolNameMatchInput(other.getToolNameMatchInput());
            break;
          }
        case TOOL_PARAMETER_KEY_MATCH_INPUT:
          {
            mergeToolParameterKeyMatchInput(other.getToolParameterKeyMatchInput());
            break;
          }
        case TOOL_PARAMETER_KV_MATCH_INPUT:
          {
            mergeToolParameterKvMatchInput(other.getToolParameterKvMatchInput());
            break;
          }
        case METRICINPUTS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getExactMatchInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getBleuInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRougeInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getFluencyInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCoherenceInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getSummarizationQualityInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSafetyInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getGroundednessInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getQuestionAnsweringQualityInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 10;
                break;
              } // case 82
            case 98:
              {
                input.readMessage(
                    getFulfillmentInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 12;
                break;
              } // case 98
            case 114:
              {
                input.readMessage(
                    getSummarizationHelpfulnessInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getSummarizationVerbosityInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getQuestionAnsweringRelevanceInputFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricInputsCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getQuestionAnsweringHelpfulnessInputFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricInputsCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getQuestionAnsweringCorrectnessInputFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricInputsCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getToolCallValidInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getToolNameMatchInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getToolParameterKeyMatchInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getToolParameterKvMatchInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getPairwiseSummarizationQualityInputFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricInputsCase_ = 23;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getPairwiseQuestionAnsweringQualityInputFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricInputsCase_ = 24;
                break;
              } // case 194
            case 226:
              {
                input.readMessage(
                    getPointwiseMetricInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 28;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(
                    getPairwiseMetricInputFieldBuilder().getBuilder(), extensionRegistry);
                metricInputsCase_ = 29;
                break;
              } // case 234
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metricInputsCase_ = 0;
    private java.lang.Object metricInputs_;

    public MetricInputsCase getMetricInputsCase() {
      return MetricInputsCase.forNumber(metricInputsCase_);
    }

    public Builder clearMetricInputs() {
      metricInputsCase_ = 0;
      metricInputs_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExactMatchInput,
            com.google.cloud.aiplatform.v1beta1.ExactMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ExactMatchInputOrBuilder>
        exactMatchInputBuilder_;
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     *
     * @return Whether the exactMatchInput field is set.
     */
    @java.lang.Override
    public boolean hasExactMatchInput() {
      return metricInputsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     *
     * @return The exactMatchInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExactMatchInput getExactMatchInput() {
      if (exactMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 2) {
          return exactMatchInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    public Builder setExactMatchInput(com.google.cloud.aiplatform.v1beta1.ExactMatchInput value) {
      if (exactMatchInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        exactMatchInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    public Builder setExactMatchInput(
        com.google.cloud.aiplatform.v1beta1.ExactMatchInput.Builder builderForValue) {
      if (exactMatchInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        exactMatchInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    public Builder mergeExactMatchInput(com.google.cloud.aiplatform.v1beta1.ExactMatchInput value) {
      if (exactMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 2
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ExactMatchInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 2) {
          exactMatchInputBuilder_.mergeFrom(value);
        } else {
          exactMatchInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    public Builder clearExactMatchInput() {
      if (exactMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 2) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 2) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        exactMatchInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExactMatchInput.Builder getExactMatchInputBuilder() {
      return getExactMatchInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExactMatchInputOrBuilder
        getExactMatchInputOrBuilder() {
      if ((metricInputsCase_ == 2) && (exactMatchInputBuilder_ != null)) {
        return exactMatchInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Auto metric instances.
     * Instances and metric spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchInput exact_match_input = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExactMatchInput,
            com.google.cloud.aiplatform.v1beta1.ExactMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ExactMatchInputOrBuilder>
        getExactMatchInputFieldBuilder() {
      if (exactMatchInputBuilder_ == null) {
        if (!(metricInputsCase_ == 2)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.ExactMatchInput.getDefaultInstance();
        }
        exactMatchInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExactMatchInput,
                com.google.cloud.aiplatform.v1beta1.ExactMatchInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ExactMatchInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ExactMatchInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 2;
      onChanged();
      return exactMatchInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BleuInput,
            com.google.cloud.aiplatform.v1beta1.BleuInput.Builder,
            com.google.cloud.aiplatform.v1beta1.BleuInputOrBuilder>
        bleuInputBuilder_;
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     *
     * @return Whether the bleuInput field is set.
     */
    @java.lang.Override
    public boolean hasBleuInput() {
      return metricInputsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     *
     * @return The bleuInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BleuInput getBleuInput() {
      if (bleuInputBuilder_ == null) {
        if (metricInputsCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 3) {
          return bleuInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    public Builder setBleuInput(com.google.cloud.aiplatform.v1beta1.BleuInput value) {
      if (bleuInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        bleuInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    public Builder setBleuInput(
        com.google.cloud.aiplatform.v1beta1.BleuInput.Builder builderForValue) {
      if (bleuInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        bleuInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    public Builder mergeBleuInput(com.google.cloud.aiplatform.v1beta1.BleuInput value) {
      if (bleuInputBuilder_ == null) {
        if (metricInputsCase_ == 3
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.BleuInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 3) {
          bleuInputBuilder_.mergeFrom(value);
        } else {
          bleuInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    public Builder clearBleuInput() {
      if (bleuInputBuilder_ == null) {
        if (metricInputsCase_ == 3) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 3) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        bleuInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BleuInput.Builder getBleuInputBuilder() {
      return getBleuInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BleuInputOrBuilder getBleuInputOrBuilder() {
      if ((metricInputsCase_ == 3) && (bleuInputBuilder_ != null)) {
        return bleuInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuInput bleu_input = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BleuInput,
            com.google.cloud.aiplatform.v1beta1.BleuInput.Builder,
            com.google.cloud.aiplatform.v1beta1.BleuInputOrBuilder>
        getBleuInputFieldBuilder() {
      if (bleuInputBuilder_ == null) {
        if (!(metricInputsCase_ == 3)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.BleuInput.getDefaultInstance();
        }
        bleuInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BleuInput,
                com.google.cloud.aiplatform.v1beta1.BleuInput.Builder,
                com.google.cloud.aiplatform.v1beta1.BleuInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BleuInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 3;
      onChanged();
      return bleuInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RougeInput,
            com.google.cloud.aiplatform.v1beta1.RougeInput.Builder,
            com.google.cloud.aiplatform.v1beta1.RougeInputOrBuilder>
        rougeInputBuilder_;
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     *
     * @return Whether the rougeInput field is set.
     */
    @java.lang.Override
    public boolean hasRougeInput() {
      return metricInputsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     *
     * @return The rougeInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RougeInput getRougeInput() {
      if (rougeInputBuilder_ == null) {
        if (metricInputsCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 4) {
          return rougeInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    public Builder setRougeInput(com.google.cloud.aiplatform.v1beta1.RougeInput value) {
      if (rougeInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        rougeInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    public Builder setRougeInput(
        com.google.cloud.aiplatform.v1beta1.RougeInput.Builder builderForValue) {
      if (rougeInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        rougeInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    public Builder mergeRougeInput(com.google.cloud.aiplatform.v1beta1.RougeInput value) {
      if (rougeInputBuilder_ == null) {
        if (metricInputsCase_ == 4
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.RougeInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 4) {
          rougeInputBuilder_.mergeFrom(value);
        } else {
          rougeInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    public Builder clearRougeInput() {
      if (rougeInputBuilder_ == null) {
        if (metricInputsCase_ == 4) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 4) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        rougeInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RougeInput.Builder getRougeInputBuilder() {
      return getRougeInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RougeInputOrBuilder getRougeInputOrBuilder() {
      if ((metricInputsCase_ == 4) && (rougeInputBuilder_ != null)) {
        return rougeInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instances and metric spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeInput rouge_input = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RougeInput,
            com.google.cloud.aiplatform.v1beta1.RougeInput.Builder,
            com.google.cloud.aiplatform.v1beta1.RougeInputOrBuilder>
        getRougeInputFieldBuilder() {
      if (rougeInputBuilder_ == null) {
        if (!(metricInputsCase_ == 4)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.RougeInput.getDefaultInstance();
        }
        rougeInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RougeInput,
                com.google.cloud.aiplatform.v1beta1.RougeInput.Builder,
                com.google.cloud.aiplatform.v1beta1.RougeInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.RougeInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 4;
      onChanged();
      return rougeInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FluencyInput,
            com.google.cloud.aiplatform.v1beta1.FluencyInput.Builder,
            com.google.cloud.aiplatform.v1beta1.FluencyInputOrBuilder>
        fluencyInputBuilder_;
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     *
     * @return Whether the fluencyInput field is set.
     */
    @java.lang.Override
    public boolean hasFluencyInput() {
      return metricInputsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     *
     * @return The fluencyInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FluencyInput getFluencyInput() {
      if (fluencyInputBuilder_ == null) {
        if (metricInputsCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 5) {
          return fluencyInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    public Builder setFluencyInput(com.google.cloud.aiplatform.v1beta1.FluencyInput value) {
      if (fluencyInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        fluencyInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    public Builder setFluencyInput(
        com.google.cloud.aiplatform.v1beta1.FluencyInput.Builder builderForValue) {
      if (fluencyInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        fluencyInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    public Builder mergeFluencyInput(com.google.cloud.aiplatform.v1beta1.FluencyInput value) {
      if (fluencyInputBuilder_ == null) {
        if (metricInputsCase_ == 5
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.FluencyInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 5) {
          fluencyInputBuilder_.mergeFrom(value);
        } else {
          fluencyInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    public Builder clearFluencyInput() {
      if (fluencyInputBuilder_ == null) {
        if (metricInputsCase_ == 5) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 5) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        fluencyInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FluencyInput.Builder getFluencyInputBuilder() {
      return getFluencyInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FluencyInputOrBuilder getFluencyInputOrBuilder() {
      if ((metricInputsCase_ == 5) && (fluencyInputBuilder_ != null)) {
        return fluencyInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric instance.
     * General text generation metrics, applicable to other categories.
     * Input for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FluencyInput fluency_input = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FluencyInput,
            com.google.cloud.aiplatform.v1beta1.FluencyInput.Builder,
            com.google.cloud.aiplatform.v1beta1.FluencyInputOrBuilder>
        getFluencyInputFieldBuilder() {
      if (fluencyInputBuilder_ == null) {
        if (!(metricInputsCase_ == 5)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.FluencyInput.getDefaultInstance();
        }
        fluencyInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FluencyInput,
                com.google.cloud.aiplatform.v1beta1.FluencyInput.Builder,
                com.google.cloud.aiplatform.v1beta1.FluencyInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FluencyInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 5;
      onChanged();
      return fluencyInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CoherenceInput,
            com.google.cloud.aiplatform.v1beta1.CoherenceInput.Builder,
            com.google.cloud.aiplatform.v1beta1.CoherenceInputOrBuilder>
        coherenceInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     *
     * @return Whether the coherenceInput field is set.
     */
    @java.lang.Override
    public boolean hasCoherenceInput() {
      return metricInputsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     *
     * @return The coherenceInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CoherenceInput getCoherenceInput() {
      if (coherenceInputBuilder_ == null) {
        if (metricInputsCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 6) {
          return coherenceInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    public Builder setCoherenceInput(com.google.cloud.aiplatform.v1beta1.CoherenceInput value) {
      if (coherenceInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        coherenceInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    public Builder setCoherenceInput(
        com.google.cloud.aiplatform.v1beta1.CoherenceInput.Builder builderForValue) {
      if (coherenceInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        coherenceInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    public Builder mergeCoherenceInput(com.google.cloud.aiplatform.v1beta1.CoherenceInput value) {
      if (coherenceInputBuilder_ == null) {
        if (metricInputsCase_ == 6
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.CoherenceInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 6) {
          coherenceInputBuilder_.mergeFrom(value);
        } else {
          coherenceInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    public Builder clearCoherenceInput() {
      if (coherenceInputBuilder_ == null) {
        if (metricInputsCase_ == 6) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 6) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        coherenceInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.CoherenceInput.Builder getCoherenceInputBuilder() {
      return getCoherenceInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CoherenceInputOrBuilder
        getCoherenceInputOrBuilder() {
      if ((metricInputsCase_ == 6) && (coherenceInputBuilder_ != null)) {
        return coherenceInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CoherenceInput coherence_input = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CoherenceInput,
            com.google.cloud.aiplatform.v1beta1.CoherenceInput.Builder,
            com.google.cloud.aiplatform.v1beta1.CoherenceInputOrBuilder>
        getCoherenceInputFieldBuilder() {
      if (coherenceInputBuilder_ == null) {
        if (!(metricInputsCase_ == 6)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.CoherenceInput.getDefaultInstance();
        }
        coherenceInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CoherenceInput,
                com.google.cloud.aiplatform.v1beta1.CoherenceInput.Builder,
                com.google.cloud.aiplatform.v1beta1.CoherenceInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.CoherenceInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 6;
      onChanged();
      return coherenceInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SafetyInput,
            com.google.cloud.aiplatform.v1beta1.SafetyInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SafetyInputOrBuilder>
        safetyInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     *
     * @return Whether the safetyInput field is set.
     */
    @java.lang.Override
    public boolean hasSafetyInput() {
      return metricInputsCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     *
     * @return The safetyInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SafetyInput getSafetyInput() {
      if (safetyInputBuilder_ == null) {
        if (metricInputsCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 8) {
          return safetyInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    public Builder setSafetyInput(com.google.cloud.aiplatform.v1beta1.SafetyInput value) {
      if (safetyInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        safetyInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    public Builder setSafetyInput(
        com.google.cloud.aiplatform.v1beta1.SafetyInput.Builder builderForValue) {
      if (safetyInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        safetyInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    public Builder mergeSafetyInput(com.google.cloud.aiplatform.v1beta1.SafetyInput value) {
      if (safetyInputBuilder_ == null) {
        if (metricInputsCase_ == 8
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SafetyInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 8) {
          safetyInputBuilder_.mergeFrom(value);
        } else {
          safetyInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    public Builder clearSafetyInput() {
      if (safetyInputBuilder_ == null) {
        if (metricInputsCase_ == 8) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 8) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        safetyInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SafetyInput.Builder getSafetyInputBuilder() {
      return getSafetyInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SafetyInputOrBuilder getSafetyInputOrBuilder() {
      if ((metricInputsCase_ == 8) && (safetyInputBuilder_ != null)) {
        return safetyInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SafetyInput safety_input = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SafetyInput,
            com.google.cloud.aiplatform.v1beta1.SafetyInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SafetyInputOrBuilder>
        getSafetyInputFieldBuilder() {
      if (safetyInputBuilder_ == null) {
        if (!(metricInputsCase_ == 8)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.SafetyInput.getDefaultInstance();
        }
        safetyInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SafetyInput,
                com.google.cloud.aiplatform.v1beta1.SafetyInput.Builder,
                com.google.cloud.aiplatform.v1beta1.SafetyInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SafetyInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 8;
      onChanged();
      return safetyInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundednessInput,
            com.google.cloud.aiplatform.v1beta1.GroundednessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundednessInputOrBuilder>
        groundednessInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     *
     * @return Whether the groundednessInput field is set.
     */
    @java.lang.Override
    public boolean hasGroundednessInput() {
      return metricInputsCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     *
     * @return The groundednessInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GroundednessInput getGroundednessInput() {
      if (groundednessInputBuilder_ == null) {
        if (metricInputsCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 9) {
          return groundednessInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    public Builder setGroundednessInput(
        com.google.cloud.aiplatform.v1beta1.GroundednessInput value) {
      if (groundednessInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        groundednessInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    public Builder setGroundednessInput(
        com.google.cloud.aiplatform.v1beta1.GroundednessInput.Builder builderForValue) {
      if (groundednessInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        groundednessInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    public Builder mergeGroundednessInput(
        com.google.cloud.aiplatform.v1beta1.GroundednessInput value) {
      if (groundednessInputBuilder_ == null) {
        if (metricInputsCase_ == 9
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.GroundednessInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 9) {
          groundednessInputBuilder_.mergeFrom(value);
        } else {
          groundednessInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    public Builder clearGroundednessInput() {
      if (groundednessInputBuilder_ == null) {
        if (metricInputsCase_ == 9) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 9) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        groundednessInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundednessInput.Builder
        getGroundednessInputBuilder() {
      return getGroundednessInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GroundednessInputOrBuilder
        getGroundednessInputOrBuilder() {
      if ((metricInputsCase_ == 9) && (groundednessInputBuilder_ != null)) {
        return groundednessInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GroundednessInput groundedness_input = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundednessInput,
            com.google.cloud.aiplatform.v1beta1.GroundednessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundednessInputOrBuilder>
        getGroundednessInputFieldBuilder() {
      if (groundednessInputBuilder_ == null) {
        if (!(metricInputsCase_ == 9)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.GroundednessInput.getDefaultInstance();
        }
        groundednessInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GroundednessInput,
                com.google.cloud.aiplatform.v1beta1.GroundednessInput.Builder,
                com.google.cloud.aiplatform.v1beta1.GroundednessInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GroundednessInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 9;
      onChanged();
      return groundednessInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FulfillmentInput,
            com.google.cloud.aiplatform.v1beta1.FulfillmentInput.Builder,
            com.google.cloud.aiplatform.v1beta1.FulfillmentInputOrBuilder>
        fulfillmentInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     *
     * @return Whether the fulfillmentInput field is set.
     */
    @java.lang.Override
    public boolean hasFulfillmentInput() {
      return metricInputsCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     *
     * @return The fulfillmentInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FulfillmentInput getFulfillmentInput() {
      if (fulfillmentInputBuilder_ == null) {
        if (metricInputsCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 12) {
          return fulfillmentInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    public Builder setFulfillmentInput(com.google.cloud.aiplatform.v1beta1.FulfillmentInput value) {
      if (fulfillmentInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        fulfillmentInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    public Builder setFulfillmentInput(
        com.google.cloud.aiplatform.v1beta1.FulfillmentInput.Builder builderForValue) {
      if (fulfillmentInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        fulfillmentInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    public Builder mergeFulfillmentInput(
        com.google.cloud.aiplatform.v1beta1.FulfillmentInput value) {
      if (fulfillmentInputBuilder_ == null) {
        if (metricInputsCase_ == 12
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.FulfillmentInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 12) {
          fulfillmentInputBuilder_.mergeFrom(value);
        } else {
          fulfillmentInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    public Builder clearFulfillmentInput() {
      if (fulfillmentInputBuilder_ == null) {
        if (metricInputsCase_ == 12) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 12) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        fulfillmentInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FulfillmentInput.Builder
        getFulfillmentInputBuilder() {
      return getFulfillmentInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FulfillmentInputOrBuilder
        getFulfillmentInputOrBuilder() {
      if ((metricInputsCase_ == 12) && (fulfillmentInputBuilder_ != null)) {
        return fulfillmentInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FulfillmentInput fulfillment_input = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FulfillmentInput,
            com.google.cloud.aiplatform.v1beta1.FulfillmentInput.Builder,
            com.google.cloud.aiplatform.v1beta1.FulfillmentInputOrBuilder>
        getFulfillmentInputFieldBuilder() {
      if (fulfillmentInputBuilder_ == null) {
        if (!(metricInputsCase_ == 12)) {
          metricInputs_ = com.google.cloud.aiplatform.v1beta1.FulfillmentInput.getDefaultInstance();
        }
        fulfillmentInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FulfillmentInput,
                com.google.cloud.aiplatform.v1beta1.FulfillmentInput.Builder,
                com.google.cloud.aiplatform.v1beta1.FulfillmentInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FulfillmentInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 12;
      onChanged();
      return fulfillmentInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput,
            com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SummarizationQualityInputOrBuilder>
        summarizationQualityInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     *
     * @return Whether the summarizationQualityInput field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationQualityInput() {
      return metricInputsCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     *
     * @return The summarizationQualityInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput
        getSummarizationQualityInput() {
      if (summarizationQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 7) {
          return summarizationQualityInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    public Builder setSummarizationQualityInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput value) {
      if (summarizationQualityInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        summarizationQualityInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    public Builder setSummarizationQualityInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.Builder builderForValue) {
      if (summarizationQualityInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        summarizationQualityInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    public Builder mergeSummarizationQualityInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput value) {
      if (summarizationQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 7
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 7) {
          summarizationQualityInputBuilder_.mergeFrom(value);
        } else {
          summarizationQualityInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    public Builder clearSummarizationQualityInput() {
      if (summarizationQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 7) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 7) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        summarizationQualityInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.Builder
        getSummarizationQualityInputBuilder() {
      return getSummarizationQualityInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SummarizationQualityInputOrBuilder
        getSummarizationQualityInputOrBuilder() {
      if ((metricInputsCase_ == 7) && (summarizationQualityInputBuilder_ != null)) {
        return summarizationQualityInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationQualityInput summarization_quality_input = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput,
            com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SummarizationQualityInputOrBuilder>
        getSummarizationQualityInputFieldBuilder() {
      if (summarizationQualityInputBuilder_ == null) {
        if (!(metricInputsCase_ == 7)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.getDefaultInstance();
        }
        summarizationQualityInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput,
                com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput.Builder,
                com.google.cloud.aiplatform.v1beta1.SummarizationQualityInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SummarizationQualityInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 7;
      onChanged();
      return summarizationQualityInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput,
            com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInputOrBuilder>
        pairwiseSummarizationQualityInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     *
     * @return Whether the pairwiseSummarizationQualityInput field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseSummarizationQualityInput() {
      return metricInputsCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     *
     * @return The pairwiseSummarizationQualityInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
        getPairwiseSummarizationQualityInput() {
      if (pairwiseSummarizationQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 23) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 23) {
          return pairwiseSummarizationQualityInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    public Builder setPairwiseSummarizationQualityInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput value) {
      if (pairwiseSummarizationQualityInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        pairwiseSummarizationQualityInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    public Builder setPairwiseSummarizationQualityInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput.Builder
            builderForValue) {
      if (pairwiseSummarizationQualityInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseSummarizationQualityInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    public Builder mergePairwiseSummarizationQualityInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput value) {
      if (pairwiseSummarizationQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 23
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 23) {
          pairwiseSummarizationQualityInputBuilder_.mergeFrom(value);
        } else {
          pairwiseSummarizationQualityInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    public Builder clearPairwiseSummarizationQualityInput() {
      if (pairwiseSummarizationQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 23) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 23) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        pairwiseSummarizationQualityInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput.Builder
        getPairwiseSummarizationQualityInputBuilder() {
      return getPairwiseSummarizationQualityInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInputOrBuilder
        getPairwiseSummarizationQualityInputOrBuilder() {
      if ((metricInputsCase_ == 23) && (pairwiseSummarizationQualityInputBuilder_ != null)) {
        return pairwiseSummarizationQualityInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 23) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput pairwise_summarization_quality_input = 23;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput,
            com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInputOrBuilder>
        getPairwiseSummarizationQualityInputFieldBuilder() {
      if (pairwiseSummarizationQualityInputBuilder_ == null) {
        if (!(metricInputsCase_ == 23)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput
                  .getDefaultInstance();
        }
        pairwiseSummarizationQualityInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput,
                com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput.Builder,
                com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PairwiseSummarizationQualityInput)
                    metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 23;
      onChanged();
      return pairwiseSummarizationQualityInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput,
            com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInputOrBuilder>
        summarizationHelpfulnessInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     *
     * @return Whether the summarizationHelpfulnessInput field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationHelpfulnessInput() {
      return metricInputsCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     *
     * @return The summarizationHelpfulnessInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
        getSummarizationHelpfulnessInput() {
      if (summarizationHelpfulnessInputBuilder_ == null) {
        if (metricInputsCase_ == 14) {
          return (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 14) {
          return summarizationHelpfulnessInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    public Builder setSummarizationHelpfulnessInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput value) {
      if (summarizationHelpfulnessInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        summarizationHelpfulnessInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    public Builder setSummarizationHelpfulnessInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.Builder builderForValue) {
      if (summarizationHelpfulnessInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        summarizationHelpfulnessInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    public Builder mergeSummarizationHelpfulnessInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput value) {
      if (summarizationHelpfulnessInputBuilder_ == null) {
        if (metricInputsCase_ == 14
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 14) {
          summarizationHelpfulnessInputBuilder_.mergeFrom(value);
        } else {
          summarizationHelpfulnessInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    public Builder clearSummarizationHelpfulnessInput() {
      if (summarizationHelpfulnessInputBuilder_ == null) {
        if (metricInputsCase_ == 14) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 14) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        summarizationHelpfulnessInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.Builder
        getSummarizationHelpfulnessInputBuilder() {
      return getSummarizationHelpfulnessInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInputOrBuilder
        getSummarizationHelpfulnessInputOrBuilder() {
      if ((metricInputsCase_ == 14) && (summarizationHelpfulnessInputBuilder_ != null)) {
        return summarizationHelpfulnessInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 14) {
          return (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput summarization_helpfulness_input = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput,
            com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInputOrBuilder>
        getSummarizationHelpfulnessInputFieldBuilder() {
      if (summarizationHelpfulnessInputBuilder_ == null) {
        if (!(metricInputsCase_ == 14)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput
                  .getDefaultInstance();
        }
        summarizationHelpfulnessInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput,
                com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput.Builder,
                com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SummarizationHelpfulnessInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 14;
      onChanged();
      return summarizationHelpfulnessInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput,
            com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInputOrBuilder>
        summarizationVerbosityInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     *
     * @return Whether the summarizationVerbosityInput field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationVerbosityInput() {
      return metricInputsCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     *
     * @return The summarizationVerbosityInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput
        getSummarizationVerbosityInput() {
      if (summarizationVerbosityInputBuilder_ == null) {
        if (metricInputsCase_ == 15) {
          return (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 15) {
          return summarizationVerbosityInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    public Builder setSummarizationVerbosityInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput value) {
      if (summarizationVerbosityInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        summarizationVerbosityInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    public Builder setSummarizationVerbosityInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.Builder builderForValue) {
      if (summarizationVerbosityInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        summarizationVerbosityInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    public Builder mergeSummarizationVerbosityInput(
        com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput value) {
      if (summarizationVerbosityInputBuilder_ == null) {
        if (metricInputsCase_ == 15
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 15) {
          summarizationVerbosityInputBuilder_.mergeFrom(value);
        } else {
          summarizationVerbosityInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    public Builder clearSummarizationVerbosityInput() {
      if (summarizationVerbosityInputBuilder_ == null) {
        if (metricInputsCase_ == 15) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 15) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        summarizationVerbosityInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.Builder
        getSummarizationVerbosityInputBuilder() {
      return getSummarizationVerbosityInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInputOrBuilder
        getSummarizationVerbosityInputOrBuilder() {
      if ((metricInputsCase_ == 15) && (summarizationVerbosityInputBuilder_ != null)) {
        return summarizationVerbosityInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 15) {
          return (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput summarization_verbosity_input = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput,
            com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInputOrBuilder>
        getSummarizationVerbosityInputFieldBuilder() {
      if (summarizationVerbosityInputBuilder_ == null) {
        if (!(metricInputsCase_ == 15)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.getDefaultInstance();
        }
        summarizationVerbosityInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput,
                com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput.Builder,
                com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SummarizationVerbosityInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 15;
      onChanged();
      return summarizationVerbosityInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInputOrBuilder>
        questionAnsweringQualityInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     *
     * @return Whether the questionAnsweringQualityInput field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringQualityInput() {
      return metricInputsCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     *
     * @return The questionAnsweringQualityInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
        getQuestionAnsweringQualityInput() {
      if (questionAnsweringQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 10) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 10) {
          return questionAnsweringQualityInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    public Builder setQuestionAnsweringQualityInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput value) {
      if (questionAnsweringQualityInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        questionAnsweringQualityInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    public Builder setQuestionAnsweringQualityInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.Builder builderForValue) {
      if (questionAnsweringQualityInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringQualityInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    public Builder mergeQuestionAnsweringQualityInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput value) {
      if (questionAnsweringQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 10
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 10) {
          questionAnsweringQualityInputBuilder_.mergeFrom(value);
        } else {
          questionAnsweringQualityInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    public Builder clearQuestionAnsweringQualityInput() {
      if (questionAnsweringQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 10) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 10) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        questionAnsweringQualityInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.Builder
        getQuestionAnsweringQualityInputBuilder() {
      return getQuestionAnsweringQualityInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInputOrBuilder
        getQuestionAnsweringQualityInputOrBuilder() {
      if ((metricInputsCase_ == 10) && (questionAnsweringQualityInputBuilder_ != null)) {
        return questionAnsweringQualityInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 10) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput question_answering_quality_input = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInputOrBuilder>
        getQuestionAnsweringQualityInputFieldBuilder() {
      if (questionAnsweringQualityInputBuilder_ == null) {
        if (!(metricInputsCase_ == 10)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput
                  .getDefaultInstance();
        }
        questionAnsweringQualityInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput.Builder,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringQualityInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 10;
      onChanged();
      return questionAnsweringQualityInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput,
            com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInputOrBuilder>
        pairwiseQuestionAnsweringQualityInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     *
     * @return Whether the pairwiseQuestionAnsweringQualityInput field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseQuestionAnsweringQualityInput() {
      return metricInputsCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     *
     * @return The pairwiseQuestionAnsweringQualityInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
        getPairwiseQuestionAnsweringQualityInput() {
      if (pairwiseQuestionAnsweringQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 24) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 24) {
          return pairwiseQuestionAnsweringQualityInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    public Builder setPairwiseQuestionAnsweringQualityInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput value) {
      if (pairwiseQuestionAnsweringQualityInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        pairwiseQuestionAnsweringQualityInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    public Builder setPairwiseQuestionAnsweringQualityInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput.Builder
            builderForValue) {
      if (pairwiseQuestionAnsweringQualityInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseQuestionAnsweringQualityInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    public Builder mergePairwiseQuestionAnsweringQualityInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput value) {
      if (pairwiseQuestionAnsweringQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 24
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 24) {
          pairwiseQuestionAnsweringQualityInputBuilder_.mergeFrom(value);
        } else {
          pairwiseQuestionAnsweringQualityInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    public Builder clearPairwiseQuestionAnsweringQualityInput() {
      if (pairwiseQuestionAnsweringQualityInputBuilder_ == null) {
        if (metricInputsCase_ == 24) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 24) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        pairwiseQuestionAnsweringQualityInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput.Builder
        getPairwiseQuestionAnsweringQualityInputBuilder() {
      return getPairwiseQuestionAnsweringQualityInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInputOrBuilder
        getPairwiseQuestionAnsweringQualityInputOrBuilder() {
      if ((metricInputsCase_ == 24) && (pairwiseQuestionAnsweringQualityInputBuilder_ != null)) {
        return pairwiseQuestionAnsweringQualityInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 24) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput pairwise_question_answering_quality_input = 24;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput,
            com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInputOrBuilder>
        getPairwiseQuestionAnsweringQualityInputFieldBuilder() {
      if (pairwiseQuestionAnsweringQualityInputBuilder_ == null) {
        if (!(metricInputsCase_ == 24)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput
                  .getDefaultInstance();
        }
        pairwiseQuestionAnsweringQualityInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput,
                com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput.Builder,
                com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PairwiseQuestionAnsweringQualityInput)
                    metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 24;
      onChanged();
      return pairwiseQuestionAnsweringQualityInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInputOrBuilder>
        questionAnsweringRelevanceInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     *
     * @return Whether the questionAnsweringRelevanceInput field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringRelevanceInput() {
      return metricInputsCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     *
     * @return The questionAnsweringRelevanceInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
        getQuestionAnsweringRelevanceInput() {
      if (questionAnsweringRelevanceInputBuilder_ == null) {
        if (metricInputsCase_ == 16) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 16) {
          return questionAnsweringRelevanceInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    public Builder setQuestionAnsweringRelevanceInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput value) {
      if (questionAnsweringRelevanceInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        questionAnsweringRelevanceInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    public Builder setQuestionAnsweringRelevanceInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.Builder
            builderForValue) {
      if (questionAnsweringRelevanceInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringRelevanceInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    public Builder mergeQuestionAnsweringRelevanceInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput value) {
      if (questionAnsweringRelevanceInputBuilder_ == null) {
        if (metricInputsCase_ == 16
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 16) {
          questionAnsweringRelevanceInputBuilder_.mergeFrom(value);
        } else {
          questionAnsweringRelevanceInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    public Builder clearQuestionAnsweringRelevanceInput() {
      if (questionAnsweringRelevanceInputBuilder_ == null) {
        if (metricInputsCase_ == 16) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 16) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        questionAnsweringRelevanceInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.Builder
        getQuestionAnsweringRelevanceInputBuilder() {
      return getQuestionAnsweringRelevanceInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInputOrBuilder
        getQuestionAnsweringRelevanceInputOrBuilder() {
      if ((metricInputsCase_ == 16) && (questionAnsweringRelevanceInputBuilder_ != null)) {
        return questionAnsweringRelevanceInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 16) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput question_answering_relevance_input = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInputOrBuilder>
        getQuestionAnsweringRelevanceInputFieldBuilder() {
      if (questionAnsweringRelevanceInputBuilder_ == null) {
        if (!(metricInputsCase_ == 16)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput
                  .getDefaultInstance();
        }
        questionAnsweringRelevanceInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput.Builder,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringRelevanceInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 16;
      onChanged();
      return questionAnsweringRelevanceInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInputOrBuilder>
        questionAnsweringHelpfulnessInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     *
     * @return Whether the questionAnsweringHelpfulnessInput field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringHelpfulnessInput() {
      return metricInputsCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     *
     * @return The questionAnsweringHelpfulnessInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
        getQuestionAnsweringHelpfulnessInput() {
      if (questionAnsweringHelpfulnessInputBuilder_ == null) {
        if (metricInputsCase_ == 17) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 17) {
          return questionAnsweringHelpfulnessInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    public Builder setQuestionAnsweringHelpfulnessInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput value) {
      if (questionAnsweringHelpfulnessInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        questionAnsweringHelpfulnessInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    public Builder setQuestionAnsweringHelpfulnessInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput.Builder
            builderForValue) {
      if (questionAnsweringHelpfulnessInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringHelpfulnessInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    public Builder mergeQuestionAnsweringHelpfulnessInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput value) {
      if (questionAnsweringHelpfulnessInputBuilder_ == null) {
        if (metricInputsCase_ == 17
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 17) {
          questionAnsweringHelpfulnessInputBuilder_.mergeFrom(value);
        } else {
          questionAnsweringHelpfulnessInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    public Builder clearQuestionAnsweringHelpfulnessInput() {
      if (questionAnsweringHelpfulnessInputBuilder_ == null) {
        if (metricInputsCase_ == 17) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 17) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        questionAnsweringHelpfulnessInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput.Builder
        getQuestionAnsweringHelpfulnessInputBuilder() {
      return getQuestionAnsweringHelpfulnessInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInputOrBuilder
        getQuestionAnsweringHelpfulnessInputOrBuilder() {
      if ((metricInputsCase_ == 17) && (questionAnsweringHelpfulnessInputBuilder_ != null)) {
        return questionAnsweringHelpfulnessInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 17) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering helpfulness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput question_answering_helpfulness_input = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInputOrBuilder>
        getQuestionAnsweringHelpfulnessInputFieldBuilder() {
      if (questionAnsweringHelpfulnessInputBuilder_ == null) {
        if (!(metricInputsCase_ == 17)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput
                  .getDefaultInstance();
        }
        questionAnsweringHelpfulnessInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput.Builder,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringHelpfulnessInput)
                    metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 17;
      onChanged();
      return questionAnsweringHelpfulnessInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInputOrBuilder>
        questionAnsweringCorrectnessInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     *
     * @return Whether the questionAnsweringCorrectnessInput field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringCorrectnessInput() {
      return metricInputsCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     *
     * @return The questionAnsweringCorrectnessInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
        getQuestionAnsweringCorrectnessInput() {
      if (questionAnsweringCorrectnessInputBuilder_ == null) {
        if (metricInputsCase_ == 18) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
            .getDefaultInstance();
      } else {
        if (metricInputsCase_ == 18) {
          return questionAnsweringCorrectnessInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    public Builder setQuestionAnsweringCorrectnessInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput value) {
      if (questionAnsweringCorrectnessInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        questionAnsweringCorrectnessInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    public Builder setQuestionAnsweringCorrectnessInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput.Builder
            builderForValue) {
      if (questionAnsweringCorrectnessInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringCorrectnessInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    public Builder mergeQuestionAnsweringCorrectnessInput(
        com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput value) {
      if (questionAnsweringCorrectnessInputBuilder_ == null) {
        if (metricInputsCase_ == 18
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 18) {
          questionAnsweringCorrectnessInputBuilder_.mergeFrom(value);
        } else {
          questionAnsweringCorrectnessInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    public Builder clearQuestionAnsweringCorrectnessInput() {
      if (questionAnsweringCorrectnessInputBuilder_ == null) {
        if (metricInputsCase_ == 18) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 18) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        questionAnsweringCorrectnessInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput.Builder
        getQuestionAnsweringCorrectnessInputBuilder() {
      return getQuestionAnsweringCorrectnessInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInputOrBuilder
        getQuestionAnsweringCorrectnessInputOrBuilder() {
      if ((metricInputsCase_ == 18) && (questionAnsweringCorrectnessInputBuilder_ != null)) {
        return questionAnsweringCorrectnessInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 18) {
          return (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput)
              metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for question answering correctness
     * metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput question_answering_correctness_input = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput.Builder,
            com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInputOrBuilder>
        getQuestionAnsweringCorrectnessInputFieldBuilder() {
      if (questionAnsweringCorrectnessInputBuilder_ == null) {
        if (!(metricInputsCase_ == 18)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput
                  .getDefaultInstance();
        }
        questionAnsweringCorrectnessInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput.Builder,
                com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.QuestionAnsweringCorrectnessInput)
                    metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 18;
      onChanged();
      return questionAnsweringCorrectnessInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricInputOrBuilder>
        pointwiseMetricInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     *
     * @return Whether the pointwiseMetricInput field is set.
     */
    @java.lang.Override
    public boolean hasPointwiseMetricInput() {
      return metricInputsCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     *
     * @return The pointwiseMetricInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput getPointwiseMetricInput() {
      if (pointwiseMetricInputBuilder_ == null) {
        if (metricInputsCase_ == 28) {
          return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 28) {
          return pointwiseMetricInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    public Builder setPointwiseMetricInput(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput value) {
      if (pointwiseMetricInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        pointwiseMetricInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    public Builder setPointwiseMetricInput(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.Builder builderForValue) {
      if (pointwiseMetricInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        pointwiseMetricInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    public Builder mergePointwiseMetricInput(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput value) {
      if (pointwiseMetricInputBuilder_ == null) {
        if (metricInputsCase_ == 28
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 28) {
          pointwiseMetricInputBuilder_.mergeFrom(value);
        } else {
          pointwiseMetricInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    public Builder clearPointwiseMetricInput() {
      if (pointwiseMetricInputBuilder_ == null) {
        if (metricInputsCase_ == 28) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 28) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        pointwiseMetricInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.Builder
        getPointwiseMetricInputBuilder() {
      return getPointwiseMetricInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricInputOrBuilder
        getPointwiseMetricInputOrBuilder() {
      if ((metricInputsCase_ == 28) && (pointwiseMetricInputBuilder_ != null)) {
        return pointwiseMetricInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 28) {
          return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricInput pointwise_metric_input = 28;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricInputOrBuilder>
        getPointwiseMetricInputFieldBuilder() {
      if (pointwiseMetricInputBuilder_ == null) {
        if (!(metricInputsCase_ == 28)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.getDefaultInstance();
        }
        pointwiseMetricInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput,
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput.Builder,
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PointwiseMetricInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 28;
      onChanged();
      return pointwiseMetricInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricInputOrBuilder>
        pairwiseMetricInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     *
     * @return Whether the pairwiseMetricInput field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseMetricInput() {
      return metricInputsCase_ == 29;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     *
     * @return The pairwiseMetricInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput getPairwiseMetricInput() {
      if (pairwiseMetricInputBuilder_ == null) {
        if (metricInputsCase_ == 29) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 29) {
          return pairwiseMetricInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    public Builder setPairwiseMetricInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput value) {
      if (pairwiseMetricInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        pairwiseMetricInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    public Builder setPairwiseMetricInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.Builder builderForValue) {
      if (pairwiseMetricInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseMetricInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    public Builder mergePairwiseMetricInput(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput value) {
      if (pairwiseMetricInputBuilder_ == null) {
        if (metricInputsCase_ == 29
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 29) {
          pairwiseMetricInputBuilder_.mergeFrom(value);
        } else {
          pairwiseMetricInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    public Builder clearPairwiseMetricInput() {
      if (pairwiseMetricInputBuilder_ == null) {
        if (metricInputsCase_ == 29) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 29) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        pairwiseMetricInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.Builder
        getPairwiseMetricInputBuilder() {
      return getPairwiseMetricInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricInputOrBuilder
        getPairwiseMetricInputOrBuilder() {
      if ((metricInputsCase_ == 29) && (pairwiseMetricInputBuilder_ != null)) {
        return pairwiseMetricInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 29) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricInput pairwise_metric_input = 29;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricInputOrBuilder>
        getPairwiseMetricInputFieldBuilder() {
      if (pairwiseMetricInputBuilder_ == null) {
        if (!(metricInputsCase_ == 29)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.getDefaultInstance();
        }
        pairwiseMetricInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput,
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput.Builder,
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PairwiseMetricInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 29;
      onChanged();
      return pairwiseMetricInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolCallValidInput,
            com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolCallValidInputOrBuilder>
        toolCallValidInputBuilder_;
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     *
     * @return Whether the toolCallValidInput field is set.
     */
    @java.lang.Override
    public boolean hasToolCallValidInput() {
      return metricInputsCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     *
     * @return The toolCallValidInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolCallValidInput getToolCallValidInput() {
      if (toolCallValidInputBuilder_ == null) {
        if (metricInputsCase_ == 19) {
          return (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 19) {
          return toolCallValidInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    public Builder setToolCallValidInput(
        com.google.cloud.aiplatform.v1beta1.ToolCallValidInput value) {
      if (toolCallValidInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        toolCallValidInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    public Builder setToolCallValidInput(
        com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.Builder builderForValue) {
      if (toolCallValidInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        toolCallValidInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    public Builder mergeToolCallValidInput(
        com.google.cloud.aiplatform.v1beta1.ToolCallValidInput value) {
      if (toolCallValidInputBuilder_ == null) {
        if (metricInputsCase_ == 19
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 19) {
          toolCallValidInputBuilder_.mergeFrom(value);
        } else {
          toolCallValidInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    public Builder clearToolCallValidInput() {
      if (toolCallValidInputBuilder_ == null) {
        if (metricInputsCase_ == 19) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 19) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        toolCallValidInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.Builder
        getToolCallValidInputBuilder() {
      return getToolCallValidInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolCallValidInputOrBuilder
        getToolCallValidInputOrBuilder() {
      if ((metricInputsCase_ == 19) && (toolCallValidInputBuilder_ != null)) {
        return toolCallValidInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 19) {
          return (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tool call metric instances.
     * Input for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolCallValidInput tool_call_valid_input = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolCallValidInput,
            com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolCallValidInputOrBuilder>
        getToolCallValidInputFieldBuilder() {
      if (toolCallValidInputBuilder_ == null) {
        if (!(metricInputsCase_ == 19)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.getDefaultInstance();
        }
        toolCallValidInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolCallValidInput,
                com.google.cloud.aiplatform.v1beta1.ToolCallValidInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolCallValidInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ToolCallValidInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 19;
      onChanged();
      return toolCallValidInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput,
            com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolNameMatchInputOrBuilder>
        toolNameMatchInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     *
     * @return Whether the toolNameMatchInput field is set.
     */
    @java.lang.Override
    public boolean hasToolNameMatchInput() {
      return metricInputsCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     *
     * @return The toolNameMatchInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput getToolNameMatchInput() {
      if (toolNameMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 20) {
          return (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 20) {
          return toolNameMatchInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    public Builder setToolNameMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput value) {
      if (toolNameMatchInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        toolNameMatchInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    public Builder setToolNameMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.Builder builderForValue) {
      if (toolNameMatchInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        toolNameMatchInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    public Builder mergeToolNameMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput value) {
      if (toolNameMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 20
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 20) {
          toolNameMatchInputBuilder_.mergeFrom(value);
        } else {
          toolNameMatchInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    public Builder clearToolNameMatchInput() {
      if (toolNameMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 20) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 20) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        toolNameMatchInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.Builder
        getToolNameMatchInputBuilder() {
      return getToolNameMatchInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolNameMatchInputOrBuilder
        getToolNameMatchInputOrBuilder() {
      if ((metricInputsCase_ == 20) && (toolNameMatchInputBuilder_ != null)) {
        return toolNameMatchInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 20) {
          return (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ToolNameMatchInput tool_name_match_input = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput,
            com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolNameMatchInputOrBuilder>
        getToolNameMatchInputFieldBuilder() {
      if (toolNameMatchInputBuilder_ == null) {
        if (!(metricInputsCase_ == 20)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.getDefaultInstance();
        }
        toolNameMatchInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput,
                com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolNameMatchInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ToolNameMatchInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 20;
      onChanged();
      return toolNameMatchInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInputOrBuilder>
        toolParameterKeyMatchInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     *
     * @return Whether the toolParameterKeyMatchInput field is set.
     */
    @java.lang.Override
    public boolean hasToolParameterKeyMatchInput() {
      return metricInputsCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     *
     * @return The toolParameterKeyMatchInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput
        getToolParameterKeyMatchInput() {
      if (toolParameterKeyMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 21) {
          return (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 21) {
          return toolParameterKeyMatchInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    public Builder setToolParameterKeyMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput value) {
      if (toolParameterKeyMatchInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        toolParameterKeyMatchInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    public Builder setToolParameterKeyMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.Builder builderForValue) {
      if (toolParameterKeyMatchInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        toolParameterKeyMatchInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    public Builder mergeToolParameterKeyMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput value) {
      if (toolParameterKeyMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 21
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput)
                          metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 21) {
          toolParameterKeyMatchInputBuilder_.mergeFrom(value);
        } else {
          toolParameterKeyMatchInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    public Builder clearToolParameterKeyMatchInput() {
      if (toolParameterKeyMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 21) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 21) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        toolParameterKeyMatchInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.Builder
        getToolParameterKeyMatchInputBuilder() {
      return getToolParameterKeyMatchInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInputOrBuilder
        getToolParameterKeyMatchInputOrBuilder() {
      if ((metricInputsCase_ == 21) && (toolParameterKeyMatchInputBuilder_ != null)) {
        return toolParameterKeyMatchInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 21) {
          return (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput tool_parameter_key_match_input = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInputOrBuilder>
        getToolParameterKeyMatchInputFieldBuilder() {
      if (toolParameterKeyMatchInputBuilder_ == null) {
        if (!(metricInputsCase_ == 21)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.getDefaultInstance();
        }
        toolParameterKeyMatchInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput,
                com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ToolParameterKeyMatchInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 21;
      onChanged();
      return toolParameterKeyMatchInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInputOrBuilder>
        toolParameterKvMatchInputBuilder_;
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     *
     * @return Whether the toolParameterKvMatchInput field is set.
     */
    @java.lang.Override
    public boolean hasToolParameterKvMatchInput() {
      return metricInputsCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     *
     * @return The toolParameterKvMatchInput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput
        getToolParameterKvMatchInput() {
      if (toolParameterKvMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 22) {
          return (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.getDefaultInstance();
      } else {
        if (metricInputsCase_ == 22) {
          return toolParameterKvMatchInputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    public Builder setToolParameterKvMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput value) {
      if (toolParameterKvMatchInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricInputs_ = value;
        onChanged();
      } else {
        toolParameterKvMatchInputBuilder_.setMessage(value);
      }
      metricInputsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    public Builder setToolParameterKvMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.Builder builderForValue) {
      if (toolParameterKvMatchInputBuilder_ == null) {
        metricInputs_ = builderForValue.build();
        onChanged();
      } else {
        toolParameterKvMatchInputBuilder_.setMessage(builderForValue.build());
      }
      metricInputsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    public Builder mergeToolParameterKvMatchInput(
        com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput value) {
      if (toolParameterKvMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 22
            && metricInputs_
                != com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput
                    .getDefaultInstance()) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricInputs_ = value;
        }
        onChanged();
      } else {
        if (metricInputsCase_ == 22) {
          toolParameterKvMatchInputBuilder_.mergeFrom(value);
        } else {
          toolParameterKvMatchInputBuilder_.setMessage(value);
        }
      }
      metricInputsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    public Builder clearToolParameterKvMatchInput() {
      if (toolParameterKvMatchInputBuilder_ == null) {
        if (metricInputsCase_ == 22) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
          onChanged();
        }
      } else {
        if (metricInputsCase_ == 22) {
          metricInputsCase_ = 0;
          metricInputs_ = null;
        }
        toolParameterKvMatchInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.Builder
        getToolParameterKvMatchInputBuilder() {
      return getToolParameterKvMatchInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInputOrBuilder
        getToolParameterKvMatchInputOrBuilder() {
      if ((metricInputsCase_ == 22) && (toolParameterKvMatchInputBuilder_ != null)) {
        return toolParameterKvMatchInputBuilder_.getMessageOrBuilder();
      } else {
        if (metricInputsCase_ == 22) {
          return (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_;
        }
        return com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput tool_parameter_kv_match_input = 22;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInputOrBuilder>
        getToolParameterKvMatchInputFieldBuilder() {
      if (toolParameterKvMatchInputBuilder_ == null) {
        if (!(metricInputsCase_ == 22)) {
          metricInputs_ =
              com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.getDefaultInstance();
        }
        toolParameterKvMatchInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput,
                com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ToolParameterKVMatchInput) metricInputs_,
                getParentForChildren(),
                isClean());
        metricInputs_ = null;
      }
      metricInputsCase_ = 22;
      onChanged();
      return toolParameterKvMatchInputBuilder_;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the instances.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the instances.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the instances.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the instances.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to evaluate the instances.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluateInstancesRequest> PARSER =
      new com.google.protobuf.AbstractParser<EvaluateInstancesRequest>() {
        @java.lang.Override
        public EvaluateInstancesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EvaluateInstancesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluateInstancesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluateInstancesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
