/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/cached_content.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A resource used in LLM queries for users to explicitly specify what to cache
 * and how to cache.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.CachedContent}
 */
public final class CachedContent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.CachedContent)
    CachedContentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CachedContent.newBuilder() to construct.
  private CachedContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CachedContent() {
    name_ = "";
    displayName_ = "";
    model_ = "";
    contents_ = java.util.Collections.emptyList();
    tools_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CachedContent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.CachedContentProto
        .internal_static_google_cloud_aiplatform_v1beta1_CachedContent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.CachedContentProto
        .internal_static_google_cloud_aiplatform_v1beta1_CachedContent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.CachedContent.class,
            com.google.cloud.aiplatform.v1beta1.CachedContent.Builder.class);
  }

  private int bitField0_;
  private int expirationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object expiration_;

  public enum ExpirationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPIRE_TIME(9),
    TTL(10),
    EXPIRATION_NOT_SET(0);
    private final int value;

    private ExpirationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpirationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExpirationCase forNumber(int value) {
      switch (value) {
        case 9:
          return EXPIRE_TIME;
        case 10:
          return TTL;
        case 0:
          return EXPIRATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExpirationCase getExpirationCase() {
    return ExpirationCase.forNumber(expirationCase_);
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Timestamp of when this resource is considered expired.
   * This is *always* provided on output, regardless of what was sent
   * on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expirationCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Timestamp of when this resource is considered expired.
   * This is *always* provided on output, regardless of what was sent
   * on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    if (expirationCase_ == 9) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Timestamp of when this resource is considered expired.
   * This is *always* provided on output, regardless of what was sent
   * on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    if (expirationCase_ == 9) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TTL_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Input only. The TTL for this resource. The expiration time is computed:
   * now + TTL.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return expirationCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL for this resource. The expiration time is computed:
   * now + TTL.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    if (expirationCase_ == 10) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL for this resource. The expiration time is computed:
   * now + TTL.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    if (expirationCase_ == 10) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Identifier. The server-generated resource name of the cached
   * content Format:
   * projects/{project}/locations/{location}/cachedContents/{cached_content}
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Identifier. The server-generated resource name of the cached
   * content Format:
   * projects/{project}/locations/{location}/cachedContents/{cached_content}
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The user-generated meaningful display name of the
   * cached content.
   * </pre>
   *
   * <code>
   * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The user-generated meaningful display name of the
   * cached content.
   * </pre>
   *
   * <code>
   * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The name of the publisher model to use for cached content.
   * Format:
   * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
   * </pre>
   *
   * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The name of the publisher model to use for cached content.
   * Format:
   * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
   * </pre>
   *
   * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SYSTEM_INSTRUCTION_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.Content systemInstruction_;
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Developer set system instruction.
   * Currently, text only
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the systemInstruction field is set.
   */
  @java.lang.Override
  public boolean hasSystemInstruction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Developer set system instruction.
   * Currently, text only
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The systemInstruction.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getSystemInstruction() {
    return systemInstruction_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : systemInstruction_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Developer set system instruction.
   * Currently, text only
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getSystemInstructionOrBuilder() {
    return systemInstruction_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : systemInstruction_;
  }

  public static final int CONTENTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> contents_;
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. The content to cache
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getContentsList() {
    return contents_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. The content to cache
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
      getContentsOrBuilderList() {
    return contents_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. The content to cache
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getContentsCount() {
    return contents_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. The content to cache
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getContents(int index) {
    return contents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. The content to cache
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentsOrBuilder(int index) {
    return contents_.get(index);
  }

  public static final int TOOLS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> tools_;
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. A list of `Tools` the model may use to
   * generate the next response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> getToolsList() {
    return tools_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. A list of `Tools` the model may use to
   * generate the next response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
      getToolsOrBuilderList() {
    return tools_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. A list of `Tools` the model may use to
   * generate the next response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getToolsCount() {
    return tools_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. A list of `Tools` the model may use to
   * generate the next response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tool getTools(int index) {
    return tools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. A list of `Tools` the model may use to
   * generate the next response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolOrBuilder getToolsOrBuilder(int index) {
    return tools_.get(index);
  }

  public static final int TOOL_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.ToolConfig toolConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tool config. This config is shared for all
   * tools
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the toolConfig field is set.
   */
  @java.lang.Override
  public boolean hasToolConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tool config. This config is shared for all
   * tools
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The toolConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolConfig getToolConfig() {
    return toolConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
        : toolConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tool config. This config is shared for all
   * tools
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder getToolConfigOrBuilder() {
    return toolConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
        : toolConfig_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creatation time of the cache entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Creatation time of the cache entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creatation time of the cache entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the cache entry was last updated in UTC time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. When the cache entry was last updated in UTC time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the cache entry was last updated in UTC time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, model_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSystemInstruction());
    }
    for (int i = 0; i < contents_.size(); i++) {
      output.writeMessage(4, contents_.get(i));
    }
    for (int i = 0; i < tools_.size(); i++) {
      output.writeMessage(5, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getToolConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getUpdateTime());
    }
    if (expirationCase_ == 9) {
      output.writeMessage(9, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 10) {
      output.writeMessage(10, (com.google.protobuf.Duration) expiration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, model_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSystemInstruction());
    }
    for (int i = 0; i < contents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, contents_.get(i));
    }
    for (int i = 0; i < tools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getToolConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (expirationCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.protobuf.Duration) expiration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.CachedContent)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.CachedContent other =
        (com.google.cloud.aiplatform.v1beta1.CachedContent) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (hasSystemInstruction() != other.hasSystemInstruction()) return false;
    if (hasSystemInstruction()) {
      if (!getSystemInstruction().equals(other.getSystemInstruction())) return false;
    }
    if (!getContentsList().equals(other.getContentsList())) return false;
    if (!getToolsList().equals(other.getToolsList())) return false;
    if (hasToolConfig() != other.hasToolConfig()) return false;
    if (hasToolConfig()) {
      if (!getToolConfig().equals(other.getToolConfig())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getExpirationCase().equals(other.getExpirationCase())) return false;
    switch (expirationCase_) {
      case 9:
        if (!getExpireTime().equals(other.getExpireTime())) return false;
        break;
      case 10:
        if (!getTtl().equals(other.getTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (hasSystemInstruction()) {
      hash = (37 * hash) + SYSTEM_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getSystemInstruction().hashCode();
    }
    if (getContentsCount() > 0) {
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContentsList().hashCode();
    }
    if (getToolsCount() > 0) {
      hash = (37 * hash) + TOOLS_FIELD_NUMBER;
      hash = (53 * hash) + getToolsList().hashCode();
    }
    if (hasToolConfig()) {
      hash = (37 * hash) + TOOL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getToolConfig().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (expirationCase_) {
      case 9:
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
        break;
      case 10:
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.CachedContent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource used in LLM queries for users to explicitly specify what to cache
   * and how to cache.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.CachedContent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.CachedContent)
      com.google.cloud.aiplatform.v1beta1.CachedContentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.CachedContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_CachedContent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.CachedContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_CachedContent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.CachedContent.class,
              com.google.cloud.aiplatform.v1beta1.CachedContent.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.CachedContent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSystemInstructionFieldBuilder();
        getContentsFieldBuilder();
        getToolsFieldBuilder();
        getToolConfigFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.clear();
      }
      if (ttlBuilder_ != null) {
        ttlBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      model_ = "";
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
      } else {
        contents_ = null;
        contentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
      } else {
        tools_ = null;
        toolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      toolConfig_ = null;
      if (toolConfigBuilder_ != null) {
        toolConfigBuilder_.dispose();
        toolConfigBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      expirationCase_ = 0;
      expiration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.CachedContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_CachedContent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CachedContent getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.CachedContent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CachedContent build() {
      com.google.cloud.aiplatform.v1beta1.CachedContent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CachedContent buildPartial() {
      com.google.cloud.aiplatform.v1beta1.CachedContent result =
          new com.google.cloud.aiplatform.v1beta1.CachedContent(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.CachedContent result) {
      if (contentsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          contents_ = java.util.Collections.unmodifiableList(contents_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.contents_ = contents_;
      } else {
        result.contents_ = contentsBuilder_.build();
      }
      if (toolsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          tools_ = java.util.Collections.unmodifiableList(tools_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.tools_ = tools_;
      } else {
        result.tools_ = toolsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.CachedContent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.model_ = model_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.systemInstruction_ =
            systemInstructionBuilder_ == null
                ? systemInstruction_
                : systemInstructionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.toolConfig_ = toolConfigBuilder_ == null ? toolConfig_ : toolConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.CachedContent result) {
      result.expirationCase_ = expirationCase_;
      result.expiration_ = this.expiration_;
      if (expirationCase_ == 9 && expireTimeBuilder_ != null) {
        result.expiration_ = expireTimeBuilder_.build();
      }
      if (expirationCase_ == 10 && ttlBuilder_ != null) {
        result.expiration_ = ttlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.CachedContent) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.CachedContent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.CachedContent other) {
      if (other == com.google.cloud.aiplatform.v1beta1.CachedContent.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSystemInstruction()) {
        mergeSystemInstruction(other.getSystemInstruction());
      }
      if (contentsBuilder_ == null) {
        if (!other.contents_.isEmpty()) {
          if (contents_.isEmpty()) {
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureContentsIsMutable();
            contents_.addAll(other.contents_);
          }
          onChanged();
        }
      } else {
        if (!other.contents_.isEmpty()) {
          if (contentsBuilder_.isEmpty()) {
            contentsBuilder_.dispose();
            contentsBuilder_ = null;
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000040);
            contentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentsFieldBuilder()
                    : null;
          } else {
            contentsBuilder_.addAllMessages(other.contents_);
          }
        }
      }
      if (toolsBuilder_ == null) {
        if (!other.tools_.isEmpty()) {
          if (tools_.isEmpty()) {
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureToolsIsMutable();
            tools_.addAll(other.tools_);
          }
          onChanged();
        }
      } else {
        if (!other.tools_.isEmpty()) {
          if (toolsBuilder_.isEmpty()) {
            toolsBuilder_.dispose();
            toolsBuilder_ = null;
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000080);
            toolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getToolsFieldBuilder()
                    : null;
          } else {
            toolsBuilder_.addAllMessages(other.tools_);
          }
        }
      }
      if (other.hasToolConfig()) {
        mergeToolConfig(other.getToolConfig());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getExpirationCase()) {
        case EXPIRE_TIME:
          {
            mergeExpireTime(other.getExpireTime());
            break;
          }
        case TTL:
          {
            mergeTtl(other.getTtl());
            break;
          }
        case EXPIRATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getSystemInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.Content m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Content.parser(), extensionRegistry);
                if (contentsBuilder_ == null) {
                  ensureContentsIsMutable();
                  contents_.add(m);
                } else {
                  contentsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.aiplatform.v1beta1.Tool m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Tool.parser(), extensionRegistry);
                if (toolsBuilder_ == null) {
                  ensureToolsIsMutable();
                  tools_.add(m);
                } else {
                  toolsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getToolConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int expirationCase_ = 0;
    private java.lang.Object expiration_;

    public ExpirationCase getExpirationCase() {
      return ExpirationCase.forNumber(expirationCase_);
    }

    public Builder clearExpiration() {
      expirationCase_ = 0;
      expiration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expirationCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 9) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (expirationCase_ == 9) {
          return expireTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      expirationCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 9
            && expiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 9) {
          expireTimeBuilder_.mergeFrom(value);
        } else {
          expireTimeBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 9) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 9) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        expireTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if ((expirationCase_ == 9) && (expireTimeBuilder_ != null)) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 9) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp of when this resource is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        if (!(expirationCase_ == 9)) {
          expiration_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 9;
      onChanged();
      return expireTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return expirationCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The ttl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 10) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (expirationCase_ == 10) {
          return ttlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        ttlBuilder_.setMessage(value);
      }
      expirationCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 10
            && expiration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 10) {
          ttlBuilder_.mergeFrom(value);
        } else {
          ttlBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder clearTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 10) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 10) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        ttlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      return getTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if ((expirationCase_ == 10) && (ttlBuilder_ != null)) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 10) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. The expiration time is computed:
     * now + TTL.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 10 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        if (!(expirationCase_ == 10)) {
          expiration_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 10;
      onChanged();
      return ttlBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The server-generated resource name of the cached
     * content Format:
     * projects/{project}/locations/{location}/cachedContents/{cached_content}
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The server-generated resource name of the cached
     * content Format:
     * projects/{project}/locations/{location}/cachedContents/{cached_content}
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The server-generated resource name of the cached
     * content Format:
     * projects/{project}/locations/{location}/cachedContents/{cached_content}
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The server-generated resource name of the cached
     * content Format:
     * projects/{project}/locations/{location}/cachedContents/{cached_content}
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The server-generated resource name of the cached
     * content Format:
     * projects/{project}/locations/{location}/cachedContents/{cached_content}
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The user-generated meaningful display name of the
     * cached content.
     * </pre>
     *
     * <code>
     * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The user-generated meaningful display name of the
     * cached content.
     * </pre>
     *
     * <code>
     * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The user-generated meaningful display name of the
     * cached content.
     * </pre>
     *
     * <code>
     * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The user-generated meaningful display name of the
     * cached content.
     * </pre>
     *
     * <code>
     * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The user-generated meaningful display name of the
     * cached content.
     * </pre>
     *
     * <code>
     * string display_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The name of the publisher model to use for cached content.
     * Format:
     * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * </pre>
     *
     * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the publisher model to use for cached content.
     * Format:
     * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * </pre>
     *
     * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the publisher model to use for cached content.
     * Format:
     * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * </pre>
     *
     * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the publisher model to use for cached content.
     * Format:
     * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * </pre>
     *
     * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the publisher model to use for cached content.
     * Format:
     * projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * </pre>
     *
     * <code>string model = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Content systemInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        systemInstructionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the systemInstruction field is set.
     */
    public boolean hasSystemInstruction() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The systemInstruction.
     */
    public com.google.cloud.aiplatform.v1beta1.Content getSystemInstruction() {
      if (systemInstructionBuilder_ == null) {
        return systemInstruction_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : systemInstruction_;
      } else {
        return systemInstructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setSystemInstruction(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemInstruction_ = value;
      } else {
        systemInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setSystemInstruction(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (systemInstructionBuilder_ == null) {
        systemInstruction_ = builderForValue.build();
      } else {
        systemInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeSystemInstruction(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && systemInstruction_ != null
            && systemInstruction_
                != com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()) {
          getSystemInstructionBuilder().mergeFrom(value);
        } else {
          systemInstruction_ = value;
        }
      } else {
        systemInstructionBuilder_.mergeFrom(value);
      }
      if (systemInstruction_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearSystemInstruction() {
      bitField0_ = (bitField0_ & ~0x00000020);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getSystemInstructionBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSystemInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getSystemInstructionOrBuilder() {
      if (systemInstructionBuilder_ != null) {
        return systemInstructionBuilder_.getMessageOrBuilder();
      } else {
        return systemInstruction_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : systemInstruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Developer set system instruction.
     * Currently, text only
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content system_instruction = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getSystemInstructionFieldBuilder() {
      if (systemInstructionBuilder_ == null) {
        systemInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                getSystemInstruction(), getParentForChildren(), isClean());
        systemInstruction_ = null;
      }
      return systemInstructionBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> contents_ =
        java.util.Collections.emptyList();

    private void ensureContentsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        contents_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Content>(contents_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        contentsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getContentsList() {
      if (contentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contents_);
      } else {
        return contentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public int getContentsCount() {
      if (contentsBuilder_ == null) {
        return contents_.size();
      } else {
        return contentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content getContents(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setContents(int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.set(index, value);
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setContents(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addContents(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addContents(int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(index, value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addContents(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addContents(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addAllContents(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Content> values) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contents_);
        onChanged();
      } else {
        contentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearContents() {
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        contentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder removeContents(int index) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.remove(index);
        onChanged();
      } else {
        contentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getContentsBuilder(int index) {
      return getContentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentsOrBuilder(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentsOrBuilderList() {
      if (contentsBuilder_ != null) {
        return contentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contents_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addContentsBuilder() {
      return getContentsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addContentsBuilder(int index) {
      return getContentsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. The content to cache
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content.Builder>
        getContentsBuilderList() {
      return getContentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentsFieldBuilder() {
      if (contentsBuilder_ == null) {
        contentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                contents_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        contents_ = null;
      }
      return contentsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> tools_ =
        java.util.Collections.emptyList();

    private void ensureToolsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        tools_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Tool>(tools_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tool,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        toolsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> getToolsList() {
      if (toolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tools_);
      } else {
        return toolsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public int getToolsCount() {
      if (toolsBuilder_ == null) {
        return tools_.size();
      } else {
        return toolsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool getTools(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setTools(int index, com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.set(index, value);
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setTools(
        int index, com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.set(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addTools(com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addTools(int index, com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(index, value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addTools(com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addTools(
        int index, com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder addAllTools(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Tool> values) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tools_);
        onChanged();
      } else {
        toolsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearTools() {
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        toolsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder removeTools(int index) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.remove(index);
        onChanged();
      } else {
        toolsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder getToolsBuilder(int index) {
      return getToolsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolOrBuilder getToolsOrBuilder(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        getToolsOrBuilderList() {
      if (toolsBuilder_ != null) {
        return toolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tools_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder addToolsBuilder() {
      return getToolsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder addToolsBuilder(int index) {
      return getToolsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. A list of `Tools` the model may use to
     * generate the next response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool.Builder> getToolsBuilderList() {
      return getToolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tool,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        getToolsFieldBuilder() {
      if (toolsBuilder_ == null) {
        toolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Tool,
                com.google.cloud.aiplatform.v1beta1.Tool.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>(
                tools_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        tools_ = null;
      }
      return toolsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ToolConfig toolConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolConfig,
            com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder>
        toolConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the toolConfig field is set.
     */
    public boolean hasToolConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The toolConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ToolConfig getToolConfig() {
      if (toolConfigBuilder_ == null) {
        return toolConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
            : toolConfig_;
      } else {
        return toolConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setToolConfig(com.google.cloud.aiplatform.v1beta1.ToolConfig value) {
      if (toolConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        toolConfig_ = value;
      } else {
        toolConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setToolConfig(
        com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder builderForValue) {
      if (toolConfigBuilder_ == null) {
        toolConfig_ = builderForValue.build();
      } else {
        toolConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeToolConfig(com.google.cloud.aiplatform.v1beta1.ToolConfig value) {
      if (toolConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && toolConfig_ != null
            && toolConfig_ != com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()) {
          getToolConfigBuilder().mergeFrom(value);
        } else {
          toolConfig_ = value;
        }
      } else {
        toolConfigBuilder_.mergeFrom(value);
      }
      if (toolConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearToolConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      toolConfig_ = null;
      if (toolConfigBuilder_ != null) {
        toolConfigBuilder_.dispose();
        toolConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder getToolConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getToolConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder getToolConfigOrBuilder() {
      if (toolConfigBuilder_ != null) {
        return toolConfigBuilder_.getMessageOrBuilder();
      } else {
        return toolConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
            : toolConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tool config. This config is shared for all
     * tools
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolConfig,
            com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder>
        getToolConfigFieldBuilder() {
      if (toolConfigBuilder_ == null) {
        toolConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolConfig,
                com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder>(
                getToolConfig(), getParentForChildren(), isClean());
        toolConfig_ = null;
      }
      return toolConfigBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creatation time of the cache entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the cache entry was last updated in UTC time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.CachedContent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.CachedContent)
  private static final com.google.cloud.aiplatform.v1beta1.CachedContent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.CachedContent();
  }

  public static com.google.cloud.aiplatform.v1beta1.CachedContent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CachedContent> PARSER =
      new com.google.protobuf.AbstractParser<CachedContent>() {
        @java.lang.Override
        public CachedContent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CachedContent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CachedContent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CachedContent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
