/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpecialistPoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SPECIALIST_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/specialistPools/{specialist_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String specialistPool;

    @Deprecated
    protected SpecialistPoolName() {
        this.project = null;
        this.location = null;
        this.specialistPool = null;
    }

    private SpecialistPoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.specialistPool = (String)Preconditions.checkNotNull((Object)builder.getSpecialistPool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSpecialistPool() {
        return this.specialistPool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SpecialistPoolName of(String project, String location, String specialistPool) {
        return SpecialistPoolName.newBuilder().setProject(project).setLocation(location).setSpecialistPool(specialistPool).build();
    }

    public static String format(String project, String location, String specialistPool) {
        return SpecialistPoolName.newBuilder().setProject(project).setLocation(location).setSpecialistPool(specialistPool).build().toString();
    }

    public static SpecialistPoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SPECIALIST_POOL.validatedMatch(formattedString, "SpecialistPoolName.parse: formattedString not in valid format");
        return SpecialistPoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("specialist_pool"));
    }

    public static List<SpecialistPoolName> parseList(List<String> formattedStrings) {
        ArrayList<SpecialistPoolName> list = new ArrayList<SpecialistPoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpecialistPoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpecialistPoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpecialistPoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SPECIALIST_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpecialistPoolName specialistPoolName = this;
            synchronized (specialistPoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.specialistPool != null) {
                        fieldMapBuilder.put((Object)"specialist_pool", (Object)this.specialistPool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SPECIALIST_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "specialist_pool", this.specialistPool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SpecialistPoolName that = (SpecialistPoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.specialistPool, that.specialistPool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.specialistPool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String specialistPool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSpecialistPool() {
            return this.specialistPool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSpecialistPool(String specialistPool) {
            this.specialistPool = specialistPool;
            return this;
        }

        private Builder(SpecialistPoolName specialistPoolName) {
            this.project = specialistPoolName.project;
            this.location = specialistPoolName.location;
            this.specialistPool = specialistPoolName.specialistPool;
        }

        public SpecialistPoolName build() {
            return new SpecialistPoolName(this);
        }
    }
}

