/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetadataSchemaName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_METADATA_STORE_METADATA_SCHEMA = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/metadataStores/{metadata_store}/metadataSchemas/{metadata_schema}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String metadataStore;
    private final String metadataSchema;

    @Deprecated
    protected MetadataSchemaName() {
        this.project = null;
        this.location = null;
        this.metadataStore = null;
        this.metadataSchema = null;
    }

    private MetadataSchemaName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.metadataStore = (String)Preconditions.checkNotNull((Object)builder.getMetadataStore());
        this.metadataSchema = (String)Preconditions.checkNotNull((Object)builder.getMetadataSchema());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMetadataStore() {
        return this.metadataStore;
    }

    public String getMetadataSchema() {
        return this.metadataSchema;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetadataSchemaName of(String project, String location, String metadataStore, String metadataSchema) {
        return MetadataSchemaName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setMetadataSchema(metadataSchema).build();
    }

    public static String format(String project, String location, String metadataStore, String metadataSchema) {
        return MetadataSchemaName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setMetadataSchema(metadataSchema).build().toString();
    }

    public static MetadataSchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_METADATA_STORE_METADATA_SCHEMA.validatedMatch(formattedString, "MetadataSchemaName.parse: formattedString not in valid format");
        return MetadataSchemaName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("metadata_store"), (String)matchMap.get("metadata_schema"));
    }

    public static List<MetadataSchemaName> parseList(List<String> formattedStrings) {
        ArrayList<MetadataSchemaName> list = new ArrayList<MetadataSchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetadataSchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetadataSchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetadataSchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_METADATA_STORE_METADATA_SCHEMA.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetadataSchemaName metadataSchemaName = this;
            synchronized (metadataSchemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.metadataStore != null) {
                        fieldMapBuilder.put((Object)"metadata_store", (Object)this.metadataStore);
                    }
                    if (this.metadataSchema != null) {
                        fieldMapBuilder.put((Object)"metadata_schema", (Object)this.metadataSchema);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_METADATA_STORE_METADATA_SCHEMA.instantiate(new String[]{"project", this.project, "location", this.location, "metadata_store", this.metadataStore, "metadata_schema", this.metadataSchema});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MetadataSchemaName that = (MetadataSchemaName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataStore, that.metadataStore) && Objects.equals(this.metadataSchema, that.metadataSchema);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.metadataStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.metadataSchema);
    }

    public static class Builder {
        private String project;
        private String location;
        private String metadataStore;
        private String metadataSchema;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMetadataStore() {
            return this.metadataStore;
        }

        public String getMetadataSchema() {
            return this.metadataSchema;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMetadataStore(String metadataStore) {
            this.metadataStore = metadataStore;
            return this;
        }

        public Builder setMetadataSchema(String metadataSchema) {
            this.metadataSchema = metadataSchema;
            return this;
        }

        private Builder(MetadataSchemaName metadataSchemaName) {
            this.project = metadataSchemaName.project;
            this.location = metadataSchemaName.location;
            this.metadataStore = metadataSchemaName.metadataStore;
            this.metadataSchema = metadataSchemaName.metadataSchema;
        }

        public MetadataSchemaName build() {
            return new MetadataSchemaName(this);
        }
    }
}

