/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetadataStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_METADATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/metadataStores/{metadata_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String metadataStore;

    @Deprecated
    protected MetadataStoreName() {
        this.project = null;
        this.location = null;
        this.metadataStore = null;
    }

    private MetadataStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.metadataStore = (String)Preconditions.checkNotNull((Object)builder.getMetadataStore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMetadataStore() {
        return this.metadataStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetadataStoreName of(String project, String location, String metadataStore) {
        return MetadataStoreName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).build();
    }

    public static String format(String project, String location, String metadataStore) {
        return MetadataStoreName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).build().toString();
    }

    public static MetadataStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_METADATA_STORE.validatedMatch(formattedString, "MetadataStoreName.parse: formattedString not in valid format");
        return MetadataStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("metadata_store"));
    }

    public static List<MetadataStoreName> parseList(List<String> formattedStrings) {
        ArrayList<MetadataStoreName> list = new ArrayList<MetadataStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetadataStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetadataStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetadataStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_METADATA_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetadataStoreName metadataStoreName = this;
            synchronized (metadataStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.metadataStore != null) {
                        fieldMapBuilder.put((Object)"metadata_store", (Object)this.metadataStore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_METADATA_STORE.instantiate(new String[]{"project", this.project, "location", this.location, "metadata_store", this.metadataStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MetadataStoreName that = (MetadataStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataStore, that.metadataStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.metadataStore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String metadataStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMetadataStore() {
            return this.metadataStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMetadataStore(String metadataStore) {
            this.metadataStore = metadataStore;
            return this;
        }

        private Builder(MetadataStoreName metadataStoreName) {
            this.project = metadataStoreName.project;
            this.location = metadataStoreName.location;
            this.metadataStore = metadataStoreName.metadataStore;
        }

        public MetadataStoreName build() {
            return new MetadataStoreName(this);
        }
    }
}

