/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PersistentResourceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PERSISTENT_RESOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/persistentResources/{persistent_resource}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String persistentResource;

    @Deprecated
    protected PersistentResourceName() {
        this.project = null;
        this.location = null;
        this.persistentResource = null;
    }

    private PersistentResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.persistentResource = (String)Preconditions.checkNotNull((Object)builder.getPersistentResource());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPersistentResource() {
        return this.persistentResource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PersistentResourceName of(String project, String location, String persistentResource) {
        return PersistentResourceName.newBuilder().setProject(project).setLocation(location).setPersistentResource(persistentResource).build();
    }

    public static String format(String project, String location, String persistentResource) {
        return PersistentResourceName.newBuilder().setProject(project).setLocation(location).setPersistentResource(persistentResource).build().toString();
    }

    public static PersistentResourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PERSISTENT_RESOURCE.validatedMatch(formattedString, "PersistentResourceName.parse: formattedString not in valid format");
        return PersistentResourceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("persistent_resource"));
    }

    public static List<PersistentResourceName> parseList(List<String> formattedStrings) {
        ArrayList<PersistentResourceName> list = new ArrayList<PersistentResourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PersistentResourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PersistentResourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PersistentResourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PERSISTENT_RESOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PersistentResourceName persistentResourceName = this;
            synchronized (persistentResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.persistentResource != null) {
                        fieldMapBuilder.put((Object)"persistent_resource", (Object)this.persistentResource);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PERSISTENT_RESOURCE.instantiate(new String[]{"project", this.project, "location", this.location, "persistent_resource", this.persistentResource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PersistentResourceName that = (PersistentResourceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.persistentResource, that.persistentResource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.persistentResource);
    }

    public static class Builder {
        private String project;
        private String location;
        private String persistentResource;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPersistentResource() {
            return this.persistentResource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPersistentResource(String persistentResource) {
            this.persistentResource = persistentResource;
            return this;
        }

        private Builder(PersistentResourceName persistentResourceName) {
            this.project = persistentResourceName.project;
            this.location = persistentResourceName.location;
            this.persistentResource = persistentResourceName.persistentResource;
        }

        public PersistentResourceName build() {
            return new PersistentResourceName(this);
        }
    }
}

