/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VersionName
implements ResourceName {
    private static final PathTemplate PROJECT_MODEL_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/models/{model}/versions/{version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String model;
    private final String version;

    @Deprecated
    protected VersionName() {
        this.project = null;
        this.model = null;
        this.version = null;
    }

    private VersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getModel() {
        return this.model;
    }

    public String getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VersionName of(String project, String model, String version) {
        return VersionName.newBuilder().setProject(project).setModel(model).setVersion(version).build();
    }

    public static String format(String project, String model, String version) {
        return VersionName.newBuilder().setProject(project).setModel(model).setVersion(version).build().toString();
    }

    public static VersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_MODEL_VERSION.validatedMatch(formattedString, "VersionName.parse: formattedString not in valid format");
        return VersionName.of((String)matchMap.get("project"), (String)matchMap.get("model"), (String)matchMap.get("version"));
    }

    public static List<VersionName> parseList(List<String> formattedStrings) {
        ArrayList<VersionName> list = new ArrayList<VersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_MODEL_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VersionName versionName = this;
            synchronized (versionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.model != null) {
                        fieldMapBuilder.put((Object)"model", (Object)this.model);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_MODEL_VERSION.instantiate(new String[]{"project", this.project, "model", this.model, "version", this.version});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VersionName that = (VersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.model, that.model) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.model);
        h *= 1000003;
        return h ^= Objects.hashCode(this.version);
    }

    public static class Builder {
        private String project;
        private String model;
        private String version;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getModel() {
            return this.model;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        private Builder(VersionName versionName) {
            this.project = versionName.project;
            this.model = versionName.model;
            this.version = versionName.version;
        }

        public VersionName build() {
            return new VersionName(this);
        }
    }
}

