/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/schema/predict/prediction/video_action_recognition.proto

package com.google.cloud.aiplatform.v1beta1.schema.predict.prediction;

/**
 *
 *
 * <pre>
 * Prediction output format for Video Action Recognition.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult}
 */
public final class VideoActionRecognitionPredictionResult
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult)
    VideoActionRecognitionPredictionResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoActionRecognitionPredictionResult.newBuilder() to construct.
  private VideoActionRecognitionPredictionResult(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoActionRecognitionPredictionResult() {
    id_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoActionRecognitionPredictionResult();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private VideoActionRecognitionPredictionResult(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 34:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeSegmentStart_ != null) {
                subBuilder = timeSegmentStart_.toBuilder();
              }
              timeSegmentStart_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeSegmentStart_);
                timeSegmentStart_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeSegmentEnd_ != null) {
                subBuilder = timeSegmentEnd_.toBuilder();
              }
              timeSegmentEnd_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeSegmentEnd_);
                timeSegmentEnd_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.FloatValue.Builder subBuilder = null;
              if (confidence_ != null) {
                subBuilder = confidence_.toBuilder();
              }
              confidence_ =
                  input.readMessage(com.google.protobuf.FloatValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(confidence_);
                confidence_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
        .VideoActionRecognitionPredictionResultProto
        .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoActionRecognitionPredictionResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
        .VideoActionRecognitionPredictionResultProto
        .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoActionRecognitionPredictionResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoActionRecognitionPredictionResult.class,
            com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoActionRecognitionPredictionResult.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * The resource ID of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource ID of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_SEGMENT_START_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration timeSegmentStart_;
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 4;</code>
   *
   * @return Whether the timeSegmentStart field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegmentStart() {
    return timeSegmentStart_ != null;
  }
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 4;</code>
   *
   * @return The timeSegmentStart.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeSegmentStart() {
    return timeSegmentStart_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentStart_;
  }
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeSegmentStartOrBuilder() {
    return getTimeSegmentStart();
  }

  public static final int TIME_SEGMENT_END_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration timeSegmentEnd_;
  /**
   *
   *
   * <pre>
   * The end, exclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 5;</code>
   *
   * @return Whether the timeSegmentEnd field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegmentEnd() {
    return timeSegmentEnd_ != null;
  }
  /**
   *
   *
   * <pre>
   * The end, exclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 5;</code>
   *
   * @return The timeSegmentEnd.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeSegmentEnd() {
    return timeSegmentEnd_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentEnd_;
  }
  /**
   *
   *
   * <pre>
   * The end, exclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeSegmentEndOrBuilder() {
    return getTimeSegmentEnd();
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 6;
  private com.google.protobuf.FloatValue confidence_;
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 6;</code>
   *
   * @return Whether the confidence field is set.
   */
  @java.lang.Override
  public boolean hasConfidence() {
    return confidence_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 6;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public com.google.protobuf.FloatValue getConfidence() {
    return confidence_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : confidence_;
  }
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FloatValueOrBuilder getConfidenceOrBuilder() {
    return getConfidence();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (timeSegmentStart_ != null) {
      output.writeMessage(4, getTimeSegmentStart());
    }
    if (timeSegmentEnd_ != null) {
      output.writeMessage(5, getTimeSegmentEnd());
    }
    if (confidence_ != null) {
      output.writeMessage(6, getConfidence());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (timeSegmentStart_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeSegmentStart());
    }
    if (timeSegmentEnd_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTimeSegmentEnd());
    }
    if (confidence_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getConfidence());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoActionRecognitionPredictionResult)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoActionRecognitionPredictionResult
        other =
            (com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                    .VideoActionRecognitionPredictionResult)
                obj;

    if (!getId().equals(other.getId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasTimeSegmentStart() != other.hasTimeSegmentStart()) return false;
    if (hasTimeSegmentStart()) {
      if (!getTimeSegmentStart().equals(other.getTimeSegmentStart())) return false;
    }
    if (hasTimeSegmentEnd() != other.hasTimeSegmentEnd()) return false;
    if (hasTimeSegmentEnd()) {
      if (!getTimeSegmentEnd().equals(other.getTimeSegmentEnd())) return false;
    }
    if (hasConfidence() != other.hasConfidence()) return false;
    if (hasConfidence()) {
      if (!getConfidence().equals(other.getConfidence())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasTimeSegmentStart()) {
      hash = (37 * hash) + TIME_SEGMENT_START_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegmentStart().hashCode();
    }
    if (hasTimeSegmentEnd()) {
      hash = (37 * hash) + TIME_SEGMENT_END_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegmentEnd().hashCode();
    }
    if (hasConfidence()) {
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + getConfidence().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoActionRecognitionPredictionResult
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Prediction output format for Video Action Recognition.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult)
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoActionRecognitionPredictionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoActionRecognitionPredictionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                  .VideoActionRecognitionPredictionResult.class,
              com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                  .VideoActionRecognitionPredictionResult.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      displayName_ = "";

      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStart_ = null;
      } else {
        timeSegmentStart_ = null;
        timeSegmentStartBuilder_ = null;
      }
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEnd_ = null;
      } else {
        timeSegmentEnd_ = null;
        timeSegmentEndBuilder_ = null;
      }
      if (confidenceBuilder_ == null) {
        confidence_ = null;
      } else {
        confidence_ = null;
        confidenceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoActionRecognitionPredictionResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoActionRecognitionPredictionResult
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoActionRecognitionPredictionResult
        build() {
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoActionRecognitionPredictionResult
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoActionRecognitionPredictionResult
        buildPartial() {
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoActionRecognitionPredictionResult
          result =
              new com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                  .VideoActionRecognitionPredictionResult(this);
      result.id_ = id_;
      result.displayName_ = displayName_;
      if (timeSegmentStartBuilder_ == null) {
        result.timeSegmentStart_ = timeSegmentStart_;
      } else {
        result.timeSegmentStart_ = timeSegmentStartBuilder_.build();
      }
      if (timeSegmentEndBuilder_ == null) {
        result.timeSegmentEnd_ = timeSegmentEnd_;
      } else {
        result.timeSegmentEnd_ = timeSegmentEndBuilder_.build();
      }
      if (confidenceBuilder_ == null) {
        result.confidence_ = confidence_;
      } else {
        result.confidence_ = confidenceBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoActionRecognitionPredictionResult) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                    .VideoActionRecognitionPredictionResult)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoActionRecognitionPredictionResult
            other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoActionRecognitionPredictionResult.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasTimeSegmentStart()) {
        mergeTimeSegmentStart(other.getTimeSegmentStart());
      }
      if (other.hasTimeSegmentEnd()) {
        mergeTimeSegmentEnd(other.getTimeSegmentEnd());
      }
      if (other.hasConfidence()) {
        mergeConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoActionRecognitionPredictionResult
          parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                    .VideoActionRecognitionPredictionResult)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeSegmentStart_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeSegmentStartBuilder_;
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     *
     * @return Whether the timeSegmentStart field is set.
     */
    public boolean hasTimeSegmentStart() {
      return timeSegmentStartBuilder_ != null || timeSegmentStart_ != null;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     *
     * @return The timeSegmentStart.
     */
    public com.google.protobuf.Duration getTimeSegmentStart() {
      if (timeSegmentStartBuilder_ == null) {
        return timeSegmentStart_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentStart_;
      } else {
        return timeSegmentStartBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder setTimeSegmentStart(com.google.protobuf.Duration value) {
      if (timeSegmentStartBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegmentStart_ = value;
        onChanged();
      } else {
        timeSegmentStartBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder setTimeSegmentStart(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStart_ = builderForValue.build();
        onChanged();
      } else {
        timeSegmentStartBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder mergeTimeSegmentStart(com.google.protobuf.Duration value) {
      if (timeSegmentStartBuilder_ == null) {
        if (timeSegmentStart_ != null) {
          timeSegmentStart_ =
              com.google.protobuf.Duration.newBuilder(timeSegmentStart_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeSegmentStart_ = value;
        }
        onChanged();
      } else {
        timeSegmentStartBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder clearTimeSegmentStart() {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStart_ = null;
        onChanged();
      } else {
        timeSegmentStart_ = null;
        timeSegmentStartBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeSegmentStartBuilder() {

      onChanged();
      return getTimeSegmentStartFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeSegmentStartOrBuilder() {
      if (timeSegmentStartBuilder_ != null) {
        return timeSegmentStartBuilder_.getMessageOrBuilder();
      } else {
        return timeSegmentStart_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentStart_;
      }
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeSegmentStartFieldBuilder() {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStartBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeSegmentStart(), getParentForChildren(), isClean());
        timeSegmentStart_ = null;
      }
      return timeSegmentStartBuilder_;
    }

    private com.google.protobuf.Duration timeSegmentEnd_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeSegmentEndBuilder_;
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     *
     * @return Whether the timeSegmentEnd field is set.
     */
    public boolean hasTimeSegmentEnd() {
      return timeSegmentEndBuilder_ != null || timeSegmentEnd_ != null;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     *
     * @return The timeSegmentEnd.
     */
    public com.google.protobuf.Duration getTimeSegmentEnd() {
      if (timeSegmentEndBuilder_ == null) {
        return timeSegmentEnd_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentEnd_;
      } else {
        return timeSegmentEndBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder setTimeSegmentEnd(com.google.protobuf.Duration value) {
      if (timeSegmentEndBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegmentEnd_ = value;
        onChanged();
      } else {
        timeSegmentEndBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder setTimeSegmentEnd(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEnd_ = builderForValue.build();
        onChanged();
      } else {
        timeSegmentEndBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder mergeTimeSegmentEnd(com.google.protobuf.Duration value) {
      if (timeSegmentEndBuilder_ == null) {
        if (timeSegmentEnd_ != null) {
          timeSegmentEnd_ =
              com.google.protobuf.Duration.newBuilder(timeSegmentEnd_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeSegmentEnd_ = value;
        }
        onChanged();
      } else {
        timeSegmentEndBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder clearTimeSegmentEnd() {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEnd_ = null;
        onChanged();
      } else {
        timeSegmentEnd_ = null;
        timeSegmentEndBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeSegmentEndBuilder() {

      onChanged();
      return getTimeSegmentEndFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeSegmentEndOrBuilder() {
      if (timeSegmentEndBuilder_ != null) {
        return timeSegmentEndBuilder_.getMessageOrBuilder();
      } else {
        return timeSegmentEnd_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentEnd_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeSegmentEndFieldBuilder() {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEndBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeSegmentEnd(), getParentForChildren(), isClean());
        timeSegmentEnd_ = null;
      }
      return timeSegmentEndBuilder_;
    }

    private com.google.protobuf.FloatValue confidence_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FloatValue,
            com.google.protobuf.FloatValue.Builder,
            com.google.protobuf.FloatValueOrBuilder>
        confidenceBuilder_;
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     *
     * @return Whether the confidence field is set.
     */
    public boolean hasConfidence() {
      return confidenceBuilder_ != null || confidence_ != null;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     *
     * @return The confidence.
     */
    public com.google.protobuf.FloatValue getConfidence() {
      if (confidenceBuilder_ == null) {
        return confidence_ == null
            ? com.google.protobuf.FloatValue.getDefaultInstance()
            : confidence_;
      } else {
        return confidenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder setConfidence(com.google.protobuf.FloatValue value) {
      if (confidenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidence_ = value;
        onChanged();
      } else {
        confidenceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder setConfidence(com.google.protobuf.FloatValue.Builder builderForValue) {
      if (confidenceBuilder_ == null) {
        confidence_ = builderForValue.build();
        onChanged();
      } else {
        confidenceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder mergeConfidence(com.google.protobuf.FloatValue value) {
      if (confidenceBuilder_ == null) {
        if (confidence_ != null) {
          confidence_ =
              com.google.protobuf.FloatValue.newBuilder(confidence_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          confidence_ = value;
        }
        onChanged();
      } else {
        confidenceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder clearConfidence() {
      if (confidenceBuilder_ == null) {
        confidence_ = null;
        onChanged();
      } else {
        confidence_ = null;
        confidenceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public com.google.protobuf.FloatValue.Builder getConfidenceBuilder() {

      onChanged();
      return getConfidenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public com.google.protobuf.FloatValueOrBuilder getConfidenceOrBuilder() {
      if (confidenceBuilder_ != null) {
        return confidenceBuilder_.getMessageOrBuilder();
      } else {
        return confidence_ == null
            ? com.google.protobuf.FloatValue.getDefaultInstance()
            : confidence_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FloatValue,
            com.google.protobuf.FloatValue.Builder,
            com.google.protobuf.FloatValueOrBuilder>
        getConfidenceFieldBuilder() {
      if (confidenceBuilder_ == null) {
        confidenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FloatValue,
                com.google.protobuf.FloatValue.Builder,
                com.google.protobuf.FloatValueOrBuilder>(
                getConfidence(), getParentForChildren(), isClean());
        confidence_ = null;
      }
      return confidenceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoActionRecognitionPredictionResult)
  private static final com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoActionRecognitionPredictionResult();
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoActionRecognitionPredictionResult> PARSER =
      new com.google.protobuf.AbstractParser<VideoActionRecognitionPredictionResult>() {
        @java.lang.Override
        public VideoActionRecognitionPredictionResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new VideoActionRecognitionPredictionResult(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<VideoActionRecognitionPredictionResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoActionRecognitionPredictionResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoActionRecognitionPredictionResult
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
